package com.ruoyi.system.service;

import com.ruoyi.system.domain.ZkActivityContent;
import com.ruoyi.system.domain.vo.ZkActivityContentVo;
import com.ruoyi.system.domain.bo.ZkActivityContentBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 活动内容Service接口
 *
 * @author ruoyi
 * @date 2021-10-27
 */
public interface IZkActivityContentService extends IServicePlus<ZkActivityContent, ZkActivityContentVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkActivityContentVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkActivityContentVo> queryPageList(ZkActivityContentBo bo);

	/**
	 * 查询列表
	 */
	List<ZkActivityContentVo> queryList(ZkActivityContentBo bo);

	/**
	 * 根据新增业务对象插入活动内容
	 * @param bo 活动内容新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkActivityContentBo bo);

	/**
	 * 根据编辑业务对象修改活动内容
	 * @param bo 活动内容编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkActivityContentBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
