package com.ruoyi.system.service;

import com.ruoyi.system.domain.ZkActivityEvaluate;
import com.ruoyi.system.domain.vo.ZkActivityEvaluateVo;
import com.ruoyi.system.domain.bo.ZkActivityEvaluateBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 组织评定Service接口
 *
 * @author ruoyi
 * @date 2021-11-10
 */
public interface IZkActivityEvaluateService extends IServicePlus<ZkActivityEvaluate, ZkActivityEvaluateVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkActivityEvaluateVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkActivityEvaluateVo> queryPageList(ZkActivityEvaluateBo bo);

	/**
	 * 查询列表
	 */
	List<ZkActivityEvaluateVo> queryList(ZkActivityEvaluateBo bo);

	/**
	 * 根据新增业务对象插入组织评定
	 * @param bo 组织评定新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkActivityEvaluateBo bo);

	/**
	 * 根据编辑业务对象修改组织评定
	 * @param bo 组织评定编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkActivityEvaluateBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<ZkActivityEvaluate> getListByActivityId(Long id);
}
