package com.ruoyi.system.service;

import com.github.pagehelper.PageInfo;
import com.ruoyi.system.domain.ZkActivityInfo;
import com.ruoyi.system.domain.bo.ActivityInfoBo;
import com.ruoyi.system.domain.bo.ZkActivityInfoBo;
import com.ruoyi.system.domain.bo.ZkActivityInfoBo2;
import com.ruoyi.system.domain.vo.*;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 活动详情主体Service接口
 *
 * @author ruoyi
 * @date 2021-10-27
 */
public interface IZkActivityInfoService extends IServicePlus<ZkActivityInfo, ZkActivityInfoVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkActivityInfoVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkActivityInfoVo> queryPageList(ZkActivityInfoBo bo);

	/**
	 * 查询列表
	 */
	List<ZkActivityInfoVo> queryList(ZkActivityInfoBo bo);

	/**
	 * 根据新增业务对象插入活动详情主体
	 * @param bo 活动详情主体新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkActivityInfoBo bo);

	/**
	 * 根据编辑业务对象修改活动详情主体
	 * @param bo 活动详情主体编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkActivityInfoBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<OrganizationalActivityInfoVo> queryListForTableData(ActivityInfoBo bo);

    Integer queryListForTableDataTotalForOrganizational(ActivityInfoBo bo);

    Integer queryListForTableDataTotalForSpecial(ActivityInfoBo bo);

    List<SpecialActivityInfoVo> queryListForTableDataForSpecial(ActivityInfoBo bo);

    List<ZkActivityHostUserVo> getHostUserByDeptId(Long deptId);

    List<SpecialActivityCountVo> querySpecialActivityCount(Long id);

    /**
     * 综合查询
     * @param bo
     * @return
     */
    PageInfo queryByZHCX(ZkActivityInfoBo2 bo);
}
