package com.ruoyi.system.service;

import com.ruoyi.system.domain.ZkActivityObj;
import com.ruoyi.system.domain.vo.ZkActivityObjVo;
import com.ruoyi.system.domain.bo.ZkActivityObjBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 活动主体中的活动对象Service接口
 *
 * @author ruoyi
 * @date 2021-10-27
 */
public interface IZkActivityObjService extends IServicePlus<ZkActivityObj, ZkActivityObjVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkActivityObjVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkActivityObjVo> queryPageList(ZkActivityObjBo bo);

	/**
	 * 查询列表
	 */
	List<ZkActivityObjVo> queryList(ZkActivityObjBo bo);

	/**
	 * 根据新增业务对象插入活动主体中的活动对象
	 * @param bo 活动主体中的活动对象新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkActivityObjBo bo);

	/**
	 * 根据编辑业务对象修改活动主体中的活动对象
	 * @param bo 活动主体中的活动对象编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkActivityObjBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
