package com.ruoyi.system.service;

import com.ruoyi.system.domain.ZkActivityObjUser;
import com.ruoyi.system.domain.vo.ZkActivityObjUserVo;
import com.ruoyi.system.domain.bo.ZkActivityObjUserBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 活动对象人员信息Service接口
 *
 * @author ruoyi
 * @date 2021-11-02
 */
public interface IZkActivityObjUserService extends IServicePlus<ZkActivityObjUser, ZkActivityObjUserVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkActivityObjUserVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkActivityObjUserVo> queryPageList(ZkActivityObjUserBo bo);

	/**
	 * 查询列表
	 */
	List<ZkActivityObjUserVo> queryList(ZkActivityObjUserBo bo);

	/**
	 * 根据新增业务对象插入活动对象人员信息
	 * @param bo 活动对象人员信息新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkActivityObjUserBo bo);

	/**
	 * 根据编辑业务对象修改活动对象人员信息
	 * @param bo 活动对象人员信息编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkActivityObjUserBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
