package com.ruoyi.system.service;

import com.ruoyi.system.domain.ZkActivityTypeContent;
import com.ruoyi.system.domain.vo.ZkActivityTypeContentVo;
import com.ruoyi.system.domain.bo.ZkActivityTypeContentBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 活动类型与活动内容关联Service接口
 *
 * @author ruoyi
 * @date 2021-10-27
 */
public interface IZkActivityTypeContentService extends IServicePlus<ZkActivityTypeContent, ZkActivityTypeContentVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkActivityTypeContentVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkActivityTypeContentVo> queryPageList(ZkActivityTypeContentBo bo);

	/**
	 * 查询列表
	 */
	List<ZkActivityTypeContentVo> queryList(ZkActivityTypeContentBo bo);

	/**
	 * 根据新增业务对象插入活动类型与活动内容关联
	 * @param bo 活动类型与活动内容关联新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkActivityTypeContentBo bo);

	/**
	 * 根据编辑业务对象修改活动类型与活动内容关联
	 * @param bo 活动类型与活动内容关联编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkActivityTypeContentBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
