package com.ruoyi.system.service;

import com.ruoyi.system.domain.ZkActivityType;
import com.ruoyi.system.domain.vo.ZkActivityTypeVo;
import com.ruoyi.system.domain.bo.ZkActivityTypeBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 活动类型Service接口
 *
 * @author ruoyi
 * @date 2021-11-03
 */
public interface IZkActivityTypeService extends IServicePlus<ZkActivityType, ZkActivityTypeVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkActivityTypeVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkActivityTypeVo> queryPageList(ZkActivityTypeBo bo);

	/**
	 * 查询列表
	 */
	List<ZkActivityTypeVo> queryList(ZkActivityTypeBo bo);

	/**
	 * 根据新增业务对象插入活动类型
	 * @param bo 活动类型新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkActivityTypeBo bo);

	/**
	 * 根据编辑业务对象修改活动类型
	 * @param bo 活动类型编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkActivityTypeBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<Map<String, Object>> getList(String roleFlag);
}
