package com.ruoyi.system.service;

import com.ruoyi.system.domain.ZkTitleType;
import com.ruoyi.system.domain.vo.ZkTitleTypeVo;
import com.ruoyi.system.domain.bo.ZkTitleTypeBo;
import com.ruoyi.common.core.mybatisplus.core.IServicePlus;
import com.ruoyi.common.core.page.TableDataInfo;

import java.util.Collection;
import java.util.List;

/**
 * 活动分类(组织活动/民主评议/谈心谈话/专项活动)Service接口
 *
 * @author ruoyi
 * @date 2021-10-27
 */
public interface IZkTitleTypeService extends IServicePlus<ZkTitleType, ZkTitleTypeVo> {
	/**
	 * 查询单个
	 * @return
	 */
	ZkTitleTypeVo queryById(Long id);

	/**
	 * 查询列表
	 */
    TableDataInfo<ZkTitleTypeVo> queryPageList(ZkTitleTypeBo bo);

	/**
	 * 查询列表
	 */
	List<ZkTitleTypeVo> queryList(ZkTitleTypeBo bo);

	/**
	 * 根据新增业务对象插入活动分类(组织活动/民主评议/谈心谈话/专项活动)
	 * @param bo 活动分类(组织活动/民主评议/谈心谈话/专项活动)新增业务对象
	 * @return
	 */
	Boolean insertByBo(ZkTitleTypeBo bo);

	/**
	 * 根据编辑业务对象修改活动分类(组织活动/民主评议/谈心谈话/专项活动)
	 * @param bo 活动分类(组织活动/民主评议/谈心谈话/专项活动)编辑业务对象
	 * @return
	 */
	Boolean updateByBo(ZkTitleTypeBo bo);

	/**
	 * 校验并删除数据
	 * @param ids 主键集合
	 * @param isValid 是否校验,true-删除前校验,false-不校验
	 * @return
	 */
	Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
