package com.ruoyi.system.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.*;
import com.ruoyi.system.domain.bo.*;
import com.ruoyi.system.domain.vo.*;
import com.ruoyi.system.service.*;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class IActivityServiceImpl implements IActivityService {

    @Autowired
    private IZkActivityContentService contentService;
    @Autowired
    private IZkActivityInfoContentService infoContentService;
    @Autowired
    private IZkActivityInfoService activityInfoService;
    @Autowired
    private IZkActivityObjService objService;
    @Autowired
    private IZkActivityObjUserService objUserService;
    @Autowired
    private ISysDeptService deptService;
    @Autowired
    private IZkActivityTypeService activityTypeService;
    @Autowired
    private IZkActivityEvaluateService evaluateService;


    @Override
    public TableDataInfo<OrganizationalActivityInfoVo> queryOrganizationalActivityPageList(ActivityInfoBo bo) {
        bo.setPageNum((bo.getPageNum() - 1) * bo.getPageSize());
        List<SysDept> deptList = deptService.selectDeptTreeById(Long.parseLong(bo.getDeptId()), false);
        List<Long> deptIdList = new ArrayList<>();
        for (SysDept dept : deptList) {
            deptIdList.add(dept.getDeptId());
        }
        String deptIds = StringUtils.join(deptIdList, ",");
        bo.setDeptId(deptIds);
        Integer totalData = activityInfoService.queryListForTableDataTotalForOrganizational(bo);
        List<OrganizationalActivityInfoVo> infos = activityInfoService.queryListForTableData(bo);
        infos.forEach(info -> {
            // 活动对象
            Long activityId = info.getId();
            LambdaQueryWrapper<ZkActivityObj> objLqWrapper = new LambdaQueryWrapper();
            objLqWrapper.eq(ZkActivityObj::getActivityId, activityId);
            List<ZkActivityObjVo> bos = objService.listVo(objLqWrapper);
            // 人员
            if (!CollectionUtils.isEmpty(bos)) {
                LambdaQueryWrapper<ZkActivityObjUser> objUserLqWrapper;
                List<ZkActivityObjUser> list;
                List<String> participatedUserNameList = new ArrayList<>();
                List<String> leaveUserNameList = new ArrayList<>();
                List<String> absentUserNameList = new ArrayList<>();
                List<String> unUserNameList = new ArrayList<>();
                List<String> ldUserNameList = new ArrayList<>();
                for (ZkActivityObjVo obj : bos) {
                    objUserLqWrapper = new LambdaQueryWrapper<>();
                    objUserLqWrapper.eq(ZkActivityObjUser::getActivityId, obj.getActivityId());
                    objUserLqWrapper.eq(ZkActivityObjUser::getActivityObjId, obj.getId());
                    list = objUserService.list(objUserLqWrapper);
                    for (ZkActivityObjUser objUser : list) {
                        String userName = objUser.getUserName();
                        if (0 == objUser.getType()) {
                            participatedUserNameList.add(userName);
                        } else if (1 == objUser.getType()) {
                            leaveUserNameList.add(userName);
                        } else if (2 == objUser.getType()) {
                            absentUserNameList.add(userName);
                        } else if (3 == objUser.getType()) {
                            unUserNameList.add(userName);
                        } else if (4 == objUser.getType()) {
                            ldUserNameList.add(userName);
                        }
                    }
                    obj.setObjUsers(list);
                }
                info.setParticipatedUser(StringUtils.join(participatedUserNameList, ","));
                info.setLeaveUser(StringUtils.join(leaveUserNameList, ","));
                info.setAbsentUser(StringUtils.join(absentUserNameList, ","));
                info.setUnUser(StringUtils.join(unUserNameList, ","));
                info.setLdUser(StringUtils.join(ldUserNameList, ","));
            }

            List<ZkActivityEvaluate> evaluates = evaluateService.getListByActivityId(activityId);
            if (evaluates != null && evaluates.size() > 0) {
                List<ZkActivityEvaluateForAddVo> evaluateForAddVoList = new ArrayList<>();
                ZkActivityEvaluateForAddVo activityEvaluateForAddVo = new ZkActivityEvaluateForAddVo();
                activityEvaluateForAddVo.setDeptId(info.getPDeptId());
                activityEvaluateForAddVo.setEvaluates(evaluates);
                evaluateForAddVoList.add(activityEvaluateForAddVo);
                info.setEvaluate(evaluateForAddVoList);
            }
        });
        TableDataInfo<OrganizationalActivityInfoVo> dataInfo = new TableDataInfo<>();
        dataInfo.setRows(infos);
        dataInfo.setTotal(totalData);
        dataInfo.setCode(200);
        dataInfo.setMsg("success");
        return dataInfo;
    }

    @Override
    public TableDataInfo<SpecialActivityInfoVo> querySpecialActivityPageList(ActivityInfoBo bo) {
        bo.setPageNum((bo.getPageNum() - 1) * bo.getPageSize());
        Integer totalData = activityInfoService.queryListForTableDataTotalForSpecial(bo);
        List<SpecialActivityInfoVo> infos = activityInfoService.queryListForTableDataForSpecial(bo);
        Long loginDeptId = SecurityUtils.getDeptId();
        infos.forEach(vo -> {
            vo.setDeptList(activityInfoService.querySpecialActivityCount(vo.getId()));
            SysDept sysDept = deptService.getById(vo.getSubjectDeptId());
            vo.setPDeptName(sysDept.getDeptName());
            // 是否可执行
            Long min = DateUtils.getDifMin(vo.getCreateTime(), new Date());
            // 可做入字典，从字段查询数据
            if (min >= 120) {
                vo.setIsImplement(1);
            } else {
                vo.setIsImplement(0);
            }
            // 是否可取消发布
            if (loginDeptId.equals(vo.getSubjectDeptId())) {
                // 完成数量
                LambdaQueryWrapper<ZkActivityInfo> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                lambdaQueryWrapper.eq(ZkActivityInfo::getTitleType, 4);
                lambdaQueryWrapper.eq(ZkActivityInfo::getSubjectActivityId, vo.getId());
                lambdaQueryWrapper.eq(ZkActivityInfo::getStatus, 1);
                Long count = activityInfoService.count(lambdaQueryWrapper);
                vo.setOverCount(count);
                vo.setIsCancel(1);
                vo.setIsImplement(0);
            } else {
                vo.setOverCount(0L);
                vo.setIsCancel(0);
            }
        });
        TableDataInfo<SpecialActivityInfoVo> dataInfo = new TableDataInfo<>();
        dataInfo.setRows(infos);
        dataInfo.setTotal(totalData);
        dataInfo.setCode(200);
        dataInfo.setMsg("success");
        return dataInfo;
    }

    @Override
    @Transactional
    public boolean add(SpecialActivityAddBo bo) {
        ZkActivityInfo zkActivityInfo = addSpecialActivity(bo);
        if (zkActivityInfo != null) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    @Transactional
    public ZkActivityInfo addForTask(SpecialActivityAddBo bo) {
        return addSpecialActivity(bo);
    }

    public ZkActivityInfo addSpecialActivity(SpecialActivityAddBo bo) {
        ZkActivityInfo zkActivityInfo = new ZkActivityInfo();
        zkActivityInfo.setPDeptId(bo.getDeptId());
        zkActivityInfo.setPDeptName(bo.getDeptName());
        zkActivityInfo.setTheme(bo.getTheme());
        if (Strings.isNotEmpty(bo.getReleaseTime())) {
            zkActivityInfo.setReleaseTime(DateUtils.parseDate(bo.getReleaseTime()));
        }
        if (Strings.isNotEmpty(bo.getOverTime())) {
            zkActivityInfo.setOverTime(DateUtils.parseDate(bo.getOverTime()));
        }
        if (null != bo.getPActivityId()) {
            zkActivityInfo.setPActivityId(bo.getPActivityId());
        }
        if (null != bo.getPushStatus()) {
            zkActivityInfo.setPushStatus(bo.getPushStatus());
        } else {
            zkActivityInfo.setPushStatus(0);
        }
        if (null != bo.getSubjectDeptId()) {
            zkActivityInfo.setSubjectDeptId(bo.getSubjectDeptId());
        } else {
            zkActivityInfo.setSubjectDeptId(bo.getDeptId());
        }
        if (null != bo.getSubjectActivityId()) {
            zkActivityInfo.setSubjectActivityId(bo.getSubjectActivityId());
        }
        zkActivityInfo.setDeptIds(String.valueOf(bo.getDeptId()));
        zkActivityInfo.setTitleType(4L);
        zkActivityInfo.setActivityDate(new Date());
        zkActivityInfo.setActivityLabel(changeActivityLabel(bo.getDeptName(), zkActivityInfo.getReleaseTime()));
        boolean flag = activityInfoService.save(zkActivityInfo);
        if (flag) {
            ZkActivityInfoContent infoContent = new ZkActivityInfoContent();
            LambdaQueryWrapper<ZkActivityContent> lqWrapper = new LambdaQueryWrapper();
            lqWrapper.eq(ZkActivityContent::getContentKey, bo.getContentKey());
            ZkActivityContent content = contentService.getOne(lqWrapper);
            if (content != null) {
                infoContent.setContent(bo.getContent());
                infoContent.setContentKey(content.getContentKey());
                infoContent.setContentName(content.getContentName());
                infoContent.setActivityId(zkActivityInfo.getId());
                flag = infoContentService.save(infoContent);
            }
        }
        return zkActivityInfo;
    }

    @Override
    @Transactional
    public boolean add(OrganizationalActivityBo bo) {
        boolean evaluateFlag = false;
        ZkActivityInfo zkActivityInfo = new ZkActivityInfo();
        BeanUtils.copyProperties(bo, zkActivityInfo);
        if (Strings.isNotEmpty(bo.getType())) {
            QueryWrapper<ZkActivityType> queryWrapper;
            String[] types = bo.getType().split(",");
            List<String> typeIds = new ArrayList<>();
            List<String> typeNames = new ArrayList<>();
            for (String type : types) {
                queryWrapper = new QueryWrapper<>();
                queryWrapper.lambda().eq(ZkActivityType::getTypeValue, type);
                ZkActivityType zkActivityType = activityTypeService.getOne(queryWrapper);
                typeIds.add(zkActivityType.getTypeValue());
                typeNames.add(zkActivityType.getType());
                if (type.equals("08")) evaluateFlag = true;
            }
            zkActivityInfo.setType(StringUtils.join(typeIds, ","));
            zkActivityInfo.setTypeName(StringUtils.join(typeNames, ","));
        }
        if (Strings.isNotEmpty(zkActivityInfo.getDeptIds())) {
            String deptIds = zkActivityInfo.getDeptIds();
            String[] deptIdsArr = deptIds.split(",");
            for (int i = 0; i < deptIdsArr.length; i++) {
                zkActivityInfo.setId(null);
                SysDept sysDept = deptService.selectDeptById(Long.parseLong(deptIdsArr[i]));
                if (sysDept != null) {
                    zkActivityInfo.setPDeptId(sysDept.getDeptId());
                    zkActivityInfo.setPDeptName(sysDept.getDeptName());
                }
                zkActivityInfo = copyProperties(bo, zkActivityInfo, 1);
                zkActivityInfo.setDeptIds(deptIdsArr[i]);
                if (bo.getObjBos() != null && bo.getObjBos().size() == deptIdsArr.length) {
                    ZkActivityObjForAddBo addBo = bo.getObjBos().get(i);
                    Map<Long, List<ZkActivityObjUser>> dataMaps = addBo.getObjUsers().stream().collect(Collectors.groupingBy(ZkActivityObjUser::getType));
                    Integer allUser = addBo.getObjUsers().size();
                    if (0 != allUser) {
                        Integer attendanceSize = 0;
                        Integer leaveSize = 0;
                        if (dataMaps.get(0L) != null) {
                            attendanceSize = dataMaps.get(0L).size();
                        }
                        if (dataMaps.get(1L) != null) {
                            leaveSize = dataMaps.get(1L).size();
                        }
                        if (dataMaps.get(3L) != null) {
                            allUser = allUser - dataMaps.get(3L).size();
                        }
                        if (dataMaps.get(4L) != null) {
                            allUser = allUser - dataMaps.get(4L).size();
                        }
                        BigDecimal attendanceRate = BigDecimal.valueOf(attendanceSize).divide(BigDecimal.valueOf(allUser), 2, BigDecimal.ROUND_DOWN);
                        BigDecimal leaveRate = BigDecimal.valueOf(leaveSize).divide(BigDecimal.valueOf(allUser), 2, BigDecimal.ROUND_DOWN);
                        attendanceRate = attendanceRate.multiply(BigDecimal.valueOf(100));
                        leaveRate = leaveRate.multiply(BigDecimal.valueOf(100));
                        zkActivityInfo.setAttendanceRate(String.valueOf(attendanceRate));
                        zkActivityInfo.setLeaveRate(String.valueOf(leaveRate));
                    } else {
                        zkActivityInfo.setAttendanceRate("0.00");
                    }
                }
                boolean flag = activityInfoService.save(zkActivityInfo);
                if (flag) {
                    Long activityId = zkActivityInfo.getId();
                    saveActivityObj(bo.getObjBos().get(i), activityId);
                    saveActivityInfoContent(bo.getContents(), activityId);
                    if (evaluateFlag && null != bo.getEvaluate()) {
                        saveActivityEvaluate(bo.getEvaluate().get(i), activityId);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public ZkActivityInfoForEditVo getInfo(Long id) {
        ZkActivityInfoForEditVo vo = new ZkActivityInfoForEditVo();
        ZkActivityInfo info = activityInfoService.getById(id);
        if (null == info) {
            throw new ServiceException("活动不存在！");
        }
        BeanUtils.copyProperties(info, vo);
        // 活动对象
        LambdaQueryWrapper<ZkActivityObj> objLqWrapper = new LambdaQueryWrapper();
        objLqWrapper.eq(ZkActivityObj::getActivityId, id);
        vo.setObjBos(objService.listVo(objLqWrapper));
        LambdaQueryWrapper<ZkActivityInfoContent> contentLqWrapper = new LambdaQueryWrapper();
        contentLqWrapper.eq(ZkActivityInfoContent::getActivityId, id);
        vo.setContents(infoContentService.listVo(contentLqWrapper));
        // 人员
        if (!CollectionUtils.isEmpty(vo.getObjBos())) {
            LambdaQueryWrapper<ZkActivityObjUser> objUserLqWrapper;
            List<ZkActivityObjUser> list;
            List<String> participatedUserNameList = new ArrayList<>();
            List<String> leaveUserNameList = new ArrayList<>();
            List<String> absentUserNameList = new ArrayList<>();
            List<String> unUserNameList = new ArrayList<>();
            List<String> ldUserNameList = new ArrayList<>();
            for (ZkActivityObjVo obj : vo.getObjBos()) {
                objUserLqWrapper = new LambdaQueryWrapper<>();
                objUserLqWrapper.eq(ZkActivityObjUser::getActivityId, vo.getId());
                objUserLqWrapper.eq(ZkActivityObjUser::getActivityObjId, obj.getId());
                list = objUserService.list(objUserLqWrapper);
                for (ZkActivityObjUser objUser : list) {
                    String userName = objUser.getUserName();
                    if (0 == objUser.getType()) {
                        participatedUserNameList.add(userName);
                    } else if (1 == objUser.getType()) {
                        leaveUserNameList.add(userName);
                    } else if (2 == objUser.getType()) {
                        absentUserNameList.add(userName);
                    } else if (3 == objUser.getType()) {
                        unUserNameList.add(userName);
                    } else if (4 == objUser.getType()) {
                        ldUserNameList.add(userName);
                    }
                }
                obj.setObjUsers(list);
            }
            vo.setParticipatedUser(StringUtils.join(participatedUserNameList, ","));
            vo.setLeaveUser(StringUtils.join(leaveUserNameList, ","));
            vo.setAbsentUser(StringUtils.join(absentUserNameList, ","));
            vo.setUnUser(StringUtils.join(unUserNameList, ","));
            vo.setLdUser(StringUtils.join(ldUserNameList, ","));
        }
        List<ZkActivityEvaluate> evaluates = evaluateService.getListByActivityId(id);
        if (evaluates != null && evaluates.size() > 0) {
            List<ZkActivityEvaluateForAddVo> evaluateForAddVoList = new ArrayList<>();
            ZkActivityEvaluateForAddVo activityEvaluateForAddVo = new ZkActivityEvaluateForAddVo();
            activityEvaluateForAddVo.setDeptId(vo.getPDeptId());
            activityEvaluateForAddVo.setEvaluates(evaluates);
            evaluateForAddVoList.add(activityEvaluateForAddVo);
            vo.setEvaluate(evaluateForAddVoList);
        }
        return vo;
    }

    @Override
    public boolean edit(OrganizationalActivityBo bo, int btnType) {
        ZkActivityInfo info = activityInfoService.getById(bo.getId());
        boolean flag = false;
        boolean evaluateFlag = false;
        if (null != info) {
            BeanUtils.copyProperties(bo, info);
            if (Strings.isNotEmpty(bo.getType())) {
                QueryWrapper<ZkActivityType> queryWrapper;
                String[] types = bo.getType().split(",");
                List<String> typeIds = new ArrayList<>();
                List<String> typeNames = new ArrayList<>();
                for (String type : types) {
                    queryWrapper = new QueryWrapper<>();
                    queryWrapper.lambda().eq(ZkActivityType::getTypeValue, type);
                    ZkActivityType zkActivityType = activityTypeService.getOne(queryWrapper);
                    typeIds.add(zkActivityType.getTypeValue());
                    typeNames.add(zkActivityType.getType());
                    if (type.equals("08")) evaluateFlag = true;
                }
                String typeIdsStr = StringUtils.join(typeIds, ",");
                info.setType(typeIdsStr);
                info.setTypeName(StringUtils.join(typeNames, ","));
            }
            if (Strings.isNotEmpty(bo.getDeptIds())) {
                String deptIds = info.getDeptIds();
                String[] deptIdsArr = deptIds.split(",");
                LambdaQueryWrapper<ZkActivityInfo> lambdaQueryWrapper = null;
                ZkActivityInfo insertInfo = null;
                Long activityId = null;
                Long pActivityId = null;
                Long pDeptId = null;
                String pDeptName = null;
                for (int i = 0; i < deptIdsArr.length; i++) {
                    Long deptId = Long.parseLong(deptIdsArr[i]);
                    if (!bo.getPDeptId().equals(deptId)) {
                        lambdaQueryWrapper = new LambdaQueryWrapper<>();
                        lambdaQueryWrapper.eq(ZkActivityInfo::getPActivityId, bo.getId());
                        lambdaQueryWrapper.eq(ZkActivityInfo::getPDeptId, deptId);
                        insertInfo = activityInfoService.getOne(lambdaQueryWrapper);
                        if (insertInfo != null) {
                            if (btnType == 1 && insertInfo.getStatus() == 1) {
                                continue;
                            }
                            activityId = insertInfo.getId();
                            pActivityId = insertInfo.getPActivityId();
                            pDeptId = insertInfo.getPDeptId();
                            pDeptName = insertInfo.getPDeptName();
                        } else {
                            continue;
                        }
                    } else {
                        insertInfo = new ZkActivityInfo();
                        activityId = info.getId();
                        pActivityId = insertInfo.getPActivityId();
                        pDeptId = insertInfo.getPDeptId();
                        pDeptName = insertInfo.getPDeptName();
                    }
                    info.setDeptIds(deptIdsArr[i]);
                    info.setPActivityId(pActivityId);
                    info.setPDeptName(pDeptName);
                    info.setPDeptId(pDeptId);
                    BeanUtils.copyProperties(info, insertInfo);
                    insertInfo = copyProperties(bo, insertInfo, bo.getTitleType());
                    if (activityId != null) {
                        insertInfo.setId(activityId);
                    }
                    // 活动标签存储
                    flag = activityInfoService.updateById(insertInfo);
                    if (flag) {
                        LambdaQueryWrapper<ZkActivityInfoContent> infoLqWrapper = new LambdaQueryWrapper<>();
                        infoLqWrapper.eq(ZkActivityInfoContent::getActivityId, activityId);
                        infoContentService.remove(infoLqWrapper);
                        saveActivityObj(bo.getObjBos().get(i), activityId);
                        saveActivityInfoContent(bo.getContents(), activityId);
                        // 评议结果不能修改：2021/11/11
//                        if (evaluateFlag && null != vo.getEvaluate()) {
//                            saveActivityEvaluate(vo.getEvaluate().get(i), activityId);
//                        }
                    }
                    if (bo.getObjBos() != null && bo.getObjBos().size() == deptIdsArr.length) {
                        ZkActivityObjForAddBo addBo = bo.getObjBos().get(i);
                        Map<Long, List<ZkActivityObjUser>> dataMaps = addBo.getObjUsers().stream().collect(Collectors.groupingBy(ZkActivityObjUser::getType));
                        Integer allUser = addBo.getObjUsers().size();
                        if (0 != allUser) {
                            Integer attendanceSize = 0;
                            Integer leaveSize = 0;
                            if (dataMaps.get(0L) != null) {
                                attendanceSize = dataMaps.get(0L).size();
                            }
                            if (dataMaps.get(1L) != null) {
                                leaveSize = dataMaps.get(1L).size();
                            }
                            if (dataMaps.get(3L) != null) {
                                allUser = allUser - dataMaps.get(3L).size();
                            }
                            if (dataMaps.get(4L) != null) {
                                allUser = allUser - dataMaps.get(4L).size();
                            }
                            BigDecimal attendanceRate = BigDecimal.valueOf(attendanceSize).divide(BigDecimal.valueOf(allUser), 2, BigDecimal.ROUND_DOWN);
                            BigDecimal leaveRate = BigDecimal.valueOf(leaveSize).divide(BigDecimal.valueOf(allUser), 2, BigDecimal.ROUND_DOWN);
                            attendanceRate = attendanceRate.multiply(BigDecimal.valueOf(100));
                            leaveRate = leaveRate.multiply(BigDecimal.valueOf(100));
                            insertInfo.setAttendanceRate(String.valueOf(attendanceRate));
                            insertInfo.setLeaveRate(String.valueOf(leaveRate));
                        } else {
                            insertInfo.setAttendanceRate("0.00");
                        }
                        activityInfoService.updateById(insertInfo);
                    }
                }
            }

        } else {
            throw new ServiceException("活动不存在!");
        }
        return flag;
    }

    private ZkActivityInfo copyProperties(OrganizationalActivityBo bo, ZkActivityInfo info, long titleType) {
        if (Strings.isNotEmpty(bo.getActivityDate())) {
            info.setActivityDate(DateUtils.parseDate(bo.getActivityDate()));
        }
        if (Strings.isNotEmpty(bo.getOverTime())) {
            info.setOverTime(DateUtils.parseDate(bo.getOverTime()));
        }
        if (Strings.isNotEmpty(bo.getExecutionTime())) {
            info.setExecutionTime(DateUtils.parseDate(bo.getExecutionTime()));
        }
        if (Strings.isNotEmpty(bo.getReleaseTime())) {
            info.setReleaseTime(DateUtils.parseDate(bo.getReleaseTime()));
        }
        if (titleType == 4) {
            info.setActivityLabel(changeActivityLabel(info.getPDeptName(), info.getReleaseTime()));
        } else {
            info.setActivityLabel(changeActivityLabel(info.getPDeptName(), info.getActivityDate()));
        }
        return info;
    }

    public void saveActivityObjs(List<ZkActivityObjForAddBo> bos, Long activityId) {
        // 活动对象
        if (!CollectionUtils.isEmpty(bos)) {
            for (ZkActivityObjForAddBo bo : bos) {
                saveActivityObj(bo, activityId);
            }
        }
    }

    public void saveActivityObj(ZkActivityObjForAddBo bo, Long activityId) {
        // 活动对象
        if (null != bo) {
            ZkActivityObj obj = new ZkActivityObj();
            ZkActivityObjUser objUser;
            if (bo.getId() != null) {
                obj.setId(bo.getId());
            }
            obj.setObjKey(bo.getObjKey());
            obj.setObjValue(bo.getObjValue());
            obj.setLabel(bo.getLabel());
            obj.setActivityId(activityId);
            // 先删除，再插入
            LambdaQueryWrapper<ZkActivityObj> lambdaQueryWrapper = new LambdaQueryWrapper<>();
            lambdaQueryWrapper.eq(ZkActivityObj::getActivityId, activityId);
            objService.remove(lambdaQueryWrapper);
            if (objService.saveOrUpdate(obj)) {
                if (!CollectionUtils.isEmpty(bo.getObjUsers())) {
                    // 先删除，再插入
                    LambdaQueryWrapper<ZkActivityObjUser> objUserLambdaQueryWrapper = new LambdaQueryWrapper<>();
                    objUserLambdaQueryWrapper.eq(ZkActivityObjUser::getActivityId, activityId);
                    objUserService.remove(objUserLambdaQueryWrapper);
                    for (ZkActivityObjUser zkObjUser : bo.getObjUsers()) {
                        objUser = new ZkActivityObjUser();
                        BeanUtils.copyProperties(zkObjUser, objUser);
                        objUser.setActivityId(activityId);
                        objUser.setActivityObjId(obj.getId());
                        objUserService.saveOrUpdate(objUser);
                    }
                }
            }
        }
    }

    public void saveActivityInfoContent(List<ZkActivityInfoContentForAddBo> bos, Long activityId) {
        // 活动内容
        // 先删除，再插入
        if (!CollectionUtils.isEmpty(bos)) {
            LambdaQueryWrapper<ZkActivityInfoContent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
            lambdaQueryWrapper.eq(ZkActivityInfoContent::getActivityId, activityId);
            infoContentService.remove(lambdaQueryWrapper);
            ZkActivityInfoContent content;
            for (ZkActivityInfoContentForAddBo bo : bos) {
                content = new ZkActivityInfoContent();
                BeanUtils.copyProperties(bo, content);
                content.setActivityId(activityId);
                content.setId(null);
                infoContentService.save(content);
            }
        }
    }

    public void saveActivityEvaluate(ZkActivityEvaluateForAddVo evaluateVo, Long activityId) {
        // 活动组织评定，2021/11/11无法修改，无需删除插入
        // 先删除，再插入
        ZkActivityEvaluate evaluate;
        List<ZkActivityEvaluate> list;
        LambdaQueryWrapper<ZkActivityEvaluate> lambdaQueryWrapper;
//        lambdaQueryWrapper.eq(ZkActivityEvaluate::getActivityId, activityId);
//        evaluateService.remove(lambdaQueryWrapper);
        // 有记录不进行更新
        for (ZkActivityEvaluate vo : evaluateVo.getEvaluates()) {
            lambdaQueryWrapper = new LambdaQueryWrapper<>();
            lambdaQueryWrapper.eq(ZkActivityEvaluate::getUserId, vo.getUserId());
            list = evaluateService.list(lambdaQueryWrapper);
            if (list != null && list.size() > 0) {
                continue;
            }
            evaluate = new ZkActivityEvaluate();
            BeanUtils.copyProperties(vo, evaluate);
            evaluate.setActivityId(activityId);
            evaluateService.saveOrUpdate(evaluate);
        }

    }

    @Override
    public boolean delete(Long[] ids) {
        boolean flag = false;
        if (ids != null) {
            for (Long id : ids) {
                ZkActivityInfo info = activityInfoService.getById(id);
                if (null != info) {
                    if (info.getTitleType().equals(4)) {
                        if (!SecurityUtils.getDeptId().equals(info.getSubjectDeptId())) {
                            throw new ServiceException("暂无操作权限！");
                        }
                    }
                    info.setIsDel(1);
                    flag = activityInfoService.updateById(info);
                    if (flag) {
                        LambdaQueryWrapper<ZkActivityInfo> queryWrapper = new LambdaQueryWrapper<>();
                        queryWrapper.eq(ZkActivityInfo::getPActivityId, id);
                        List<ZkActivityInfo> list = activityInfoService.list(queryWrapper);
                        Long[] idsArr = new Long[list.size()];
                        int i = 0;
                        for (ZkActivityInfo zkInfo : list) {
                            idsArr[i] = zkInfo.getId();
                            i++;
                        }
                        flag = delete(idsArr);
                    }
                } else {
                    //throw new ServiceException("活动不存在!");
                }
            }
        }
        return flag;
    }

    /**
     * 同步组织数据
     *
     * @param bo
     * @return
     */
    @Override
    public boolean syncActivity(ActivitySyncBo bo) {
        String idStr = bo.getActivityIds();
        String[] ids = idStr.split(",");
        if (ids.length <= 0) {
            return false;
        }
        if (CollectionUtils.isEmpty(bo.getList())) {
            return false;
        }
        ZkActivityInfo info;
        for (ActivityDeptAndObjVo vo : bo.getList()) {
            SysDept dept = deptService.selectDeptById(Long.parseLong(vo.getDeptId()));
            for (String id : ids) {
                Long activityId = Long.parseLong(id);
                info = activityInfoService.getById(activityId);
                if (info != null) {
                    info.setActivityDate(new Date());
                    info.setActivityLabel(dept.getDeptName() + info.getActivityDate());
                    info.setDeptIds(vo.getDeptId());
                    info.setPDeptName(dept.getDeptName());
                    info.setPDeptId(Long.parseLong(vo.getDeptId()));
                    info.setId(null);
                    if (activityInfoService.save(info)) {
                        saveActivityObjs(vo.getObjs(), info.getId());
                        LambdaQueryWrapper<ZkActivityInfoContent> contentLqWrapper = new LambdaQueryWrapper();
                        contentLqWrapper.eq(ZkActivityInfoContent::getActivityId, id);
                        List<ZkActivityInfoContentVo> infoContentList = infoContentService.listVo(contentLqWrapper);
                        List<ZkActivityInfoContentForAddBo> addbos = new ArrayList<>();
                        ZkActivityInfoContentForAddBo addbo;
                        for (ZkActivityInfoContentVo infoContentVo : infoContentList) {
                            addbo = new ZkActivityInfoContentForAddBo();
                            addbo.setActivityId(info.getId());
                            addbo.setContent(infoContentVo.getContent());
                            addbo.setContentKey(infoContentVo.getContentKey());
                            addbo.setContentName(infoContentVo.getContentName());
                            addbos.add(addbo);
                        }
                        saveActivityInfoContent(addbos, info.getId());
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean specialActivityCorrection(SpecialActivityCorrectionBo bo, ZkActivityContent content, ZkActivityInfoContent infoContent) {
        boolean flag = false;
        if (bo != null) {
            Long id = bo.getId();
            ZkActivityInfo info = activityInfoService.getById(id);
            if (null != info) {
                if (!SecurityUtils.getDeptId().equals(info.getSubjectDeptId())) {
                    throw new ServiceException("暂无操作权限！");
                }
                info.setTheme(bo.getTheme());
                info.setOverTime(DateUtils.parseDate(bo.getOverTime()));
                info.setReleaseTime(DateUtils.parseDate(bo.getReleaseTime()));
                flag = activityInfoService.updateById(info);
                if (flag) {
                    if (content != null) {
                        LambdaQueryWrapper<ZkActivityInfoContent> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                        lambdaQueryWrapper.eq(ZkActivityInfoContent::getActivityId, id);
                        infoContent.setActivityId(id);
                        flag = infoContentService.update(infoContent, lambdaQueryWrapper);
                    }
                    LambdaQueryWrapper<ZkActivityInfo> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(ZkActivityInfo::getPActivityId, id);
                    List<ZkActivityInfo> list = activityInfoService.list(queryWrapper);
                    if (!CollectionUtils.isEmpty(list)) {
                        SpecialActivityCorrectionBo correctionBo;
                        for (ZkActivityInfo activityInfo : list) {
                            correctionBo = new SpecialActivityCorrectionBo();
                            BeanUtils.copyProperties(bo, correctionBo);
                            bo.setId(activityInfo.getId());
                            specialActivityCorrection(bo, content, infoContent);
                        }
                    }
                }
            } else {
                //throw new ServiceException("活动不存在!");
            }
        }
        return flag;
    }

    @Override
    public List<ZkActivityEvaluate> queryEvaluateById(Long id) {
        LambdaQueryWrapper<ZkActivityEvaluate> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(ZkActivityEvaluate::getActivityId, id);
        return evaluateService.list(lambdaQueryWrapper);
    }

    private String changeActivityLabel(String deptName, Date time) {
        String timeStr = DateUtils.parseDateToStr(DateUtils.YYYYMMDD_HHMM, time).replace(" ", "T");
        return deptName + " " + timeStr;
    }
}
