package com.ruoyi.system.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.RedisUtils;
import com.ruoyi.system.domain.SysPost;
import com.ruoyi.system.domain.ZkActivityContent;
import com.ruoyi.system.domain.ZkActivityType;
import com.ruoyi.system.domain.ZkActivityTypeContent;
import com.ruoyi.system.domain.vo.SysPostByTypeVo;
import com.ruoyi.system.domain.vo.ZkActivityHostUserVo;
import com.ruoyi.system.service.*;
import com.ruoyi.system.utils.redis.RedisForActivityUtil;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class IBaseDataActivityServiceImpl implements IBaseDataActivityService {

    @Autowired
    private IZkActivityContentService contentService;
    @Autowired
    private IZkActivityTypeContentService typeContentService;
    @Autowired
    private ISysDictDataService sysDictDataService;
    @Autowired
    private ISysPostService postService;
    @Autowired
    private ISysUserService userService;

    /**
     * 获取活动内容
     *
     * @return
     */
    @Override
    public List<Map<String, Object>> getActivityContent() {
        List<Map<String, Object>> list = RedisForActivityUtil.getActivityContent();
        if (CollectionUtils.isEmpty(list)) {
            List<ZkActivityContent> contents = contentService.list();
            list = initActivityContentMap(null, contents);
        }
        return list;
    }

    /**
     * 获取活动内容
     *
     * @return
     */
    @Override
    public List<Map<String, Object>> getActivityContentDict() {
        List<Map<String, Object>> list = RedisForActivityUtil.getActivityContent();
        if (CollectionUtils.isEmpty(list)) {
            SysDictData sysDictData = new SysDictData();
            sysDictData.setDictType("activity_content");
            List<SysDictData> dictDataList = sysDictDataService.selectDictDataList(sysDictData);
            list = initActivityContentMaps(null, dictDataList);
        }
        return list;
    }

    /**
     * 获取活动内容
     *
     * @param key
     * @return
     */
    @Override
    public List<Map<String, Object>> getActivityContent(String key) {
        List<Map<String, Object>> list = RedisForActivityUtil.getActivityContent(key);
        if (CollectionUtils.isEmpty(list)) {
            LambdaQueryWrapper<ZkActivityTypeContent> queryWrapper = new LambdaQueryWrapper();
            if (Strings.isNotEmpty(key)) {
                String keyStr[] = key.split(",");
                for (int i = 0; i < keyStr.length; i++) {
                    if (i == 0) {
                        queryWrapper.eq(ZkActivityTypeContent::getType, keyStr[i]);
                    } else {
                        queryWrapper.or().eq(ZkActivityTypeContent::getType, keyStr[i]);
                    }
                }
            }
            List<ZkActivityTypeContent> typeContent = typeContentService.list(queryWrapper);
            if (null != typeContent) {
                Set<String> ids = new HashSet<>();
                for (ZkActivityTypeContent con : typeContent) {
                    ids.addAll(Arrays.asList(con.getContentIds().split(",")));
                }
                List<ZkActivityContent> contents = contentService.listByIds(ids);
                list = initActivityContentMap(key, contents);
            }
        }
        return list;
    }

    /**
     * 获取活动内容
     *
     * @param key
     * @return
     */
    @Override
    public List<Map<String, Object>> getActivityContentDict(String key) {
        List<Map<String, Object>> list = RedisForActivityUtil.getActivityContent(key);
        if (CollectionUtils.isEmpty(list)) {
            List<SysDictData> sysDictDataList = queryDict("activity_type", key);
            if (null != sysDictDataList) {
                Set<String> ids = new HashSet<>();
                for (SysDictData data : sysDictDataList) {
                    ids.addAll(Arrays.asList(data.getDictValue().split(",")));
                }
                QueryWrapper<SysDictData> dataLambdaQueryWrapper = new QueryWrapper<>();
                dataLambdaQueryWrapper.lambda().eq(SysDictData::getDictType, "activity_content_type");
                dataLambdaQueryWrapper.lambda().and(lq -> {
                    for (String label : ids) {
                        lq.or().eq(SysDictData::getDictLabel, label);
                    }
                });
                List<SysDictData> dictDataList = sysDictDataService.list(dataLambdaQueryWrapper);
                if (null != dictDataList) {
                    Set<String> values = new HashSet<>();
                    for (SysDictData data : dictDataList) {
                        values.addAll(Arrays.asList(data.getDictValue().split(",")));
                    }
                    dictDataList = queryDict("activity_content", String.join(",", values));
                    list = initActivityContentMaps(key, dictDataList);
                }
            }
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getPostList(String typeValue) {
        List<Map<String, Object>> mapList = new ArrayList<>();
        Map<String, Object> map;
        Map<String, Object> mapFlag = new HashMap<>();
        List<SysDictData> sysDictDataList = queryDict("activity_type", typeValue);
        if (null != sysDictDataList) {
            Set<String> ids = new HashSet<>();
            for (SysDictData data : sysDictDataList) {
                ids.addAll(Arrays.asList(data.getDictValue().split(",")));
            }
            QueryWrapper<SysDictData> dataLambdaQueryWrapper = new QueryWrapper<>();
            dataLambdaQueryWrapper.lambda().eq(SysDictData::getDictType, "activity_post_type");
            dataLambdaQueryWrapper.lambda().and(lq -> {
                for (String label : ids) {
                    lq.or().eq(SysDictData::getDictLabel, label);
                }
            });
            List<SysDictData> dictDataList = sysDictDataService.list(dataLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(dictDataList) && dictDataList.size() > 0) {
                Set<String> values = new HashSet<>();
                for (SysDictData data : dictDataList) {
                    values.addAll(Arrays.asList(data.getDictValue().split(",")));
                }
                List<SysPost> list = postService.listByIds(values);
                for (SysPost post : list) {
                    map = new HashMap<>();
                    map.put("label", post.getPostName());
                    map.put("value", post.getPostId());
                    if (mapFlag.get(String.valueOf(post.getPostId())) == null) {
                        mapList.add(map);
                        mapFlag.put(String.valueOf(post.getPostId()), map);
                    }
                }
            }
        }
        return mapList;
    }

    @Override
    public List<SysDictData> getUnqualified() {
        QueryWrapper<SysDictData> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SysDictData::getDictType, "activity_evaluate_unqualified");
        return sysDictDataService.list(queryWrapper);
    }

    public List<SysDictData> queryDict(String type, String keys) {
        QueryWrapper<SysDictData> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(SysDictData::getDictType, type);
        if (Strings.isNotEmpty(keys)) {
            queryWrapper.lambda().and(lq -> {
                    String keyStr[] = keys.split(",");
                    for (int i = 0; i < keyStr.length; i++) {
                        lq.or().eq(SysDictData::getDictValue, keyStr[i]);
                    }
            });
        }
        queryWrapper.lambda().orderByAsc(SysDictData::getDictSort);
        return sysDictDataService.list(queryWrapper);
    }


    /**
     * 获取活动类型
     *
     * @param roleFlag
     * @return
     */
    @Override
    public List<Map<String, Object>> getTypeList(String roleFlag) {
        // 切换为非必传
        if (Strings.isEmpty(roleFlag) || (!"1".equals(roleFlag) && !"3".equals(roleFlag))) {
            roleFlag = "1";
        }
        List<Map<String, Object>> mapList = new ArrayList<>();
        Map<String, Object> map;
        LambdaQueryWrapper<SysDictData> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SysDictData::getDictType, "activity_type");
        List<SysDictData> list = sysDictDataService.list(lambdaQueryWrapper);
        for (SysDictData type : list) {
            map = new HashMap<>();
            if ("3".equals(roleFlag)) {
                if ("02".equals(type.getDictValue()))
                    continue;
            }
            if ("1".equals(roleFlag)) {
                if ("01".equals(type.getDictValue()))
                    continue;
            }
            map.put("value", type.getDictValue());
            map.put("label", type.getDictLabel());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public List<SysUser> getHostUserByDeptId(Long deptId) {
        return userService.getUserByDeptIdAndRoleName(deptId, "书记");
    }

    @Override
    public List<SysUser> getUserByDeptId(Long deptId) {
        LambdaQueryWrapper<SysUser> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(SysUser::getDeptId, deptId);
        lambdaQueryWrapper.eq(SysUser::getIsUser, 1);
        return userService.list(lambdaQueryWrapper);
    }

    public List<Map<String, Object>> initActivityContentMap(String key, List<ZkActivityContent> contents) {
        List<Map<String, Object>> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(contents)) {
            Map<String, Object> map = null;
            for (ZkActivityContent content : contents) {
                map = new HashMap<>();
                map.put("key", content.getContentKey());
                map.put("value", content.getContentName());
                list.add(map);
            }
        }
        if (Strings.isEmpty(key)) {
            RedisForActivityUtil.setActivityContent(list);
        }
        return list;
    }

    public List<Map<String, Object>> initActivityContentMaps(String key, List<SysDictData> contents) {
        List<Map<String, Object>> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(contents)) {
            Map<String, Object> map = null;
            for (SysDictData content : contents) {
                map = new HashMap<>();
                map.put("key", content.getDictValue());
                map.put("value", content.getDictLabel());
                list.add(map);
            }
        }
        if (Strings.isEmpty(key)) {
            RedisForActivityUtil.setActivityContent(list);
        }
        return list;
    }

}
