package com.ruoyi.system.service.impl;

import com.ruoyi.system.domain.bo.CockpitActivityQueryBo;
import com.ruoyi.system.domain.vo.ZkActivityCountVo;
import com.ruoyi.system.mapper.ZkActivityInfoCountMapper;
import com.ruoyi.system.service.IZkActivityInfoCountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
@Service
public class IZkActivityInfoCountImpl implements IZkActivityInfoCountService {

    @Autowired
    private ZkActivityInfoCountMapper countMapper;

    @Override
    public Long selectActivityWithContentCount(CockpitActivityQueryBo queryBo){
        return countMapper.selectActivityWithContentCount(queryBo);
    }

    @Override
    public Long selectActivityAttendanceAvg(CockpitActivityQueryBo queryBo) {
        return countMapper.selectActivityAttendanceAvg(queryBo);
    }

    @Override
    public Long selectActivityAttendanceAvgByTypeList(CockpitActivityQueryBo queryBo) {
        return countMapper.selectActivityAttendanceAvgByTypeList(queryBo);
    }

    @Override
    public Long selectActivityLeaveAvg(CockpitActivityQueryBo queryBo) {
        return countMapper.selectActivityLeaveAvg(queryBo);
    }

    @Override
    public List<ZkActivityCountVo> selectSpecialActivityStatus(CockpitActivityQueryBo queryBo) {
        return countMapper.selectSpecialActivityStatus(queryBo);
    }

    @Override
    public Long selectActivityDuration(CockpitActivityQueryBo queryBo) {
        return countMapper.selectActivityDuration(queryBo);
    }

    @Override
    public List<ZkActivityCountVo> selectActivityEvaluate(CockpitActivityQueryBo queryBo) {
        return countMapper.selectActivityEvaluate(queryBo);
    }

    @Override
    public Long selectActivityObjUserUnCount(CockpitActivityQueryBo queryBo) {
        return countMapper.selectActivityObjUserUnCount(queryBo);
    }
}
