package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.system.domain.TbDzbCount;
import com.ruoyi.system.domain.bo.TbDzbCountBo;
import com.ruoyi.system.domain.vo.TbDzbCountForScreenVo;
import com.ruoyi.system.domain.vo.TbDzbCountVo;
import com.ruoyi.system.mapper.TbDzbCountMapper;
import com.ruoyi.system.service.ITbDzbCountService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 党支部基层数据大屏统计Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Service
public class TbDzbCountServiceImpl extends ServicePlusImpl<TbDzbCountMapper, TbDzbCount, TbDzbCountVo> implements ITbDzbCountService {

    @Override
    public TbDzbCountVo queryById(Long id) {
        return getVoById(id);
    }

    @Override
    public TableDataInfo<TbDzbCountVo> queryPageList(TbDzbCountBo bo) {
        PagePlus<TbDzbCount, TbDzbCountVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<TbDzbCountVo> queryList(TbDzbCountBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<TbDzbCount> buildQueryWrapper(TbDzbCountBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<TbDzbCount> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getName()), TbDzbCount::getName, bo.getName());
        lqw.eq(bo.getDzbCount() != null, TbDzbCount::getDzbCount, bo.getDzbCount());
        lqw.eq(bo.getDyCount() != null, TbDzbCount::getDyCount, bo.getDyCount());
        lqw.eq(bo.getYbdyCount() != null, TbDzbCount::getYbdyCount, bo.getYbdyCount());
        lqw.eq(bo.getIsShow() != null, TbDzbCount::getIsShow, bo.getIsShow());
        return lqw;
    }

    @Override
    public Boolean insertByBo(TbDzbCountBo bo) {
        TbDzbCount add = BeanUtil.toBean(bo, TbDzbCount.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(TbDzbCountBo bo) {
        TbDzbCount update = BeanUtil.toBean(bo, TbDzbCount.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(TbDzbCount entity) {
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if (isValid) {
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }

    @Override
    public List<Map<String, Object>> getScreen() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        Map<String, Object> dataMap;
        List<TbDzbCount> dzbCounts = this.list();
        TbDzbCountForScreenVo vo = null;
        for (TbDzbCount dzb : dzbCounts) {
            dataMap = new HashMap<>();
            vo = new TbDzbCountForScreenVo();
            BeanUtils.copyProperties(dzb, vo);
            dataMap.put("name", dzb.getName());
            dataMap.put("data", vo);
            resultList.add(dataMap);
        }
        return resultList;
    }
}
