package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.TbDzbGatheringsCountBo;
import com.ruoyi.system.domain.vo.TbDzbGatheringsCountVo;
import com.ruoyi.system.domain.TbDzbGatheringsCount;
import com.ruoyi.system.mapper.TbDzbGatheringsCountMapper;
import com.ruoyi.system.service.ITbDzbGatheringsCountService;

import java.util.*;

/**
 * 组织生活会/民主生活会 数据统计Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Service
public class TbDzbGatheringsCountServiceImpl extends ServicePlusImpl<TbDzbGatheringsCountMapper, TbDzbGatheringsCount, TbDzbGatheringsCountVo> implements ITbDzbGatheringsCountService {

    @Override
    public TbDzbGatheringsCountVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<TbDzbGatheringsCountVo> queryPageList(TbDzbGatheringsCountBo bo) {
        PagePlus<TbDzbGatheringsCount, TbDzbGatheringsCountVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<TbDzbGatheringsCountVo> queryList(TbDzbGatheringsCountBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<TbDzbGatheringsCount> buildQueryWrapper(TbDzbGatheringsCountBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<TbDzbGatheringsCount> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getName()), TbDzbGatheringsCount::getName, bo.getName());
        lqw.eq(bo.getTotalCount() != null, TbDzbGatheringsCount::getTotalCount, bo.getTotalCount());
        lqw.eq(bo.getAvgDuration() != null, TbDzbGatheringsCount::getAvgDuration, bo.getAvgDuration());
        lqw.eq(bo.getAttendanceRate() != null, TbDzbGatheringsCount::getAttendanceRate, bo.getAttendanceRate());
        lqw.eq(bo.getLeaveRate() != null, TbDzbGatheringsCount::getLeaveRate, bo.getLeaveRate());
        lqw.eq(bo.getProblemsCount() != null, TbDzbGatheringsCount::getProblemsCount, bo.getProblemsCount());
        lqw.eq(bo.getCriticismCount() != null, TbDzbGatheringsCount::getCriticismCount, bo.getCriticismCount());
        lqw.eq(bo.getRectificationCount() != null, TbDzbGatheringsCount::getRectificationCount, bo.getRectificationCount());
        lqw.eq(bo.getCompletionRate() != null, TbDzbGatheringsCount::getCompletionRate, bo.getCompletionRate());
        return lqw;
    }

    @Override
    public Boolean insertByBo(TbDzbGatheringsCountBo bo) {
        TbDzbGatheringsCount add = BeanUtil.toBean(bo, TbDzbGatheringsCount.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(TbDzbGatheringsCountBo bo) {
        TbDzbGatheringsCount update = BeanUtil.toBean(bo, TbDzbGatheringsCount.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(TbDzbGatheringsCount entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }

    @Override
    public List<Map<String, Object>> getScreen() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        Map<String, Object> map;
        Map<String, Object> dataMap;
        Map<String, Object> zzsshMap;
        Map<String, Object> mzsshMap;
        List<TbDzbGatheringsCount> dzbCounts = this.list();
        for (TbDzbGatheringsCount count : dzbCounts) {
            map = new HashMap<>();
            dataMap = new HashMap<>();
            zzsshMap = new HashMap<>();
            zzsshMap.put("totalCount", count.getTotalCount());
            zzsshMap.put("avgDuration", count.getAvgDuration());
            zzsshMap.put("attendanceRate", count.getAttendanceRate());
            zzsshMap.put("leaveRate", count.getLeaveRate());
            mzsshMap = new HashMap<>();
            mzsshMap.put("problemsCount", count.getProblemsCount());
            mzsshMap.put("criticismCount", count.getCriticismCount());
            mzsshMap.put("rectificationCount", count.getRectificationCount());
            mzsshMap.put("completionRate", count.getCompletionRate());
            dataMap.put("zzshh", zzsshMap);
            dataMap.put("mzshh", mzsshMap);
            map.put("name", count.getName());
            map.put("data", dataMap);
            resultList.add(map);
        }
        return resultList;
    }
}
