package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.TbDzbMeetingsCountBo;
import com.ruoyi.system.domain.vo.TbDzbMeetingsCountVo;
import com.ruoyi.system.domain.TbDzbMeetingsCount;
import com.ruoyi.system.mapper.TbDzbMeetingsCountMapper;
import com.ruoyi.system.service.ITbDzbMeetingsCountService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 三会一课

Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Service
public class TbDzbMeetingsCountServiceImpl extends ServicePlusImpl<TbDzbMeetingsCountMapper, TbDzbMeetingsCount, TbDzbMeetingsCountVo> implements ITbDzbMeetingsCountService {

    @Override
    public TbDzbMeetingsCountVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<TbDzbMeetingsCountVo> queryPageList(TbDzbMeetingsCountBo bo) {
        PagePlus<TbDzbMeetingsCount, TbDzbMeetingsCountVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<TbDzbMeetingsCountVo> queryList(TbDzbMeetingsCountBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<TbDzbMeetingsCount> buildQueryWrapper(TbDzbMeetingsCountBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<TbDzbMeetingsCount> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getName()), TbDzbMeetingsCount::getName, bo.getName());
        lqw.eq(StringUtils.isNotBlank(bo.getType()), TbDzbMeetingsCount::getType, bo.getType());
        lqw.like(StringUtils.isNotBlank(bo.getChildName()), TbDzbMeetingsCount::getChildName, bo.getChildName());
        lqw.eq(bo.getValue() != null, TbDzbMeetingsCount::getValue, bo.getValue());
        lqw.eq(StringUtils.isNotBlank(bo.getNumber()), TbDzbMeetingsCount::getNumber, bo.getNumber());
        return lqw;
    }

    @Override
    public Boolean insertByBo(TbDzbMeetingsCountBo bo) {
        TbDzbMeetingsCount add = BeanUtil.toBean(bo, TbDzbMeetingsCount.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(TbDzbMeetingsCountBo bo) {
        TbDzbMeetingsCount update = BeanUtil.toBean(bo, TbDzbMeetingsCount.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(TbDzbMeetingsCount entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
