package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.domain.TbDzbGatheringsCount;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.TbDzbReviewConversationCountBo;
import com.ruoyi.system.domain.vo.TbDzbReviewConversationCountVo;
import com.ruoyi.system.domain.TbDzbReviewConversationCount;
import com.ruoyi.system.mapper.TbDzbReviewConversationCountMapper;
import com.ruoyi.system.service.ITbDzbReviewConversationCountService;

import java.util.*;

/**
 * 民主评议/谈心谈话Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Service
public class TbDzbReviewConversationCountServiceImpl extends ServicePlusImpl<TbDzbReviewConversationCountMapper, TbDzbReviewConversationCount, TbDzbReviewConversationCountVo> implements ITbDzbReviewConversationCountService {

    @Override
    public TbDzbReviewConversationCountVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<TbDzbReviewConversationCountVo> queryPageList(TbDzbReviewConversationCountBo bo) {
        PagePlus<TbDzbReviewConversationCount, TbDzbReviewConversationCountVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<TbDzbReviewConversationCountVo> queryList(TbDzbReviewConversationCountBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<TbDzbReviewConversationCount> buildQueryWrapper(TbDzbReviewConversationCountBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<TbDzbReviewConversationCount> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getName()), TbDzbReviewConversationCount::getName, bo.getName());
        lqw.eq(bo.getExcellentRate() != null, TbDzbReviewConversationCount::getExcellentRate, bo.getExcellentRate());
        lqw.eq(bo.getQualifiedRate() != null, TbDzbReviewConversationCount::getQualifiedRate, bo.getQualifiedRate());
        lqw.eq(bo.getBasicQualifiedRate() != null, TbDzbReviewConversationCount::getBasicQualifiedRate, bo.getBasicQualifiedRate());
        lqw.eq(bo.getUnqualifiedRate() != null, TbDzbReviewConversationCount::getUnqualifiedRate, bo.getUnqualifiedRate());
        lqw.eq(bo.getSwCount() != null, TbDzbReviewConversationCount::getSwCount, bo.getSwCount());
        lqw.eq(bo.getWwCount() != null, TbDzbReviewConversationCount::getWwCount, bo.getWwCount());
        lqw.eq(bo.getWdCount() != null, TbDzbReviewConversationCount::getWdCount, bo.getWdCount());
        lqw.eq(bo.getDdCount() != null, TbDzbReviewConversationCount::getDdCount, bo.getDdCount());
        return lqw;
    }

    @Override
    public Boolean insertByBo(TbDzbReviewConversationCountBo bo) {
        TbDzbReviewConversationCount add = BeanUtil.toBean(bo, TbDzbReviewConversationCount.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(TbDzbReviewConversationCountBo bo) {
        TbDzbReviewConversationCount update = BeanUtil.toBean(bo, TbDzbReviewConversationCount.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(TbDzbReviewConversationCount entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }

    @Override
    public List<Map<String, Object>> getScreen() {
        List<Map<String, Object>> resultList = new ArrayList<>();
        Map<String, Object> map;
        Map<String, Object> dataMap;
        Map<String, Object> mzpy;
        Map<String, Object> txth;
        List<TbDzbReviewConversationCount> dzbCounts = this.list();
        for (TbDzbReviewConversationCount count : dzbCounts) {
            map = new HashMap<>();
            dataMap = new HashMap<>();
            mzpy = new HashMap<>();
            mzpy.put("excellentRate", count.getExcellentRate());
            mzpy.put("qualifiedRate", count.getQualifiedRate());
            mzpy.put("basicQualifiedRate", count.getBasicQualifiedRate());
            mzpy.put("unqualifiedRate", count.getUnqualifiedRate());
            txth = new HashMap<>();
            txth.put("swCount", count.getSwCount());
            txth.put("wwCount", count.getWwCount());
            txth.put("wdCount", count.getWdCount());
            txth.put("ddCount", count.getDdCount());
            dataMap.put("mzpy", mzpy);
            dataMap.put("txth", txth);
            map.put("name", count.getName());
            map.put("data", dataMap);
            resultList.add(map);
        }
        return resultList;
    }
}
