package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.TbDzbThemeCountBo;
import com.ruoyi.system.domain.vo.TbDzbThemeCountVo;
import com.ruoyi.system.domain.TbDzbThemeCount;
import com.ruoyi.system.mapper.TbDzbThemeCountMapper;
import com.ruoyi.system.service.ITbDzbThemeCountService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 主题党日 数据统计Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-26
 */
@Service
public class TbDzbThemeCountServiceImpl extends ServicePlusImpl<TbDzbThemeCountMapper, TbDzbThemeCount, TbDzbThemeCountVo> implements ITbDzbThemeCountService {

    @Override
    public TbDzbThemeCountVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<TbDzbThemeCountVo> queryPageList(TbDzbThemeCountBo bo) {
        PagePlus<TbDzbThemeCount, TbDzbThemeCountVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<TbDzbThemeCountVo> queryList(TbDzbThemeCountBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<TbDzbThemeCount> buildQueryWrapper(TbDzbThemeCountBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<TbDzbThemeCount> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getName()), TbDzbThemeCount::getName, bo.getName());
        lqw.eq(bo.getFrequency() != null, TbDzbThemeCount::getFrequency, bo.getFrequency());
        lqw.eq(bo.getAvgDuration() != null, TbDzbThemeCount::getAvgDuration, bo.getAvgDuration());
        lqw.eq(bo.getAttendanceRate() != null, TbDzbThemeCount::getAttendanceRate, bo.getAttendanceRate());
        lqw.eq(bo.getLeaveRate() != null, TbDzbThemeCount::getLeaveRate, bo.getLeaveRate());
        return lqw;
    }

    @Override
    public Boolean insertByBo(TbDzbThemeCountBo bo) {
        TbDzbThemeCount add = BeanUtil.toBean(bo, TbDzbThemeCount.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(TbDzbThemeCountBo bo) {
        TbDzbThemeCount update = BeanUtil.toBean(bo, TbDzbThemeCount.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(TbDzbThemeCount entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
