package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.utils.redis.RedisForActivityUtil;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkActivityContentBo;
import com.ruoyi.system.domain.vo.ZkActivityContentVo;
import com.ruoyi.system.domain.ZkActivityContent;
import com.ruoyi.system.mapper.ZkActivityContentMapper;
import com.ruoyi.system.service.IZkActivityContentService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 活动内容Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Service
public class ZkActivityContentServiceImpl extends ServicePlusImpl<ZkActivityContentMapper, ZkActivityContent, ZkActivityContentVo> implements IZkActivityContentService {

    @Override
    public ZkActivityContentVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityContentVo> queryPageList(ZkActivityContentBo bo) {
        PagePlus<ZkActivityContent, ZkActivityContentVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityContentVo> queryList(ZkActivityContentBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityContent> buildQueryWrapper(ZkActivityContentBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityContent> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getContentName()), ZkActivityContent::getContentName, bo.getContentName());
        lqw.eq(StringUtils.isNotBlank(bo.getContentKey()), ZkActivityContent::getContentKey, bo.getContentKey());
        lqw.eq(bo.getIsDel() != null, ZkActivityContent::getIsDel, bo.getIsDel());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityContentBo bo) {
        ZkActivityContent add = BeanUtil.toBean(bo, ZkActivityContent.class);
        validEntityBeforeSave(add);
        boolean flag = save(add);
        if (flag) {
            RedisForActivityUtil.delActivityContent();
        }
        return flag;
    }

    @Override
    public Boolean updateByBo(ZkActivityContentBo bo) {
        ZkActivityContent update = BeanUtil.toBean(bo, ZkActivityContent.class);
        validEntityBeforeSave(update);
        boolean flag = updateById(update);
        if (flag) {
            RedisForActivityUtil.delActivityContent();
        }
        return flag;
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityContent entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
