package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkActivityEvaluateBo;
import com.ruoyi.system.domain.vo.ZkActivityEvaluateVo;
import com.ruoyi.system.domain.ZkActivityEvaluate;
import com.ruoyi.system.mapper.ZkActivityEvaluateMapper;
import com.ruoyi.system.service.IZkActivityEvaluateService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 组织评定Service业务层处理
 *
 * @author ruoyi
 * @date 2021-11-10
 */
@Service
public class ZkActivityEvaluateServiceImpl extends ServicePlusImpl<ZkActivityEvaluateMapper, ZkActivityEvaluate, ZkActivityEvaluateVo> implements IZkActivityEvaluateService {

    @Override
    public ZkActivityEvaluateVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityEvaluateVo> queryPageList(ZkActivityEvaluateBo bo) {
        PagePlus<ZkActivityEvaluate, ZkActivityEvaluateVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityEvaluateVo> queryList(ZkActivityEvaluateBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityEvaluate> buildQueryWrapper(ZkActivityEvaluateBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityEvaluate> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getActivityId() != null, ZkActivityEvaluate::getActivityId, bo.getActivityId());
        lqw.eq(bo.getUserId() != null, ZkActivityEvaluate::getUserId, bo.getUserId());
        lqw.like(StringUtils.isNotBlank(bo.getUserName()), ZkActivityEvaluate::getUserName, bo.getUserName());
        lqw.eq(bo.getEvaluateType() != null, ZkActivityEvaluate::getEvaluateType, bo.getEvaluateType());
        lqw.eq(bo.getIsPraise() != null, ZkActivityEvaluate::getIsPraise, bo.getIsPraise());
        lqw.eq(StringUtils.isNotBlank(bo.getUnqualified()), ZkActivityEvaluate::getUnqualified, bo.getUnqualified());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityEvaluateBo bo) {
        ZkActivityEvaluate add = BeanUtil.toBean(bo, ZkActivityEvaluate.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkActivityEvaluateBo bo) {
        ZkActivityEvaluate update = BeanUtil.toBean(bo, ZkActivityEvaluate.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityEvaluate entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }

    @Override
    public List<ZkActivityEvaluate> getListByActivityId(Long id) {
        LambdaQueryWrapper<ZkActivityEvaluate> lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ZkActivityEvaluate::getActivityId, id);
        return this.list(lambdaQueryWrapper);
    }

}
