package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkActivityInfoContentBo;
import com.ruoyi.system.domain.vo.ZkActivityInfoContentVo;
import com.ruoyi.system.domain.ZkActivityInfoContent;
import com.ruoyi.system.mapper.ZkActivityInfoContentMapper;
import com.ruoyi.system.service.IZkActivityInfoContentService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Service
public class ZkActivityInfoContentServiceImpl extends ServicePlusImpl<ZkActivityInfoContentMapper, ZkActivityInfoContent, ZkActivityInfoContentVo> implements IZkActivityInfoContentService {

    @Override
    public ZkActivityInfoContentVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityInfoContentVo> queryPageList(ZkActivityInfoContentBo bo) {
        PagePlus<ZkActivityInfoContent, ZkActivityInfoContentVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityInfoContentVo> queryList(ZkActivityInfoContentBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityInfoContent> buildQueryWrapper(ZkActivityInfoContentBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityInfoContent> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getActivityId() != null, ZkActivityInfoContent::getActivityId, bo.getActivityId());
        lqw.like(StringUtils.isNotBlank(bo.getContentName()), ZkActivityInfoContent::getContentName, bo.getContentName());
        lqw.eq(StringUtils.isNotBlank(bo.getContentKey()), ZkActivityInfoContent::getContentKey, bo.getContentKey());
        lqw.eq(StringUtils.isNotBlank(bo.getContent()), ZkActivityInfoContent::getContent, bo.getContent());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityInfoContentBo bo) {
        ZkActivityInfoContent add = BeanUtil.toBean(bo, ZkActivityInfoContent.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkActivityInfoContentBo bo) {
        ZkActivityInfoContent update = BeanUtil.toBean(bo, ZkActivityInfoContent.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityInfoContent entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
