package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.system.domain.ZkActivityInfoContent;
import com.ruoyi.system.domain.ZkActivityObj;
import com.ruoyi.system.domain.bo.ActivityInfoBo;
import com.ruoyi.system.domain.bo.ZkActivityInfoBo;
import com.ruoyi.system.domain.bo.ZkActivityInfoBo2;
import com.ruoyi.system.domain.vo.*;
import com.ruoyi.system.mapper.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.ZkActivityInfo;
import com.ruoyi.system.service.IZkActivityInfoService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 活动详情主体Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Service
public class ZkActivityInfoServiceImpl extends ServicePlusImpl<ZkActivityInfoMapper, ZkActivityInfo, ZkActivityInfoVo> implements IZkActivityInfoService {

    @Autowired
    private SysDeptMapper sysDeptMapper;

    @Autowired
    private ZkActivityInfoContentMapper zkActivityInfoContentMapper;

    @Autowired
    private ZkActivityObjMapper zkActivityObjMapper;


    @Override
    public ZkActivityInfoVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityInfoVo> queryPageList(ZkActivityInfoBo bo) {
        PagePlus<ZkActivityInfo, ZkActivityInfoVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityInfoVo> queryList(ZkActivityInfoBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityInfo> buildQueryWrapper(ZkActivityInfoBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityInfo> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getTitleType() != null, ZkActivityInfo::getTitleType, bo.getTitleType());
        lqw.eq(StringUtils.isNotBlank(bo.getDeptIds()), ZkActivityInfo::getDeptIds, bo.getDeptIds());
        lqw.eq(StringUtils.isNotBlank(bo.getType()), ZkActivityInfo::getType, bo.getType());
        lqw.eq(StringUtils.isNotBlank(bo.getActivityLabel()), ZkActivityInfo::getActivityLabel, bo.getActivityLabel());
        lqw.eq(bo.getActivityDate() != null, ZkActivityInfo::getActivityDate, bo.getActivityDate());
        lqw.eq(StringUtils.isNotBlank(bo.getAddress()), ZkActivityInfo::getAddress, bo.getAddress());
        lqw.eq(StringUtils.isNotBlank(bo.getHostUser()), ZkActivityInfo::getHostUser, bo.getHostUser());
        lqw.eq(StringUtils.isNotBlank(bo.getRecorder()), ZkActivityInfo::getRecorder, bo.getRecorder());
        lqw.eq(StringUtils.isNotBlank(bo.getNvPersonnel()), ZkActivityInfo::getNvPersonnel, bo.getNvPersonnel());
        lqw.eq(bo.getDuration() != null, ZkActivityInfo::getDuration, bo.getDuration());
        lqw.eq(StringUtils.isNotBlank(bo.getPhoto()), ZkActivityInfo::getPhoto, bo.getPhoto());
        lqw.eq(StringUtils.isNotBlank(bo.getCreateUser()), ZkActivityInfo::getCreateUser, bo.getCreateUser());
        lqw.eq(StringUtils.isNotBlank(bo.getLastUpdateUser()), ZkActivityInfo::getLastUpdateUser, bo.getLastUpdateUser());
        lqw.like(StringUtils.isNotBlank(bo.getPDeptName()), ZkActivityInfo::getPDeptName, bo.getPDeptName());
        lqw.eq(bo.getReleaseTime() != null, ZkActivityInfo::getReleaseTime, bo.getReleaseTime());
        lqw.eq(bo.getOverTime() != null, ZkActivityInfo::getOverTime, bo.getOverTime());
        lqw.eq(bo.getExecutionTime() != null, ZkActivityInfo::getExecutionTime, bo.getExecutionTime());
        lqw.eq(bo.getStatus() != null, ZkActivityInfo::getStatus, bo.getStatus());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityInfoBo bo) {
        ZkActivityInfo add = BeanUtil.toBean(bo, ZkActivityInfo.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkActivityInfoBo bo) {
        ZkActivityInfo update = BeanUtil.toBean(bo, ZkActivityInfo.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityInfo entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }

    @Override
    public List<OrganizationalActivityInfoVo> queryListForTableData(ActivityInfoBo bo) {
        return baseMapper.queryListForTableDataForOrganizational(bo);
    }

    @Override
    public Integer queryListForTableDataTotalForOrganizational(ActivityInfoBo bo) {
        return baseMapper.queryListForTableDataTotalForOrganizational(bo);
    }

    @Override
    public Integer queryListForTableDataTotalForSpecial(ActivityInfoBo bo) {
        return baseMapper.queryListForTableDataTotalForSpecial(bo);
    }

    @Override
    public List<SpecialActivityInfoVo> queryListForTableDataForSpecial(ActivityInfoBo bo) {
        return baseMapper.queryListForTableDataForSpecial(bo);
    }

    @Override
    public List<ZkActivityHostUserVo> getHostUserByDeptId(Long deptId) {
        return baseMapper.getHostUserByDeptId(deptId);
    }

    @Override
    public List<SpecialActivityCountVo> querySpecialActivityCount(Long pActivityId) {
        return baseMapper.querySpecialActivityCount(pActivityId);
    }

    @Override
    public PageInfo queryByZHCX(ZkActivityInfoBo2 bo) {
        String end = bo.getAbsentRateEnd();
        if(bo.getAbsentRateStart()!=null) {
            bo.setAbsentRateEnd(100F-Float.parseFloat(bo.getAbsentRateStart())+"00");
        }
        if(end!=null){
            bo.setAbsentRateStart((100F-Float.parseFloat(end)+"").replaceAll("(0)+$", ""));
        }
        if(bo.getAttendanceRateStart() != null){
            bo.setAttendanceRateStart(bo.getAttendanceRateStart().replaceAll("(0)+$", ""));
        }
        if(bo.getAttendanceRateEnd() != null){
            bo.setAttendanceRateEnd(bo.getAttendanceRateEnd()+"00");
        }

        if(bo.getLeaveRateStart() != null){
            bo.setLeaveRateStart(bo.getLeaveRateStart().replaceAll("(0)+$", ""));
        }

        if(bo.getLeaveRateEnd() != null){
            bo.setAttendanceRateEnd(bo.getLeaveRateEnd()+"00");
        }
        List<String> deptIDS = new ArrayList<>();
        if(bo.getDeptId() != null && bo.getDeptId() != ""){
            deptIDS.add(bo.getDeptId());
        }

        if(bo.getDeptId()!=null && bo.getDeptId() != ""){
            digui(Long.parseLong(bo.getDeptId()),deptIDS);
        }

        bo.setDeptIDS(deptIDS);
        PageHelper.startPage(bo.getPageNum(), bo.getPageSize());
        List<ZkActivityInfoVo2> zkActivityInfos = baseMapper.queryByZHCX(bo);


        List<String> contentNames;
        List<String> objKeys;
        for (ZkActivityInfoVo2 zkActivityInfo : zkActivityInfos) {
            Long id = zkActivityInfo.getId();
            contentNames = zkActivityInfoContentMapper.findAllByActivityId(id.intValue()).stream().map(ZkActivityInfoContent::getContentName).collect(Collectors.toList());
            objKeys = zkActivityObjMapper.findAllByActivityId(id.intValue()).stream().map(ZkActivityObj::getObjKey).collect(Collectors.toList());
            zkActivityInfo.setContentName(Arrays.toString(contentNames.toArray(new String[contentNames.size()])).replaceAll(",","/").replace("[","").replace("]",""));
            zkActivityInfo.setObjKey(Arrays.toString(objKeys.toArray(new String[objKeys.size()])).replaceAll(",","/").replace("[","").replace("]",""));
        }
        PageInfo pageInfo = new PageInfo(zkActivityInfos);
        return pageInfo;
    }

    public void digui(Long id,List<String> deptIDS){
        List<Long> list = sysDeptMapper.selectChildrenDeptIdsListByParent(id).stream().map(SysDept::getDeptId).collect(Collectors.toList());
        if(list != null && list.size()>0){
            for (Long one : list) {
                deptIDS.add(""+one);
                digui(one,deptIDS);
            }
        }
    }
}
