package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkActivityObjBo;
import com.ruoyi.system.domain.vo.ZkActivityObjVo;
import com.ruoyi.system.domain.ZkActivityObj;
import com.ruoyi.system.mapper.ZkActivityObjMapper;
import com.ruoyi.system.service.IZkActivityObjService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 活动主体中的活动对象Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Service
public class ZkActivityObjServiceImpl extends ServicePlusImpl<ZkActivityObjMapper, ZkActivityObj, ZkActivityObjVo> implements IZkActivityObjService {

    @Override
    public ZkActivityObjVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityObjVo> queryPageList(ZkActivityObjBo bo) {
        PagePlus<ZkActivityObj, ZkActivityObjVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityObjVo> queryList(ZkActivityObjBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityObj> buildQueryWrapper(ZkActivityObjBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityObj> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getActivityId() != null, ZkActivityObj::getActivityId, bo.getActivityId());
        lqw.eq(StringUtils.isNotBlank(bo.getLabel()), ZkActivityObj::getLabel, bo.getLabel());
        lqw.eq(StringUtils.isNotBlank(bo.getObjKey()), ZkActivityObj::getObjKey, bo.getObjKey());
        lqw.eq(StringUtils.isNotBlank(bo.getObjValue()), ZkActivityObj::getObjValue, bo.getObjValue());
        lqw.eq(bo.getIsDel() != null, ZkActivityObj::getIsDel, bo.getIsDel());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityObjBo bo) {
        ZkActivityObj add = BeanUtil.toBean(bo, ZkActivityObj.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkActivityObjBo bo) {
        ZkActivityObj update = BeanUtil.toBean(bo, ZkActivityObj.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityObj entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
