package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkActivityObjUserBo;
import com.ruoyi.system.domain.vo.ZkActivityObjUserVo;
import com.ruoyi.system.domain.ZkActivityObjUser;
import com.ruoyi.system.mapper.ZkActivityObjUserMapper;
import com.ruoyi.system.service.IZkActivityObjUserService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 活动对象人员信息Service业务层处理
 *
 * @author ruoyi
 * @date 2021-11-02
 */
@Service
public class ZkActivityObjUserServiceImpl extends ServicePlusImpl<ZkActivityObjUserMapper, ZkActivityObjUser, ZkActivityObjUserVo> implements IZkActivityObjUserService {

    @Override
    public ZkActivityObjUserVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityObjUserVo> queryPageList(ZkActivityObjUserBo bo) {
        PagePlus<ZkActivityObjUser, ZkActivityObjUserVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityObjUserVo> queryList(ZkActivityObjUserBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityObjUser> buildQueryWrapper(ZkActivityObjUserBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityObjUser> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getActivityId() != null, ZkActivityObjUser::getActivityId, bo.getActivityId());
        lqw.eq(bo.getType() != null, ZkActivityObjUser::getType, bo.getType());
        lqw.eq(bo.getUserId() != null, ZkActivityObjUser::getUserId, bo.getUserId());
        lqw.like(StringUtils.isNotBlank(bo.getUserName()), ZkActivityObjUser::getUserName, bo.getUserName());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityObjUserBo bo) {
        ZkActivityObjUser add = BeanUtil.toBean(bo, ZkActivityObjUser.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkActivityObjUserBo bo) {
        ZkActivityObjUser update = BeanUtil.toBean(bo, ZkActivityObjUser.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityObjUser entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
