package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkActivityTypeContentBo;
import com.ruoyi.system.domain.vo.ZkActivityTypeContentVo;
import com.ruoyi.system.domain.ZkActivityTypeContent;
import com.ruoyi.system.mapper.ZkActivityTypeContentMapper;
import com.ruoyi.system.service.IZkActivityTypeContentService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 活动类型与活动内容关联Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Service
public class ZkActivityTypeContentServiceImpl extends ServicePlusImpl<ZkActivityTypeContentMapper, ZkActivityTypeContent, ZkActivityTypeContentVo> implements IZkActivityTypeContentService {

    @Override
    public ZkActivityTypeContentVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityTypeContentVo> queryPageList(ZkActivityTypeContentBo bo) {
        PagePlus<ZkActivityTypeContent, ZkActivityTypeContentVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityTypeContentVo> queryList(ZkActivityTypeContentBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityTypeContent> buildQueryWrapper(ZkActivityTypeContentBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityTypeContent> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getType()), ZkActivityTypeContent::getType, bo.getType());
        lqw.eq(StringUtils.isNotBlank(bo.getContentIds()), ZkActivityTypeContent::getContentIds, bo.getContentIds());
        lqw.eq(bo.getIsDel() != null, ZkActivityTypeContent::getIsDel, bo.getIsDel());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityTypeContentBo bo) {
        ZkActivityTypeContent add = BeanUtil.toBean(bo, ZkActivityTypeContent.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkActivityTypeContentBo bo) {
        ZkActivityTypeContent update = BeanUtil.toBean(bo, ZkActivityTypeContent.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityTypeContent entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
