package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ruoyi.common.utils.RedisUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkActivityTypeBo;
import com.ruoyi.system.domain.vo.ZkActivityTypeVo;
import com.ruoyi.system.domain.ZkActivityType;
import com.ruoyi.system.mapper.ZkActivityTypeMapper;
import com.ruoyi.system.service.IZkActivityTypeService;

import java.util.*;

/**
 * 活动类型Service业务层处理
 *
 * @author ruoyi
 * @date 2021-11-03
 */
@Service
public class ZkActivityTypeServiceImpl extends ServicePlusImpl<ZkActivityTypeMapper, ZkActivityType, ZkActivityTypeVo> implements IZkActivityTypeService {

    @Override
    public ZkActivityTypeVo queryById(Long id) {
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkActivityTypeVo> queryPageList(ZkActivityTypeBo bo) {
        PagePlus<ZkActivityType, ZkActivityTypeVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkActivityTypeVo> queryList(ZkActivityTypeBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkActivityType> buildQueryWrapper(ZkActivityTypeBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkActivityType> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getType()), ZkActivityType::getType, bo.getType());
        lqw.eq(StringUtils.isNotBlank(bo.getTypeValue()), ZkActivityType::getTypeValue, bo.getTypeValue());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkActivityTypeBo bo) {
        ZkActivityType add = BeanUtil.toBean(bo, ZkActivityType.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkActivityTypeBo bo) {
        ZkActivityType update = BeanUtil.toBean(bo, ZkActivityType.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkActivityType entity) {
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if (isValid) {
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }

    @Override
    public List<Map<String, Object>> getList(String roleFlag) {
        // 切换为非必传
        if (Strings.isEmpty(roleFlag) || (!"1".equals(roleFlag) && !"3".equals(roleFlag))) {
            roleFlag = "1";
        }
        String redisKey = "ZK:ACTIVITY_TYPE_" + roleFlag;
        List<Map<String, Object>> mapList = RedisUtils.getCacheList(redisKey);
        if (CollectionUtils.isEmpty(mapList)) {
            Map<String, Object> map;
            List<ZkActivityType> list = this.list();
            for (ZkActivityType type : list) {
                map = new HashMap<>();
                if ("3".equals(roleFlag)) {
                    if ("02".equals(type.getTypeValue()))
                        continue;
                }
                if ("1".equals(roleFlag)) {
                    if ("01".equals(type.getTypeValue()))
                        continue;
                }
                map.put("value", type.getTypeValue());
                map.put("label", type.getType());
                mapList.add(map);
            }
            RedisUtils.setCacheList(redisKey, mapList);
        } else {
            mapList = RedisUtils.getCacheList(redisKey);
        }
        return mapList;
    }
}
