package com.ruoyi.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.PageUtils;
import com.ruoyi.common.core.page.PagePlus;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.stereotype.Service;
import com.ruoyi.common.core.mybatisplus.core.ServicePlusImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.system.domain.bo.ZkTitleTypeBo;
import com.ruoyi.system.domain.vo.ZkTitleTypeVo;
import com.ruoyi.system.domain.ZkTitleType;
import com.ruoyi.system.mapper.ZkTitleTypeMapper;
import com.ruoyi.system.service.IZkTitleTypeService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 活动分类(组织活动/民主评议/谈心谈话/专项活动)Service业务层处理
 *
 * @author ruoyi
 * @date 2021-10-27
 */
@Service
public class ZkTitleTypeServiceImpl extends ServicePlusImpl<ZkTitleTypeMapper, ZkTitleType, ZkTitleTypeVo> implements IZkTitleTypeService {

    @Override
    public ZkTitleTypeVo queryById(Long id){
        return getVoById(id);
    }

    @Override
    public TableDataInfo<ZkTitleTypeVo> queryPageList(ZkTitleTypeBo bo) {
        PagePlus<ZkTitleType, ZkTitleTypeVo> result = pageVo(PageUtils.buildPagePlus(), buildQueryWrapper(bo));
        return PageUtils.buildDataInfo(result);
    }

    @Override
    public List<ZkTitleTypeVo> queryList(ZkTitleTypeBo bo) {
        return listVo(buildQueryWrapper(bo));
    }

    private LambdaQueryWrapper<ZkTitleType> buildQueryWrapper(ZkTitleTypeBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZkTitleType> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getType()), ZkTitleType::getType, bo.getType());
        lqw.eq(StringUtils.isNotBlank(bo.getLastUpdateUser()), ZkTitleType::getLastUpdateUser, bo.getLastUpdateUser());
        return lqw;
    }

    @Override
    public Boolean insertByBo(ZkTitleTypeBo bo) {
        ZkTitleType add = BeanUtil.toBean(bo, ZkTitleType.class);
        validEntityBeforeSave(add);
        return save(add);
    }

    @Override
    public Boolean updateByBo(ZkTitleTypeBo bo) {
        ZkTitleType update = BeanUtil.toBean(bo, ZkTitleType.class);
        validEntityBeforeSave(update);
        return updateById(update);
    }

    /**
     * 保存前的数据校验
     *
     * @param entity 实体类数据
     */
    private void validEntityBeforeSave(ZkTitleType entity){
        //TODO 做一些数据校验,如唯一约束
    }

    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return removeByIds(ids);
    }
}
