package com.ruoyi.system.utils.redis;

import com.ruoyi.common.utils.RedisUtils;
import com.ruoyi.system.domain.ZkActivityTypeContent;
import com.ruoyi.system.domain.ZkTitleType;

import java.util.List;
import java.util.Map;

/**
 * 活动添加页面redis取值
 */
public class RedisForActivityUtil {

    /**
     * 获取 title type
     *
     * @return
     */
    public static List<ZkTitleType> getTitleType() {
        return RedisUtils.getCacheList("ZK:TITLE_TYPE");
    }

    /**
     * 获取 title type
     *
     * @return
     */
    public static boolean setTitleType(List<ZkTitleType> types) {
        return RedisUtils.setCacheList("ZK:TITLE_TYPE", types);
    }

    /**
     * 获取 activity content
     *
     * @return
     */
    public static List<Map<String, Object>> getActivityContent() {
        return RedisUtils.getCacheList("ZK:ACTIVITY_CONTENT");
    }


    /**
     * 获取 activity content
     *
     * @return
     */
    public static List<Map<String, Object>> getActivityContent(String key) {
        return RedisUtils.getCacheList("ZK:ACTIVITY_CONTENT:" + key);
    }


    /**
     * 获取 activity content
     *
     * @return
     */
    public static void delActivityContent() {
        RedisUtils.deleteObject("ZK:ACTIVITY_CONTENT");
        RedisUtils.deleteObject("ZK:ACTIVITY_CONTENT:");
    }

    /**
     * 获取 activity content
     *
     * @param list
     * @return
     */
    public static boolean setActivityContent(List<Map<String, Object>> list) {
        return RedisUtils.setCacheList("ZK:ACTIVITY_CONTENT", list);
    }

    /**
     * 获取活动类型与活动内容信息
     *
     * @return
     */
    public static List<Map<String, Object>> getActivityTypeContent(String key) {
        return RedisUtils.getCacheList("ZK:ACTIVITY_TYPE_CONTENT:" + key);
    }

    /**
     * 获取活动类型与活动内容信息
     *
     * @return
     */
    public static boolean setActivityTypeContent(String key, List<ZkActivityTypeContent> list) {
        return RedisUtils.setCacheList("ZK:ACTIVITY_TYPE_CONTENT:" + key, list);
    }

}
