package com.ruoyi.common.core.domain.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.*;

/**
 * 部门表 sys_dept
 *
 * @author ruoyi
 */

@Data
@NoArgsConstructor
@Accessors(chain = true)
@TableName("sys_dept")
@Api("部门对象")
public class SysDept implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 部门ID
	 */
	@TableId(value = "dept_id", type = IdType.AUTO)
	private Long deptId;

	/**
	 * 父部门ID
	 */
	private Long parentId;

	/**
	 * 祖级列表
	 */
	private String ancestors;

	/**
	 * 部门名称
	 */
	@NotBlank(message = "部门名称不能为空")
	@Size(min = 0, max = 30, message = "部门名称长度不能超过30个字符")
	private String deptName;

	/**
	 * 显示顺序
	 */
	@NotBlank(message = "显示顺序不能为空")
	private String orderNum;

	/**
	 * 负责人
	 */
	private String leader;

	/**
	 * 菜单角色权限
	 */
	@ApiModelProperty("菜单角色权限")
	private String roleFlag;

	/**
	 * 联系电话
	 */
	@Size(min = 0, max = 11, message = "联系电话长度不能超过11个字符")
	private String phone;

	/**
	 * 邮箱
	 */
	@Email(message = "邮箱格式不正确")
	@Size(min = 0, max = 50, message = "邮箱长度不能超过50个字符")
	private String email;

	/**
	 * 部门状态:0正常,1停用
	 */
	private String status;


	/**
	 * 部门地点标记
	 */
	private String addressAbb;

	/**
	 * 删除标志（0代表存在 2代表删除）
	 */
	@TableLogic
	private String delFlag;

	/**
	 * 父部门名称
	 */
	@TableField(exist = false)
	private String parentName;

	/**
	 * 创建者
	 */
	@TableField(fill = FieldFill.INSERT)
	private String createBy;

	/**
	 * 创建时间
	 */
	@TableField(fill = FieldFill.INSERT)
	private Date createTime;

	/**
	 * 更新者
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private String updateBy;

	/**
	 * 更新时间
	 */
	@TableField(fill = FieldFill.INSERT_UPDATE)
	private Date updateTime;

	/**
	 * 部门级别
	 */
	@ApiModelProperty("部门级别，区委为1，向上增长，权限越低越大")
	private Long deptLevel;

	/**
	 * 子部门
	 */
	@TableField(exist = false)
	private List<SysDept> children = new ArrayList<SysDept>();

	/**
	 * 请求参数
	 */
	@TableField(exist = false)
	private Map<String, Object> params = new HashMap<>();

}
