package com.ruoyi.quartz.task;

import cn.hutool.core.lang.Console;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.domain.ZkActivityInfo;
import com.ruoyi.system.domain.ZkActivityInfoContent;
import com.ruoyi.system.domain.bo.SpecialActivityAddBo;
import com.ruoyi.system.service.IActivityService;
import com.ruoyi.system.service.ISysDeptService;
import com.ruoyi.system.service.IZkActivityInfoContentService;
import com.ruoyi.system.service.IZkActivityInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("specialTask")
public class SpecialTask {

    @Autowired
    private IZkActivityInfoService zkActivityInfoService;

    @Autowired
    private IZkActivityInfoContentService zkActivityInfoContentService;

    @Autowired
    private ISysDeptService sysDeptService;

    @Autowired
    private IActivityService activityService;

    public void initSpecialActivityData() {
        LambdaQueryWrapper<ZkActivityInfo> lqWrapper = new LambdaQueryWrapper<>();
        lqWrapper.eq(ZkActivityInfo::getTitleType, 4);
        lqWrapper.eq(ZkActivityInfo::getPushStatus, 0);
        List<ZkActivityInfo> list = zkActivityInfoService.list(lqWrapper);
        SpecialActivityAddBo addBo;
        LambdaQueryWrapper<ZkActivityInfoContent> lqWrapperContent;
        for (ZkActivityInfo info : list) {
            System.out.println("begin----" + info.getId());
            addBo = new SpecialActivityAddBo();
            addBo.setTheme(info.getTheme());
            addBo.setPActivityId(info.getId());
            addBo.setReleaseTime(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM_SS, info.getReleaseTime()));
            addBo.setOverTime(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM_SS, info.getOverTime()));
            addBo.setSubjectActivityId(info.getId());
            lqWrapperContent = new LambdaQueryWrapper<>();
            lqWrapperContent.eq(ZkActivityInfoContent::getActivityId, info.getId());
            ZkActivityInfoContent infoContent = zkActivityInfoContentService.getOne(lqWrapperContent);
            if (infoContent != null) {
                addBo.setContentKey(infoContent.getContentKey());
                addBo.setContent(infoContent.getContent());
            }
            List<SysDept> sysDepts = sysDeptService.selectDeptTreeById(info.getPDeptId(), true);
            addBo.setSubjectDeptId(info.getSubjectDeptId());
            Map<Long, Long> map = new HashMap<>();
            for (SysDept sysDept : sysDepts) {
                Long deptId = sysDept.getDeptId();
                addBo.setDeptId(deptId);
                addBo.setDeptName(sysDept.getDeptName());
                Long parentId = sysDept.getParentId();
                if (info.getPDeptId().equals(deptId))
                    continue;
                if (map.get(parentId) != null) {
                    if (info.getPDeptId() != deptId) {
                        addBo.setPushStatus(1);
                        addBo.setPActivityId(map.get(parentId));
                        ZkActivityInfo activityInfo = activityService.addForTask(addBo);
                        map.put(sysDept.getDeptId(), activityInfo.getId());
                    }
                } else {
                    addBo.setPushStatus(1);
                    addBo.setPActivityId(info.getId());
                    ZkActivityInfo activityInfo = activityService.addForTask(addBo);
                    map.put(sysDept.getDeptId(), activityInfo.getId());
                }
            }
            info.setPushStatus(1);
            zkActivityInfoService.updateById(info);
            System.out.println("end----" + info.getId());
        }
    }

}
