/*
Navicat MySQL Data Transfer

Source Server         : 192.168.1.55
Source Server Version : 50505
Source Host           : 192.168.1.55:3306
Source Database       : fhzzb

Target Server Type    : MYSQL
Target Server Version : 50505
File Encoding         : 65001

Date: 2021-11-12 19:31:52
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table` (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) DEFAULT '' COMMENT '表描述',
  `sub_table_name` varchar(64) DEFAULT NULL COMMENT '关联子表的表名',
  `sub_table_fk_name` varchar(64) DEFAULT NULL COMMENT '子表关联的外键名',
  `class_name` varchar(100) DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) DEFAULT NULL COMMENT '生成功能作者',
  `gen_type` char(1) DEFAULT '0' COMMENT '生成代码方式（0zip压缩包 1自定义路径）',
  `gen_path` varchar(200) DEFAULT '/' COMMENT '生成路径（不填默认项目路径）',
  `options` varchar(1000) DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COMMENT='代码生成业务表';

-- ----------------------------
-- Records of gen_table
-- ----------------------------
INSERT INTO `gen_table` VALUES ('1', 'tb_dzb_count', ' 党支部基层数据大屏统计', null, null, 'TbDzbCount', 'crud', 'com.ruoyi.system', 'system', 'dzbCount', ' 党支部基层数据大屏统计', 'ruoyi', '0', '/', null, 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48', null);
INSERT INTO `gen_table` VALUES ('2', 'tb_dzb_gatherings_count', '组织生活会/民主生活会 数据统计', null, null, 'TbDzbGatheringsCount', 'crud', 'com.ruoyi.system', 'system', 'dzbGatheringsCount', '组织生活会/民主生活会 数据统计', 'ruoyi', '0', '/', null, 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48', null);
INSERT INTO `gen_table` VALUES ('3', 'tb_dzb_meetings_count', '三会一课\r\n\r\n', null, null, 'TbDzbMeetingsCount', 'crud', 'com.ruoyi.system', 'system', 'dzbMeetingsCount', '三会一课\r\n\r\n', 'ruoyi', '0', '/', null, 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48', null);
INSERT INTO `gen_table` VALUES ('4', 'tb_dzb_review_conversation_count', '民主评议/谈心谈话', null, null, 'TbDzbReviewConversationCount', 'crud', 'com.ruoyi.system', 'system', 'dzbReviewConversationCount', '民主评议/谈心谈话', 'ruoyi', '0', '/', null, 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48', null);
INSERT INTO `gen_table` VALUES ('5', 'tb_dzb_theme_count', '主题党日 数据统计', null, null, 'TbDzbThemeCount', 'crud', 'com.ruoyi.system', 'system', 'dzbThemeCount', '主题党日 数据统计', 'ruoyi', '0', '/', null, 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48', null);
INSERT INTO `gen_table` VALUES ('7', 'zk_activity_content', '活动内容', null, null, 'ZkActivityContent', 'crud', 'com.ruoyi.system', 'system', 'activityContent', '活动内容', 'ruoyi', '0', '/', null, 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25', null);
INSERT INTO `gen_table` VALUES ('8', 'zk_activity_info', '活动详情主体', null, null, 'ZkActivityInfo', 'crud', 'com.ruoyi.system', 'system', 'activityInfo', '活动详情主体', 'ruoyi', '0', '/', null, 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25', null);
INSERT INTO `gen_table` VALUES ('9', 'zk_activity_obj', '活动主体中的活动对象', null, null, 'ZkActivityObj', 'crud', 'com.ruoyi.system', 'system', 'activityObj', '活动主体中的活动对象', 'ruoyi', '0', '/', null, 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25', null);
INSERT INTO `gen_table` VALUES ('10', 'zk_activity_type_content', '活动类型与活动内容关联表', null, null, 'ZkActivityTypeContent', 'crud', 'com.ruoyi.system', 'system', 'activityTypeContent', '活动类型与活动内容关联', 'ruoyi', '0', '/', null, 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26', null);
INSERT INTO `gen_table` VALUES ('11', 'zk_title_type', '活动分类表(组织活动/民主评议/谈心谈话/专项活动)', null, null, 'ZkTitleType', 'crud', 'com.ruoyi.system', 'system', 'titleType', '活动分类(组织活动/民主评议/谈心谈话/专项活动)', 'ruoyi', '0', '/', null, 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26', null);
INSERT INTO `gen_table` VALUES ('12', 'zk_activity_info_content', '', null, null, 'ZkActivityInfoContent', 'crud', 'com.ruoyi.system', 'system', 'activityInfoContent', '', 'ruoyi', '0', '/', null, 'admin', '2021-10-27 17:22:59', 'admin', '2021-10-27 17:22:59', null);
INSERT INTO `gen_table` VALUES ('13', 'zk_activity_obj_user', '活动对象人员信息', null, null, 'ZkActivityObjUser', 'crud', 'com.ruoyi.system', 'system', 'activityObjUser', '活动对象人员信息', 'ruoyi', '0', '/', null, 'admin', '2021-11-02 16:41:51', 'admin', '2021-11-02 16:41:51', null);
INSERT INTO `gen_table` VALUES ('14', 'zk_activity_type', '活动类型', null, null, 'ZkActivityType', 'crud', 'com.ruoyi.system', 'system', 'activityType', '活动类型', 'ruoyi', '0', '/', null, 'admin', '2021-11-03 09:44:35', 'admin', '2021-11-03 09:44:35', null);

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column` (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) DEFAULT '' COMMENT '字典类型',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8 COMMENT='代码生成业务表字段';

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
INSERT INTO `gen_table_column` VALUES ('1', '1', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('2', '1', 'name', '党组织简称', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', '2', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('3', '1', 'dzb_count', '党支部数', 'int(6)', 'Integer', 'dzbCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('4', '1', 'dy_count', '党员总数', 'int(6)', 'Integer', 'dyCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('5', '1', 'ybdy_count', '预备党员人数', 'int(6)', 'Integer', 'ybdyCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('6', '1', 'is_show', '是否显示', 'int(1)', 'Integer', 'isShow', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '6', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('7', '1', 'update_time', '数据更新时间', 'timestamp', 'Date', 'updateTime', '0', '0', null, '1', '1', null, null, 'EQ', 'datetime', '', '7', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('8', '2', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('9', '2', 'name', '组织名称', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', '2', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('10', '2', 'total_count', '累计开展次数', 'int(6)', 'Integer', 'totalCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('11', '2', 'avg_duration', '平均时长', 'int(6)', 'Integer', 'avgDuration', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('12', '2', 'attendance_rate', '到会率', 'int(6)', 'Integer', 'attendanceRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('13', '2', 'leave_rate', '请假率', 'int(6)', 'Integer', 'leaveRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '6', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('14', '2', 'problems_count', '查摆问题数', 'int(6)', 'Integer', 'problemsCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '7', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('15', '2', 'criticism_count', '批评与自我批评数', 'int(6)', 'Integer', 'criticismCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '8', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('16', '2', 'rectification_count', '整改措施数', 'int(6)', 'Integer', 'rectificationCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '9', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('17', '2', 'completion_rate', '整改完成情况', 'int(6)', 'Integer', 'completionRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '10', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('18', '2', 'update_time', '数据更新时间', 'timestamp', 'Date', 'updateTime', '0', '0', null, '1', '1', null, null, 'EQ', 'datetime', '', '11', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('19', '3', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('20', '3', 'name', '组织名称', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', '2', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('21', '3', 'type', '类型（frequency:开展频次，activityContent:活动内容，attendanceRate：到会率，leaveRate：请假率）', 'varchar(50)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', '3', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('22', '3', 'child_name', '会议名称/XX名字', 'varchar(100)', 'String', 'childName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', '4', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('23', '3', 'value', '对应值', 'int(6)', 'Integer', 'value', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('24', '3', 'number', '编号', 'varchar(5)', 'String', 'number', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '6', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('25', '3', 'update_time', '数据更新时间', 'timestamp', 'Date', 'updateTime', '0', '0', null, '1', '1', null, null, 'EQ', 'datetime', '', '7', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('26', '4', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('27', '4', 'name', '组织名称', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', '2', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('28', '4', 'excellent_rate', '优秀率', 'int(6)', 'Integer', 'excellentRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('29', '4', 'qualified_rate', '合格率', 'int(6)', 'Integer', 'qualifiedRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('30', '4', 'basic_qualified_rate', '基本合格率', 'int(6)', 'Integer', 'basicQualifiedRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('31', '4', 'unqualified_rate', '不合格率', 'int(6)', 'Integer', 'unqualifiedRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '6', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('32', '4', 'sw_count', '书记与委员谈话数', 'int(6)', 'Integer', 'swCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '7', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('33', '4', 'ww_count', '委员与委员谈话数', 'int(6)', 'Integer', 'wwCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '8', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('34', '4', 'wd_count', '委员与党员谈话数', 'int(6)', 'Integer', 'wdCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '9', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('35', '4', 'dd_count', '党员与党员谈话数', 'int(6)', 'Integer', 'ddCount', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '10', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('36', '4', 'update_time', '', 'timestamp', 'Date', 'updateTime', '0', '0', null, '1', '1', null, null, 'EQ', 'datetime', '', '11', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('37', '5', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('38', '5', 'name', '组织名字', 'varchar(100)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', '2', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('39', '5', 'frequency', '开展频次', 'int(6)', 'Integer', 'frequency', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('40', '5', 'avg_duration', '平均时长', 'int(6)', 'Integer', 'avgDuration', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('41', '5', 'attendance_rate', '到会率', 'int(6)', 'Integer', 'attendanceRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('42', '5', 'leave_rate', '请假率', 'int(6)', 'Integer', 'leaveRate', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '6', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('43', '5', 'update_time', '数据更新时间', 'timestamp', 'Date', 'updateTime', '0', '0', null, '1', '1', null, null, 'EQ', 'datetime', '', '7', 'admin', '2021-10-26 13:41:48', 'admin', '2021-10-26 13:41:48');
INSERT INTO `gen_table_column` VALUES ('49', '7', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('50', '7', 'content_name', '活动内容名称', 'varchar(100)', 'String', 'contentName', '0', '0', null, '1', '1', '1', '1', 'LIKE', 'input', '', '2', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('51', '7', 'content_key', '活动内容key', 'varchar(10)', 'String', 'contentKey', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('52', '7', 'is_del', '', 'int(1)', 'Integer', 'isDel', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('53', '8', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('54', '8', 'title_type', 'zk_activity_type表对应id', 'int(11)', 'Long', 'titleType', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', '2', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('55', '8', 'dept_ids', '参加党支部部门id', 'varchar(500)', 'String', 'deptIds', '0', '0', null, '1', '1', '1', '1', 'EQ', 'textarea', '', '3', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('56', '8', 'type', '活动类型', 'varchar(500)', 'String', 'type', '0', '0', null, '1', '1', '1', '1', 'EQ', 'select', '', '4', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('57', '8', 'activity_label', '活动标签（党支部名称+活动时间）', 'varchar(100)', 'String', 'activityLabel', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('58', '8', 'activity_date', '活动时间', 'datetime', 'Date', 'activityDate', '0', '0', null, '1', '1', '1', '1', 'EQ', 'datetime', '', '6', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('59', '8', 'address', '活动地址', 'varchar(50)', 'String', 'address', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '7', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('60', '8', 'host_user', '主持人', 'varchar(100)', 'String', 'hostUser', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '8', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('61', '8', 'recorder', '记录人', 'varchar(100)', 'String', 'recorder', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '9', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('62', '8', 'nv_personnel', '列席人员', 'text', 'String', 'nvPersonnel', '0', '0', null, '1', '1', '1', '1', 'EQ', 'textarea', '', '10', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('63', '8', 'duration', '活动时长', 'int(5)', 'Integer', 'duration', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '11', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('64', '8', 'photo', '活动照片', 'text', 'String', 'photo', '0', '0', null, '1', '1', '1', '1', 'EQ', 'textarea', '', '12', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('65', '8', 'create_time', '', 'timestamp', 'Date', 'createTime', '0', '0', null, '1', null, null, null, 'EQ', 'datetime', '', '13', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('66', '8', 'create_user', '创建人', 'varchar(100)', 'String', 'createUser', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '14', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('67', '8', 'update_time', '', 'timestamp', 'Date', 'updateTime', '0', '0', null, '1', '1', null, null, 'EQ', 'datetime', '', '15', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('68', '8', 'last_update_user', '', 'varchar(100)', 'String', 'lastUpdateUser', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '16', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('69', '8', 'p_dept_name', '发布主体', 'varchar(255)', 'String', 'pDeptName', '0', '0', null, '1', '1', '1', '1', 'LIKE', 'input', '', '17', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('70', '8', 'release_time', '发布时间', 'datetime', 'Date', 'releaseTime', '0', '0', null, '1', '1', '1', '1', 'EQ', 'datetime', '', '18', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('71', '8', 'over_time', '活动截至时间', 'datetime', 'Date', 'overTime', '0', '0', null, '1', '1', '1', '1', 'EQ', 'datetime', '', '19', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('72', '8', 'execution_time', '活动开展时间', 'datetime', 'Date', 'executionTime', '0', '0', null, '1', '1', '1', '1', 'EQ', 'datetime', '', '20', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('73', '8', 'status', '活动状态（0：未完成；1：已完成）', 'int(1)', 'Integer', 'status', '0', '0', null, '1', '1', '1', '1', 'EQ', 'radio', '', '21', 'admin', '2021-10-27 09:45:25', 'admin', '2021-10-27 09:45:25');
INSERT INTO `gen_table_column` VALUES ('74', '9', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('75', '9', 'activity_id', '对应活动id', 'int(11)', 'Long', 'activityId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '2', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('76', '9', 'label', '活动对象标签名称', 'varchar(150)', 'String', 'label', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('77', '9', 'key', '活动对象Key', 'varchar(50)', 'String', 'key', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('78', '9', 'value', '活动对象value', 'varchar(100)', 'String', 'value', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('79', '9', 'is_del', '删除状态', 'int(1)', 'Integer', 'isDel', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '6', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('80', '10', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('81', '10', 'type', '活动分类', 'varchar(50)', 'String', 'type', '0', '0', null, '1', '1', '1', '1', 'EQ', 'select', '', '2', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('82', '10', 'content_ids', '活动id（1，2）', 'varchar(100)', 'String', 'contentIds', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('83', '10', 'is_del', '删除标识', 'int(1)', 'Integer', 'isDel', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('84', '11', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('85', '11', 'type', '活动大分类', 'varchar(100)', 'String', 'type', '0', '0', null, '1', '1', '1', '1', 'EQ', 'select', '', '2', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('86', '11', 'create_time', '', 'timestamp', 'Date', 'createTime', '0', '0', null, '1', null, null, null, 'EQ', 'datetime', '', '3', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('87', '11', 'update_time', '', 'timestamp', 'Date', 'updateTime', '0', '0', null, '1', '1', null, null, 'EQ', 'datetime', '', '4', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('88', '11', 'last_update_user', '最后修改用户', 'varchar(100)', 'String', 'lastUpdateUser', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '5', 'admin', '2021-10-27 09:45:26', 'admin', '2021-10-27 09:45:26');
INSERT INTO `gen_table_column` VALUES ('89', '12', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-10-27 17:22:59', 'admin', '2021-10-27 17:22:59');
INSERT INTO `gen_table_column` VALUES ('90', '12', 'activity_id', 'activity_info_id', 'int(11)', 'Long', 'activityId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '2', 'admin', '2021-10-27 17:22:59', 'admin', '2021-10-27 17:22:59');
INSERT INTO `gen_table_column` VALUES ('91', '12', 'content_name', 'activity_content_name', 'varchar(100)', 'String', 'contentName', '0', '0', null, '1', '1', '1', '1', 'LIKE', 'input', '', '3', 'admin', '2021-10-27 17:22:59', 'admin', '2021-10-27 17:22:59');
INSERT INTO `gen_table_column` VALUES ('92', '12', 'content_key', 'activity_content_key', 'varchar(10)', 'String', 'contentKey', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-10-27 17:22:59', 'admin', '2021-10-27 17:22:59');
INSERT INTO `gen_table_column` VALUES ('93', '12', 'content', '内容正文', 'text', 'String', 'content', '0', '0', null, '1', '1', '1', '1', 'EQ', 'editor', '', '5', 'admin', '2021-10-27 17:22:59', 'admin', '2021-10-27 17:22:59');
INSERT INTO `gen_table_column` VALUES ('94', '13', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-11-02 16:41:51', 'admin', '2021-11-02 16:41:51');
INSERT INTO `gen_table_column` VALUES ('95', '13', 'activity_id', '活动id', 'int(11)', 'Long', 'activityId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', '2', 'admin', '2021-11-02 16:41:51', 'admin', '2021-11-02 16:41:51');
INSERT INTO `gen_table_column` VALUES ('96', '13', 'type', '人员类型（0正常，1缺席，2请假）', 'int(11)', 'Long', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', '3', 'admin', '2021-11-02 16:41:51', 'admin', '2021-11-02 16:41:51');
INSERT INTO `gen_table_column` VALUES ('97', '13', 'user_id', '', 'int(11)', 'Long', 'userId', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '4', 'admin', '2021-11-02 16:41:51', 'admin', '2021-11-02 16:41:51');
INSERT INTO `gen_table_column` VALUES ('98', '13', 'user_name', '人员名字', 'varchar(100)', 'String', 'userName', '0', '0', null, '1', '1', '1', '1', 'LIKE', 'input', '', '5', 'admin', '2021-11-02 16:41:51', 'admin', '2021-11-02 16:41:51');
INSERT INTO `gen_table_column` VALUES ('99', '13', 'create_time', '', 'timestamp', 'Date', 'createTime', '0', '0', null, '1', null, null, null, 'EQ', 'datetime', '', '6', 'admin', '2021-11-02 16:41:51', 'admin', '2021-11-02 16:41:51');
INSERT INTO `gen_table_column` VALUES ('100', '14', 'id', '', 'int(11)', 'Long', 'id', '1', '1', null, '1', null, null, null, 'EQ', 'input', '', '1', 'admin', '2021-11-03 09:44:35', 'admin', '2021-11-03 09:44:35');
INSERT INTO `gen_table_column` VALUES ('101', '14', 'type', 'type显示文字', 'varchar(100)', 'String', 'type', '0', '0', null, '1', '1', '1', '1', 'EQ', 'select', '', '2', 'admin', '2021-11-03 09:44:35', 'admin', '2021-11-03 09:44:35');
INSERT INTO `gen_table_column` VALUES ('102', '14', 'type_value', 'type值value', 'varchar(20)', 'String', 'typeValue', '0', '0', null, '1', '1', '1', '1', 'EQ', 'input', '', '3', 'admin', '2021-11-03 09:44:35', 'admin', '2021-11-03 09:44:35');
INSERT INTO `gen_table_column` VALUES ('103', '14', 'create_time', '', 'timestamp', 'Date', 'createTime', '0', '0', null, '1', null, null, null, 'EQ', 'datetime', '', '4', 'admin', '2021-11-03 09:44:35', 'admin', '2021-11-03 09:44:35');

-- ----------------------------
-- Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `blob_data` blob DEFAULT NULL COMMENT '存放持久化Trigger对象',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Blob类型的触发器表';

-- ----------------------------
-- Records of qrtz_blob_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `calendar_name` varchar(200) NOT NULL COMMENT '日历名称',
  `calendar` blob NOT NULL COMMENT '存放持久化calendar对象',
  PRIMARY KEY (`sched_name`,`calendar_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='日历信息表';

-- ----------------------------
-- Records of qrtz_calendars
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `cron_expression` varchar(200) NOT NULL COMMENT 'cron表达式',
  `time_zone_id` varchar(80) DEFAULT NULL COMMENT '时区',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Cron类型的触发器表';

-- ----------------------------
-- Records of qrtz_cron_triggers
-- ----------------------------
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', '0/10 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', '0/15 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', '0/20 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', '0 0/1 * * * ?', 'Asia/Shanghai');

-- ----------------------------
-- Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `entry_id` varchar(95) NOT NULL COMMENT '调度器实例id',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `instance_name` varchar(200) NOT NULL COMMENT '调度器实例名',
  `fired_time` bigint(13) NOT NULL COMMENT '触发的时间',
  `sched_time` bigint(13) NOT NULL COMMENT '定时器制定的时间',
  `priority` int(11) NOT NULL COMMENT '优先级',
  `state` varchar(16) NOT NULL COMMENT '状态',
  `job_name` varchar(200) DEFAULT NULL COMMENT '任务名称',
  `job_group` varchar(200) DEFAULT NULL COMMENT '任务组名',
  `is_nonconcurrent` varchar(1) DEFAULT NULL COMMENT '是否并发',
  `requests_recovery` varchar(1) DEFAULT NULL COMMENT '是否接受恢复执行',
  PRIMARY KEY (`sched_name`,`entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='已触发的触发器表';

-- ----------------------------
-- Records of qrtz_fired_triggers
-- ----------------------------
INSERT INTO `qrtz_fired_triggers` VALUES ('RuoyiScheduler', 'WIN-kvalley216366985543091636698554547', 'TASK_CLASS_NAME4', 'DEFAULT', 'WIN-kvalley21636698554309', '1636716712822', '1636716720000', '5', 'ACQUIRED', null, null, '0', '0');

-- ----------------------------
-- Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `job_name` varchar(200) NOT NULL COMMENT '任务名称',
  `job_group` varchar(200) NOT NULL COMMENT '任务组名',
  `description` varchar(250) DEFAULT NULL COMMENT '相关介绍',
  `job_class_name` varchar(250) NOT NULL COMMENT '执行任务类名称',
  `is_durable` varchar(1) NOT NULL COMMENT '是否持久化',
  `is_nonconcurrent` varchar(1) NOT NULL COMMENT '是否并发',
  `is_update_data` varchar(1) NOT NULL COMMENT '是否更新数据',
  `requests_recovery` varchar(1) NOT NULL COMMENT '是否接受恢复执行',
  `job_data` blob DEFAULT NULL COMMENT '存放持久化job对象',
  PRIMARY KEY (`sched_name`,`job_name`,`job_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务详细信息表';

-- ----------------------------
-- Records of qrtz_job_details
-- ----------------------------
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', null, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F62000000000000000102000E4C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000673746174757371007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000A78707400013174000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017C20DBD3D07874000E302F3130202A202A202A202A203F74001172795461736B2E72794E6F506172616D7374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000001740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E697A0E58F82EFBC89740001337371007E00053F4000000000000077080000001000000000787400007400013174000561646D696E7371007E000F77080000017CEA291B58787800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', null, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F62000000000000000102000E4C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000673746174757371007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000A78707400013174000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017C20DBD3D07874000E302F3135202A202A202A202A203F74001572795461736B2E7279506172616D7328277279272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000002740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E69C89E58F82EFBC89740001337371007E00053F40000000000000770800000010000000007874000074000131740000707800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', null, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F62000000000000000102000E4C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000673746174757371007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000A78707400013174000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017C20DBD3D07874000E302F3230202A202A202A202A203F74003872795461736B2E72794D756C7469706C65506172616D7328277279272C20747275652C20323030304C2C203331362E3530442C203130302974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000003740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E5A49AE58F82EFBC89740001337371007E00053F40000000000000770800000010000000007874000074000131740000707800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', null, 'com.ruoyi.quartz.util.QuartzJobExecution', '0', '0', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F62000000000000000102000E4C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000673746174757371007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000A78707400013074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B597419030000787077080000017CC603E3207874000D3020302F31202A202A202A203F7400237370656369616C5461736B2E696E69745370656369616C41637469766974794461746174000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000004740018E4B893E9A1B9E6B4BBE58AA8E695B0E68DAEE5908CE6ADA5740001317371007E00053F4000000000000077080000001000000000787400007400013074000561646D696E7371007E000F77080000017CEA274A80787800);

-- ----------------------------
-- Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `lock_name` varchar(40) NOT NULL COMMENT '悲观锁名称',
  PRIMARY KEY (`sched_name`,`lock_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='存储的悲观锁信息表';

-- ----------------------------
-- Records of qrtz_locks
-- ----------------------------
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'STATE_ACCESS');
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'TRIGGER_ACCESS');

-- ----------------------------
-- Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  PRIMARY KEY (`sched_name`,`trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='暂停的触发器表';

-- ----------------------------
-- Records of qrtz_paused_trigger_grps
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `instance_name` varchar(200) NOT NULL COMMENT '之前配置文件中org.quartz.scheduler.instanceId配置的名字，就会写入该字段',
  `last_checkin_time` bigint(13) NOT NULL COMMENT '上次检查时间',
  `checkin_interval` bigint(13) NOT NULL COMMENT '检查间隔时间',
  PRIMARY KEY (`sched_name`,`instance_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='调度器状态表';

-- ----------------------------
-- Records of qrtz_scheduler_state
-- ----------------------------
INSERT INTO `qrtz_scheduler_state` VALUES ('RuoyiScheduler', 'WIN-kvalley21636698554309', '1636716708854', '15000');

-- ----------------------------
-- Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_ name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `repeat_count` bigint(7) NOT NULL COMMENT '重复的次数统计',
  `repeat_interval` bigint(12) NOT NULL COMMENT '重复的间隔时间',
  `times_triggered` bigint(10) NOT NULL COMMENT '已经触发的次数',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='简单触发器的信息表';

-- ----------------------------
-- Records of qrtz_simple_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_ name的外键',
  `trigger_group` varchar(200) NOT NULL COMMENT 'qrtz_triggers表trigger_group的外键',
  `str_prop_1` varchar(512) DEFAULT NULL COMMENT 'String类型的trigger的第一个参数',
  `str_prop_2` varchar(512) DEFAULT NULL COMMENT 'String类型的trigger的第二个参数',
  `str_prop_3` varchar(512) DEFAULT NULL COMMENT 'String类型的trigger的第三个参数',
  `int_prop_1` int(11) DEFAULT NULL COMMENT 'int类型的trigger的第一个参数',
  `int_prop_2` int(11) DEFAULT NULL COMMENT 'int类型的trigger的第二个参数',
  `long_prop_1` bigint(20) DEFAULT NULL COMMENT 'long类型的trigger的第一个参数',
  `long_prop_2` bigint(20) DEFAULT NULL COMMENT 'long类型的trigger的第二个参数',
  `dec_prop_1` decimal(13,4) DEFAULT NULL COMMENT 'decimal类型的trigger的第一个参数',
  `dec_prop_2` decimal(13,4) DEFAULT NULL COMMENT 'decimal类型的trigger的第二个参数',
  `bool_prop_1` varchar(1) DEFAULT NULL COMMENT 'Boolean类型的trigger的第一个参数',
  `bool_prop_2` varchar(1) DEFAULT NULL COMMENT 'Boolean类型的trigger的第二个参数',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='同步机制的行锁表';

-- ----------------------------
-- Records of qrtz_simprop_triggers
-- ----------------------------

-- ----------------------------
-- Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers` (
  `sched_name` varchar(120) NOT NULL COMMENT '调度名称',
  `trigger_name` varchar(200) NOT NULL COMMENT '触发器的名字',
  `trigger_group` varchar(200) NOT NULL COMMENT '触发器所属组的名字',
  `job_name` varchar(200) NOT NULL COMMENT 'qrtz_job_details表job_name的外键',
  `job_group` varchar(200) NOT NULL COMMENT 'qrtz_job_details表job_group的外键',
  `description` varchar(250) DEFAULT NULL COMMENT '相关介绍',
  `next_fire_time` bigint(13) DEFAULT NULL COMMENT '上一次触发时间（毫秒）',
  `prev_fire_time` bigint(13) DEFAULT NULL COMMENT '下一次触发时间（默认为-1表示不触发）',
  `priority` int(11) DEFAULT NULL COMMENT '优先级',
  `trigger_state` varchar(16) NOT NULL COMMENT '触发器状态',
  `trigger_type` varchar(8) NOT NULL COMMENT '触发器的类型',
  `start_time` bigint(13) NOT NULL COMMENT '开始时间',
  `end_time` bigint(13) DEFAULT NULL COMMENT '结束时间',
  `calendar_name` varchar(200) DEFAULT NULL COMMENT '日程表名称',
  `misfire_instr` smallint(2) DEFAULT NULL COMMENT '补偿执行的策略',
  `job_data` blob DEFAULT NULL COMMENT '存放持久化job对象',
  PRIMARY KEY (`sched_name`,`trigger_name`,`trigger_group`),
  KEY `sched_name` (`sched_name`,`job_name`,`job_group`),
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `qrtz_job_details` (`sched_name`, `job_name`, `job_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='触发器详细信息表';

-- ----------------------------
-- Records of qrtz_triggers
-- ----------------------------
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', 'TASK_CLASS_NAME1', 'DEFAULT', null, '1636698560000', '-1', '5', 'PAUSED', 'CRON', '1636698554000', '0', null, '2', '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', 'TASK_CLASS_NAME2', 'DEFAULT', null, '1636698555000', '-1', '5', 'PAUSED', 'CRON', '1636698554000', '0', null, '2', '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', 'TASK_CLASS_NAME3', 'DEFAULT', null, '1636698560000', '-1', '5', 'PAUSED', 'CRON', '1636698554000', '0', null, '2', '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME4', 'DEFAULT', 'TASK_CLASS_NAME4', 'DEFAULT', null, '1636716720000', '1636716660000', '5', 'ACQUIRED', 'CRON', '1636698554000', '0', null, '-1', '');

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `config_id` int(5) NOT NULL AUTO_INCREMENT COMMENT '参数主键',
  `config_name` varchar(100) DEFAULT '' COMMENT '参数名称',
  `config_key` varchar(100) DEFAULT '' COMMENT '参数键名',
  `config_value` varchar(500) DEFAULT '' COMMENT '参数键值',
  `config_type` char(1) DEFAULT 'N' COMMENT '系统内置（Y是 N否）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`config_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='参数配置表';

-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES ('1', '主框架页-默认皮肤样式名称', 'sys.index.skinName', 'skin-purpl', 'Y', 'admin', '2021-09-26 14:47:29', 'admin', '2021-09-27 09:41:55', '蓝色 skin-blue、绿色 skin-green、紫色 skin-purple、红色 skin-red、黄色 skin-yellow');
INSERT INTO `sys_config` VALUES ('2', '用户管理-账号初始密码', 'sys.user.initPassword', '123456', 'Y', 'admin', '2021-09-26 14:47:29', '', null, '初始化密码 123456');
INSERT INTO `sys_config` VALUES ('3', '主框架页-侧边栏主题', 'sys.index.sideTheme', 'theme-dark', 'Y', 'admin', '2021-09-26 14:47:29', '', null, '深色主题theme-dark，浅色主题theme-light');
INSERT INTO `sys_config` VALUES ('4', '账号自助-验证码开关', 'sys.account.captchaOnOff', 'false', 'Y', 'admin', '2021-09-26 14:47:29', 'admin', '2021-11-09 15:13:34', '是否开启验证码功能（true开启，false关闭）');
INSERT INTO `sys_config` VALUES ('5', '账号自助-是否开启用户注册功能', 'sys.account.registerUser', 'false', 'N', 'admin', '2021-09-26 14:47:29', 'admin', '2021-09-27 09:41:30', '是否开启注册用户功能（true开启，false关闭）');
INSERT INTO `sys_config` VALUES ('11', 'OSS预览列表资源开关', 'sys.oss.previewListResource', 'true', 'Y', 'admin', '2021-09-26 14:47:38', '', null, 'true:开启, false:关闭');

-- ----------------------------
-- Table structure for sys_dept
-- ----------------------------
DROP TABLE IF EXISTS `sys_dept`;
CREATE TABLE `sys_dept` (
  `dept_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '部门id',
  `parent_id` bigint(20) DEFAULT 0 COMMENT '父部门id',
  `ancestors` varchar(50) DEFAULT '' COMMENT '祖级列表',
  `dept_name` varchar(30) DEFAULT '' COMMENT '部门名称',
  `order_num` int(4) DEFAULT 0 COMMENT '显示顺序',
  `leader` varchar(20) DEFAULT NULL COMMENT '负责人',
  `phone` varchar(11) DEFAULT NULL COMMENT '联系电话',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `status` char(1) DEFAULT '0' COMMENT '部门状态（0正常 1停用）',
  `del_flag` char(1) DEFAULT '0' COMMENT '删除标志（0代表存在 2代表删除）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `role_flag` varchar(50) DEFAULT NULL COMMENT '角色标识',
  `dept_level` int(2) DEFAULT 1 COMMENT '部门级别，顺序',
  `address_abb` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`dept_id`)
) ENGINE=InnoDB AUTO_INCREMENT=574 DEFAULT CHARSET=utf8 COMMENT='部门表';

-- ----------------------------
-- Records of sys_dept
-- ----------------------------
INSERT INTO `sys_dept` VALUES ('100', '0', '0', '中共奉化区委', '0', '', '', '', '0', '0', 'admin', '2021-09-26 14:47:19', 'admin', '2021-10-26 16:16:01', '2', '1', null);
INSERT INTO `sys_dept` VALUES ('101', '100', '0,100', '众控科技', '1', '雷', '13166285021', 'alei_ljl@outlook.com', '0', '2', 'admin', '2021-09-26 14:47:19', 'admin', '2021-09-26 17:15:52', null, null, null);
INSERT INTO `sys_dept` VALUES ('102', '100', '0,100', '长沙分公司', '2', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:19', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('103', '101', '0,100,101', '研发部门', '1', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:19', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('104', '101', '0,100,101', '市场部门', '2', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:19', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('105', '101', '0,100,101', '测试部门', '3', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:19', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('106', '101', '0,100,101', '财务部门', '4', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:19', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('107', '101', '0,100,101', '运维部门', '5', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:19', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('108', '102', '0,100,102', '市场部门', '1', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:20', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('109', '102', '0,100,102', '财务部门', '2', '若依', '15888888888', 'ry@qq.com', '0', '2', 'admin', '2021-09-26 14:47:20', '', null, null, null, null);
INSERT INTO `sys_dept` VALUES ('200', '201', '0,100,201', '锦屏街道居敬社区党委', '5', null, null, null, '0', '0', 'admin', '2021-09-26 17:24:14', 'admin', '2021-11-10 21:37:50', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('201', '100', '0,100', '奉化区锦屏街道党工委', '2', null, null, null, '0', '0', 'admin', '2021-10-26 16:28:22', 'admin', '2021-11-10 21:50:29', '4', '2', 'jp');
INSERT INTO `sys_dept` VALUES ('202', '100', '0,100', '奉化区锦岳林街道党工委', '3', null, null, null, '0', '0', 'admin', '2021-10-26 16:28:30', 'admin', '2021-11-11 10:35:59', '4', '2', 'yl');
INSERT INTO `sys_dept` VALUES ('203', '100', '0,100', '奉化区莼湖街道党工委', '4', null, null, null, '0', '0', 'admin', '2021-10-27 16:08:08', 'admin', '2021-11-11 10:36:11', '4', '2', 'ch');
INSERT INTO `sys_dept` VALUES ('204', '100', '0,100', '奉化区西坞街道党工委', '5', null, null, null, '0', '0', 'admin', '2021-10-27 16:08:31', 'admin', '2021-11-11 10:36:21', '4', '2', 'xw');
INSERT INTO `sys_dept` VALUES ('205', '100', '0,100', '奉化区尚田街道党工委', '6', null, null, null, '0', '0', 'admin', '2021-10-27 16:08:56', 'admin', '2021-11-10 22:13:27', '4', '2', 'st');
INSERT INTO `sys_dept` VALUES ('206', '100', '0,100', '奉化区萧王庙街道党工委', '7', null, null, null, '0', '0', 'admin', '2021-10-27 16:09:16', 'admin', '2021-11-11 10:36:45', '4', '2', 'xwm');
INSERT INTO `sys_dept` VALUES ('207', '100', '0,100', '奉化区江口街道党工委', '8', null, null, null, '0', '0', 'admin', '2021-10-27 16:09:44', 'admin', '2021-11-11 10:36:56', '4', '2', 'jk');
INSERT INTO `sys_dept` VALUES ('208', '100', '0,100', '奉化区方桥街道党工委', '9', null, null, null, '0', '0', 'admin', '2021-10-27 16:10:04', 'admin', '2021-11-11 10:37:08', '4', '2', 'fq');
INSERT INTO `sys_dept` VALUES ('209', '100', '0,100', '奉化区溪口镇党委', '10', null, null, null, '0', '0', 'admin', '2021-10-27 16:10:24', 'admin', '2021-11-11 10:37:47', '4', '2', 'xk');
INSERT INTO `sys_dept` VALUES ('210', '100', '0,100', '奉化区大堰镇党委', '11', null, null, null, '0', '0', 'admin', '2021-10-27 16:10:47', 'admin', '2021-11-11 10:38:00', '4', '2', 'dy');
INSERT INTO `sys_dept` VALUES ('211', '100', '0,100', '奉化区裘村镇党委', '12', null, null, null, '0', '0', 'admin', '2021-10-27 16:11:08', 'admin', '2021-11-11 10:38:14', '4', '2', 'qc');
INSERT INTO `sys_dept` VALUES ('212', '100', '0,100', '奉化区松岙镇党委', '13', null, null, null, '0', '0', 'admin', '2021-10-27 16:11:52', 'admin', '2021-11-10 22:04:30', '4', '2', 'sa');
INSERT INTO `sys_dept` VALUES ('213', '100', '0,100', '奉化区教育局党委', '14', null, null, null, '0', '0', 'admin', '2021-10-27 16:12:10', 'admin', '2021-10-27 16:12:10', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('214', '100', '0,100', '奉化区卫生健康局党委', '15', null, null, null, '0', '0', 'admin', '2021-10-27 16:12:35', 'admin', '2021-10-27 16:12:35', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('215', '100', '0,100', '奉化经济开发区党工委', '16', null, null, null, '0', '0', 'admin', '2021-10-27 16:12:55', 'admin', '2021-10-27 16:12:55', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('216', '100', '0,100', '宁波滨海旅游休闲区开发建设管理中心党委', '17', null, null, null, '0', '0', 'admin', '2021-10-27 16:13:55', 'admin', '2021-10-27 16:13:55', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('217', '100', '0,100', '宁波南新城开发建设管理中心党委', '18', null, null, null, '0', '0', 'admin', '2021-10-27 16:14:28', 'admin', '2021-10-27 16:14:28', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('218', '100', '0,100', '奉化区国有资产管理中心党委', '19', null, null, null, '0', '0', 'admin', '2021-10-27 16:14:53', 'admin', '2021-10-27 16:14:53', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('219', '100', '0,100', '中国邮政集团有限公司奉化区党委', '20', null, null, null, '0', '0', 'admin', '2021-10-27 16:16:02', 'admin', '2021-10-27 16:16:02', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('220', '100', '0,100', '中国电信股份有限公司奉化区党委', '21', null, null, null, '0', '0', 'admin', '2021-10-27 16:16:27', 'admin', '2021-10-27 16:16:27', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('221', '100', '0,100', '奉化区委直属机关工委', '22', null, null, null, '0', '0', 'admin', '2021-10-27 16:17:23', 'admin', '2021-10-27 16:17:23', '4', '2', null);
INSERT INTO `sys_dept` VALUES ('222', '201', '0,100,201', '锦屏街道春晖社区党委', '14', null, null, null, '0', '0', 'admin', '2021-10-27 16:19:36', 'admin', '2021-11-10 21:50:18', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('223', '201', '0,100,201', '锦屏街道南门社区党委', '13', null, null, null, '0', '0', 'admin', '2021-10-27 16:20:14', 'admin', '2021-11-10 21:49:19', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('224', '201', '0,100,201', '锦屏街道锦山社区党委', '12', null, null, null, '0', '0', 'admin', '2021-10-27 16:20:39', 'admin', '2021-11-10 21:47:58', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('225', '201', '0,100,201', '锦屏街道阳光社区党委', '11', null, null, null, '0', '0', 'admin', '2021-10-27 16:21:06', 'admin', '2021-11-10 21:47:05', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('226', '201', '0,100,201', '锦屏街道光明社区党委', '10', null, null, null, '0', '0', 'admin', '2021-10-27 16:21:39', 'admin', '2021-11-10 21:45:33', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('227', '201', '0,100,201', '锦屏街道长岭社区党委', '9', null, null, null, '0', '0', 'admin', '2021-10-27 16:21:56', 'admin', '2021-11-10 21:44:36', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('228', '201', '0,100,201', '锦屏街道花园社区党委', '8', null, null, null, '0', '0', 'admin', '2021-10-27 16:22:29', 'admin', '2021-11-10 21:43:45', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('229', '201', '0,100,201', '锦屏街道奉中社区党委', '4', null, null, null, '0', '0', 'admin', '2021-10-27 16:22:51', 'admin', '2021-11-10 21:36:53', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('230', '201', '0,100,201', '锦屏街道东门社区党委', '7', null, null, null, '0', '0', 'admin', '2021-10-27 16:23:05', 'admin', '2021-11-10 21:39:32', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('231', '201', '0,100,201', '锦屏街道庄山社区党委', '3', null, null, null, '0', '0', 'admin', '2021-10-27 16:23:32', 'admin', '2021-11-10 21:35:43', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('232', '201', '0,100,201', '锦屏街道长汀社区党总支', '2', null, null, null, '0', '0', 'admin', '2021-10-27 16:23:52', 'admin', '2021-11-10 21:34:40', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('233', '201', '0,100,201', '锦屏街道仁湖社区党总支', '1', null, null, null, '0', '0', 'admin', '2021-10-27 16:24:16', 'admin', '2021-11-10 21:34:13', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('234', '201', '0,100,201', '锦屏街道南溪社区党支部', '14', null, null, null, '0', '2', 'admin', '2021-10-27 16:24:40', 'admin', '2021-10-27 16:24:40', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('235', '201', '0,100,201', '锦屏街道溪岙村党总支', '23', null, null, null, '0', '0', 'admin', '2021-10-27 16:25:12', 'admin', '2021-11-11 11:36:17', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('236', '201', '0,100,201', '锦屏街道长岭村党支部', '16', null, null, null, '0', '0', 'admin', '2021-10-27 16:25:34', 'admin', '2021-11-10 21:54:51', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('237', '201', '0,100,201', '锦屏街道上宋村党支部', '17', null, null, null, '0', '2', 'admin', '2021-10-27 16:25:52', 'admin', '2021-10-27 16:25:52', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('238', '201', '0,100,201', '锦屏街道西岸村党支部', '18', null, null, null, '0', '2', 'admin', '2021-10-27 16:26:20', 'admin', '2021-10-27 16:26:20', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('239', '200', '0,100,201,200', '锦屏街道居敬社区官亭小区党支部', '1', null, null, null, '0', '0', 'admin', '2021-10-27 16:45:58', 'admin', '2021-11-10 21:37:53', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('240', '200', '0,100,201,200', '锦屏街道居敬社区居敬一区党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-04 09:49:31', 'admin', '2021-11-10 21:37:58', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('241', '200', '0,100,201,200', '锦屏街道居敬社区居敬二区党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-04 09:49:47', 'admin', '2021-11-10 21:38:02', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('242', '200', '0,100,201,200', '锦屏街道居敬社区茗山党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-04 09:50:06', 'admin', '2021-11-10 21:38:05', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('243', '200', '0,100,201,200', '锦屏街道居敬社区广济小区党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-04 09:50:20', 'admin', '2021-11-10 21:38:23', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('244', '200', '0,100,201,200', '锦屏街道居敬社区南山党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-04 09:50:39', 'admin', '2021-11-10 21:38:10', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('245', '200', '0,100,201,200', '锦屏街道居敬社区两新联合党支部', '7', null, null, null, '0', '0', 'admin', '2021-11-04 09:50:53', 'admin', '2021-11-10 21:38:17', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('247', '233', '0,100,201,233', '锦屏街道南溪社区党支部', '1', null, null, null, '0', '2', 'admin', '2021-11-04 10:22:53', 'admin', '2021-11-04 10:22:53', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('249', '201', '0,100,201', '锦屏街道上宋村党支部', '18', null, null, null, '0', '0', 'admin', '2021-11-04 10:24:31', 'admin', '2021-11-10 21:52:19', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('250', '201', '0,100,201', '锦屏街道西岸村党支部', '16', null, null, null, '0', '0', 'admin', '2021-11-04 10:24:47', 'admin', '2021-11-10 21:52:00', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('251', '201', '0,100,201', '锦屏街道西圃村党支部', '17', null, null, null, '0', '0', 'admin', '2021-11-04 10:25:03', 'admin', '2021-11-10 21:52:09', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('252', '201', '0,100,201', '锦屏街道正明村党支部', '19', null, null, null, '0', '0', 'admin', '2021-11-04 10:25:21', 'admin', '2021-11-10 21:52:28', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('253', '201', '0,100,201', '锦屏街道河头村党支部', '20', null, null, null, '0', '0', 'admin', '2021-11-04 10:25:35', 'admin', '2021-11-10 21:52:37', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('254', '201', '0,100,201', '锦屏街道奉南村党支部', '21', null, null, null, '0', '0', 'admin', '2021-11-04 10:26:32', 'admin', '2021-11-10 21:52:46', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('255', '201', '0,100,201', '锦屏街道城西岙党支部', '22', null, null, null, '0', '0', 'admin', '2021-11-04 10:26:47', 'admin', '2021-11-10 21:52:55', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('256', '235', '0,100,201,235', '锦屏街道塘下村党支部', '9', null, null, null, '0', '2', 'admin', '2021-11-04 10:27:00', 'admin', '2021-11-04 10:27:00', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('257', '235', '0,100,201,235', '锦屏街道山岭村党支部', '10', null, null, null, '0', '2', 'admin', '2021-11-04 10:27:17', 'admin', '2021-11-04 10:27:17', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('258', '235', '0,100,201,235', '锦屏街道石柱村党支部', '11', null, null, null, '0', '2', 'admin', '2021-11-04 10:27:31', 'admin', '2021-11-04 10:27:31', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('259', '235', '0,100,201,235', '锦屏街道西锦村党支部', '12', null, null, null, '0', '2', 'admin', '2021-11-04 10:27:44', 'admin', '2021-11-04 10:27:44', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('260', '235', '0,100,201,235', '锦屏街道外应村党支部', '13', null, null, null, '0', '2', 'admin', '2021-11-04 10:27:56', 'admin', '2021-11-04 10:27:56', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('261', '235', '0,100,201,235', '锦屏街道西溪村党支部', '14', null, null, null, '0', '2', 'admin', '2021-11-04 10:28:08', 'admin', '2021-11-04 10:28:08', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('262', '235', '0,100,201,235', '锦屏街道北街村党支部', '15', null, null, null, '0', '2', 'admin', '2021-11-04 10:28:39', 'admin', '2021-11-04 10:28:39', '1', '4', null);
INSERT INTO `sys_dept` VALUES ('263', '201', '0,100,201', '锦屏街道东关村党支部', '15', null, null, null, '0', '0', 'admin', '2021-11-04 10:28:55', 'admin', '2021-11-10 21:51:51', '1', '4', 'jp');
INSERT INTO `sys_dept` VALUES ('266', '201', '0,100,201', '锦屏街道东关村党支部', '0', null, null, null, '0', '2', 'admin', null, '', null, '1', '3', null);
INSERT INTO `sys_dept` VALUES ('267', '201', '0,100,201', '锦屏街道西圃村党支部', '0', null, null, null, '0', '2', 'admin', null, '', null, '1', '3', null);
INSERT INTO `sys_dept` VALUES ('268', '201', '0,100,201', '锦屏街道正明村党支部', '0', null, null, null, '0', '2', 'admin', null, '', null, '1', '3', null);
INSERT INTO `sys_dept` VALUES ('269', '201', '0,100,201', '锦屏街道河头村党支部', '0', null, null, null, '0', '2', 'admin', null, '', null, '1', '3', null);
INSERT INTO `sys_dept` VALUES ('270', '201', '0,100,201', '锦屏街道奉南村党支部', '0', null, null, null, '0', '2', 'admin', null, '', null, '1', '3', null);
INSERT INTO `sys_dept` VALUES ('271', '201', '0,100,201', '锦屏街道城西岙党支部', '0', null, null, null, '0', '2', 'admin', null, '', null, '1', '3', null);
INSERT INTO `sys_dept` VALUES ('272', '201', '0,100,201', '锦屏街道西锦村党支部', '24', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 14:52:42', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('273', '201', '0,100,201', '锦屏街道塘下村党支部', '25', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:08:39', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('274', '201', '0,100,201', '锦屏街道北街村党支部', '26', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:08:49', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('275', '201', '0,100,201', '锦屏街道山岭村党支部', '27', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:09:06', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('276', '201', '0,100,201', '锦屏街道石柱村党支部', '28', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:09:17', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('277', '201', '0,100,201', '锦屏街道西溪村党支部', '30', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 14:52:56', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('278', '201', '0,100,201', '锦屏街道外应村党支部', '31', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 11:39:14', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('279', '201', '0,100,201', '锦屏街道机关党委', '32', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 21:55:29', '3', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('280', '201', '0,100,201', '宁波利安科技股份有限公司党支部', '33', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:11:38', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('281', '201', '0,100,201', '宁波长隆国泰集团有限公司党支部', '34', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:11:58', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('282', '201', '0,100,201', '宁波奉天海供氧成套设备有限公司党支部', '35', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:12:11', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('283', '201', '0,100,201', '宁波好德美电声有限公司党支部', '36', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:12:25', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('284', '201', '0,100,201', '宁波市奉化浙东标准件有限公司党支部', '37', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:12:34', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('285', '201', '0,100,201', '宁波丹盈服饰有限公司党支部', '38', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:12:41', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('286', '201', '0,100,201', '宁波市奉化区南山路个体一条街党支部', '39', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:12:49', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('287', '201', '0,100,201', '宁波市奉化区锦屏服务行业联合党支部', '40', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:13:08', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('288', '201', '0,100,201', '奉化区锦屏街道尚亚服饰有限公司党支部', '41', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:13:16', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('289', '201', '0,100,201', '宁波市凌晨农业科技有限公司党支部', '42', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:13:24', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('290', '201', '0,100,201', '奉化区浙江捷达物业服务有限公司党支部', '43', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:13:32', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('291', '201', '0,100,201', '宁波市奉化区商务局餐饮行业协会党支部', '44', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:13:38', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('292', '201', '0,100,201', '奉化区广平会计事务所有限公司党支部', '45', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:13:52', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('293', '201', '0,100,201', '宁波市奉化区联鑫塑钢五金有限公司党支部', '46', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:14:01', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('294', '201', '0,100,201', '宁波市运通旅游汽车运输有限公司党支部', '47', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:14:10', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('295', '201', '0,100,201', '宁波市奉化区蓝天保洁有限公司党支部', '48', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-11 15:14:16', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('296', '201', '0,100,201', '奉化区锦屏民个协党支部', '49', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 21:59:32', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('297', '201', '0,100,201', '宁波市奉化区大桥商会党支部', '50', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 21:59:42', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('298', '201', '0,100,201', '宁波市奉化区大桥市场个协党支部', '51', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 21:59:50', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('299', '201', '0,100,201', '宁波市奉化区银泰城联合党支部', '52', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 21:59:59', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('300', '201', '0,100,201', '宁波市奉化区商贸大厦联合党支部', '53', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:00:10', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('301', '201', '0,100,201', '奉化摩米创新工场电子科技有限公司党支部', '54', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:00:20', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('302', '201', '0,100,201', '奉化华侨豪生大酒店党支部', '55', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:00:29', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('303', '201', '0,100,201', '宁波美特丽化妆品有限公司党支部', '56', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:00:38', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('304', '201', '0,100,201', '宁波市奉化区印象奉化党支部', '57', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:00:47', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('305', '201', '0,100,201', '宁波四通易达快递有限公司党支部', '58', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:00:56', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('306', '201', '0,100,201', '宁波市奉化区泰阳石业有限公司党支部', '59', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:01:04', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('307', '201', '0,100,201', '宁波市奉化区锦泰电脑技术有限公司党支部', '60', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:01:13', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('308', '201', '0,100,201', '宁波市奉化区奉溪出租车有限公司党支部', '61', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:01:34', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('309', '201', '0,100,201', '奉化区浩基建筑工程服务有限公司党支部', '62', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:01:44', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('310', '201', '0,100,201', '宁波市奉化区东升包装印务有限公司党支部', '63', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:01:55', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('311', '201', '0,100,201', '宁波市奉化区工业住宅开发有限公司党支部', '64', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:02:10', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('312', '201', '0,100,201', '奉化云创商业管理（杭州）有限公司党支部', '65', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:02:19', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('313', '201', '0,100,201', '宁波市奉化区中城房地产开有限公司党支部', '66', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:02:30', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('314', '201', '0,100,201', '奉化区南海建筑材料中心试验室党支部', '67', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:02:39', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('315', '201', '0,100,201', '奉化巨浪饮料饮料厂支部党支部', '68', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:02:49', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('316', '201', '0,100,201', '宁波万泰建设工程有限公司党支部', '69', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:02:58', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('317', '201', '0,100,201', '宁波天歌物业有限公司党支部', '70', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:03:07', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('318', '201', '0,100,201', '宁波市奉化区杰力铝材有限公司党支部', '71', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:03:17', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('319', '201', '0,100,201', '宁波市奉化区外贸党支部', '72', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:03:26', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('320', '201', '0,100,201', '宁波华标特瓷采油设备有限公司党支部', '73', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:03:37', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('321', '201', '0,100,201', '宁波市妮妮服饰有限公司党支部', '74', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:03:46', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('322', '201', '0,100,201', '宁波佐餐王调味食品公司党支部', '75', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:03:55', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('323', '201', '0,100,201', '奉化太平洋购物广场有限公司党支部', '76', null, null, null, '0', '0', 'admin', null, 'admin', '2021-11-10 22:04:05', '1', '3', 'jp');
INSERT INTO `sys_dept` VALUES ('324', '231', '0,100,201,231', '锦屏街道庄山社区庄二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:38:36', 'admin', '2021-11-10 21:35:47', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('325', '231', '0,100,201,231', '锦屏街道庄山社区庄一党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:45:10', 'admin', '2021-11-10 21:35:50', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('326', '231', '0,100,201,231', '锦屏街道庄山社区庄四党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 21:45:25', 'admin', '2021-11-10 21:35:53', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('327', '231', '0,100,201,231', '锦屏街道庄山社区庄三党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 21:45:36', 'admin', '2021-11-10 21:35:57', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('328', '231', '0,100,201,231', '锦屏街道庄山社区塔水党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 21:45:47', 'admin', '2021-11-10 21:36:05', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('329', '231', '0,100,201,231', '锦屏街道庄山社区庄五党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-09 21:45:59', 'admin', '2021-11-10 21:36:09', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('330', '231', '0,100,201,231', '锦屏街道庄山社区庄六党支部', '7', null, null, null, '0', '0', 'admin', '2021-11-09 21:46:11', 'admin', '2021-11-10 21:36:13', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('331', '233', '0,100,201,233', '锦屏街道仁湖社区玫瑰园党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:46:42', 'admin', '2021-11-10 21:34:21', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('332', '233', '0,100,201,233', '锦屏街道朱家河党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:47:33', 'admin', '2021-11-10 21:34:29', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('333', '232', '0,100,201,232', '锦屏街道长汀社区长汀一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:49:18', 'admin', '2021-11-10 21:35:16', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('334', '232', '0,100,201,232', '锦屏街道长汀社区长汀二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:49:30', 'admin', '2021-11-10 21:35:20', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('335', '232', '0,100,201,232', '锦屏街道长汀社区长汀三党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 21:49:44', 'admin', '2021-11-10 21:35:23', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('336', '229', '0,100,201,229', '锦屏街道奉中社区北门党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:52:03', 'admin', '2021-11-10 21:37:18', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('337', '229', '0,100,201,229', '锦屏街道奉中社区西门党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:52:18', 'admin', '2021-11-10 21:37:21', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('338', '229', '0,100,201,229', '锦屏街道奉中社区东门党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 21:52:30', 'admin', '2021-11-10 21:37:24', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('339', '229', '0,100,201,229', '锦屏街道奉中社区南门党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 21:52:41', 'admin', '2021-11-10 21:37:27', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('340', '229', '0,100,201,229', '锦屏街道奉中社区北门二党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 21:52:56', 'admin', '2021-11-10 21:37:30', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('341', '201', '0,100,201', '锦屏街道南溪社区党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-09 21:53:53', 'admin', '2021-11-10 21:38:59', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('342', '230', '0,100,201,230', '锦屏街道东门社区东一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:55:14', 'admin', '2021-11-10 21:39:36', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('343', '230', '0,100,201,230', '锦屏街道东门社区东二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:55:28', 'admin', '2021-11-10 21:43:11', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('344', '230', '0,100,201,230', '锦屏街道东门社区东三党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 21:55:37', 'admin', '2021-11-10 21:39:39', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('345', '230', '0,100,201,230', '锦屏街道东门社区东四党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 21:55:45', 'admin', '2021-11-10 21:39:42', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('346', '230', '0,100,201,230', '锦屏开发投资与商贸服务联合党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 21:55:55', 'admin', '2021-11-10 21:39:54', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('347', '228', '0,100,201,228', '锦屏街道花园社区花三党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:56:55', 'admin', '2021-11-10 21:43:53', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('348', '228', '0,100,201,228', '锦屏街道花园社区惠二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:57:05', 'admin', '2021-11-10 21:44:01', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('349', '228', '0,100,201,228', '锦屏街道花园社区食品党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 21:57:16', 'admin', '2021-11-10 21:44:09', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('350', '228', '0,100,201,228', '锦屏材料与装饰联合党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 21:57:27', 'admin', '2021-11-10 21:44:18', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('351', '228', '0,100,201,228', '锦屏街道惠政路步行一条街党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 21:57:35', 'admin', '2021-11-10 21:44:26', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('352', '227', '0,100,201,227', '锦屏街道长岭社区第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:58:06', 'admin', '2021-11-10 21:44:44', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('353', '227', '0,100,201,227', '锦屏街道长岭社区第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:58:20', 'admin', '2021-11-10 21:44:51', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('354', '227', '0,100,201,227', '锦屏街道长岭社区第三党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 21:58:34', 'admin', '2021-11-10 21:44:58', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('355', '227', '0,100,201,227', '锦屏街道长岭社区第四党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 21:58:46', 'admin', '2021-11-10 21:45:06', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('356', '227', '0,100,201,227', '锦屏街道长岭社区第五党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 21:58:53', 'admin', '2021-11-10 21:45:14', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('357', '227', '0,100,201,227', '锦屏街道长岭社区两新联合党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-09 21:59:06', 'admin', '2021-11-10 21:45:22', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('358', '226', '0,100,201,226', '锦屏街道光明社区状元坊党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 21:59:28', 'admin', '2021-11-10 21:45:46', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('359', '226', '0,100,201,226', '锦屏街道光明社区惠政党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 21:59:39', 'admin', '2021-11-10 21:46:10', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('360', '226', '0,100,201,226', '锦屏街道光明社区广平党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 21:59:47', 'admin', '2021-11-10 21:46:17', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('361', '226', '0,100,201,226', '锦屏街道江滨家居一条街党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 21:59:55', 'admin', '2021-11-10 21:46:36', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('362', '226', '0,100,201,226', '锦屏街道广平时尚女人街党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 22:00:54', 'admin', '2021-11-09 22:00:54', '1', '1', null);
INSERT INTO `sys_dept` VALUES ('363', '226', '0,100,201,226', '锦屏机械与网络技术联合党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-09 22:01:11', 'admin', '2021-11-10 21:46:43', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('364', '226', '0,100,201,226', '锦屏街道惠政西路商贸联合党支部', '7', null, null, null, '0', '0', 'admin', '2021-11-09 22:01:22', 'admin', '2021-11-10 21:46:51', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('365', '225', '0,100,201,225', '锦屏街道阳光社区阳光一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 22:02:06', 'admin', '2021-11-10 21:47:13', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('366', '225', '0,100,201,225', '锦屏街道阳光社区阳光二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 22:02:15', 'admin', '2021-11-10 21:47:22', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('367', '225', '0,100,201,225', '锦屏街道阳光社区大成一党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 22:02:38', 'admin', '2021-11-10 21:47:30', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('368', '225', '0,100,201,225', '锦屏街道阳光社区大成二党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 22:02:47', 'admin', '2021-11-10 21:47:40', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('369', '225', '0,100,201,225', '锦屏街道阳光社区两新联合党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 22:02:56', 'admin', '2021-11-10 21:47:48', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('370', '224', '0,100,201,224', '锦屏街道锦山社区锦一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 22:03:20', 'admin', '2021-11-10 21:48:06', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('371', '224', '0,100,201,224', '锦屏街道锦山社区锦二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 22:03:28', 'admin', '2021-11-10 21:48:36', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('372', '224', '0,100,201,224', '锦屏街道锦山社区锦三党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 22:03:40', 'admin', '2021-11-10 21:48:44', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('373', '224', '0,100,201,224', '锦屏街道锦山社区锦四党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 22:03:48', 'admin', '2021-11-10 21:48:52', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('374', '224', '0,100,201,224', '锦屏街道锦山社区锦五党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 22:03:56', 'admin', '2021-11-10 21:49:01', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('375', '224', '0,100,201,224', '锦屏街道锦山社区锦六党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-09 22:04:04', 'admin', '2021-11-10 21:49:10', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('376', '223', '0,100,201,223', '锦屏街道南门社区桑园党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 22:05:35', 'admin', '2021-11-10 21:49:34', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('377', '223', '0,100,201,223', '锦屏街道南门社区南街党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 22:05:45', 'admin', '2021-11-10 21:49:43', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('378', '223', '0,100,201,223', '锦屏街道南门社区城南党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 22:06:04', 'admin', '2021-11-10 21:49:51', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('379', '223', '0,100,201,223', '锦屏街道南门社区锦南党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 22:06:12', 'admin', '2021-11-10 21:49:59', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('380', '223', '0,100,201,223', '锦屏街道南门社区西溪党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 22:06:20', 'admin', '2021-11-10 21:50:07', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('381', '222', '0,100,201,222', '锦屏街道春晖社区第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 22:06:44', 'admin', '2021-11-10 21:50:41', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('382', '222', '0,100,201,222', '锦屏街道春晖社区第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 22:06:52', 'admin', '2021-11-10 21:50:49', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('383', '222', '0,100,201,222', '锦屏街道春晖社区第三党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 22:07:00', 'admin', '2021-11-10 21:51:05', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('384', '222', '0,100,201,222', '锦屏街道春晖社区青年党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 22:07:08', 'admin', '2021-11-10 21:51:15', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('385', '235', '0,100,201,235', '锦屏街道溪岙村第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 22:15:54', 'admin', '2021-11-10 21:53:32', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('386', '235', '0,100,201,235', '锦屏街道溪岙村第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 22:16:02', 'admin', '2021-11-10 21:53:39', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('387', '235', '0,100,201,235', '锦屏街道溪岙村第三党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 22:16:11', 'admin', '2021-11-10 21:53:49', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('388', '235', '0,100,201,235', '锦屏街道溪岙村第四党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 22:16:21', 'admin', '2021-11-10 21:53:57', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('389', '279', '0,100,201,279', '锦屏街道机关党群党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 22:18:37', 'admin', '2021-11-10 21:55:37', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('390', '279', '0,100,201,279', '锦屏街道综治党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 22:18:57', 'admin', '2021-11-10 21:55:44', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('391', '279', '0,100,201,279', '锦屏街道建设党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 22:19:05', 'admin', '2021-11-10 21:55:53', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('392', '279', '0,100,201,279', '锦屏街道机关工贸党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 22:19:12', 'admin', '2021-11-10 21:56:00', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('393', '279', '0,100,201,279', '锦屏街道事业党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 22:19:19', 'admin', '2021-11-10 21:56:08', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('394', '279', '0,100,201,279', '锦屏街道农业党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-09 22:19:29', 'admin', '2021-11-10 21:56:16', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('395', '279', '0,100,201,279', '综合行政执法局锦屏中队党支部', '7', null, null, null, '0', '0', 'admin', '2021-11-09 22:19:36', 'admin', '2021-11-10 21:56:24', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('396', '279', '0,100,201,279', '锦屏街道办事处退休党支部', '8', null, null, null, '0', '0', 'admin', '2021-11-09 22:19:45', 'admin', '2021-11-10 21:56:32', '1', '1', 'jp');
INSERT INTO `sys_dept` VALUES ('397', '205', '0,100,205', '尚田街道居民委员会党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 22:26:02', 'admin', '2021-11-10 22:13:38', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('398', '205', '0,100,205', '尚田街道冷西村党委', '2', null, null, null, '0', '0', 'admin', '2021-11-09 22:26:51', 'admin', '2021-11-10 22:13:47', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('399', '205', '0,100,205', '尚田街道方门村党委', '3', null, null, null, '0', '0', 'admin', '2021-11-09 22:27:37', 'admin', '2021-11-10 22:14:38', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('400', '205', '0,100,205', '尚田街道尚二村党委', '4', null, null, null, '0', '0', 'admin', '2021-11-09 22:27:47', 'admin', '2021-11-10 22:15:04', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('401', '205', '0,100,205', '尚田街道条宅村党委', '5', null, null, null, '0', '0', 'admin', '2021-11-09 22:27:56', 'admin', '2021-11-10 22:15:31', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('402', '205', '0,100,205', '尚田街道尚一村党总支', '6', null, null, null, '0', '0', 'admin', '2021-11-09 22:28:05', 'admin', '2021-11-10 22:15:58', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('403', '205', '0,100,205', '尚田街道广渡村党总支', '7', null, null, null, '0', '0', 'admin', '2021-11-09 22:30:27', 'admin', '2021-11-10 22:16:15', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('404', '205', '0,100,205', '尚田街道楼岩村党总支', '8', null, null, null, '0', '0', 'admin', '2021-11-09 22:30:36', 'admin', '2021-11-10 22:16:35', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('405', '205', '0,100,205', '尚田街道金地寺村党总支', '9', null, null, null, '0', '0', 'admin', '2021-11-09 22:30:46', 'admin', '2021-11-10 22:17:01', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('406', '205', '0,100,205', '尚田街道桥棚村党总支', '10', null, null, null, '0', '0', 'admin', '2021-11-09 22:31:10', 'admin', '2021-11-10 22:17:44', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('407', '205', '0,100,205', '尚田街道许家村党总支', '11', null, null, null, '0', '0', 'admin', '2021-11-09 23:21:20', 'admin', '2021-11-10 22:18:00', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('408', '205', '0,100,205', '尚田街道汇溪村党总支', '12', null, null, null, '0', '0', 'admin', '2021-11-09 23:21:57', 'admin', '2021-11-10 22:18:27', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('409', '205', '0,100,205', '尚田街道杨家堰村党总支', '13', null, null, null, '0', '0', 'admin', '2021-11-09 23:22:06', 'admin', '2021-11-10 22:18:46', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('410', '205', '0,100,205', '尚田街道双溪联村党总支', '14', null, null, null, '0', '0', 'admin', '2021-11-09 23:22:15', 'admin', '2021-11-10 22:19:01', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('411', '205', '0,100,205', '尚田街道鹊岙村党支部', '15', null, null, null, '0', '0', 'admin', '2021-11-09 23:22:25', 'admin', '2021-11-10 22:19:28', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('412', '205', '0,100,205', '尚田街道鸣雁村党支部', '16', null, null, null, '0', '0', 'admin', '2021-11-09 23:22:36', 'admin', '2021-11-10 22:19:38', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('413', '205', '0,100,205', '尚田街道杜家村党支部', '17', null, null, null, '0', '0', 'admin', '2021-11-09 23:22:44', 'admin', '2021-11-10 22:19:45', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('414', '205', '0,100,205', '尚田街道尚三村党支部', '18', null, null, null, '0', '0', 'admin', '2021-11-09 23:22:54', 'admin', '2021-11-10 22:19:55', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('415', '205', '0,100,205', '尚田街道张家坑村党支部', '19', null, null, null, '0', '0', 'admin', '2021-11-09 23:23:03', 'admin', '2021-11-10 22:20:03', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('416', '205', '0,100,205', '尚田街道西岙村党支部', '20', null, null, null, '0', '0', 'admin', '2021-11-09 23:23:13', 'admin', '2021-11-10 22:20:13', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('417', '205', '0,100,205', '尚田街道山岙村党支部', '21', null, null, null, '0', '0', 'admin', '2021-11-09 23:23:24', 'admin', '2021-11-10 22:20:21', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('418', '205', '0,100,205', '尚田街道畈头村党支部', '22', null, null, null, '0', '0', 'admin', '2021-11-09 23:23:39', 'admin', '2021-11-10 22:20:28', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('419', '205', '0,100,205', '尚田街道龚原村党支部', '23', null, null, null, '0', '0', 'admin', '2021-11-09 23:23:52', 'admin', '2021-11-10 22:20:37', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('420', '205', '0,100,205', '尚田街道印家坑村党支部', '24', null, null, null, '0', '0', 'admin', '2021-11-09 23:23:58', 'admin', '2021-11-10 22:20:57', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('421', '205', '0,100,205', '尚田街道王董新村党支部', '25', null, null, null, '0', '0', 'admin', '2021-11-09 23:24:08', 'admin', '2021-11-10 22:21:05', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('422', '205', '0,100,205', '尚田街道后潭村党支部', '26', null, null, null, '0', '0', 'admin', '2021-11-09 23:24:20', 'admin', '2021-11-10 22:21:12', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('423', '205', '0,100,205', '尚田街道王家岭村党支部', '27', null, null, null, '0', '0', 'admin', '2021-11-09 23:24:29', 'admin', '2021-11-10 22:21:20', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('424', '205', '0,100,205', '尚田街道尚东村党支部', '28', null, null, null, '0', '0', 'admin', '2021-11-09 23:24:37', 'admin', '2021-11-10 22:21:28', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('425', '205', '0,100,205', '尚田街道大岙村党支部', '29', null, null, null, '0', '0', 'admin', '2021-11-09 23:24:48', 'admin', '2021-11-10 22:21:35', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('426', '205', '0,100,205', '尚田街道下畈村党支部', '30', null, null, null, '0', '0', 'admin', '2021-11-09 23:24:57', 'admin', '2021-11-10 22:21:42', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('427', '205', '0,100,205', '尚田街道梅岭下村党支部', '31', null, null, null, '0', '0', 'admin', '2021-11-09 23:25:08', 'admin', '2021-11-10 22:21:49', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('428', '205', '0,100,205', '尚田街道溪汪村党支部', '32', null, null, null, '0', '0', 'admin', '2021-11-09 23:25:20', 'admin', '2021-11-10 22:21:58', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('429', '205', '0,100,205', '尚田街道葛岙股份经济合作社党支部', '33', null, null, null, '0', '0', 'admin', '2021-11-09 23:25:30', 'admin', '2021-11-10 22:22:06', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('430', '205', '0,100,205', '尚田街道排溪股份经济合作社党支部', '34', null, null, null, '0', '0', 'admin', '2021-11-09 23:25:48', 'admin', '2021-11-10 22:22:15', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('431', '205', '0,100,205', '尚田街道沙栋头股份经济合作社党支部', '35', null, null, null, '0', '0', 'admin', '2021-11-09 23:25:57', 'admin', '2021-11-10 22:22:24', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('432', '205', '0,100,205', '尚田街道下蒋股份经济合作社党支部', '36', null, null, null, '0', '0', 'admin', '2021-11-09 23:26:04', 'admin', '2021-11-10 22:22:40', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('433', '205', '0,100,205', '尚田街道综合治理办公室党支部', '37', null, null, null, '0', '0', 'admin', '2021-11-09 23:26:12', 'admin', '2021-11-10 22:22:49', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('434', '205', '0,100,205', '尚田街道党政综合办公室党支部', '38', null, null, null, '0', '0', 'admin', '2021-11-09 23:26:20', 'admin', '2021-11-10 22:22:58', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('435', '205', '0,100,205', '尚田街道建设管理办公室党支部', '39', null, null, null, '0', '0', 'admin', '2021-11-09 23:26:28', 'admin', '2021-11-10 22:23:07', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('436', '205', '0,100,205', '尚田街道农业办公室党支部', '40', null, null, null, '0', '0', 'admin', '2021-11-09 23:26:35', 'admin', '2021-11-10 22:23:15', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('437', '205', '0,100,205', '尚田街道社会事务管理办公室党支部', '41', null, null, null, '0', '0', 'admin', '2021-11-09 23:26:44', 'admin', '2021-11-10 22:23:23', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('438', '205', '0,100,205', '尚田街道发展服务办公室党支部', '42', null, null, null, '0', '0', 'admin', '2021-11-09 23:26:52', 'admin', '2021-11-10 22:23:44', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('439', '205', '0,100,205', '奉化区尚田自然资源和规划所党支部', '43', null, null, null, '0', '0', 'admin', '2021-11-09 23:27:02', 'admin', '2021-11-10 22:23:57', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('440', '205', '0,100,205', '奉化区尚田水利站管理服务站党支部', '44', null, null, null, '0', '0', 'admin', '2021-11-09 23:27:10', 'admin', '2021-11-10 22:24:07', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('441', '205', '0,100,205', '奉化区尚田街道广播电视站党支部', '45', null, null, null, '0', '0', 'admin', '2021-11-09 23:29:46', 'admin', '2021-11-10 22:24:16', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('442', '205', '0,100,205', '尚田街道党员先锋加油站党支部', '46', null, null, null, '0', '0', 'admin', '2021-11-09 23:29:55', 'admin', '2021-11-10 22:24:29', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('443', '205', '0,100,205', '尚田街道退休干部党支部', '47', null, null, null, '0', '0', 'admin', '2021-11-09 23:30:05', 'admin', '2021-11-10 22:24:39', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('444', '205', '0,100,205', '尚田街道滨江小区党支部', '48', null, null, null, '0', '0', 'admin', '2021-11-09 23:30:14', 'admin', '2021-11-10 22:24:47', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('445', '205', '0,100,205', '尚田街道工商个私协会党支部', '49', null, null, null, '0', '0', 'admin', '2021-11-09 23:30:22', 'admin', '2021-11-10 22:25:01', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('446', '205', '0,100,205', '宁波市奉化区尚田商会党支部', '50', null, null, null, '0', '0', 'admin', '2021-11-09 23:30:31', 'admin', '2021-11-10 22:25:08', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('447', '205', '0,100,205', '宁波市奉化区尚田乡创联盟党支部', '51', null, null, null, '0', '0', 'admin', '2021-11-09 23:30:42', 'admin', '2021-11-10 22:25:16', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('448', '205', '0,100,205', '宁波市奉化区尚田街道山登水电站党支部', '52', null, null, null, '0', '0', 'admin', '2021-11-09 23:30:51', 'admin', '2021-11-10 22:25:26', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('449', '205', '0,100,205', '宁波市奉化区尚田街道葛岙卫生院党支部', '53', null, null, null, '0', '0', 'admin', '2021-11-09 23:30:59', 'admin', '2021-11-10 22:25:37', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('450', '205', '0,100,205', '宁波市奉化区南方机械制造有限公司党总支', '54', null, null, null, '0', '0', 'admin', '2021-11-09 23:31:07', 'admin', '2021-11-10 22:25:55', '3', '1', 'st');
INSERT INTO `sys_dept` VALUES ('451', '205', '0,100,205', '宁波市奉化区金隆日用品有限公司党支部', '55', null, null, null, '0', '0', 'admin', '2021-11-09 23:31:19', 'admin', '2021-11-10 22:27:00', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('452', '205', '0,100,205', '宁波奉欣电力金具实业股份有限公司党支部', '56', null, null, null, '0', '0', 'admin', '2021-11-09 23:34:23', 'admin', '2021-11-10 22:27:14', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('453', '205', '0,100,205', '奉化区宁波米格林标识有限公司党支部', '57', null, null, null, '0', '0', 'admin', '2021-11-09 23:34:32', 'admin', '2021-11-10 22:27:28', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('454', '205', '0,100,205', '奉化区宁波鼎发轴业有限公司党支部', '58', null, null, null, '0', '0', 'admin', '2021-11-09 23:34:54', 'admin', '2021-11-10 22:27:42', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('455', '205', '0,100,205', '宁波市奉化区奥纪农业科技有限公司党支部', '59', null, null, null, '0', '0', 'admin', '2021-11-09 23:35:02', 'admin', '2021-11-10 22:27:52', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('456', '205', '0,100,205', '奉化区宁波卓越同辉灯饰有限公司党支部', '60', null, null, null, '0', '0', 'admin', '2021-11-09 23:35:13', 'admin', '2021-11-10 22:28:03', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('457', '205', '0,100,205', '奉化区浙江高度环保科技有限公司党支部', '61', null, null, null, '0', '0', 'admin', '2021-11-09 23:35:22', 'admin', '2021-11-10 22:28:15', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('458', '205', '0,100,205', '宁波奉化莱米纳塑业有限公司党支部', '62', null, null, null, '0', '0', 'admin', '2021-11-09 23:35:34', 'admin', '2021-11-10 22:28:27', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('459', '205', '0,100,205', '奉化区宁波祥嘉精密轴业有限公司党支部', '63', null, null, null, '0', '0', 'admin', '2021-11-09 23:35:44', 'admin', '2021-11-10 22:28:39', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('460', '205', '0,100,205', '宁波威特豪斯木业科技有限公司党支部', '64', null, null, null, '0', '0', 'admin', '2021-11-09 23:35:52', 'admin', '2021-11-10 22:28:48', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('461', '205', '0,100,205', '尚田街道仁龙联合党支部', '65', null, null, null, '0', '0', 'admin', '2021-11-09 23:36:01', 'admin', '2021-11-10 22:29:01', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('462', '205', '0,100,205', '奉化区宁波市维特建筑五金有限公司党支部', '66', null, null, null, '0', '0', 'admin', '2021-11-09 23:36:09', 'admin', '2021-11-10 22:29:15', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('463', '205', '0,100,205', '奉化区宁波健芝康医疗设备有限公司党支部', '67', null, null, null, '0', '0', 'admin', '2021-11-09 23:36:24', 'admin', '2021-11-10 22:29:24', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('464', '205', '0,100,205', '宁波奉化永潇机械厂党支部', '68', null, null, null, '0', '0', 'admin', '2021-11-09 23:36:33', 'admin', '2021-11-10 22:29:34', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('465', '205', '0,100,205', '奉化区科盛微型轴业有限公司党支部', '69', null, null, null, '0', '0', 'admin', '2021-11-09 23:36:41', 'admin', '2021-11-10 22:29:43', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('466', '205', '0,100,205', '宁波市奉化瑞军塑料制品厂党支部', '70', null, null, null, '0', '0', 'admin', '2021-11-09 23:36:51', 'admin', '2021-11-10 22:29:52', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('467', '205', '0,100,205', '奉化区宁波沃腾玛尔洁具有限公司党支部', '71', null, null, null, '0', '0', 'admin', '2021-11-09 23:37:02', 'admin', '2021-11-10 22:30:05', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('468', '205', '0,100,205', '奉化区宁波市银蝶服饰有限公司党支部', '72', null, null, null, '0', '0', 'admin', '2021-11-09 23:37:09', 'admin', '2021-11-10 22:30:14', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('469', '205', '0,100,205', '宁波市奉化区圆华织造有限公司党支部', '73', null, null, null, '0', '0', 'admin', '2021-11-09 23:37:19', 'admin', '2021-11-10 22:30:28', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('470', '205', '0,100,205', '奉化区宁波市三力机械有限公司党支部', '74', null, null, null, '0', '0', 'admin', '2021-11-09 23:37:27', 'admin', '2021-11-10 22:30:37', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('471', '205', '0,100,205', '宁波市欧佰胜箱柜制造有限公司党支部', '75', null, null, null, '0', '0', 'admin', '2021-11-09 23:37:35', 'admin', '2021-11-10 22:30:49', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('472', '205', '0,100,205', '奉化区宁波天风汽车空压机有限公司党支部', '76', null, null, null, '0', '0', 'admin', '2021-11-09 23:37:56', 'admin', '2021-11-10 22:31:00', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('473', '205', '0,100,205', '宁波市奉化区白云防水材料厂党支部', '77', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:04', 'admin', '2021-11-10 22:31:10', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('474', '205', '0,100,205', '浙江锐泰悬挂系统科技有限公司党支部', '78', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:11', 'admin', '2021-11-10 22:31:29', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('475', '205', '0,100,205', '宁波奉化贝来钢球轴承有限公司党支部', '79', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:20', 'admin', '2021-11-10 22:31:38', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('476', '205', '0,100,205', '力星金燕钢球（宁波）有限公司党支部', '80', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:28', 'admin', '2021-11-10 22:31:48', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('477', '205', '0,100,205', '宁波奉化新元宠物用品有限公司党支部', '81', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:36', 'admin', '2021-11-10 22:31:56', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('478', '205', '0,100,205', '奉化区宁波赛夫科技有限公司党支部', '82', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:44', 'admin', '2021-11-10 22:32:05', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('479', '205', '0,100,205', '奉化区宁波市宇星水表有限公司党支部', '83', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:51', 'admin', '2021-11-10 22:32:15', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('480', '205', '0,100,205', '奉化区宁波市埃美仪表制造有限公司党支部', '84', null, null, null, '0', '0', 'admin', '2021-11-09 23:38:59', 'admin', '2021-11-10 22:32:23', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('481', '205', '0,100,205', '宁波奉化精密钢球有限公司党支部', '85', null, null, null, '0', '0', 'admin', '2021-11-09 23:39:06', 'admin', '2021-11-10 22:32:32', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('482', '205', '0,100,205', '奉化区宁波亿尚钢化制品有限公司党支部', '86', null, null, null, '0', '0', 'admin', '2021-11-09 23:39:17', 'admin', '2021-11-10 22:32:41', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('483', '205', '0,100,205', '宁波奉化申沪宠物玩具厂党支部', '87', null, null, null, '0', '0', 'admin', '2021-11-09 23:39:27', 'admin', '2021-11-10 22:32:50', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('484', '205', '0,100,205', '宁波奉化波涛汽配制造有限公司党支部', '88', null, null, null, '0', '0', 'admin', '2021-11-09 23:39:35', 'admin', '2021-11-10 22:33:05', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('485', '205', '0,100,205', '奉化区宁波市恩霖工艺品有限公司党支部', '89', null, null, null, '0', '0', 'admin', '2021-11-09 23:39:49', 'admin', '2021-11-10 22:33:19', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('486', '205', '0,100,205', '宁波市奉化区狮山波纹管有限公司党支部', '90', null, null, null, '0', '0', 'admin', '2021-11-09 23:39:57', 'admin', '2021-11-10 22:33:32', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('487', '205', '0,100,205', '宁波奉化盛荣升铸造有限公司党支部', '91', null, null, null, '0', '0', 'admin', '2021-11-09 23:40:16', 'admin', '2021-11-10 22:33:43', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('488', '205', '0,100,205', '奉化区宁波派达索塑料玩具有限公司党支部', '92', null, null, null, '0', '0', 'admin', '2021-11-09 23:40:24', 'admin', '2021-11-10 22:33:52', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('489', '205', '0,100,205', '奉化区宁波佰利刀业有限公司党支部', '93', null, null, null, '0', '0', 'admin', '2021-11-09 23:40:33', 'admin', '2021-11-10 22:34:01', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('490', '205', '0,100,205', '奉化区宁波隆欣金属科技有限公司党支部', '94', null, null, null, '0', '0', 'admin', '2021-11-09 23:40:42', 'admin', '2021-11-10 22:34:11', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('491', '205', '0,100,205', '浙拖奔野宁波拖拉机制造有限公司党支部', '95', null, null, null, '0', '0', 'admin', '2021-11-09 23:40:51', 'admin', '2021-11-10 22:34:19', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('492', '205', '0,100,205', '奉化区浙江中桓建设有限公司党支部', '96', null, null, null, '0', '0', 'admin', '2021-11-09 23:41:05', 'admin', '2021-11-10 22:34:29', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('493', '205', '0,100,205', '尚田开发区上海工业城联合党支部', '97', null, null, null, '0', '0', 'admin', '2021-11-09 23:41:14', 'admin', '2021-11-10 22:34:38', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('494', '205', '0,100,205', '宁波市奉化区青林工贸有限公司党支部', '98', null, null, null, '0', '0', 'admin', '2021-11-09 23:41:27', 'admin', '2021-11-10 22:34:46', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('495', '205', '0,100,205', '奉化区宁波市锦泰机械制造有限公司党支部', '99', null, null, null, '0', '0', 'admin', '2021-11-09 23:41:37', 'admin', '2021-11-10 22:34:57', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('496', '398', '0,100,205,398', '尚田街道冷西村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:42:27', 'admin', '2021-11-10 22:13:56', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('497', '398', '0,100,205,398', '尚田街道冷西村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:42:36', 'admin', '2021-11-10 22:14:10', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('498', '398', '0,100,205,398', '尚田街道冷西村第一党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:42:44', 'admin', '2021-11-10 22:14:17', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('499', '398', '0,100,205,398', '尚田街道冷西村第四党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 23:42:59', 'admin', '2021-11-10 22:14:26', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('500', '399', '0,100,205,399', '尚田街道方门村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:43:16', 'admin', '2021-11-10 22:14:41', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('501', '399', '0,100,205,399', '尚田街道方门村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:43:24', 'admin', '2021-11-10 22:14:45', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('502', '399', '0,100,205,399', '尚田街道方门村第一党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:43:33', 'admin', '2021-11-10 22:14:49', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('503', '399', '0,100,205,399', '尚田街道方门村第四党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 23:43:41', 'admin', '2021-11-10 22:14:52', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('504', '400', '0,100,205,400', '尚田街道尚二村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:44:36', 'admin', '2021-11-10 22:15:08', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('505', '400', '0,100,205,400', '尚田街道尚二村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:44:45', 'admin', '2021-11-10 22:15:14', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('506', '400', '0,100,205,400', '尚田街道尚二村第一党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:44:53', 'admin', '2021-11-10 22:15:17', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('507', '401', '0,100,205,401', '尚田街道条宅村第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:45:14', 'admin', '2021-11-10 22:15:34', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('508', '401', '0,100,205,401', '尚田街道条宅村第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:45:22', 'admin', '2021-11-10 22:15:37', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('509', '401', '0,100,205,401', '尚田街道条宅村第四党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:45:31', 'admin', '2021-11-10 22:15:40', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('510', '401', '0,100,205,401', '尚田街道条宅村第三党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 23:45:39', 'admin', '2021-11-10 22:15:43', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('511', '402', '0,100,205,402', '尚田街道尚一村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:45:57', 'admin', '2021-11-10 22:16:00', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('512', '402', '0,100,205,402', '尚田街道尚一村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:46:08', 'admin', '2021-11-10 22:16:04', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('513', '402', '0,100,205,402', '尚田街道尚一村第一党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:46:17', 'admin', '2021-11-10 22:16:07', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('514', '403', '0,100,205,403', '尚田街道广渡村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:46:36', 'admin', '2021-11-10 22:16:18', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('515', '403', '0,100,205,403', '尚田街道广渡村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:46:44', 'admin', '2021-11-10 22:16:21', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('516', '403', '0,100,205,403', '尚田街道广渡村第一党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:46:52', 'admin', '2021-11-10 22:16:24', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('517', '404', '0,100,205,404', '尚田街道楼岩村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:47:17', 'admin', '2021-11-10 22:16:38', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('518', '404', '0,100,205,404', '尚田街道楼岩村第一党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:47:25', 'admin', '2021-11-10 22:16:42', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('519', '405', '0,100,205,405', '尚田街道金地寺村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:47:45', 'admin', '2021-11-10 22:17:05', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('520', '405', '0,100,205,405', '尚田街道金地寺村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:47:53', 'admin', '2021-11-10 22:17:08', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('521', '405', '0,100,205,405', '尚田街道金地寺村第四党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:48:01', 'admin', '2021-11-10 22:17:11', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('522', '405', '0,100,205,405', '尚田街道金地寺村第五党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 23:48:08', 'admin', '2021-11-10 22:17:17', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('523', '405', '0,100,205,405', '尚田街道金地寺村第一党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 23:48:14', 'admin', '2021-11-10 22:17:27', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('524', '406', '0,100,205,406', '尚田街道桥棚村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:48:31', 'admin', '2021-11-10 22:17:48', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('525', '406', '0,100,205,406', '尚田街道桥棚村第一党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:48:44', 'admin', '2021-11-10 22:17:51', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('526', '407', '0,100,205,407', '尚田街道许家村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:49:03', 'admin', '2021-11-10 22:18:02', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('527', '407', '0,100,205,407', '尚田街道许家村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:49:10', 'admin', '2021-11-10 22:18:06', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('528', '407', '0,100,205,407', '尚田街道许家村第一党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:49:17', 'admin', '2021-11-10 22:18:08', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('529', '408', '0,100,205,408', '尚田街道汇溪村第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:49:35', 'admin', '2021-11-10 22:18:30', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('530', '408', '0,100,205,408', '尚田街道汇溪村第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:49:43', 'admin', '2021-11-10 22:18:33', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('531', '409', '0,100,205,409', '尚田街道杨家堰村第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:50:00', 'admin', '2021-11-10 22:18:48', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('532', '409', '0,100,205,409', '尚田街道杨家堰村第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:50:10', 'admin', '2021-11-10 22:18:52', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('533', '410', '0,100,205,410', '尚田街道双溪联村第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:51:11', 'admin', '2021-11-10 22:19:04', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('534', '410', '0,100,205,410', '尚田街道双溪联村第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:51:19', 'admin', '2021-11-10 22:19:07', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('535', '450', '0,100,205,450', '奉化区南方机械制造有限公司第一党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:51:41', 'admin', '2021-11-10 22:25:58', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('536', '450', '0,100,205,450', '奉化区南方机械制造有限公司第二党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:52:06', 'admin', '2021-11-10 22:26:01', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('537', '450', '0,100,205,450', '奉化区南方机械制造有限公司第三党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:52:17', 'admin', '2021-11-10 22:26:04', '1', '1', 'st');
INSERT INTO `sys_dept` VALUES ('538', '212', '0,100,212', '松岙镇居委会党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-09 23:57:58', 'admin', '2021-11-10 22:04:40', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('539', '212', '0,100,212', '松岙镇海沿村党总支', '2', null, null, null, '0', '0', 'admin', '2021-11-09 23:58:14', 'admin', '2021-11-10 22:04:50', '3', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('540', '212', '0,100,212', '松岙镇后山村党总支', '3', null, null, null, '0', '0', 'admin', '2021-11-09 23:58:23', 'admin', '2021-11-10 22:05:01', '3', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('541', '212', '0,100,212', '松岙镇上汪村党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-09 23:58:31', 'admin', '2021-11-10 22:06:12', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('542', '212', '0,100,212', '松岙镇街横村党支部', '5', null, null, null, '0', '0', 'admin', '2021-11-09 23:58:39', 'admin', '2021-11-10 22:06:20', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('543', '212', '0,100,212', '松岙镇街二村党支部', '6', null, null, null, '0', '0', 'admin', '2021-11-09 23:58:47', 'admin', '2021-11-10 22:06:30', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('544', '212', '0,100,212', '松岙镇淡溪村党支部', '7', null, null, null, '0', '0', 'admin', '2021-11-09 23:58:56', 'admin', '2021-11-10 22:06:40', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('545', '212', '0,100,212', '松岙镇五百岙村党支部', '8', null, null, null, '0', '0', 'admin', '2021-11-09 23:59:17', 'admin', '2021-11-10 22:06:58', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('546', '212', '0,100,212', '松岙镇湖头渡村党支部', '9', null, null, null, '0', '0', 'admin', '2021-11-09 23:59:26', 'admin', '2021-11-10 22:07:09', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('547', '212', '0,100,212', '松岙镇大埠村党支部', '10', null, null, null, '0', '0', 'admin', '2021-11-09 23:59:37', 'admin', '2021-11-10 22:07:18', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('548', '212', '0,100,212', '松岙镇街一村党支部', '11', null, null, null, '0', '0', 'admin', '2021-11-09 23:59:45', 'admin', '2021-11-10 22:07:47', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('549', '212', '0,100,212', '松岙镇西岙村党支部', '12', null, null, null, '0', '0', 'admin', '2021-11-09 23:59:53', 'admin', '2021-11-10 22:07:56', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('550', '212', '0,100,212', '松岙镇机关党总支', '13', null, null, null, '0', '0', 'admin', '2021-11-10 00:00:02', 'admin', '2021-11-10 22:08:09', '3', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('551', '212', '0,100,212', '松岙镇船厂党支部', '14', null, '', null, '0', '0', 'admin', '2021-11-10 00:00:12', 'admin', '2021-11-10 22:09:14', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('552', '212', '0,100,212', '松岙镇商会支党支部', '15', null, null, null, '0', '0', 'admin', '2021-11-10 00:00:22', 'admin', '2021-11-10 22:09:22', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('553', '212', '0,100,212', '松岙镇奉化立佳铸造厂党支部', '16', null, null, null, '0', '0', 'admin', '2021-11-10 00:00:29', 'admin', '2021-11-10 22:09:32', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('554', '212', '0,100,212', '松岙镇宁波海丰纸业有限公司党支部', '17', null, null, null, '0', '0', 'admin', '2021-11-10 00:00:39', 'admin', '2021-11-10 22:09:41', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('555', '212', '0,100,212', '松岙镇宁波杰森绿色能源科技公司党支部', '18', null, null, null, '0', '0', 'admin', '2021-11-10 00:00:47', 'admin', '2021-11-10 22:11:17', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('556', '212', '0,100,212', '松岙镇宁波和创物流发展有限公司党支部', '19', null, null, null, '0', '0', 'admin', '2021-11-10 00:00:56', 'admin', '2021-11-10 22:11:27', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('557', '212', '0,100,212', '松岙镇磁材行业联合党支部', '20', null, null, null, '0', '0', 'admin', '2021-11-10 00:01:05', 'admin', '2021-11-10 22:11:37', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('558', '212', '0,100,212', '松岙镇宝龙建筑构件有限公司党支部', '21', null, null, null, '0', '0', 'admin', '2021-11-10 00:01:13', 'admin', '2021-11-10 22:11:47', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('559', '212', '0,100,212', '松岙镇宁波松科磁材有限公司党支部', '22', null, null, null, '0', '0', 'admin', '2021-11-10 00:01:22', 'admin', '2021-11-10 22:11:56', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('560', '212', '0,100,212', '松岙镇宁波汇丰食品有限公司党支部', '23', null, null, null, '0', '0', 'admin', '2021-11-10 00:01:30', 'admin', '2021-11-10 22:12:05', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('561', '212', '0,100,212', '松岙镇宁波一成食品有限公司党支部', '24', null, null, null, '0', '0', 'admin', '2021-11-10 00:01:38', 'admin', '2021-11-10 22:12:17', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('562', '212', '0,100,212', '松岙镇松欣食品有限公司党支部', '25', null, null, null, '0', '0', 'admin', '2021-11-10 00:01:47', 'admin', '2021-11-10 22:12:27', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('563', '212', '0,100,212', '松岙镇佳鑫港务工程有限公司党支部', '26', null, null, null, '0', '0', 'admin', '2021-11-10 00:01:56', 'admin', '2021-11-10 22:12:36', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('564', '539', '0,100,212,539', '松岙镇海沿村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-10 00:02:37', 'admin', '2021-11-10 22:05:12', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('565', '539', '0,100,212,539', '松岙镇海沿村第三党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-10 00:02:46', 'admin', '2021-11-10 22:05:20', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('566', '539', '0,100,212,539', '松岙镇海沿村第四党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-10 00:02:56', 'admin', '2021-11-10 22:05:28', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('567', '539', '0,100,212,539', '松岙镇海沿村第一党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-10 00:03:12', 'admin', '2021-11-10 22:05:36', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('568', '540', '0,100,212,540', '松岙镇后山村第二党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-10 00:04:56', 'admin', '2021-11-10 22:05:45', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('569', '540', '0,100,212,540', '松岙镇后山村第一党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-10 00:05:03', 'admin', '2021-11-10 22:05:58', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('570', '550', '0,100,212,550', '松岙镇发展服务党支部', '1', null, null, null, '0', '0', 'admin', '2021-11-10 00:06:01', 'admin', '2021-11-10 22:08:31', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('571', '550', '0,100,212,550', '松岙镇组织保障党支部', '2', null, null, null, '0', '0', 'admin', '2021-11-10 00:06:10', 'admin', '2021-11-10 22:08:48', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('572', '550', '0,100,212,550', '松岙镇平安建设党支部', '3', null, null, null, '0', '0', 'admin', '2021-11-10 00:06:29', 'admin', '2021-11-10 22:08:57', '1', '1', 'sa');
INSERT INTO `sys_dept` VALUES ('573', '550', '0,100,212,550', '松岙镇综合统筹党支部', '4', null, null, null, '0', '0', 'admin', '2021-11-10 00:06:43', 'admin', '2021-11-10 22:09:05', '1', '1', 'sa');

-- ----------------------------
-- Table structure for sys_dict_data
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_data`;
CREATE TABLE `sys_dict_data` (
  `dict_code` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典编码',
  `dict_sort` int(4) DEFAULT 0 COMMENT '字典排序',
  `dict_label` varchar(100) DEFAULT '' COMMENT '字典标签',
  `dict_value` varchar(100) DEFAULT '' COMMENT '字典键值',
  `dict_type` varchar(100) DEFAULT '' COMMENT '字典类型',
  `css_class` varchar(100) DEFAULT NULL COMMENT '样式属性（其他样式扩展）',
  `list_class` varchar(100) DEFAULT NULL COMMENT '表格回显样式',
  `is_default` char(1) DEFAULT 'N' COMMENT '是否默认（Y是 N否）',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_code`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 COMMENT='字典数据表';

-- ----------------------------
-- Records of sys_dict_data
-- ----------------------------
INSERT INTO `sys_dict_data` VALUES ('1', '1', '男', '0', 'sys_user_sex', '', '', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '性别男');
INSERT INTO `sys_dict_data` VALUES ('2', '2', '女', '1', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '性别女');
INSERT INTO `sys_dict_data` VALUES ('3', '3', '未知', '2', 'sys_user_sex', '', '', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '性别未知');
INSERT INTO `sys_dict_data` VALUES ('4', '1', '显示', '0', 'sys_show_hide', '', 'primary', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '显示菜单');
INSERT INTO `sys_dict_data` VALUES ('5', '2', '隐藏', '1', 'sys_show_hide', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '隐藏菜单');
INSERT INTO `sys_dict_data` VALUES ('6', '1', '正常', '0', 'sys_normal_disable', '', 'primary', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '正常状态');
INSERT INTO `sys_dict_data` VALUES ('7', '2', '停用', '1', 'sys_normal_disable', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '停用状态');
INSERT INTO `sys_dict_data` VALUES ('8', '1', '正常', '0', 'sys_job_status', '', 'primary', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '正常状态');
INSERT INTO `sys_dict_data` VALUES ('9', '2', '暂停', '1', 'sys_job_status', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '停用状态');
INSERT INTO `sys_dict_data` VALUES ('10', '1', '默认', 'DEFAULT', 'sys_job_group', '', '', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '默认分组');
INSERT INTO `sys_dict_data` VALUES ('11', '2', '系统', 'SYSTEM', 'sys_job_group', '', '', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '系统分组');
INSERT INTO `sys_dict_data` VALUES ('12', '1', '是', 'Y', 'sys_yes_no', '', 'primary', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '系统默认是');
INSERT INTO `sys_dict_data` VALUES ('13', '2', '否', 'N', 'sys_yes_no', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '系统默认否');
INSERT INTO `sys_dict_data` VALUES ('14', '1', '通知', '1', 'sys_notice_type', '', 'warning', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '通知');
INSERT INTO `sys_dict_data` VALUES ('15', '2', '公告', '2', 'sys_notice_type', '', 'success', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '公告');
INSERT INTO `sys_dict_data` VALUES ('16', '1', '正常', '0', 'sys_notice_status', '', 'primary', 'Y', '0', 'admin', '2021-09-26 14:47:28', '', null, '正常状态');
INSERT INTO `sys_dict_data` VALUES ('17', '2', '关闭', '1', 'sys_notice_status', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '关闭状态');
INSERT INTO `sys_dict_data` VALUES ('18', '1', '新增', '1', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '新增操作');
INSERT INTO `sys_dict_data` VALUES ('19', '2', '修改', '2', 'sys_oper_type', '', 'info', 'N', '0', 'admin', '2021-09-26 14:47:28', '', null, '修改操作');
INSERT INTO `sys_dict_data` VALUES ('20', '3', '删除', '3', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '删除操作');
INSERT INTO `sys_dict_data` VALUES ('21', '4', '授权', '4', 'sys_oper_type', '', 'primary', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '授权操作');
INSERT INTO `sys_dict_data` VALUES ('22', '5', '导出', '5', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '导出操作');
INSERT INTO `sys_dict_data` VALUES ('23', '6', '导入', '6', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '导入操作');
INSERT INTO `sys_dict_data` VALUES ('24', '7', '强退', '7', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '强退操作');
INSERT INTO `sys_dict_data` VALUES ('25', '8', '生成代码', '8', 'sys_oper_type', '', 'warning', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '生成操作');
INSERT INTO `sys_dict_data` VALUES ('26', '9', '清空数据', '9', 'sys_oper_type', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '清空操作');
INSERT INTO `sys_dict_data` VALUES ('27', '1', '成功', '0', 'sys_common_status', '', 'primary', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '正常状态');
INSERT INTO `sys_dict_data` VALUES ('28', '2', '失败', '1', 'sys_common_status', '', 'danger', 'N', '0', 'admin', '2021-09-26 14:47:29', '', null, '停用状态');
INSERT INTO `sys_dict_data` VALUES ('29', '1', '01政治理论、业务学习', '1', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:32:56', 'admin', '2021-11-04 18:32:56', null);
INSERT INTO `sys_dict_data` VALUES ('30', '2', '02传达上级文件和指示精神', '2', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:33:07', 'admin', '2021-11-04 18:33:07', null);
INSERT INTO `sys_dict_data` VALUES ('31', '3', '03批评和自我批评', '3', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:33:19', 'admin', '2021-11-04 18:33:19', null);
INSERT INTO `sys_dict_data` VALUES ('32', '4', '04民主评议党员', '4', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:33:35', 'admin', '2021-11-04 18:33:35', null);
INSERT INTO `sys_dict_data` VALUES ('33', '5', '05研究党员组织处置和纪律处分', '5', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:33:47', 'admin', '2021-11-04 18:33:47', null);
INSERT INTO `sys_dict_data` VALUES ('34', '6', '06研究发展党员', '6', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:34:03', 'admin', '2021-11-04 18:34:03', null);
INSERT INTO `sys_dict_data` VALUES ('35', '7', '07党内选举', '7', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:34:23', 'admin', '2021-11-04 18:34:23', null);
INSERT INTO `sys_dict_data` VALUES ('36', '8', '08研究支部重大事项', '8', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:34:34', 'admin', '2021-11-04 18:34:34', null);
INSERT INTO `sys_dict_data` VALUES ('37', '9', '09关爱帮扶和志愿活动', '9', 'activity_content', '', 'default', 'N', '0', 'admin', '2021-11-04 18:34:46', 'admin', '2021-11-04 18:34:46', null);
INSERT INTO `sys_dict_data` VALUES ('38', '99', '99其他', '99', 'activity_content', null, 'default', 'N', '0', 'admin', '2021-11-04 18:34:56', 'admin', '2021-11-04 18:34:56', null);
INSERT INTO `sys_dict_data` VALUES ('39', '1', '基层委员会', '01', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:53:36', 'admin', '2021-11-10 10:53:36', null);
INSERT INTO `sys_dict_data` VALUES ('40', '2', '支部委员会', '02', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:53:48', 'admin', '2021-11-10 10:54:07', null);
INSERT INTO `sys_dict_data` VALUES ('41', '3', '党小组会', '03', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:53:58', 'admin', '2021-11-10 10:54:02', null);
INSERT INTO `sys_dict_data` VALUES ('42', '4', '党员大会', '04', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:54:19', 'admin', '2021-11-10 10:54:19', null);
INSERT INTO `sys_dict_data` VALUES ('43', '5', '主题党日', '05', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:54:26', 'admin', '2021-11-10 10:54:47', null);
INSERT INTO `sys_dict_data` VALUES ('44', '6', '组织生活会', '06', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:54:37', 'admin', '2021-11-10 10:54:52', null);
INSERT INTO `sys_dict_data` VALUES ('45', '7', '党课', '07', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:55:02', 'admin', '2021-11-10 10:55:02', null);
INSERT INTO `sys_dict_data` VALUES ('46', '8', '民主评议', '08', 'activity_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:55:13', 'admin', '2021-11-10 10:55:13', null);
INSERT INTO `sys_dict_data` VALUES ('47', '1', '01', '1,2,3,4,5,6,7,8,9,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:57:31', 'admin', '2021-11-10 10:57:31', null);
INSERT INTO `sys_dict_data` VALUES ('48', '2', '02', '1,2,3,6,8,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:57:49', 'admin', '2021-11-10 10:57:49', null);
INSERT INTO `sys_dict_data` VALUES ('49', '3', '03', '1,2,9,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:58:01', 'admin', '2021-11-10 10:58:01', null);
INSERT INTO `sys_dict_data` VALUES ('50', '4', '04', '1,2,3,4,5,6,7,8,9,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:58:09', 'admin', '2021-11-10 10:58:14', null);
INSERT INTO `sys_dict_data` VALUES ('51', '5', '05', '1,2,3,4,5,6,7,8,9,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:58:24', 'admin', '2021-11-10 10:58:24', null);
INSERT INTO `sys_dict_data` VALUES ('52', '6', '06', '3,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:58:33', 'admin', '2021-11-10 10:58:33', null);
INSERT INTO `sys_dict_data` VALUES ('53', '7', '07', '1,2,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:58:42', 'admin', '2021-11-10 10:58:42', null);
INSERT INTO `sys_dict_data` VALUES ('54', '8', '08', '1,2,3,4,5,6,7,8,9,99', 'activity_content_type', null, 'default', 'N', '0', 'admin', '2021-11-10 10:58:51', 'admin', '2021-11-10 10:58:51', null);
INSERT INTO `sys_dict_data` VALUES ('55', '1', '01', '3', 'activity_post_type', null, 'default', 'N', '0', 'admin', '2021-11-10 11:50:36', 'admin', '2021-11-10 11:50:36', null);
INSERT INTO `sys_dict_data` VALUES ('56', '2', '02', '1', 'activity_post_type', null, 'default', 'N', '0', 'admin', '2021-11-10 11:50:47', 'admin', '2021-11-10 11:53:18', null);
INSERT INTO `sys_dict_data` VALUES ('57', '3', '03', '4', 'activity_post_type', null, 'default', 'N', '0', 'admin', '2021-11-10 11:50:55', 'admin', '2021-11-10 11:53:13', null);
INSERT INTO `sys_dict_data` VALUES ('58', '4', '04', '2,6,7', 'activity_post_type', null, 'default', 'N', '0', 'admin', '2021-11-10 11:51:20', 'admin', '2021-11-10 11:53:10', null);
INSERT INTO `sys_dict_data` VALUES ('59', '5', '05', '2', 'activity_post_type', null, 'default', 'N', '0', 'admin', '2021-11-10 11:52:25', 'admin', '2021-11-10 11:53:04', null);
INSERT INTO `sys_dict_data` VALUES ('60', '6', '06', '2,7', 'activity_post_type', null, 'default', 'N', '0', 'admin', '2021-11-10 11:52:36', 'admin', '2021-11-10 11:52:58', null);
INSERT INTO `sys_dict_data` VALUES ('61', '7', '07', '6', 'activity_post_type', null, 'default', 'N', '0', 'admin', '2021-11-10 11:52:51', 'admin', '2021-11-10 11:52:51', null);
INSERT INTO `sys_dict_data` VALUES ('62', '8', '08', '7', 'activity_post_type', '', 'default', 'N', '0', 'admin', '2021-11-10 11:52:51', 'admin', '2021-11-10 11:52:51', '');
INSERT INTO `sys_dict_data` VALUES ('63', '0', '31理想信念缺失', '31', 'activity_evaluate_unqualified', null, 'default', 'N', '0', 'admin', '2021-11-11 11:06:31', 'admin', '2021-11-11 11:06:31', null);
INSERT INTO `sys_dict_data` VALUES ('64', '1', '32政治立场动摇', '32', 'activity_evaluate_unqualified', null, 'default', 'N', '0', 'admin', '2021-11-11 11:06:54', 'admin', '2021-11-11 11:06:54', null);
INSERT INTO `sys_dict_data` VALUES ('65', '2', '33宗旨观念淡薄', '33', 'activity_evaluate_unqualified', null, 'default', 'N', '0', 'admin', '2021-11-11 11:07:13', 'admin', '2021-11-11 11:07:21', null);
INSERT INTO `sys_dict_data` VALUES ('66', '4', '34工作消极懈怠', '34', 'activity_evaluate_unqualified', null, 'default', 'N', '0', 'admin', '2021-11-11 11:07:35', 'admin', '2021-11-11 11:07:35', null);
INSERT INTO `sys_dict_data` VALUES ('67', '5', '35组织纪律散漫', '35', 'activity_evaluate_unqualified', null, 'default', 'N', '0', 'admin', '2021-11-11 11:07:48', 'admin', '2021-11-11 11:07:48', null);
INSERT INTO `sys_dict_data` VALUES ('68', '6', '36道德行为不端', '36', 'activity_evaluate_unqualified', null, 'default', 'N', '0', 'admin', '2021-11-11 11:08:07', 'admin', '2021-11-11 11:08:07', null);

-- ----------------------------
-- Table structure for sys_dict_type
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict_type`;
CREATE TABLE `sys_dict_type` (
  `dict_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '字典主键',
  `dict_name` varchar(100) DEFAULT '' COMMENT '字典名称',
  `dict_type` varchar(100) DEFAULT '' COMMENT '字典类型',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1停用）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`dict_id`),
  UNIQUE KEY `dict_type` (`dict_type`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COMMENT='字典类型表';

-- ----------------------------
-- Records of sys_dict_type
-- ----------------------------
INSERT INTO `sys_dict_type` VALUES ('1', '用户性别', 'sys_user_sex', '0', 'admin', '2021-09-26 14:47:27', '', null, '用户性别列表');
INSERT INTO `sys_dict_type` VALUES ('2', '菜单状态', 'sys_show_hide', '0', 'admin', '2021-09-26 14:47:27', '', null, '菜单状态列表');
INSERT INTO `sys_dict_type` VALUES ('3', '系统开关', 'sys_normal_disable', '0', 'admin', '2021-09-26 14:47:27', '', null, '系统开关列表');
INSERT INTO `sys_dict_type` VALUES ('4', '任务状态', 'sys_job_status', '0', 'admin', '2021-09-26 14:47:27', '', null, '任务状态列表');
INSERT INTO `sys_dict_type` VALUES ('5', '任务分组', 'sys_job_group', '0', 'admin', '2021-09-26 14:47:27', '', null, '任务分组列表');
INSERT INTO `sys_dict_type` VALUES ('6', '系统是否', 'sys_yes_no', '0', 'admin', '2021-09-26 14:47:27', '', null, '系统是否列表');
INSERT INTO `sys_dict_type` VALUES ('7', '通知类型', 'sys_notice_type', '0', 'admin', '2021-09-26 14:47:27', '', null, '通知类型列表');
INSERT INTO `sys_dict_type` VALUES ('8', '通知状态', 'sys_notice_status', '0', 'admin', '2021-09-26 14:47:28', '', null, '通知状态列表');
INSERT INTO `sys_dict_type` VALUES ('9', '操作类型', 'sys_oper_type', '0', 'admin', '2021-09-26 14:47:28', '', null, '操作类型列表');
INSERT INTO `sys_dict_type` VALUES ('10', '系统状态', 'sys_common_status', '0', 'admin', '2021-09-26 14:47:28', '', null, '登录状态列表');
INSERT INTO `sys_dict_type` VALUES ('11', '活动内容', 'activity_content', '0', 'admin', '2021-11-04 18:32:12', 'admin', '2021-11-04 18:32:12', '活动内容信息');
INSERT INTO `sys_dict_type` VALUES ('12', '活动类型与内容关联', 'activity_content_type', '0', 'admin', '2021-11-04 18:36:05', 'admin', '2021-11-10 11:49:15', '活动内容关联类型');
INSERT INTO `sys_dict_type` VALUES ('13', '活动类型', 'activity_type', '0', 'admin', null, 'admin', null, '活动类型');
INSERT INTO `sys_dict_type` VALUES ('14', '活动类型与活动对象关联', 'activity_post_type', '0', 'admin', '2021-11-10 11:49:46', 'admin', '2021-11-10 11:49:46', null);
INSERT INTO `sys_dict_type` VALUES ('15', '民主评议不合格数据字典', 'activity_evaluate_unqualified', '0', 'admin', '2021-11-11 11:05:58', 'admin', '2021-11-11 11:05:58', '民主评议不合格数据字典');

-- ----------------------------
-- Table structure for sys_job
-- ----------------------------
DROP TABLE IF EXISTS `sys_job`;
CREATE TABLE `sys_job` (
  `job_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务ID',
  `job_name` varchar(64) NOT NULL DEFAULT '' COMMENT '任务名称',
  `job_group` varchar(64) NOT NULL DEFAULT 'DEFAULT' COMMENT '任务组名',
  `invoke_target` varchar(500) NOT NULL COMMENT '调用目标字符串',
  `cron_expression` varchar(255) DEFAULT '' COMMENT 'cron执行表达式',
  `misfire_policy` varchar(20) DEFAULT '3' COMMENT '计划执行错误策略（1立即执行 2执行一次 3放弃执行）',
  `concurrent` char(1) DEFAULT '1' COMMENT '是否并发执行（0允许 1禁止）',
  `status` char(1) DEFAULT '0' COMMENT '状态（0正常 1暂停）',
  `create_by` varchar(64) DEFAULT '' COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) DEFAULT '' COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) DEFAULT '' COMMENT '备注信息',
  PRIMARY KEY (`job_id`,`job_name`,`job_group`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='定时任务调度表';

-- ----------------------------
-- Records of sys_job
-- ----------------------------
INSERT INTO `sys_job` VALUES ('1', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '0/10 * * * * ?', '3', '1', '1', 'admin', '2021-09-26 14:47:30', 'admin', '2021-11-04 16:55:35', '');
INSERT INTO `sys_job` VALUES ('2', '系统默认（有参）', 'DEFAULT', 'ryTask.ryParams(\'ry\')', '0/15 * * * * ?', '3', '1', '1', 'admin', '2021-09-26 14:47:30', '', null, '');
INSERT INTO `sys_job` VALUES ('3', '系统默认（多参）', 'DEFAULT', 'ryTask.ryMultipleParams(\'ry\', true, 2000L, 316.50D, 100)', '0/20 * * * * ?', '3', '1', '1', 'admin', '2021-09-26 14:47:30', '', null, '');
INSERT INTO `sys_job` VALUES ('4', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '0 0/1 * * * ?', '1', '0', '0', 'admin', '2021-10-28 16:28:36', 'admin', '2021-11-04 16:53:36', '');

-- ----------------------------
-- Table structure for sys_job_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_job_log`;
CREATE TABLE `sys_job_log` (
  `job_log_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务日志ID',
  `job_name` varchar(64) NOT NULL COMMENT '任务名称',
  `job_group` varchar(64) NOT NULL COMMENT '任务组名',
  `invoke_target` varchar(500) NOT NULL COMMENT '调用目标字符串',
  `job_message` varchar(500) DEFAULT NULL COMMENT '日志信息',
  `status` char(1) DEFAULT '0' COMMENT '执行状态（0正常 1失败）',
  `exception_info` varchar(2000) DEFAULT '' COMMENT '异常信息',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`job_log_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5669 DEFAULT CHARSET=utf8 COMMENT='定时任务调度日志表';

-- ----------------------------
-- Records of sys_job_log
-- ----------------------------
INSERT INTO `sys_job_log` VALUES ('1', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：121毫秒', '1', 'org.springframework.beans.factory.NoSuchBeanDefinitionException: No bean named \'specialTask\' available\r\n	at org.springframework.beans.factory.support.DefaultListableBeanFactory.getBeanDefinition(DefaultListableBeanFactory.java:863)\r\n	at org.springframework.beans.factory.support.AbstractBeanFactory.getMergedLocalBeanDefinition(AbstractBeanFactory.java:1344)\r\n	at org.springframework.beans.factory.support.AbstractBeanFactory.doGetBean(AbstractBeanFactory.java:309)\r\n	at org.springframework.beans.factory.support.AbstractBeanFactory.getBean(AbstractBeanFactory.java:208)\r\n	at cn.hutool.extra.spring.SpringUtil.getBean(SpringUtil.java:106)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:32)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\n', '2021-10-28 16:29:00');
INSERT INTO `sys_job_log` VALUES ('2', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:52');
INSERT INTO `sys_job_log` VALUES ('3', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9070毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:55');
INSERT INTO `sys_job_log` VALUES ('4', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:55');
INSERT INTO `sys_job_log` VALUES ('5', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:55');
INSERT INTO `sys_job_log` VALUES ('6', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:55');
INSERT INTO `sys_job_log` VALUES ('7', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:55');
INSERT INTO `sys_job_log` VALUES ('8', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:55');
INSERT INTO `sys_job_log` VALUES ('9', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:55');
INSERT INTO `sys_job_log` VALUES ('10', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:56');
INSERT INTO `sys_job_log` VALUES ('11', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:56');
INSERT INTO `sys_job_log` VALUES ('12', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:56');
INSERT INTO `sys_job_log` VALUES ('13', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:56');
INSERT INTO `sys_job_log` VALUES ('14', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:56');
INSERT INTO `sys_job_log` VALUES ('15', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:53:56');
INSERT INTO `sys_job_log` VALUES ('16', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：1毫秒', '0', '', '2021-11-04 16:53:56');
INSERT INTO `sys_job_log` VALUES ('17', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：1毫秒', '0', '', '2021-11-04 16:54:00');
INSERT INTO `sys_job_log` VALUES ('18', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:54:00');
INSERT INTO `sys_job_log` VALUES ('19', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：1毫秒', '0', '', '2021-11-04 16:54:10');
INSERT INTO `sys_job_log` VALUES ('20', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：1毫秒', '0', '', '2021-11-04 16:54:20');
INSERT INTO `sys_job_log` VALUES ('21', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：0毫秒', '0', '', '2021-11-04 16:54:30');
INSERT INTO `sys_job_log` VALUES ('22', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：0毫秒', '0', '', '2021-11-04 16:54:40');
INSERT INTO `sys_job_log` VALUES ('23', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：0毫秒', '0', '', '2021-11-04 16:54:50');
INSERT INTO `sys_job_log` VALUES ('24', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：4727毫秒', '0', '', '2021-11-04 16:55:26');
INSERT INTO `sys_job_log` VALUES ('25', '系统默认（无参）', 'DEFAULT', 'ryTask.ryNoParams', '系统默认（无参） 总共耗时：0毫秒', '0', '', '2021-11-04 16:55:30');
INSERT INTO `sys_job_log` VALUES ('26', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:56:00');
INSERT INTO `sys_job_log` VALUES ('27', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23452毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:57:24');
INSERT INTO `sys_job_log` VALUES ('28', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: java.lang.NullPointerException\r\n	at com.ruoyi.quartz.task.SpecialTask.initSpecialActivityData(SpecialTask.java:52)\r\n	... 10 more\r\n', '2021-11-04 16:58:00');
INSERT INTO `sys_job_log` VALUES ('29', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：781毫秒', '0', '', '2021-11-04 16:59:01');
INSERT INTO `sys_job_log` VALUES ('30', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：602毫秒', '0', '', '2021-11-04 17:00:01');
INSERT INTO `sys_job_log` VALUES ('31', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：568毫秒', '0', '', '2021-11-04 17:01:01');
INSERT INTO `sys_job_log` VALUES ('32', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：648毫秒', '0', '', '2021-11-04 17:02:02');
INSERT INTO `sys_job_log` VALUES ('33', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：571毫秒', '0', '', '2021-11-04 17:03:01');
INSERT INTO `sys_job_log` VALUES ('34', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：560毫秒', '0', '', '2021-11-04 17:04:01');
INSERT INTO `sys_job_log` VALUES ('35', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：721毫秒', '0', '', '2021-11-04 17:05:01');
INSERT INTO `sys_job_log` VALUES ('36', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：663毫秒', '0', '', '2021-11-04 17:06:01');
INSERT INTO `sys_job_log` VALUES ('37', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：557毫秒', '0', '', '2021-11-04 17:07:01');
INSERT INTO `sys_job_log` VALUES ('38', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：605毫秒', '0', '', '2021-11-04 17:08:01');
INSERT INTO `sys_job_log` VALUES ('39', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：549毫秒', '0', '', '2021-11-04 17:09:14');
INSERT INTO `sys_job_log` VALUES ('40', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：831毫秒', '0', '', '2021-11-04 17:10:01');
INSERT INTO `sys_job_log` VALUES ('41', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1002毫秒', '0', '', '2021-11-04 17:11:10');
INSERT INTO `sys_job_log` VALUES ('42', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：831毫秒', '0', '', '2021-11-04 17:12:01');
INSERT INTO `sys_job_log` VALUES ('43', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：558毫秒', '0', '', '2021-11-04 17:13:01');
INSERT INTO `sys_job_log` VALUES ('44', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：716毫秒', '0', '', '2021-11-04 17:14:01');
INSERT INTO `sys_job_log` VALUES ('45', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：536毫秒', '0', '', '2021-11-04 17:15:01');
INSERT INTO `sys_job_log` VALUES ('46', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：503毫秒', '0', '', '2021-11-04 17:16:01');
INSERT INTO `sys_job_log` VALUES ('47', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：571毫秒', '0', '', '2021-11-04 17:17:01');
INSERT INTO `sys_job_log` VALUES ('48', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：688毫秒', '0', '', '2021-11-04 17:18:01');
INSERT INTO `sys_job_log` VALUES ('49', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：524毫秒', '0', '', '2021-11-04 17:19:01');
INSERT INTO `sys_job_log` VALUES ('50', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：39460毫秒', '0', '', '2021-11-04 17:20:42');
INSERT INTO `sys_job_log` VALUES ('51', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：535毫秒', '0', '', '2021-11-04 17:21:01');
INSERT INTO `sys_job_log` VALUES ('52', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21027毫秒', '0', '', '2021-11-04 17:22:28');
INSERT INTO `sys_job_log` VALUES ('53', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：697毫秒', '0', '', '2021-11-04 17:23:05');
INSERT INTO `sys_job_log` VALUES ('54', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：625毫秒', '0', '', '2021-11-04 17:24:01');
INSERT INTO `sys_job_log` VALUES ('55', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：488毫秒', '0', '', '2021-11-04 17:25:01');
INSERT INTO `sys_job_log` VALUES ('56', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：513毫秒', '0', '', '2021-11-04 17:26:01');
INSERT INTO `sys_job_log` VALUES ('57', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：571毫秒', '0', '', '2021-11-04 17:27:01');
INSERT INTO `sys_job_log` VALUES ('58', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：501毫秒', '0', '', '2021-11-04 17:28:01');
INSERT INTO `sys_job_log` VALUES ('59', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：535毫秒', '0', '', '2021-11-04 17:29:01');
INSERT INTO `sys_job_log` VALUES ('60', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：658毫秒', '0', '', '2021-11-04 17:30:01');
INSERT INTO `sys_job_log` VALUES ('61', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：538毫秒', '0', '', '2021-11-04 17:31:01');
INSERT INTO `sys_job_log` VALUES ('62', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：738毫秒', '0', '', '2021-11-04 17:32:01');
INSERT INTO `sys_job_log` VALUES ('63', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：599毫秒', '0', '', '2021-11-04 17:33:01');
INSERT INTO `sys_job_log` VALUES ('64', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：674毫秒', '0', '', '2021-11-04 17:34:01');
INSERT INTO `sys_job_log` VALUES ('65', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 17:35:01');
INSERT INTO `sys_job_log` VALUES ('66', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：848毫秒', '0', '', '2021-11-04 17:36:01');
INSERT INTO `sys_job_log` VALUES ('67', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：512毫秒', '0', '', '2021-11-04 17:37:01');
INSERT INTO `sys_job_log` VALUES ('68', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：576毫秒', '0', '', '2021-11-04 17:38:01');
INSERT INTO `sys_job_log` VALUES ('69', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3233毫秒', '0', '', '2021-11-04 17:39:28');
INSERT INTO `sys_job_log` VALUES ('70', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：490毫秒', '0', '', '2021-11-04 17:40:01');
INSERT INTO `sys_job_log` VALUES ('71', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：769毫秒', '0', '', '2021-11-04 17:42:01');
INSERT INTO `sys_job_log` VALUES ('72', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：416毫秒', '0', '', '2021-11-04 17:43:00');
INSERT INTO `sys_job_log` VALUES ('73', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：418毫秒', '0', '', '2021-11-04 17:44:01');
INSERT INTO `sys_job_log` VALUES ('74', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：505毫秒', '0', '', '2021-11-04 17:45:01');
INSERT INTO `sys_job_log` VALUES ('75', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：489毫秒', '0', '', '2021-11-04 17:46:01');
INSERT INTO `sys_job_log` VALUES ('76', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：549毫秒', '0', '', '2021-11-04 17:47:01');
INSERT INTO `sys_job_log` VALUES ('77', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：539毫秒', '0', '', '2021-11-04 17:48:01');
INSERT INTO `sys_job_log` VALUES ('78', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：484毫秒', '0', '', '2021-11-04 17:49:01');
INSERT INTO `sys_job_log` VALUES ('79', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：500毫秒', '0', '', '2021-11-04 17:50:01');
INSERT INTO `sys_job_log` VALUES ('80', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：516毫秒', '0', '', '2021-11-04 17:51:01');
INSERT INTO `sys_job_log` VALUES ('81', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 17:52:01');
INSERT INTO `sys_job_log` VALUES ('82', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：469毫秒', '0', '', '2021-11-04 17:53:01');
INSERT INTO `sys_job_log` VALUES ('83', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：527毫秒', '0', '', '2021-11-04 17:54:01');
INSERT INTO `sys_job_log` VALUES ('84', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 17:55:01');
INSERT INTO `sys_job_log` VALUES ('85', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：539毫秒', '0', '', '2021-11-04 17:56:01');
INSERT INTO `sys_job_log` VALUES ('86', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：532毫秒', '0', '', '2021-11-04 17:57:01');
INSERT INTO `sys_job_log` VALUES ('87', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：482毫秒', '0', '', '2021-11-04 17:58:01');
INSERT INTO `sys_job_log` VALUES ('88', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：479毫秒', '0', '', '2021-11-04 17:59:01');
INSERT INTO `sys_job_log` VALUES ('89', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：494毫秒', '0', '', '2021-11-04 18:00:01');
INSERT INTO `sys_job_log` VALUES ('90', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：681毫秒', '0', '', '2021-11-04 18:01:01');
INSERT INTO `sys_job_log` VALUES ('91', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：495毫秒', '0', '', '2021-11-04 18:02:01');
INSERT INTO `sys_job_log` VALUES ('92', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：526毫秒', '0', '', '2021-11-04 18:03:01');
INSERT INTO `sys_job_log` VALUES ('93', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：494毫秒', '0', '', '2021-11-04 18:04:01');
INSERT INTO `sys_job_log` VALUES ('94', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：487毫秒', '0', '', '2021-11-04 18:05:01');
INSERT INTO `sys_job_log` VALUES ('95', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：500毫秒', '0', '', '2021-11-04 18:06:01');
INSERT INTO `sys_job_log` VALUES ('96', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：483毫秒', '0', '', '2021-11-04 18:07:01');
INSERT INTO `sys_job_log` VALUES ('97', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：498毫秒', '0', '', '2021-11-04 18:08:01');
INSERT INTO `sys_job_log` VALUES ('98', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：525毫秒', '0', '', '2021-11-04 18:09:01');
INSERT INTO `sys_job_log` VALUES ('99', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 18:10:01');
INSERT INTO `sys_job_log` VALUES ('100', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：494毫秒', '0', '', '2021-11-04 18:11:01');
INSERT INTO `sys_job_log` VALUES ('101', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：568毫秒', '0', '', '2021-11-04 18:12:01');
INSERT INTO `sys_job_log` VALUES ('102', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：482毫秒', '0', '', '2021-11-04 18:13:01');
INSERT INTO `sys_job_log` VALUES ('103', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：608毫秒', '0', '', '2021-11-04 18:14:01');
INSERT INTO `sys_job_log` VALUES ('104', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：827毫秒', '0', '', '2021-11-04 18:15:01');
INSERT INTO `sys_job_log` VALUES ('105', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：647毫秒', '0', '', '2021-11-04 18:16:01');
INSERT INTO `sys_job_log` VALUES ('106', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：572毫秒', '0', '', '2021-11-04 18:17:01');
INSERT INTO `sys_job_log` VALUES ('107', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：563毫秒', '0', '', '2021-11-04 18:18:01');
INSERT INTO `sys_job_log` VALUES ('108', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：480毫秒', '0', '', '2021-11-04 18:19:01');
INSERT INTO `sys_job_log` VALUES ('109', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：483毫秒', '0', '', '2021-11-04 18:20:01');
INSERT INTO `sys_job_log` VALUES ('110', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 18:21:01');
INSERT INTO `sys_job_log` VALUES ('111', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：463毫秒', '0', '', '2021-11-04 18:22:01');
INSERT INTO `sys_job_log` VALUES ('112', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：462毫秒', '0', '', '2021-11-04 18:23:01');
INSERT INTO `sys_job_log` VALUES ('113', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：470毫秒', '0', '', '2021-11-04 18:24:01');
INSERT INTO `sys_job_log` VALUES ('114', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：470毫秒', '0', '', '2021-11-04 18:25:01');
INSERT INTO `sys_job_log` VALUES ('115', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：471毫秒', '0', '', '2021-11-04 18:26:01');
INSERT INTO `sys_job_log` VALUES ('116', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：636毫秒', '0', '', '2021-11-04 18:27:01');
INSERT INTO `sys_job_log` VALUES ('117', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1001毫秒', '0', '', '2021-11-04 18:28:01');
INSERT INTO `sys_job_log` VALUES ('118', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：506毫秒', '0', '', '2021-11-04 18:29:01');
INSERT INTO `sys_job_log` VALUES ('119', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：469毫秒', '0', '', '2021-11-04 18:30:01');
INSERT INTO `sys_job_log` VALUES ('120', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：493毫秒', '0', '', '2021-11-04 18:31:01');
INSERT INTO `sys_job_log` VALUES ('121', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：483毫秒', '0', '', '2021-11-04 18:32:01');
INSERT INTO `sys_job_log` VALUES ('122', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：922毫秒', '0', '', '2021-11-04 18:33:01');
INSERT INTO `sys_job_log` VALUES ('123', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：526毫秒', '0', '', '2021-11-04 18:34:01');
INSERT INTO `sys_job_log` VALUES ('124', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：516毫秒', '0', '', '2021-11-04 18:35:01');
INSERT INTO `sys_job_log` VALUES ('125', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：482毫秒', '0', '', '2021-11-04 18:36:01');
INSERT INTO `sys_job_log` VALUES ('126', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：617毫秒', '0', '', '2021-11-04 18:37:01');
INSERT INTO `sys_job_log` VALUES ('127', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：627毫秒', '0', '', '2021-11-04 18:38:01');
INSERT INTO `sys_job_log` VALUES ('128', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：547毫秒', '0', '', '2021-11-04 18:39:01');
INSERT INTO `sys_job_log` VALUES ('129', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：648毫秒', '0', '', '2021-11-04 18:40:01');
INSERT INTO `sys_job_log` VALUES ('130', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：494毫秒', '0', '', '2021-11-04 18:41:01');
INSERT INTO `sys_job_log` VALUES ('131', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：473毫秒', '0', '', '2021-11-04 18:42:01');
INSERT INTO `sys_job_log` VALUES ('132', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：659毫秒', '0', '', '2021-11-04 18:43:01');
INSERT INTO `sys_job_log` VALUES ('133', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：923毫秒', '0', '', '2021-11-04 18:44:01');
INSERT INTO `sys_job_log` VALUES ('134', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：481毫秒', '0', '', '2021-11-04 18:45:01');
INSERT INTO `sys_job_log` VALUES ('135', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 18:46:01');
INSERT INTO `sys_job_log` VALUES ('136', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 18:47:01');
INSERT INTO `sys_job_log` VALUES ('137', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：559毫秒', '0', '', '2021-11-04 18:48:01');
INSERT INTO `sys_job_log` VALUES ('138', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-04 18:49:01');
INSERT INTO `sys_job_log` VALUES ('139', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：483毫秒', '0', '', '2021-11-04 18:50:01');
INSERT INTO `sys_job_log` VALUES ('140', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：527毫秒', '0', '', '2021-11-04 18:51:01');
INSERT INTO `sys_job_log` VALUES ('141', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：527毫秒', '0', '', '2021-11-04 18:52:01');
INSERT INTO `sys_job_log` VALUES ('142', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：879毫秒', '0', '', '2021-11-04 18:53:01');
INSERT INTO `sys_job_log` VALUES ('143', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：480毫秒', '0', '', '2021-11-04 18:54:01');
INSERT INTO `sys_job_log` VALUES ('144', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：462毫秒', '0', '', '2021-11-04 18:55:01');
INSERT INTO `sys_job_log` VALUES ('145', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：470毫秒', '0', '', '2021-11-04 18:56:01');
INSERT INTO `sys_job_log` VALUES ('146', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：470毫秒', '0', '', '2021-11-04 18:57:01');
INSERT INTO `sys_job_log` VALUES ('147', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：459毫秒', '0', '', '2021-11-04 18:58:01');
INSERT INTO `sys_job_log` VALUES ('148', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：514毫秒', '0', '', '2021-11-04 18:59:01');
INSERT INTO `sys_job_log` VALUES ('149', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：495毫秒', '0', '', '2021-11-04 19:00:01');
INSERT INTO `sys_job_log` VALUES ('150', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：473毫秒', '0', '', '2021-11-04 19:01:01');
INSERT INTO `sys_job_log` VALUES ('151', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：481毫秒', '0', '', '2021-11-04 19:02:01');
INSERT INTO `sys_job_log` VALUES ('152', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：492毫秒', '0', '', '2021-11-04 19:03:01');
INSERT INTO `sys_job_log` VALUES ('153', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：491毫秒', '0', '', '2021-11-04 19:04:01');
INSERT INTO `sys_job_log` VALUES ('154', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：461毫秒', '0', '', '2021-11-04 19:05:01');
INSERT INTO `sys_job_log` VALUES ('155', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：571毫秒', '0', '', '2021-11-04 19:06:01');
INSERT INTO `sys_job_log` VALUES ('156', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：499毫秒', '0', '', '2021-11-04 19:07:01');
INSERT INTO `sys_job_log` VALUES ('157', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：667毫秒', '0', '', '2021-11-05 09:37:01');
INSERT INTO `sys_job_log` VALUES ('158', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：543毫秒', '0', '', '2021-11-05 09:38:01');
INSERT INTO `sys_job_log` VALUES ('159', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：489毫秒', '0', '', '2021-11-05 09:39:01');
INSERT INTO `sys_job_log` VALUES ('160', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-05 09:40:01');
INSERT INTO `sys_job_log` VALUES ('161', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：534毫秒', '0', '', '2021-11-05 09:41:01');
INSERT INTO `sys_job_log` VALUES ('162', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：655毫秒', '0', '', '2021-11-05 09:42:01');
INSERT INTO `sys_job_log` VALUES ('163', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：547毫秒', '0', '', '2021-11-05 09:43:01');
INSERT INTO `sys_job_log` VALUES ('164', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：752毫秒', '0', '', '2021-11-05 09:44:01');
INSERT INTO `sys_job_log` VALUES ('165', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：512毫秒', '0', '', '2021-11-05 09:45:01');
INSERT INTO `sys_job_log` VALUES ('166', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：523毫秒', '0', '', '2021-11-05 09:46:01');
INSERT INTO `sys_job_log` VALUES ('167', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：489毫秒', '0', '', '2021-11-05 09:47:01');
INSERT INTO `sys_job_log` VALUES ('168', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：578毫秒', '0', '', '2021-11-05 09:48:01');
INSERT INTO `sys_job_log` VALUES ('169', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-05 09:49:01');
INSERT INTO `sys_job_log` VALUES ('170', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：471毫秒', '0', '', '2021-11-05 09:50:01');
INSERT INTO `sys_job_log` VALUES ('171', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：560毫秒', '0', '', '2021-11-05 09:51:01');
INSERT INTO `sys_job_log` VALUES ('172', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：574毫秒', '0', '', '2021-11-05 09:52:01');
INSERT INTO `sys_job_log` VALUES ('173', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：472毫秒', '0', '', '2021-11-05 09:53:01');
INSERT INTO `sys_job_log` VALUES ('174', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：467毫秒', '0', '', '2021-11-05 09:54:01');
INSERT INTO `sys_job_log` VALUES ('175', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：504毫秒', '0', '', '2021-11-05 09:55:01');
INSERT INTO `sys_job_log` VALUES ('176', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：505毫秒', '0', '', '2021-11-05 09:56:01');
INSERT INTO `sys_job_log` VALUES ('177', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：454毫秒', '0', '', '2021-11-05 09:57:01');
INSERT INTO `sys_job_log` VALUES ('178', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：576毫秒', '0', '', '2021-11-05 09:58:01');
INSERT INTO `sys_job_log` VALUES ('179', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：560毫秒', '0', '', '2021-11-05 09:59:01');
INSERT INTO `sys_job_log` VALUES ('180', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：527毫秒', '0', '', '2021-11-05 10:00:01');
INSERT INTO `sys_job_log` VALUES ('181', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：619毫秒', '0', '', '2021-11-05 10:01:01');
INSERT INTO `sys_job_log` VALUES ('182', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：730毫秒', '0', '', '2021-11-05 10:02:01');
INSERT INTO `sys_job_log` VALUES ('183', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：516毫秒', '0', '', '2021-11-05 10:03:01');
INSERT INTO `sys_job_log` VALUES ('184', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：483毫秒', '0', '', '2021-11-05 10:04:01');
INSERT INTO `sys_job_log` VALUES ('185', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：527毫秒', '0', '', '2021-11-05 10:05:01');
INSERT INTO `sys_job_log` VALUES ('186', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：50785毫秒', '0', '', '2021-11-05 10:06:51');
INSERT INTO `sys_job_log` VALUES ('187', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：510毫秒', '0', '', '2021-11-05 10:07:01');
INSERT INTO `sys_job_log` VALUES ('188', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：63992毫秒', '0', '', '2021-11-05 10:09:04');
INSERT INTO `sys_job_log` VALUES ('189', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：922毫秒', '0', '', '2021-11-05 10:09:04');
INSERT INTO `sys_job_log` VALUES ('190', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：973毫秒', '0', '', '2021-11-05 10:10:01');
INSERT INTO `sys_job_log` VALUES ('191', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：97505毫秒', '0', '', '2021-11-05 10:12:38');
INSERT INTO `sys_job_log` VALUES ('192', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27758毫秒', '0', '', '2021-11-05 10:12:38');
INSERT INTO `sys_job_log` VALUES ('193', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1973毫秒', '0', '', '2021-11-05 10:13:02');
INSERT INTO `sys_job_log` VALUES ('194', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1874毫秒', '0', '', '2021-11-05 10:14:02');
INSERT INTO `sys_job_log` VALUES ('195', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：87333毫秒', '0', '', '2021-11-05 10:16:27');
INSERT INTO `sys_job_log` VALUES ('196', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：26067毫秒', '0', '', '2021-11-05 10:16:28');
INSERT INTO `sys_job_log` VALUES ('197', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3988毫秒', '0', '', '2021-11-05 10:17:04');
INSERT INTO `sys_job_log` VALUES ('198', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4839毫秒', '0', '', '2021-11-05 10:18:05');
INSERT INTO `sys_job_log` VALUES ('199', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3923毫秒', '0', '', '2021-11-05 10:19:04');
INSERT INTO `sys_job_log` VALUES ('200', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3947毫秒', '0', '', '2021-11-05 10:20:04');
INSERT INTO `sys_job_log` VALUES ('201', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4181毫秒', '0', '', '2021-11-05 10:21:04');
INSERT INTO `sys_job_log` VALUES ('202', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3746毫秒', '0', '', '2021-11-05 10:22:04');
INSERT INTO `sys_job_log` VALUES ('203', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4143毫秒', '0', '', '2021-11-05 10:23:04');
INSERT INTO `sys_job_log` VALUES ('204', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3814毫秒', '0', '', '2021-11-05 10:24:04');
INSERT INTO `sys_job_log` VALUES ('205', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：127040毫秒', '0', '', '2021-11-05 10:28:37');
INSERT INTO `sys_job_log` VALUES ('206', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：90409毫秒', '0', '', '2021-11-05 10:28:38');
INSERT INTO `sys_job_log` VALUES ('207', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：218730毫秒', '0', '', '2021-11-05 10:28:39');
INSERT INTO `sys_job_log` VALUES ('208', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：37322毫秒', '0', '', '2021-11-05 10:28:39');
INSERT INTO `sys_job_log` VALUES ('209', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16393毫秒', '0', '', '2021-11-05 10:30:17');
INSERT INTO `sys_job_log` VALUES ('210', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14683毫秒', '0', '', '2021-11-05 10:31:15');
INSERT INTO `sys_job_log` VALUES ('211', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3031毫秒', '0', '', '2021-11-05 10:37:03');
INSERT INTO `sys_job_log` VALUES ('212', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 10:38:00');
INSERT INTO `sys_job_log` VALUES ('213', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27773毫秒', '0', '', '2021-11-05 10:39:28');
INSERT INTO `sys_job_log` VALUES ('214', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5212毫秒', '0', '', '2021-11-05 10:40:05');
INSERT INTO `sys_job_log` VALUES ('215', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6476毫秒', '0', '', '2021-11-05 10:41:07');
INSERT INTO `sys_job_log` VALUES ('216', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：280毫秒', '0', '', '2021-11-05 10:42:00');
INSERT INTO `sys_job_log` VALUES ('217', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：281毫秒', '0', '', '2021-11-05 10:43:00');
INSERT INTO `sys_job_log` VALUES ('218', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22243毫秒', '0', '', '2021-11-05 10:44:22');
INSERT INTO `sys_job_log` VALUES ('219', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：528毫秒', '0', '', '2021-11-05 10:46:01');
INSERT INTO `sys_job_log` VALUES ('220', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 10:47:00');
INSERT INTO `sys_job_log` VALUES ('221', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 10:48:00');
INSERT INTO `sys_job_log` VALUES ('222', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 10:49:00');
INSERT INTO `sys_job_log` VALUES ('223', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 10:50:00');
INSERT INTO `sys_job_log` VALUES ('224', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 10:51:00');
INSERT INTO `sys_job_log` VALUES ('225', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 10:52:00');
INSERT INTO `sys_job_log` VALUES ('226', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 10:53:00');
INSERT INTO `sys_job_log` VALUES ('227', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-05 10:54:00');
INSERT INTO `sys_job_log` VALUES ('228', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 10:55:00');
INSERT INTO `sys_job_log` VALUES ('229', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-05 10:56:00');
INSERT INTO `sys_job_log` VALUES ('230', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 10:57:00');
INSERT INTO `sys_job_log` VALUES ('231', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 10:58:00');
INSERT INTO `sys_job_log` VALUES ('232', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 10:59:00');
INSERT INTO `sys_job_log` VALUES ('233', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:00:00');
INSERT INTO `sys_job_log` VALUES ('234', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:01:00');
INSERT INTO `sys_job_log` VALUES ('235', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 11:02:00');
INSERT INTO `sys_job_log` VALUES ('236', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:03:00');
INSERT INTO `sys_job_log` VALUES ('237', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:04:00');
INSERT INTO `sys_job_log` VALUES ('238', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:05:00');
INSERT INTO `sys_job_log` VALUES ('239', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:06:00');
INSERT INTO `sys_job_log` VALUES ('240', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:07:00');
INSERT INTO `sys_job_log` VALUES ('241', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 11:08:00');
INSERT INTO `sys_job_log` VALUES ('242', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:09:00');
INSERT INTO `sys_job_log` VALUES ('243', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-05 11:10:00');
INSERT INTO `sys_job_log` VALUES ('244', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:11:00');
INSERT INTO `sys_job_log` VALUES ('245', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-05 11:25:00');
INSERT INTO `sys_job_log` VALUES ('246', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:26:00');
INSERT INTO `sys_job_log` VALUES ('247', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:27:00');
INSERT INTO `sys_job_log` VALUES ('248', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:28:00');
INSERT INTO `sys_job_log` VALUES ('249', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:29:00');
INSERT INTO `sys_job_log` VALUES ('250', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 11:30:00');
INSERT INTO `sys_job_log` VALUES ('251', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:31:00');
INSERT INTO `sys_job_log` VALUES ('252', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 11:32:00');
INSERT INTO `sys_job_log` VALUES ('253', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 11:33:00');
INSERT INTO `sys_job_log` VALUES ('254', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:34:00');
INSERT INTO `sys_job_log` VALUES ('255', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:35:00');
INSERT INTO `sys_job_log` VALUES ('256', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:36:00');
INSERT INTO `sys_job_log` VALUES ('257', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 11:37:00');
INSERT INTO `sys_job_log` VALUES ('258', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:38:00');
INSERT INTO `sys_job_log` VALUES ('259', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-05 11:39:00');
INSERT INTO `sys_job_log` VALUES ('260', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:40:00');
INSERT INTO `sys_job_log` VALUES ('261', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 11:41:00');
INSERT INTO `sys_job_log` VALUES ('262', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:42:00');
INSERT INTO `sys_job_log` VALUES ('263', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:43:00');
INSERT INTO `sys_job_log` VALUES ('264', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:44:00');
INSERT INTO `sys_job_log` VALUES ('265', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 11:45:00');
INSERT INTO `sys_job_log` VALUES ('266', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:46:00');
INSERT INTO `sys_job_log` VALUES ('267', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:47:00');
INSERT INTO `sys_job_log` VALUES ('268', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:48:00');
INSERT INTO `sys_job_log` VALUES ('269', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:49:00');
INSERT INTO `sys_job_log` VALUES ('270', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 11:50:00');
INSERT INTO `sys_job_log` VALUES ('271', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:51:00');
INSERT INTO `sys_job_log` VALUES ('272', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:52:00');
INSERT INTO `sys_job_log` VALUES ('273', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 11:53:00');
INSERT INTO `sys_job_log` VALUES ('274', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:54:00');
INSERT INTO `sys_job_log` VALUES ('275', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:55:00');
INSERT INTO `sys_job_log` VALUES ('276', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:56:00');
INSERT INTO `sys_job_log` VALUES ('277', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:57:00');
INSERT INTO `sys_job_log` VALUES ('278', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 11:58:00');
INSERT INTO `sys_job_log` VALUES ('279', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 11:59:00');
INSERT INTO `sys_job_log` VALUES ('280', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:00:00');
INSERT INTO `sys_job_log` VALUES ('281', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:01:00');
INSERT INTO `sys_job_log` VALUES ('282', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:02:00');
INSERT INTO `sys_job_log` VALUES ('283', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:03:00');
INSERT INTO `sys_job_log` VALUES ('284', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:04:00');
INSERT INTO `sys_job_log` VALUES ('285', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 12:05:00');
INSERT INTO `sys_job_log` VALUES ('286', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:06:00');
INSERT INTO `sys_job_log` VALUES ('287', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 12:07:00');
INSERT INTO `sys_job_log` VALUES ('288', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:08:00');
INSERT INTO `sys_job_log` VALUES ('289', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:09:00');
INSERT INTO `sys_job_log` VALUES ('290', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:10:00');
INSERT INTO `sys_job_log` VALUES ('291', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:11:00');
INSERT INTO `sys_job_log` VALUES ('292', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:12:00');
INSERT INTO `sys_job_log` VALUES ('293', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:13:00');
INSERT INTO `sys_job_log` VALUES ('294', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:14:00');
INSERT INTO `sys_job_log` VALUES ('295', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 12:15:00');
INSERT INTO `sys_job_log` VALUES ('296', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:16:00');
INSERT INTO `sys_job_log` VALUES ('297', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:17:00');
INSERT INTO `sys_job_log` VALUES ('298', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 12:18:00');
INSERT INTO `sys_job_log` VALUES ('299', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:19:00');
INSERT INTO `sys_job_log` VALUES ('300', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:20:00');
INSERT INTO `sys_job_log` VALUES ('301', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:21:00');
INSERT INTO `sys_job_log` VALUES ('302', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:22:00');
INSERT INTO `sys_job_log` VALUES ('303', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:23:00');
INSERT INTO `sys_job_log` VALUES ('304', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:24:00');
INSERT INTO `sys_job_log` VALUES ('305', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:25:00');
INSERT INTO `sys_job_log` VALUES ('306', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:26:00');
INSERT INTO `sys_job_log` VALUES ('307', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:27:00');
INSERT INTO `sys_job_log` VALUES ('308', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:28:00');
INSERT INTO `sys_job_log` VALUES ('309', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:29:00');
INSERT INTO `sys_job_log` VALUES ('310', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:30:00');
INSERT INTO `sys_job_log` VALUES ('311', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:31:00');
INSERT INTO `sys_job_log` VALUES ('312', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 12:32:00');
INSERT INTO `sys_job_log` VALUES ('313', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 12:33:00');
INSERT INTO `sys_job_log` VALUES ('314', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 12:34:00');
INSERT INTO `sys_job_log` VALUES ('315', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:35:00');
INSERT INTO `sys_job_log` VALUES ('316', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:36:00');
INSERT INTO `sys_job_log` VALUES ('317', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:37:00');
INSERT INTO `sys_job_log` VALUES ('318', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:38:00');
INSERT INTO `sys_job_log` VALUES ('319', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 12:39:00');
INSERT INTO `sys_job_log` VALUES ('320', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:40:00');
INSERT INTO `sys_job_log` VALUES ('321', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:41:00');
INSERT INTO `sys_job_log` VALUES ('322', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 12:42:00');
INSERT INTO `sys_job_log` VALUES ('323', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:43:00');
INSERT INTO `sys_job_log` VALUES ('324', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 12:44:00');
INSERT INTO `sys_job_log` VALUES ('325', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 12:45:00');
INSERT INTO `sys_job_log` VALUES ('326', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:46:00');
INSERT INTO `sys_job_log` VALUES ('327', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:47:00');
INSERT INTO `sys_job_log` VALUES ('328', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:48:00');
INSERT INTO `sys_job_log` VALUES ('329', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:49:00');
INSERT INTO `sys_job_log` VALUES ('330', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 12:50:00');
INSERT INTO `sys_job_log` VALUES ('331', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 12:51:00');
INSERT INTO `sys_job_log` VALUES ('332', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:52:00');
INSERT INTO `sys_job_log` VALUES ('333', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:53:00');
INSERT INTO `sys_job_log` VALUES ('334', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:54:00');
INSERT INTO `sys_job_log` VALUES ('335', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:55:00');
INSERT INTO `sys_job_log` VALUES ('336', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 12:56:00');
INSERT INTO `sys_job_log` VALUES ('337', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:57:00');
INSERT INTO `sys_job_log` VALUES ('338', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 12:58:00');
INSERT INTO `sys_job_log` VALUES ('339', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 12:59:00');
INSERT INTO `sys_job_log` VALUES ('340', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:00:00');
INSERT INTO `sys_job_log` VALUES ('341', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:01:00');
INSERT INTO `sys_job_log` VALUES ('342', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:02:00');
INSERT INTO `sys_job_log` VALUES ('343', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:03:00');
INSERT INTO `sys_job_log` VALUES ('344', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:04:00');
INSERT INTO `sys_job_log` VALUES ('345', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-05 13:05:00');
INSERT INTO `sys_job_log` VALUES ('346', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:06:00');
INSERT INTO `sys_job_log` VALUES ('347', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:07:00');
INSERT INTO `sys_job_log` VALUES ('348', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:08:00');
INSERT INTO `sys_job_log` VALUES ('349', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:09:00');
INSERT INTO `sys_job_log` VALUES ('350', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:10:00');
INSERT INTO `sys_job_log` VALUES ('351', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:11:00');
INSERT INTO `sys_job_log` VALUES ('352', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 13:12:00');
INSERT INTO `sys_job_log` VALUES ('353', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:13:00');
INSERT INTO `sys_job_log` VALUES ('354', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:14:00');
INSERT INTO `sys_job_log` VALUES ('355', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:15:00');
INSERT INTO `sys_job_log` VALUES ('356', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:16:00');
INSERT INTO `sys_job_log` VALUES ('357', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:17:00');
INSERT INTO `sys_job_log` VALUES ('358', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:18:00');
INSERT INTO `sys_job_log` VALUES ('359', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 13:19:00');
INSERT INTO `sys_job_log` VALUES ('360', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:20:00');
INSERT INTO `sys_job_log` VALUES ('361', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:21:00');
INSERT INTO `sys_job_log` VALUES ('362', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:22:00');
INSERT INTO `sys_job_log` VALUES ('363', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:23:00');
INSERT INTO `sys_job_log` VALUES ('364', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:24:00');
INSERT INTO `sys_job_log` VALUES ('365', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:25:00');
INSERT INTO `sys_job_log` VALUES ('366', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:26:00');
INSERT INTO `sys_job_log` VALUES ('367', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:27:00');
INSERT INTO `sys_job_log` VALUES ('368', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 13:28:00');
INSERT INTO `sys_job_log` VALUES ('369', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:29:00');
INSERT INTO `sys_job_log` VALUES ('370', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:30:00');
INSERT INTO `sys_job_log` VALUES ('371', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:31:00');
INSERT INTO `sys_job_log` VALUES ('372', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:32:00');
INSERT INTO `sys_job_log` VALUES ('373', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 13:33:00');
INSERT INTO `sys_job_log` VALUES ('374', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:34:00');
INSERT INTO `sys_job_log` VALUES ('375', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:35:00');
INSERT INTO `sys_job_log` VALUES ('376', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:36:00');
INSERT INTO `sys_job_log` VALUES ('377', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:37:00');
INSERT INTO `sys_job_log` VALUES ('378', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:38:00');
INSERT INTO `sys_job_log` VALUES ('379', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:39:00');
INSERT INTO `sys_job_log` VALUES ('380', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:40:00');
INSERT INTO `sys_job_log` VALUES ('381', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:41:00');
INSERT INTO `sys_job_log` VALUES ('382', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:42:00');
INSERT INTO `sys_job_log` VALUES ('383', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:43:00');
INSERT INTO `sys_job_log` VALUES ('384', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:44:00');
INSERT INTO `sys_job_log` VALUES ('385', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:45:00');
INSERT INTO `sys_job_log` VALUES ('386', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:46:00');
INSERT INTO `sys_job_log` VALUES ('387', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:47:00');
INSERT INTO `sys_job_log` VALUES ('388', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:48:00');
INSERT INTO `sys_job_log` VALUES ('389', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:49:00');
INSERT INTO `sys_job_log` VALUES ('390', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:50:00');
INSERT INTO `sys_job_log` VALUES ('391', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:51:00');
INSERT INTO `sys_job_log` VALUES ('392', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:52:00');
INSERT INTO `sys_job_log` VALUES ('393', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:53:00');
INSERT INTO `sys_job_log` VALUES ('394', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 13:54:00');
INSERT INTO `sys_job_log` VALUES ('395', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 13:55:00');
INSERT INTO `sys_job_log` VALUES ('396', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 13:56:00');
INSERT INTO `sys_job_log` VALUES ('397', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 13:57:00');
INSERT INTO `sys_job_log` VALUES ('398', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 13:58:00');
INSERT INTO `sys_job_log` VALUES ('399', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 13:59:00');
INSERT INTO `sys_job_log` VALUES ('400', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:00:00');
INSERT INTO `sys_job_log` VALUES ('401', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 14:01:00');
INSERT INTO `sys_job_log` VALUES ('402', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:02:00');
INSERT INTO `sys_job_log` VALUES ('403', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:03:00');
INSERT INTO `sys_job_log` VALUES ('404', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:04:00');
INSERT INTO `sys_job_log` VALUES ('405', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:05:00');
INSERT INTO `sys_job_log` VALUES ('406', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:06:00');
INSERT INTO `sys_job_log` VALUES ('407', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:07:00');
INSERT INTO `sys_job_log` VALUES ('408', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:08:00');
INSERT INTO `sys_job_log` VALUES ('409', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 14:09:00');
INSERT INTO `sys_job_log` VALUES ('410', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:10:00');
INSERT INTO `sys_job_log` VALUES ('411', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:11:00');
INSERT INTO `sys_job_log` VALUES ('412', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 14:12:00');
INSERT INTO `sys_job_log` VALUES ('413', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:13:00');
INSERT INTO `sys_job_log` VALUES ('414', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 14:14:00');
INSERT INTO `sys_job_log` VALUES ('415', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:15:00');
INSERT INTO `sys_job_log` VALUES ('416', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:16:00');
INSERT INTO `sys_job_log` VALUES ('417', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:17:00');
INSERT INTO `sys_job_log` VALUES ('418', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:18:00');
INSERT INTO `sys_job_log` VALUES ('419', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:19:00');
INSERT INTO `sys_job_log` VALUES ('420', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-05 14:21:00');
INSERT INTO `sys_job_log` VALUES ('421', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:22:00');
INSERT INTO `sys_job_log` VALUES ('422', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 14:24:00');
INSERT INTO `sys_job_log` VALUES ('423', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 14:25:00');
INSERT INTO `sys_job_log` VALUES ('424', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:26:00');
INSERT INTO `sys_job_log` VALUES ('425', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:27:00');
INSERT INTO `sys_job_log` VALUES ('426', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-05 14:28:00');
INSERT INTO `sys_job_log` VALUES ('427', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:29:00');
INSERT INTO `sys_job_log` VALUES ('428', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 14:30:00');
INSERT INTO `sys_job_log` VALUES ('429', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-05 14:31:00');
INSERT INTO `sys_job_log` VALUES ('430', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:32:00');
INSERT INTO `sys_job_log` VALUES ('431', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:33:00');
INSERT INTO `sys_job_log` VALUES ('432', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:34:00');
INSERT INTO `sys_job_log` VALUES ('433', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:35:00');
INSERT INTO `sys_job_log` VALUES ('434', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 14:36:00');
INSERT INTO `sys_job_log` VALUES ('435', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-05 14:37:00');
INSERT INTO `sys_job_log` VALUES ('436', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:38:00');
INSERT INTO `sys_job_log` VALUES ('437', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:39:00');
INSERT INTO `sys_job_log` VALUES ('438', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:40:00');
INSERT INTO `sys_job_log` VALUES ('439', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 14:41:00');
INSERT INTO `sys_job_log` VALUES ('440', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 14:43:00');
INSERT INTO `sys_job_log` VALUES ('441', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 14:44:00');
INSERT INTO `sys_job_log` VALUES ('442', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-05 14:45:00');
INSERT INTO `sys_job_log` VALUES ('443', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:46:00');
INSERT INTO `sys_job_log` VALUES ('444', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 14:47:00');
INSERT INTO `sys_job_log` VALUES ('445', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 14:48:00');
INSERT INTO `sys_job_log` VALUES ('446', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：26毫秒', '0', '', '2021-11-05 14:49:07');
INSERT INTO `sys_job_log` VALUES ('447', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:50:00');
INSERT INTO `sys_job_log` VALUES ('448', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 14:51:00');
INSERT INTO `sys_job_log` VALUES ('449', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 14:52:00');
INSERT INTO `sys_job_log` VALUES ('450', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:53:00');
INSERT INTO `sys_job_log` VALUES ('451', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 14:54:00');
INSERT INTO `sys_job_log` VALUES ('452', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:55:00');
INSERT INTO `sys_job_log` VALUES ('453', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-05 14:56:00');
INSERT INTO `sys_job_log` VALUES ('454', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 14:57:00');
INSERT INTO `sys_job_log` VALUES ('455', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 14:58:00');
INSERT INTO `sys_job_log` VALUES ('456', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 14:59:00');
INSERT INTO `sys_job_log` VALUES ('457', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 15:00:00');
INSERT INTO `sys_job_log` VALUES ('458', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-05 16:00:08');
INSERT INTO `sys_job_log` VALUES ('459', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:01:00');
INSERT INTO `sys_job_log` VALUES ('460', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:02:00');
INSERT INTO `sys_job_log` VALUES ('461', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-05 16:03:00');
INSERT INTO `sys_job_log` VALUES ('462', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:04:00');
INSERT INTO `sys_job_log` VALUES ('463', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-05 16:05:00');
INSERT INTO `sys_job_log` VALUES ('464', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 16:06:00');
INSERT INTO `sys_job_log` VALUES ('465', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 16:07:00');
INSERT INTO `sys_job_log` VALUES ('466', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-05 16:08:00');
INSERT INTO `sys_job_log` VALUES ('467', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 16:09:00');
INSERT INTO `sys_job_log` VALUES ('468', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:10:00');
INSERT INTO `sys_job_log` VALUES ('469', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-05 16:11:00');
INSERT INTO `sys_job_log` VALUES ('470', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:12:00');
INSERT INTO `sys_job_log` VALUES ('471', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:13:00');
INSERT INTO `sys_job_log` VALUES ('472', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 16:14:00');
INSERT INTO `sys_job_log` VALUES ('473', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:15:00');
INSERT INTO `sys_job_log` VALUES ('474', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:16:00');
INSERT INTO `sys_job_log` VALUES ('475', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:17:00');
INSERT INTO `sys_job_log` VALUES ('476', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-05 16:18:00');
INSERT INTO `sys_job_log` VALUES ('477', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:19:00');
INSERT INTO `sys_job_log` VALUES ('478', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:20:00');
INSERT INTO `sys_job_log` VALUES ('479', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:21:00');
INSERT INTO `sys_job_log` VALUES ('480', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:22:00');
INSERT INTO `sys_job_log` VALUES ('481', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:23:00');
INSERT INTO `sys_job_log` VALUES ('482', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:24:00');
INSERT INTO `sys_job_log` VALUES ('483', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-05 16:25:00');
INSERT INTO `sys_job_log` VALUES ('484', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:26:00');
INSERT INTO `sys_job_log` VALUES ('485', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-05 16:27:00');
INSERT INTO `sys_job_log` VALUES ('486', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:28:00');
INSERT INTO `sys_job_log` VALUES ('487', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 16:29:00');
INSERT INTO `sys_job_log` VALUES ('488', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:30:00');
INSERT INTO `sys_job_log` VALUES ('489', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:31:00');
INSERT INTO `sys_job_log` VALUES ('490', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:32:00');
INSERT INTO `sys_job_log` VALUES ('491', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 16:33:00');
INSERT INTO `sys_job_log` VALUES ('492', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:34:00');
INSERT INTO `sys_job_log` VALUES ('493', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:35:00');
INSERT INTO `sys_job_log` VALUES ('494', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:36:00');
INSERT INTO `sys_job_log` VALUES ('495', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:37:00');
INSERT INTO `sys_job_log` VALUES ('496', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:38:00');
INSERT INTO `sys_job_log` VALUES ('497', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:39:00');
INSERT INTO `sys_job_log` VALUES ('498', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:40:00');
INSERT INTO `sys_job_log` VALUES ('499', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:41:00');
INSERT INTO `sys_job_log` VALUES ('500', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:42:00');
INSERT INTO `sys_job_log` VALUES ('501', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 16:43:00');
INSERT INTO `sys_job_log` VALUES ('502', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:44:00');
INSERT INTO `sys_job_log` VALUES ('503', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:45:00');
INSERT INTO `sys_job_log` VALUES ('504', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:46:00');
INSERT INTO `sys_job_log` VALUES ('505', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:47:00');
INSERT INTO `sys_job_log` VALUES ('506', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:48:00');
INSERT INTO `sys_job_log` VALUES ('507', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:49:00');
INSERT INTO `sys_job_log` VALUES ('508', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:50:00');
INSERT INTO `sys_job_log` VALUES ('509', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 16:51:00');
INSERT INTO `sys_job_log` VALUES ('510', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:52:00');
INSERT INTO `sys_job_log` VALUES ('511', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:53:00');
INSERT INTO `sys_job_log` VALUES ('512', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 16:54:00');
INSERT INTO `sys_job_log` VALUES ('513', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 16:55:00');
INSERT INTO `sys_job_log` VALUES ('514', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:56:00');
INSERT INTO `sys_job_log` VALUES ('515', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 16:57:00');
INSERT INTO `sys_job_log` VALUES ('516', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:58:00');
INSERT INTO `sys_job_log` VALUES ('517', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 16:59:00');
INSERT INTO `sys_job_log` VALUES ('518', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:00:00');
INSERT INTO `sys_job_log` VALUES ('519', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:01:00');
INSERT INTO `sys_job_log` VALUES ('520', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:02:00');
INSERT INTO `sys_job_log` VALUES ('521', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:03:00');
INSERT INTO `sys_job_log` VALUES ('522', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 17:04:00');
INSERT INTO `sys_job_log` VALUES ('523', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:05:00');
INSERT INTO `sys_job_log` VALUES ('524', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:06:00');
INSERT INTO `sys_job_log` VALUES ('525', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:07:00');
INSERT INTO `sys_job_log` VALUES ('526', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:08:00');
INSERT INTO `sys_job_log` VALUES ('527', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:09:00');
INSERT INTO `sys_job_log` VALUES ('528', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:10:00');
INSERT INTO `sys_job_log` VALUES ('529', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-05 17:11:00');
INSERT INTO `sys_job_log` VALUES ('530', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:12:00');
INSERT INTO `sys_job_log` VALUES ('531', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:13:00');
INSERT INTO `sys_job_log` VALUES ('532', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:14:00');
INSERT INTO `sys_job_log` VALUES ('533', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:15:00');
INSERT INTO `sys_job_log` VALUES ('534', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:16:00');
INSERT INTO `sys_job_log` VALUES ('535', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:17:00');
INSERT INTO `sys_job_log` VALUES ('536', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:18:00');
INSERT INTO `sys_job_log` VALUES ('537', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:19:00');
INSERT INTO `sys_job_log` VALUES ('538', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:20:00');
INSERT INTO `sys_job_log` VALUES ('539', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:21:00');
INSERT INTO `sys_job_log` VALUES ('540', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:22:00');
INSERT INTO `sys_job_log` VALUES ('541', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-05 17:23:00');
INSERT INTO `sys_job_log` VALUES ('542', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:24:00');
INSERT INTO `sys_job_log` VALUES ('543', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 17:25:00');
INSERT INTO `sys_job_log` VALUES ('544', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:26:00');
INSERT INTO `sys_job_log` VALUES ('545', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:27:00');
INSERT INTO `sys_job_log` VALUES ('546', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:28:00');
INSERT INTO `sys_job_log` VALUES ('547', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:29:00');
INSERT INTO `sys_job_log` VALUES ('548', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:30:00');
INSERT INTO `sys_job_log` VALUES ('549', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:31:00');
INSERT INTO `sys_job_log` VALUES ('550', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:32:00');
INSERT INTO `sys_job_log` VALUES ('551', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:33:00');
INSERT INTO `sys_job_log` VALUES ('552', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:34:00');
INSERT INTO `sys_job_log` VALUES ('553', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-05 17:35:00');
INSERT INTO `sys_job_log` VALUES ('554', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:36:00');
INSERT INTO `sys_job_log` VALUES ('555', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:37:00');
INSERT INTO `sys_job_log` VALUES ('556', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:38:00');
INSERT INTO `sys_job_log` VALUES ('557', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-05 17:42:00');
INSERT INTO `sys_job_log` VALUES ('558', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:43:00');
INSERT INTO `sys_job_log` VALUES ('559', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:44:00');
INSERT INTO `sys_job_log` VALUES ('560', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:45:00');
INSERT INTO `sys_job_log` VALUES ('561', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:46:00');
INSERT INTO `sys_job_log` VALUES ('562', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:47:00');
INSERT INTO `sys_job_log` VALUES ('563', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:48:00');
INSERT INTO `sys_job_log` VALUES ('564', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-05 17:49:00');
INSERT INTO `sys_job_log` VALUES ('565', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:50:00');
INSERT INTO `sys_job_log` VALUES ('566', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:51:00');
INSERT INTO `sys_job_log` VALUES ('567', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:52:00');
INSERT INTO `sys_job_log` VALUES ('568', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:53:00');
INSERT INTO `sys_job_log` VALUES ('569', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:54:00');
INSERT INTO `sys_job_log` VALUES ('570', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:55:00');
INSERT INTO `sys_job_log` VALUES ('571', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:56:00');
INSERT INTO `sys_job_log` VALUES ('572', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-05 17:57:00');
INSERT INTO `sys_job_log` VALUES ('573', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:58:00');
INSERT INTO `sys_job_log` VALUES ('574', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-05 17:59:00');
INSERT INTO `sys_job_log` VALUES ('575', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-05 18:01:00');
INSERT INTO `sys_job_log` VALUES ('576', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：54毫秒', '0', '', '2021-11-08 09:28:01');
INSERT INTO `sys_job_log` VALUES ('577', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:29:00');
INSERT INTO `sys_job_log` VALUES ('578', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 09:30:00');
INSERT INTO `sys_job_log` VALUES ('579', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-08 09:31:00');
INSERT INTO `sys_job_log` VALUES ('580', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 09:32:00');
INSERT INTO `sys_job_log` VALUES ('581', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 09:33:00');
INSERT INTO `sys_job_log` VALUES ('582', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:34:00');
INSERT INTO `sys_job_log` VALUES ('583', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:35:00');
INSERT INTO `sys_job_log` VALUES ('584', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:36:00');
INSERT INTO `sys_job_log` VALUES ('585', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:37:00');
INSERT INTO `sys_job_log` VALUES ('586', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 09:38:00');
INSERT INTO `sys_job_log` VALUES ('587', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:39:00');
INSERT INTO `sys_job_log` VALUES ('588', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-08 09:40:00');
INSERT INTO `sys_job_log` VALUES ('589', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:41:00');
INSERT INTO `sys_job_log` VALUES ('590', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 09:42:00');
INSERT INTO `sys_job_log` VALUES ('591', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:43:00');
INSERT INTO `sys_job_log` VALUES ('592', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:44:00');
INSERT INTO `sys_job_log` VALUES ('593', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 09:45:00');
INSERT INTO `sys_job_log` VALUES ('594', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:46:00');
INSERT INTO `sys_job_log` VALUES ('595', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-08 09:54:00');
INSERT INTO `sys_job_log` VALUES ('596', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-08 09:55:00');
INSERT INTO `sys_job_log` VALUES ('597', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 09:56:00');
INSERT INTO `sys_job_log` VALUES ('598', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 09:57:00');
INSERT INTO `sys_job_log` VALUES ('599', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 09:58:00');
INSERT INTO `sys_job_log` VALUES ('600', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 09:59:00');
INSERT INTO `sys_job_log` VALUES ('601', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-08 10:00:00');
INSERT INTO `sys_job_log` VALUES ('602', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 10:01:00');
INSERT INTO `sys_job_log` VALUES ('603', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:02:00');
INSERT INTO `sys_job_log` VALUES ('604', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:03:00');
INSERT INTO `sys_job_log` VALUES ('605', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:04:00');
INSERT INTO `sys_job_log` VALUES ('606', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:05:00');
INSERT INTO `sys_job_log` VALUES ('607', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:06:00');
INSERT INTO `sys_job_log` VALUES ('608', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:07:00');
INSERT INTO `sys_job_log` VALUES ('609', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:08:00');
INSERT INTO `sys_job_log` VALUES ('610', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:09:00');
INSERT INTO `sys_job_log` VALUES ('611', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:10:00');
INSERT INTO `sys_job_log` VALUES ('612', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:11:00');
INSERT INTO `sys_job_log` VALUES ('613', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:12:00');
INSERT INTO `sys_job_log` VALUES ('614', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:13:00');
INSERT INTO `sys_job_log` VALUES ('615', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:14:00');
INSERT INTO `sys_job_log` VALUES ('616', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:15:00');
INSERT INTO `sys_job_log` VALUES ('617', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:16:00');
INSERT INTO `sys_job_log` VALUES ('618', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:17:00');
INSERT INTO `sys_job_log` VALUES ('619', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:18:00');
INSERT INTO `sys_job_log` VALUES ('620', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:19:00');
INSERT INTO `sys_job_log` VALUES ('621', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:20:00');
INSERT INTO `sys_job_log` VALUES ('622', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:21:00');
INSERT INTO `sys_job_log` VALUES ('623', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 10:22:00');
INSERT INTO `sys_job_log` VALUES ('624', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:23:00');
INSERT INTO `sys_job_log` VALUES ('625', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:24:00');
INSERT INTO `sys_job_log` VALUES ('626', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:25:00');
INSERT INTO `sys_job_log` VALUES ('627', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:26:00');
INSERT INTO `sys_job_log` VALUES ('628', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:27:00');
INSERT INTO `sys_job_log` VALUES ('629', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:28:00');
INSERT INTO `sys_job_log` VALUES ('630', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:29:00');
INSERT INTO `sys_job_log` VALUES ('631', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:30:00');
INSERT INTO `sys_job_log` VALUES ('632', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:31:00');
INSERT INTO `sys_job_log` VALUES ('633', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:32:00');
INSERT INTO `sys_job_log` VALUES ('634', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:33:00');
INSERT INTO `sys_job_log` VALUES ('635', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:34:00');
INSERT INTO `sys_job_log` VALUES ('636', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:35:00');
INSERT INTO `sys_job_log` VALUES ('637', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:36:00');
INSERT INTO `sys_job_log` VALUES ('638', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:37:00');
INSERT INTO `sys_job_log` VALUES ('639', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:38:00');
INSERT INTO `sys_job_log` VALUES ('640', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1385毫秒', '0', '', '2021-11-08 10:39:01');
INSERT INTO `sys_job_log` VALUES ('641', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:40:00');
INSERT INTO `sys_job_log` VALUES ('642', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:41:00');
INSERT INTO `sys_job_log` VALUES ('643', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:42:00');
INSERT INTO `sys_job_log` VALUES ('644', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:43:00');
INSERT INTO `sys_job_log` VALUES ('645', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:44:00');
INSERT INTO `sys_job_log` VALUES ('646', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1417毫秒', '0', '', '2021-11-08 10:45:02');
INSERT INTO `sys_job_log` VALUES ('647', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1396毫秒', '0', '', '2021-11-08 10:46:01');
INSERT INTO `sys_job_log` VALUES ('648', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 10:47:00');
INSERT INTO `sys_job_log` VALUES ('649', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-08 10:48:00');
INSERT INTO `sys_job_log` VALUES ('650', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-08 10:49:03');
INSERT INTO `sys_job_log` VALUES ('651', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-08 10:50:00');
INSERT INTO `sys_job_log` VALUES ('652', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 10:51:00');
INSERT INTO `sys_job_log` VALUES ('653', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:52:00');
INSERT INTO `sys_job_log` VALUES ('654', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:53:00');
INSERT INTO `sys_job_log` VALUES ('655', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:54:00');
INSERT INTO `sys_job_log` VALUES ('656', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:55:00');
INSERT INTO `sys_job_log` VALUES ('657', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:56:00');
INSERT INTO `sys_job_log` VALUES ('658', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:57:00');
INSERT INTO `sys_job_log` VALUES ('659', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:58:00');
INSERT INTO `sys_job_log` VALUES ('660', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 10:59:00');
INSERT INTO `sys_job_log` VALUES ('661', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 11:00:00');
INSERT INTO `sys_job_log` VALUES ('662', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 11:02:00');
INSERT INTO `sys_job_log` VALUES ('663', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-08 11:03:00');
INSERT INTO `sys_job_log` VALUES ('664', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:04:00');
INSERT INTO `sys_job_log` VALUES ('665', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:05:00');
INSERT INTO `sys_job_log` VALUES ('666', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:06:00');
INSERT INTO `sys_job_log` VALUES ('667', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:07:00');
INSERT INTO `sys_job_log` VALUES ('668', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:08:00');
INSERT INTO `sys_job_log` VALUES ('669', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:09:00');
INSERT INTO `sys_job_log` VALUES ('670', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 11:11:00');
INSERT INTO `sys_job_log` VALUES ('671', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 11:12:00');
INSERT INTO `sys_job_log` VALUES ('672', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:13:00');
INSERT INTO `sys_job_log` VALUES ('673', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:14:00');
INSERT INTO `sys_job_log` VALUES ('674', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:15:00');
INSERT INTO `sys_job_log` VALUES ('675', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:16:00');
INSERT INTO `sys_job_log` VALUES ('676', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:17:00');
INSERT INTO `sys_job_log` VALUES ('677', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:18:00');
INSERT INTO `sys_job_log` VALUES ('678', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:19:00');
INSERT INTO `sys_job_log` VALUES ('679', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:20:00');
INSERT INTO `sys_job_log` VALUES ('680', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:21:00');
INSERT INTO `sys_job_log` VALUES ('681', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 11:22:00');
INSERT INTO `sys_job_log` VALUES ('682', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:23:00');
INSERT INTO `sys_job_log` VALUES ('683', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:24:00');
INSERT INTO `sys_job_log` VALUES ('684', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:25:00');
INSERT INTO `sys_job_log` VALUES ('685', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:26:00');
INSERT INTO `sys_job_log` VALUES ('686', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 11:27:00');
INSERT INTO `sys_job_log` VALUES ('687', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:28:00');
INSERT INTO `sys_job_log` VALUES ('688', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:29:00');
INSERT INTO `sys_job_log` VALUES ('689', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:30:00');
INSERT INTO `sys_job_log` VALUES ('690', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:31:00');
INSERT INTO `sys_job_log` VALUES ('691', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:32:00');
INSERT INTO `sys_job_log` VALUES ('692', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:33:00');
INSERT INTO `sys_job_log` VALUES ('693', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:34:00');
INSERT INTO `sys_job_log` VALUES ('694', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:35:00');
INSERT INTO `sys_job_log` VALUES ('695', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：816毫秒', '0', '', '2021-11-08 11:36:01');
INSERT INTO `sys_job_log` VALUES ('696', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:37:00');
INSERT INTO `sys_job_log` VALUES ('697', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:38:00');
INSERT INTO `sys_job_log` VALUES ('698', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:39:00');
INSERT INTO `sys_job_log` VALUES ('699', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-08 11:40:00');
INSERT INTO `sys_job_log` VALUES ('700', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:41:00');
INSERT INTO `sys_job_log` VALUES ('701', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:42:00');
INSERT INTO `sys_job_log` VALUES ('702', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:43:00');
INSERT INTO `sys_job_log` VALUES ('703', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 11:44:00');
INSERT INTO `sys_job_log` VALUES ('704', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 11:45:00');
INSERT INTO `sys_job_log` VALUES ('705', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 11:46:00');
INSERT INTO `sys_job_log` VALUES ('706', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:47:00');
INSERT INTO `sys_job_log` VALUES ('707', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:48:00');
INSERT INTO `sys_job_log` VALUES ('708', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:49:00');
INSERT INTO `sys_job_log` VALUES ('709', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:50:00');
INSERT INTO `sys_job_log` VALUES ('710', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:51:00');
INSERT INTO `sys_job_log` VALUES ('711', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 11:52:00');
INSERT INTO `sys_job_log` VALUES ('712', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:53:00');
INSERT INTO `sys_job_log` VALUES ('713', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:54:00');
INSERT INTO `sys_job_log` VALUES ('714', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:55:00');
INSERT INTO `sys_job_log` VALUES ('715', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 11:56:00');
INSERT INTO `sys_job_log` VALUES ('716', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 11:57:00');
INSERT INTO `sys_job_log` VALUES ('717', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 11:58:00');
INSERT INTO `sys_job_log` VALUES ('718', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 11:59:00');
INSERT INTO `sys_job_log` VALUES ('719', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:00:00');
INSERT INTO `sys_job_log` VALUES ('720', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 12:01:00');
INSERT INTO `sys_job_log` VALUES ('721', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:02:00');
INSERT INTO `sys_job_log` VALUES ('722', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:03:00');
INSERT INTO `sys_job_log` VALUES ('723', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:04:00');
INSERT INTO `sys_job_log` VALUES ('724', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 12:05:00');
INSERT INTO `sys_job_log` VALUES ('725', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:06:00');
INSERT INTO `sys_job_log` VALUES ('726', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:07:00');
INSERT INTO `sys_job_log` VALUES ('727', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 12:08:00');
INSERT INTO `sys_job_log` VALUES ('728', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 12:09:00');
INSERT INTO `sys_job_log` VALUES ('729', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:10:00');
INSERT INTO `sys_job_log` VALUES ('730', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:11:00');
INSERT INTO `sys_job_log` VALUES ('731', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:12:00');
INSERT INTO `sys_job_log` VALUES ('732', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:13:00');
INSERT INTO `sys_job_log` VALUES ('733', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:14:00');
INSERT INTO `sys_job_log` VALUES ('734', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 12:15:00');
INSERT INTO `sys_job_log` VALUES ('735', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:16:00');
INSERT INTO `sys_job_log` VALUES ('736', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:17:00');
INSERT INTO `sys_job_log` VALUES ('737', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:18:00');
INSERT INTO `sys_job_log` VALUES ('738', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 12:19:00');
INSERT INTO `sys_job_log` VALUES ('739', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:20:00');
INSERT INTO `sys_job_log` VALUES ('740', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 12:21:00');
INSERT INTO `sys_job_log` VALUES ('741', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 12:22:00');
INSERT INTO `sys_job_log` VALUES ('742', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-08 12:23:00');
INSERT INTO `sys_job_log` VALUES ('743', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:24:00');
INSERT INTO `sys_job_log` VALUES ('744', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:25:00');
INSERT INTO `sys_job_log` VALUES ('745', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:26:00');
INSERT INTO `sys_job_log` VALUES ('746', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 12:27:00');
INSERT INTO `sys_job_log` VALUES ('747', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:28:00');
INSERT INTO `sys_job_log` VALUES ('748', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:29:00');
INSERT INTO `sys_job_log` VALUES ('749', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:30:00');
INSERT INTO `sys_job_log` VALUES ('750', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 12:31:00');
INSERT INTO `sys_job_log` VALUES ('751', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:32:00');
INSERT INTO `sys_job_log` VALUES ('752', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:33:00');
INSERT INTO `sys_job_log` VALUES ('753', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:34:00');
INSERT INTO `sys_job_log` VALUES ('754', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 12:35:00');
INSERT INTO `sys_job_log` VALUES ('755', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 12:36:00');
INSERT INTO `sys_job_log` VALUES ('756', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:37:00');
INSERT INTO `sys_job_log` VALUES ('757', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:38:00');
INSERT INTO `sys_job_log` VALUES ('758', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:39:00');
INSERT INTO `sys_job_log` VALUES ('759', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 12:40:00');
INSERT INTO `sys_job_log` VALUES ('760', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:41:00');
INSERT INTO `sys_job_log` VALUES ('761', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:42:00');
INSERT INTO `sys_job_log` VALUES ('762', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:43:00');
INSERT INTO `sys_job_log` VALUES ('763', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:44:00');
INSERT INTO `sys_job_log` VALUES ('764', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:45:00');
INSERT INTO `sys_job_log` VALUES ('765', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:46:00');
INSERT INTO `sys_job_log` VALUES ('766', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:47:00');
INSERT INTO `sys_job_log` VALUES ('767', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:48:00');
INSERT INTO `sys_job_log` VALUES ('768', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:49:00');
INSERT INTO `sys_job_log` VALUES ('769', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:50:00');
INSERT INTO `sys_job_log` VALUES ('770', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:51:00');
INSERT INTO `sys_job_log` VALUES ('771', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:52:00');
INSERT INTO `sys_job_log` VALUES ('772', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:53:00');
INSERT INTO `sys_job_log` VALUES ('773', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 12:54:00');
INSERT INTO `sys_job_log` VALUES ('774', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:55:00');
INSERT INTO `sys_job_log` VALUES ('775', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:56:00');
INSERT INTO `sys_job_log` VALUES ('776', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 12:57:00');
INSERT INTO `sys_job_log` VALUES ('777', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:58:00');
INSERT INTO `sys_job_log` VALUES ('778', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 12:59:00');
INSERT INTO `sys_job_log` VALUES ('779', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:00:00');
INSERT INTO `sys_job_log` VALUES ('780', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:01:00');
INSERT INTO `sys_job_log` VALUES ('781', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:02:00');
INSERT INTO `sys_job_log` VALUES ('782', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-08 13:03:00');
INSERT INTO `sys_job_log` VALUES ('783', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:04:00');
INSERT INTO `sys_job_log` VALUES ('784', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:05:00');
INSERT INTO `sys_job_log` VALUES ('785', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 13:06:00');
INSERT INTO `sys_job_log` VALUES ('786', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 13:07:00');
INSERT INTO `sys_job_log` VALUES ('787', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 13:08:00');
INSERT INTO `sys_job_log` VALUES ('788', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:09:00');
INSERT INTO `sys_job_log` VALUES ('789', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:10:00');
INSERT INTO `sys_job_log` VALUES ('790', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:11:00');
INSERT INTO `sys_job_log` VALUES ('791', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:12:00');
INSERT INTO `sys_job_log` VALUES ('792', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:13:00');
INSERT INTO `sys_job_log` VALUES ('793', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:14:00');
INSERT INTO `sys_job_log` VALUES ('794', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:15:00');
INSERT INTO `sys_job_log` VALUES ('795', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:16:00');
INSERT INTO `sys_job_log` VALUES ('796', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 13:17:00');
INSERT INTO `sys_job_log` VALUES ('797', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:18:00');
INSERT INTO `sys_job_log` VALUES ('798', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:19:00');
INSERT INTO `sys_job_log` VALUES ('799', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:20:00');
INSERT INTO `sys_job_log` VALUES ('800', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:21:00');
INSERT INTO `sys_job_log` VALUES ('801', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:22:00');
INSERT INTO `sys_job_log` VALUES ('802', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:23:00');
INSERT INTO `sys_job_log` VALUES ('803', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 13:24:00');
INSERT INTO `sys_job_log` VALUES ('804', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 13:25:00');
INSERT INTO `sys_job_log` VALUES ('805', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:26:00');
INSERT INTO `sys_job_log` VALUES ('806', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:27:00');
INSERT INTO `sys_job_log` VALUES ('807', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:28:00');
INSERT INTO `sys_job_log` VALUES ('808', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:29:00');
INSERT INTO `sys_job_log` VALUES ('809', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:30:00');
INSERT INTO `sys_job_log` VALUES ('810', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:31:00');
INSERT INTO `sys_job_log` VALUES ('811', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 13:32:00');
INSERT INTO `sys_job_log` VALUES ('812', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:33:00');
INSERT INTO `sys_job_log` VALUES ('813', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:34:00');
INSERT INTO `sys_job_log` VALUES ('814', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:35:00');
INSERT INTO `sys_job_log` VALUES ('815', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 13:36:00');
INSERT INTO `sys_job_log` VALUES ('816', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:37:00');
INSERT INTO `sys_job_log` VALUES ('817', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:38:00');
INSERT INTO `sys_job_log` VALUES ('818', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:39:00');
INSERT INTO `sys_job_log` VALUES ('819', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:40:00');
INSERT INTO `sys_job_log` VALUES ('820', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 13:41:00');
INSERT INTO `sys_job_log` VALUES ('821', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:42:00');
INSERT INTO `sys_job_log` VALUES ('822', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:43:00');
INSERT INTO `sys_job_log` VALUES ('823', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 13:44:00');
INSERT INTO `sys_job_log` VALUES ('824', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:45:00');
INSERT INTO `sys_job_log` VALUES ('825', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:46:00');
INSERT INTO `sys_job_log` VALUES ('826', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:47:00');
INSERT INTO `sys_job_log` VALUES ('827', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:48:00');
INSERT INTO `sys_job_log` VALUES ('828', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:49:00');
INSERT INTO `sys_job_log` VALUES ('829', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 13:50:00');
INSERT INTO `sys_job_log` VALUES ('830', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:51:00');
INSERT INTO `sys_job_log` VALUES ('831', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:52:00');
INSERT INTO `sys_job_log` VALUES ('832', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:53:00');
INSERT INTO `sys_job_log` VALUES ('833', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 13:54:00');
INSERT INTO `sys_job_log` VALUES ('834', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:55:00');
INSERT INTO `sys_job_log` VALUES ('835', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:56:00');
INSERT INTO `sys_job_log` VALUES ('836', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:57:00');
INSERT INTO `sys_job_log` VALUES ('837', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 13:58:00');
INSERT INTO `sys_job_log` VALUES ('838', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 13:59:00');
INSERT INTO `sys_job_log` VALUES ('839', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:00:00');
INSERT INTO `sys_job_log` VALUES ('840', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:01:00');
INSERT INTO `sys_job_log` VALUES ('841', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:02:00');
INSERT INTO `sys_job_log` VALUES ('842', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:03:00');
INSERT INTO `sys_job_log` VALUES ('843', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:04:00');
INSERT INTO `sys_job_log` VALUES ('844', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:05:00');
INSERT INTO `sys_job_log` VALUES ('845', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:06:00');
INSERT INTO `sys_job_log` VALUES ('846', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:07:00');
INSERT INTO `sys_job_log` VALUES ('847', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:08:00');
INSERT INTO `sys_job_log` VALUES ('848', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:09:00');
INSERT INTO `sys_job_log` VALUES ('849', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:10:00');
INSERT INTO `sys_job_log` VALUES ('850', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:11:00');
INSERT INTO `sys_job_log` VALUES ('851', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:12:00');
INSERT INTO `sys_job_log` VALUES ('852', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:13:00');
INSERT INTO `sys_job_log` VALUES ('853', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 14:14:00');
INSERT INTO `sys_job_log` VALUES ('854', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 14:15:00');
INSERT INTO `sys_job_log` VALUES ('855', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:16:00');
INSERT INTO `sys_job_log` VALUES ('856', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:17:00');
INSERT INTO `sys_job_log` VALUES ('857', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:18:00');
INSERT INTO `sys_job_log` VALUES ('858', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:19:00');
INSERT INTO `sys_job_log` VALUES ('859', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:20:00');
INSERT INTO `sys_job_log` VALUES ('860', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:21:00');
INSERT INTO `sys_job_log` VALUES ('861', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:22:00');
INSERT INTO `sys_job_log` VALUES ('862', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:23:00');
INSERT INTO `sys_job_log` VALUES ('863', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:24:00');
INSERT INTO `sys_job_log` VALUES ('864', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 14:25:00');
INSERT INTO `sys_job_log` VALUES ('865', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:26:00');
INSERT INTO `sys_job_log` VALUES ('866', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 14:27:00');
INSERT INTO `sys_job_log` VALUES ('867', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-08 14:28:00');
INSERT INTO `sys_job_log` VALUES ('868', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:29:00');
INSERT INTO `sys_job_log` VALUES ('869', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 14:30:00');
INSERT INTO `sys_job_log` VALUES ('870', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:31:00');
INSERT INTO `sys_job_log` VALUES ('871', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:32:00');
INSERT INTO `sys_job_log` VALUES ('872', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:33:00');
INSERT INTO `sys_job_log` VALUES ('873', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 14:34:00');
INSERT INTO `sys_job_log` VALUES ('874', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:35:00');
INSERT INTO `sys_job_log` VALUES ('875', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:36:00');
INSERT INTO `sys_job_log` VALUES ('876', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：879毫秒', '0', '', '2021-11-08 14:37:01');
INSERT INTO `sys_job_log` VALUES ('877', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:38:00');
INSERT INTO `sys_job_log` VALUES ('878', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:39:00');
INSERT INTO `sys_job_log` VALUES ('879', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 14:40:00');
INSERT INTO `sys_job_log` VALUES ('880', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 14:41:00');
INSERT INTO `sys_job_log` VALUES ('881', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:42:00');
INSERT INTO `sys_job_log` VALUES ('882', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:43:00');
INSERT INTO `sys_job_log` VALUES ('883', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:44:00');
INSERT INTO `sys_job_log` VALUES ('884', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:45:00');
INSERT INTO `sys_job_log` VALUES ('885', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 14:46:00');
INSERT INTO `sys_job_log` VALUES ('886', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:47:00');
INSERT INTO `sys_job_log` VALUES ('887', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 14:48:00');
INSERT INTO `sys_job_log` VALUES ('888', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:49:00');
INSERT INTO `sys_job_log` VALUES ('889', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:50:00');
INSERT INTO `sys_job_log` VALUES ('890', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:51:00');
INSERT INTO `sys_job_log` VALUES ('891', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1393毫秒', '0', '', '2021-11-08 14:52:01');
INSERT INTO `sys_job_log` VALUES ('892', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:53:00');
INSERT INTO `sys_job_log` VALUES ('893', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 14:54:00');
INSERT INTO `sys_job_log` VALUES ('894', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:55:00');
INSERT INTO `sys_job_log` VALUES ('895', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-08 14:56:00');
INSERT INTO `sys_job_log` VALUES ('896', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 14:57:00');
INSERT INTO `sys_job_log` VALUES ('897', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-08 14:58:00');
INSERT INTO `sys_job_log` VALUES ('898', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 14:59:00');
INSERT INTO `sys_job_log` VALUES ('899', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 15:00:00');
INSERT INTO `sys_job_log` VALUES ('900', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:01:00');
INSERT INTO `sys_job_log` VALUES ('901', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:02:00');
INSERT INTO `sys_job_log` VALUES ('902', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:03:00');
INSERT INTO `sys_job_log` VALUES ('903', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:04:00');
INSERT INTO `sys_job_log` VALUES ('904', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:05:00');
INSERT INTO `sys_job_log` VALUES ('905', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:06:00');
INSERT INTO `sys_job_log` VALUES ('906', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-08 15:07:06');
INSERT INTO `sys_job_log` VALUES ('907', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:08:00');
INSERT INTO `sys_job_log` VALUES ('908', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-08 15:09:00');
INSERT INTO `sys_job_log` VALUES ('909', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 15:10:00');
INSERT INTO `sys_job_log` VALUES ('910', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1154毫秒', '0', '', '2021-11-08 15:11:01');
INSERT INTO `sys_job_log` VALUES ('911', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2991毫秒', '0', '', '2021-11-08 15:12:03');
INSERT INTO `sys_job_log` VALUES ('912', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2968毫秒', '0', '', '2021-11-08 15:13:03');
INSERT INTO `sys_job_log` VALUES ('913', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2946毫秒', '0', '', '2021-11-08 15:14:03');
INSERT INTO `sys_job_log` VALUES ('914', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2908毫秒', '0', '', '2021-11-08 15:15:03');
INSERT INTO `sys_job_log` VALUES ('915', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3042毫秒', '0', '', '2021-11-08 15:16:03');
INSERT INTO `sys_job_log` VALUES ('916', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:17:00');
INSERT INTO `sys_job_log` VALUES ('917', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:18:00');
INSERT INTO `sys_job_log` VALUES ('918', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:19:00');
INSERT INTO `sys_job_log` VALUES ('919', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:20:00');
INSERT INTO `sys_job_log` VALUES ('920', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：55毫秒', '0', '', '2021-11-08 15:21:00');
INSERT INTO `sys_job_log` VALUES ('921', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:22:00');
INSERT INTO `sys_job_log` VALUES ('922', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:23:00');
INSERT INTO `sys_job_log` VALUES ('923', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 15:24:00');
INSERT INTO `sys_job_log` VALUES ('924', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:25:00');
INSERT INTO `sys_job_log` VALUES ('925', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:26:00');
INSERT INTO `sys_job_log` VALUES ('926', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：818毫秒', '0', '', '2021-11-08 15:27:01');
INSERT INTO `sys_job_log` VALUES ('927', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 15:28:00');
INSERT INTO `sys_job_log` VALUES ('928', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19714毫秒', '0', '', '2021-11-08 15:29:20');
INSERT INTO `sys_job_log` VALUES ('929', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-08 15:30:00');
INSERT INTO `sys_job_log` VALUES ('930', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12115毫秒', '0', '', '2021-11-08 15:31:12');
INSERT INTO `sys_job_log` VALUES ('931', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:32:00');
INSERT INTO `sys_job_log` VALUES ('932', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:33:00');
INSERT INTO `sys_job_log` VALUES ('933', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 15:34:00');
INSERT INTO `sys_job_log` VALUES ('934', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:35:00');
INSERT INTO `sys_job_log` VALUES ('935', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-08 15:36:00');
INSERT INTO `sys_job_log` VALUES ('936', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:37:00');
INSERT INTO `sys_job_log` VALUES ('937', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2120毫秒', '0', '', '2021-11-08 15:38:02');
INSERT INTO `sys_job_log` VALUES ('938', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 15:39:00');
INSERT INTO `sys_job_log` VALUES ('939', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:40:00');
INSERT INTO `sys_job_log` VALUES ('940', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:41:00');
INSERT INTO `sys_job_log` VALUES ('941', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:42:00');
INSERT INTO `sys_job_log` VALUES ('942', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:43:00');
INSERT INTO `sys_job_log` VALUES ('943', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:44:00');
INSERT INTO `sys_job_log` VALUES ('944', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-08 15:46:00');
INSERT INTO `sys_job_log` VALUES ('945', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2205毫秒', '0', '', '2021-11-08 15:47:02');
INSERT INTO `sys_job_log` VALUES ('946', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:48:00');
INSERT INTO `sys_job_log` VALUES ('947', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 15:49:00');
INSERT INTO `sys_job_log` VALUES ('948', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:50:00');
INSERT INTO `sys_job_log` VALUES ('949', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:51:00');
INSERT INTO `sys_job_log` VALUES ('950', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-08 15:53:05');
INSERT INTO `sys_job_log` VALUES ('951', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2109毫秒', '0', '', '2021-11-08 15:54:02');
INSERT INTO `sys_job_log` VALUES ('952', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:55:00');
INSERT INTO `sys_job_log` VALUES ('953', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 15:56:00');
INSERT INTO `sys_job_log` VALUES ('954', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-08 15:57:00');
INSERT INTO `sys_job_log` VALUES ('955', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2615毫秒', '0', '', '2021-11-08 15:58:03');
INSERT INTO `sys_job_log` VALUES ('956', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 15:59:00');
INSERT INTO `sys_job_log` VALUES ('957', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-08 16:00:00');
INSERT INTO `sys_job_log` VALUES ('958', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 16:01:00');
INSERT INTO `sys_job_log` VALUES ('959', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:02:00');
INSERT INTO `sys_job_log` VALUES ('960', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:03:00');
INSERT INTO `sys_job_log` VALUES ('961', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:04:00');
INSERT INTO `sys_job_log` VALUES ('962', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：44988毫秒', '0', '', '2021-11-08 16:05:45');
INSERT INTO `sys_job_log` VALUES ('963', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:06:00');
INSERT INTO `sys_job_log` VALUES ('964', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:07:00');
INSERT INTO `sys_job_log` VALUES ('965', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2300毫秒', '0', '', '2021-11-08 16:08:02');
INSERT INTO `sys_job_log` VALUES ('966', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:09:00');
INSERT INTO `sys_job_log` VALUES ('967', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:10:00');
INSERT INTO `sys_job_log` VALUES ('968', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:11:00');
INSERT INTO `sys_job_log` VALUES ('969', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:12:00');
INSERT INTO `sys_job_log` VALUES ('970', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 16:13:00');
INSERT INTO `sys_job_log` VALUES ('971', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:14:00');
INSERT INTO `sys_job_log` VALUES ('972', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:15:00');
INSERT INTO `sys_job_log` VALUES ('973', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:16:00');
INSERT INTO `sys_job_log` VALUES ('974', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 16:17:00');
INSERT INTO `sys_job_log` VALUES ('975', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:18:00');
INSERT INTO `sys_job_log` VALUES ('976', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:19:00');
INSERT INTO `sys_job_log` VALUES ('977', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:20:00');
INSERT INTO `sys_job_log` VALUES ('978', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:21:00');
INSERT INTO `sys_job_log` VALUES ('979', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 16:22:00');
INSERT INTO `sys_job_log` VALUES ('980', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:23:00');
INSERT INTO `sys_job_log` VALUES ('981', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:24:00');
INSERT INTO `sys_job_log` VALUES ('982', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 16:25:00');
INSERT INTO `sys_job_log` VALUES ('983', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 16:26:00');
INSERT INTO `sys_job_log` VALUES ('984', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:27:00');
INSERT INTO `sys_job_log` VALUES ('985', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 16:28:00');
INSERT INTO `sys_job_log` VALUES ('986', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:29:00');
INSERT INTO `sys_job_log` VALUES ('987', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 16:30:00');
INSERT INTO `sys_job_log` VALUES ('988', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 16:31:00');
INSERT INTO `sys_job_log` VALUES ('989', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 16:32:00');
INSERT INTO `sys_job_log` VALUES ('990', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:33:00');
INSERT INTO `sys_job_log` VALUES ('991', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:34:00');
INSERT INTO `sys_job_log` VALUES ('992', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 16:35:00');
INSERT INTO `sys_job_log` VALUES ('993', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:36:00');
INSERT INTO `sys_job_log` VALUES ('994', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:37:00');
INSERT INTO `sys_job_log` VALUES ('995', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:38:00');
INSERT INTO `sys_job_log` VALUES ('996', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:39:00');
INSERT INTO `sys_job_log` VALUES ('997', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 16:40:00');
INSERT INTO `sys_job_log` VALUES ('998', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-08 16:41:00');
INSERT INTO `sys_job_log` VALUES ('999', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:42:00');
INSERT INTO `sys_job_log` VALUES ('1000', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:43:00');
INSERT INTO `sys_job_log` VALUES ('1001', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:44:00');
INSERT INTO `sys_job_log` VALUES ('1002', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 16:45:00');
INSERT INTO `sys_job_log` VALUES ('1003', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:46:00');
INSERT INTO `sys_job_log` VALUES ('1004', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 16:47:00');
INSERT INTO `sys_job_log` VALUES ('1005', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-08 16:48:00');
INSERT INTO `sys_job_log` VALUES ('1006', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:49:00');
INSERT INTO `sys_job_log` VALUES ('1007', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:50:00');
INSERT INTO `sys_job_log` VALUES ('1008', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-08 16:52:00');
INSERT INTO `sys_job_log` VALUES ('1009', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:53:00');
INSERT INTO `sys_job_log` VALUES ('1010', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-08 16:54:00');
INSERT INTO `sys_job_log` VALUES ('1011', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:55:00');
INSERT INTO `sys_job_log` VALUES ('1012', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:56:00');
INSERT INTO `sys_job_log` VALUES ('1013', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:57:00');
INSERT INTO `sys_job_log` VALUES ('1014', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 16:58:00');
INSERT INTO `sys_job_log` VALUES ('1015', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 16:59:00');
INSERT INTO `sys_job_log` VALUES ('1016', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:00:00');
INSERT INTO `sys_job_log` VALUES ('1017', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:01:00');
INSERT INTO `sys_job_log` VALUES ('1018', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:02:00');
INSERT INTO `sys_job_log` VALUES ('1019', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:03:00');
INSERT INTO `sys_job_log` VALUES ('1020', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:04:00');
INSERT INTO `sys_job_log` VALUES ('1021', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:05:00');
INSERT INTO `sys_job_log` VALUES ('1022', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:06:00');
INSERT INTO `sys_job_log` VALUES ('1023', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:07:00');
INSERT INTO `sys_job_log` VALUES ('1024', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:08:00');
INSERT INTO `sys_job_log` VALUES ('1025', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:09:00');
INSERT INTO `sys_job_log` VALUES ('1026', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:10:00');
INSERT INTO `sys_job_log` VALUES ('1027', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:11:00');
INSERT INTO `sys_job_log` VALUES ('1028', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:12:00');
INSERT INTO `sys_job_log` VALUES ('1029', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:13:00');
INSERT INTO `sys_job_log` VALUES ('1030', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:14:00');
INSERT INTO `sys_job_log` VALUES ('1031', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:15:00');
INSERT INTO `sys_job_log` VALUES ('1032', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-08 17:16:00');
INSERT INTO `sys_job_log` VALUES ('1033', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:17:00');
INSERT INTO `sys_job_log` VALUES ('1034', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:18:00');
INSERT INTO `sys_job_log` VALUES ('1035', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:19:00');
INSERT INTO `sys_job_log` VALUES ('1036', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:20:00');
INSERT INTO `sys_job_log` VALUES ('1037', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:21:00');
INSERT INTO `sys_job_log` VALUES ('1038', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:22:00');
INSERT INTO `sys_job_log` VALUES ('1039', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:23:00');
INSERT INTO `sys_job_log` VALUES ('1040', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:24:00');
INSERT INTO `sys_job_log` VALUES ('1041', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:25:00');
INSERT INTO `sys_job_log` VALUES ('1042', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:26:00');
INSERT INTO `sys_job_log` VALUES ('1043', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:27:00');
INSERT INTO `sys_job_log` VALUES ('1044', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:28:00');
INSERT INTO `sys_job_log` VALUES ('1045', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:29:00');
INSERT INTO `sys_job_log` VALUES ('1046', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:30:00');
INSERT INTO `sys_job_log` VALUES ('1047', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:31:00');
INSERT INTO `sys_job_log` VALUES ('1048', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:32:00');
INSERT INTO `sys_job_log` VALUES ('1049', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:33:00');
INSERT INTO `sys_job_log` VALUES ('1050', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:34:00');
INSERT INTO `sys_job_log` VALUES ('1051', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:35:00');
INSERT INTO `sys_job_log` VALUES ('1052', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:36:00');
INSERT INTO `sys_job_log` VALUES ('1053', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:37:00');
INSERT INTO `sys_job_log` VALUES ('1054', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 17:38:00');
INSERT INTO `sys_job_log` VALUES ('1055', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:39:00');
INSERT INTO `sys_job_log` VALUES ('1056', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:40:00');
INSERT INTO `sys_job_log` VALUES ('1057', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-08 17:41:00');
INSERT INTO `sys_job_log` VALUES ('1058', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:42:00');
INSERT INTO `sys_job_log` VALUES ('1059', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:43:00');
INSERT INTO `sys_job_log` VALUES ('1060', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:44:00');
INSERT INTO `sys_job_log` VALUES ('1061', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:45:00');
INSERT INTO `sys_job_log` VALUES ('1062', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:46:00');
INSERT INTO `sys_job_log` VALUES ('1063', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:47:00');
INSERT INTO `sys_job_log` VALUES ('1064', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:48:00');
INSERT INTO `sys_job_log` VALUES ('1065', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-08 17:49:00');
INSERT INTO `sys_job_log` VALUES ('1066', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 17:50:00');
INSERT INTO `sys_job_log` VALUES ('1067', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2714毫秒', '0', '', '2021-11-08 17:51:03');
INSERT INTO `sys_job_log` VALUES ('1068', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-08 17:53:00');
INSERT INTO `sys_job_log` VALUES ('1069', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 17:54:00');
INSERT INTO `sys_job_log` VALUES ('1070', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2306毫秒', '0', '', '2021-11-08 17:55:02');
INSERT INTO `sys_job_log` VALUES ('1071', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:56:00');
INSERT INTO `sys_job_log` VALUES ('1072', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-08 17:57:00');
INSERT INTO `sys_job_log` VALUES ('1073', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 17:58:00');
INSERT INTO `sys_job_log` VALUES ('1074', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 17:59:00');
INSERT INTO `sys_job_log` VALUES ('1075', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 18:00:00');
INSERT INTO `sys_job_log` VALUES ('1076', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 18:01:00');
INSERT INTO `sys_job_log` VALUES ('1077', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 18:02:00');
INSERT INTO `sys_job_log` VALUES ('1078', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 18:03:00');
INSERT INTO `sys_job_log` VALUES ('1079', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 18:04:00');
INSERT INTO `sys_job_log` VALUES ('1080', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 18:05:00');
INSERT INTO `sys_job_log` VALUES ('1081', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 18:06:00');
INSERT INTO `sys_job_log` VALUES ('1082', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-08 18:07:00');
INSERT INTO `sys_job_log` VALUES ('1083', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 18:08:00');
INSERT INTO `sys_job_log` VALUES ('1084', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 18:09:00');
INSERT INTO `sys_job_log` VALUES ('1085', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 18:10:00');
INSERT INTO `sys_job_log` VALUES ('1086', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 18:11:00');
INSERT INTO `sys_job_log` VALUES ('1087', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-08 18:12:00');
INSERT INTO `sys_job_log` VALUES ('1088', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 18:13:00');
INSERT INTO `sys_job_log` VALUES ('1089', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 18:14:00');
INSERT INTO `sys_job_log` VALUES ('1090', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 18:15:00');
INSERT INTO `sys_job_log` VALUES ('1091', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 18:16:00');
INSERT INTO `sys_job_log` VALUES ('1092', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 18:17:00');
INSERT INTO `sys_job_log` VALUES ('1093', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-08 18:18:00');
INSERT INTO `sys_job_log` VALUES ('1094', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 18:19:00');
INSERT INTO `sys_job_log` VALUES ('1095', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 18:20:00');
INSERT INTO `sys_job_log` VALUES ('1096', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-08 18:21:00');
INSERT INTO `sys_job_log` VALUES ('1097', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-08 18:22:00');
INSERT INTO `sys_job_log` VALUES ('1098', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-08 18:23:00');
INSERT INTO `sys_job_log` VALUES ('1099', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：51毫秒', '0', '', '2021-11-09 14:56:00');
INSERT INTO `sys_job_log` VALUES ('1100', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 14:57:00');
INSERT INTO `sys_job_log` VALUES ('1101', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 14:58:00');
INSERT INTO `sys_job_log` VALUES ('1102', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 14:59:00');
INSERT INTO `sys_job_log` VALUES ('1103', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:00:00');
INSERT INTO `sys_job_log` VALUES ('1104', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:01:00');
INSERT INTO `sys_job_log` VALUES ('1105', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:02:00');
INSERT INTO `sys_job_log` VALUES ('1106', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:03:00');
INSERT INTO `sys_job_log` VALUES ('1107', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:04:00');
INSERT INTO `sys_job_log` VALUES ('1108', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:05:00');
INSERT INTO `sys_job_log` VALUES ('1109', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:06:00');
INSERT INTO `sys_job_log` VALUES ('1110', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:07:00');
INSERT INTO `sys_job_log` VALUES ('1111', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:08:00');
INSERT INTO `sys_job_log` VALUES ('1112', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 15:09:00');
INSERT INTO `sys_job_log` VALUES ('1113', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:10:00');
INSERT INTO `sys_job_log` VALUES ('1114', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:11:00');
INSERT INTO `sys_job_log` VALUES ('1115', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 15:12:00');
INSERT INTO `sys_job_log` VALUES ('1116', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:13:00');
INSERT INTO `sys_job_log` VALUES ('1117', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 15:14:00');
INSERT INTO `sys_job_log` VALUES ('1118', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 15:15:00');
INSERT INTO `sys_job_log` VALUES ('1119', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:16:00');
INSERT INTO `sys_job_log` VALUES ('1120', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:17:00');
INSERT INTO `sys_job_log` VALUES ('1121', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:18:00');
INSERT INTO `sys_job_log` VALUES ('1122', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 15:19:00');
INSERT INTO `sys_job_log` VALUES ('1123', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 15:20:00');
INSERT INTO `sys_job_log` VALUES ('1124', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:21:00');
INSERT INTO `sys_job_log` VALUES ('1125', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:22:00');
INSERT INTO `sys_job_log` VALUES ('1126', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:23:00');
INSERT INTO `sys_job_log` VALUES ('1127', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:24:00');
INSERT INTO `sys_job_log` VALUES ('1128', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 15:25:00');
INSERT INTO `sys_job_log` VALUES ('1129', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 15:26:00');
INSERT INTO `sys_job_log` VALUES ('1130', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:27:00');
INSERT INTO `sys_job_log` VALUES ('1131', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:28:00');
INSERT INTO `sys_job_log` VALUES ('1132', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:29:00');
INSERT INTO `sys_job_log` VALUES ('1133', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 15:30:00');
INSERT INTO `sys_job_log` VALUES ('1134', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 15:31:00');
INSERT INTO `sys_job_log` VALUES ('1135', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:32:00');
INSERT INTO `sys_job_log` VALUES ('1136', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:33:00');
INSERT INTO `sys_job_log` VALUES ('1137', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:34:00');
INSERT INTO `sys_job_log` VALUES ('1138', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:35:00');
INSERT INTO `sys_job_log` VALUES ('1139', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 15:36:00');
INSERT INTO `sys_job_log` VALUES ('1140', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:37:00');
INSERT INTO `sys_job_log` VALUES ('1141', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:38:00');
INSERT INTO `sys_job_log` VALUES ('1142', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:39:00');
INSERT INTO `sys_job_log` VALUES ('1143', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:40:00');
INSERT INTO `sys_job_log` VALUES ('1144', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:41:00');
INSERT INTO `sys_job_log` VALUES ('1145', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:42:00');
INSERT INTO `sys_job_log` VALUES ('1146', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 15:43:00');
INSERT INTO `sys_job_log` VALUES ('1147', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:44:00');
INSERT INTO `sys_job_log` VALUES ('1148', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:45:00');
INSERT INTO `sys_job_log` VALUES ('1149', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:46:00');
INSERT INTO `sys_job_log` VALUES ('1150', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:47:00');
INSERT INTO `sys_job_log` VALUES ('1151', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:48:00');
INSERT INTO `sys_job_log` VALUES ('1152', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:49:00');
INSERT INTO `sys_job_log` VALUES ('1153', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-09 15:51:00');
INSERT INTO `sys_job_log` VALUES ('1154', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:52:00');
INSERT INTO `sys_job_log` VALUES ('1155', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:53:00');
INSERT INTO `sys_job_log` VALUES ('1156', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:54:00');
INSERT INTO `sys_job_log` VALUES ('1157', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:55:00');
INSERT INTO `sys_job_log` VALUES ('1158', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:56:00');
INSERT INTO `sys_job_log` VALUES ('1159', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:57:00');
INSERT INTO `sys_job_log` VALUES ('1160', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 15:58:00');
INSERT INTO `sys_job_log` VALUES ('1161', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 15:59:00');
INSERT INTO `sys_job_log` VALUES ('1162', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:00:00');
INSERT INTO `sys_job_log` VALUES ('1163', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:01:00');
INSERT INTO `sys_job_log` VALUES ('1164', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:02:00');
INSERT INTO `sys_job_log` VALUES ('1165', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 16:03:00');
INSERT INTO `sys_job_log` VALUES ('1166', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 16:04:00');
INSERT INTO `sys_job_log` VALUES ('1167', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:05:00');
INSERT INTO `sys_job_log` VALUES ('1168', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 16:06:00');
INSERT INTO `sys_job_log` VALUES ('1169', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:07:00');
INSERT INTO `sys_job_log` VALUES ('1170', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 16:08:00');
INSERT INTO `sys_job_log` VALUES ('1171', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-09 16:09:00');
INSERT INTO `sys_job_log` VALUES ('1172', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 16:10:00');
INSERT INTO `sys_job_log` VALUES ('1173', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-09 16:11:00');
INSERT INTO `sys_job_log` VALUES ('1174', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 16:12:00');
INSERT INTO `sys_job_log` VALUES ('1175', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 16:13:00');
INSERT INTO `sys_job_log` VALUES ('1176', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 16:14:00');
INSERT INTO `sys_job_log` VALUES ('1177', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:15:00');
INSERT INTO `sys_job_log` VALUES ('1178', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:16:00');
INSERT INTO `sys_job_log` VALUES ('1179', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 16:17:00');
INSERT INTO `sys_job_log` VALUES ('1180', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:18:00');
INSERT INTO `sys_job_log` VALUES ('1181', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:19:00');
INSERT INTO `sys_job_log` VALUES ('1182', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:20:00');
INSERT INTO `sys_job_log` VALUES ('1183', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:21:00');
INSERT INTO `sys_job_log` VALUES ('1184', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:22:00');
INSERT INTO `sys_job_log` VALUES ('1185', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:23:00');
INSERT INTO `sys_job_log` VALUES ('1186', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:24:00');
INSERT INTO `sys_job_log` VALUES ('1187', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:25:00');
INSERT INTO `sys_job_log` VALUES ('1188', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 16:26:00');
INSERT INTO `sys_job_log` VALUES ('1189', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:27:00');
INSERT INTO `sys_job_log` VALUES ('1190', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:28:00');
INSERT INTO `sys_job_log` VALUES ('1191', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:29:00');
INSERT INTO `sys_job_log` VALUES ('1192', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:30:00');
INSERT INTO `sys_job_log` VALUES ('1193', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 16:31:00');
INSERT INTO `sys_job_log` VALUES ('1194', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：30毫秒', '0', '', '2021-11-09 16:32:00');
INSERT INTO `sys_job_log` VALUES ('1195', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-09 16:33:00');
INSERT INTO `sys_job_log` VALUES ('1196', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:34:00');
INSERT INTO `sys_job_log` VALUES ('1197', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 16:35:00');
INSERT INTO `sys_job_log` VALUES ('1198', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:36:00');
INSERT INTO `sys_job_log` VALUES ('1199', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:37:00');
INSERT INTO `sys_job_log` VALUES ('1200', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:38:00');
INSERT INTO `sys_job_log` VALUES ('1201', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:39:00');
INSERT INTO `sys_job_log` VALUES ('1202', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:40:00');
INSERT INTO `sys_job_log` VALUES ('1203', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:41:00');
INSERT INTO `sys_job_log` VALUES ('1204', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:42:00');
INSERT INTO `sys_job_log` VALUES ('1205', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:43:00');
INSERT INTO `sys_job_log` VALUES ('1206', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:44:00');
INSERT INTO `sys_job_log` VALUES ('1207', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-09 16:45:00');
INSERT INTO `sys_job_log` VALUES ('1208', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:46:00');
INSERT INTO `sys_job_log` VALUES ('1209', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:47:00');
INSERT INTO `sys_job_log` VALUES ('1210', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:48:00');
INSERT INTO `sys_job_log` VALUES ('1211', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:49:00');
INSERT INTO `sys_job_log` VALUES ('1212', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:50:00');
INSERT INTO `sys_job_log` VALUES ('1213', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 16:51:00');
INSERT INTO `sys_job_log` VALUES ('1214', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:52:00');
INSERT INTO `sys_job_log` VALUES ('1215', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 16:53:00');
INSERT INTO `sys_job_log` VALUES ('1216', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 16:54:00');
INSERT INTO `sys_job_log` VALUES ('1217', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 16:55:00');
INSERT INTO `sys_job_log` VALUES ('1218', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 16:56:00');
INSERT INTO `sys_job_log` VALUES ('1219', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:57:00');
INSERT INTO `sys_job_log` VALUES ('1220', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 16:58:00');
INSERT INTO `sys_job_log` VALUES ('1221', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 16:59:00');
INSERT INTO `sys_job_log` VALUES ('1222', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:00:00');
INSERT INTO `sys_job_log` VALUES ('1223', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 17:01:00');
INSERT INTO `sys_job_log` VALUES ('1224', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:02:00');
INSERT INTO `sys_job_log` VALUES ('1225', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:03:00');
INSERT INTO `sys_job_log` VALUES ('1226', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:04:00');
INSERT INTO `sys_job_log` VALUES ('1227', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:05:00');
INSERT INTO `sys_job_log` VALUES ('1228', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:06:00');
INSERT INTO `sys_job_log` VALUES ('1229', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:07:00');
INSERT INTO `sys_job_log` VALUES ('1230', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-09 17:08:00');
INSERT INTO `sys_job_log` VALUES ('1231', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:09:00');
INSERT INTO `sys_job_log` VALUES ('1232', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:10:00');
INSERT INTO `sys_job_log` VALUES ('1233', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-09 17:11:09');
INSERT INTO `sys_job_log` VALUES ('1234', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:12:00');
INSERT INTO `sys_job_log` VALUES ('1235', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:13:00');
INSERT INTO `sys_job_log` VALUES ('1236', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 17:15:00');
INSERT INTO `sys_job_log` VALUES ('1237', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:16:00');
INSERT INTO `sys_job_log` VALUES ('1238', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:17:00');
INSERT INTO `sys_job_log` VALUES ('1239', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:18:00');
INSERT INTO `sys_job_log` VALUES ('1240', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:19:00');
INSERT INTO `sys_job_log` VALUES ('1241', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 17:20:00');
INSERT INTO `sys_job_log` VALUES ('1242', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:21:00');
INSERT INTO `sys_job_log` VALUES ('1243', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 17:22:00');
INSERT INTO `sys_job_log` VALUES ('1244', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:23:00');
INSERT INTO `sys_job_log` VALUES ('1245', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:24:00');
INSERT INTO `sys_job_log` VALUES ('1246', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:25:00');
INSERT INTO `sys_job_log` VALUES ('1247', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:26:00');
INSERT INTO `sys_job_log` VALUES ('1248', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:27:00');
INSERT INTO `sys_job_log` VALUES ('1249', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:28:00');
INSERT INTO `sys_job_log` VALUES ('1250', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:29:00');
INSERT INTO `sys_job_log` VALUES ('1251', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:30:00');
INSERT INTO `sys_job_log` VALUES ('1252', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:31:00');
INSERT INTO `sys_job_log` VALUES ('1253', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:32:00');
INSERT INTO `sys_job_log` VALUES ('1254', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:33:00');
INSERT INTO `sys_job_log` VALUES ('1255', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:34:00');
INSERT INTO `sys_job_log` VALUES ('1256', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:35:00');
INSERT INTO `sys_job_log` VALUES ('1257', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:36:00');
INSERT INTO `sys_job_log` VALUES ('1258', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:37:00');
INSERT INTO `sys_job_log` VALUES ('1259', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:38:00');
INSERT INTO `sys_job_log` VALUES ('1260', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:39:00');
INSERT INTO `sys_job_log` VALUES ('1261', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 17:40:00');
INSERT INTO `sys_job_log` VALUES ('1262', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:41:00');
INSERT INTO `sys_job_log` VALUES ('1263', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:42:00');
INSERT INTO `sys_job_log` VALUES ('1264', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:43:00');
INSERT INTO `sys_job_log` VALUES ('1265', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 17:44:00');
INSERT INTO `sys_job_log` VALUES ('1266', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:45:00');
INSERT INTO `sys_job_log` VALUES ('1267', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:46:00');
INSERT INTO `sys_job_log` VALUES ('1268', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 17:47:00');
INSERT INTO `sys_job_log` VALUES ('1269', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:48:00');
INSERT INTO `sys_job_log` VALUES ('1270', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:49:00');
INSERT INTO `sys_job_log` VALUES ('1271', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 17:50:00');
INSERT INTO `sys_job_log` VALUES ('1272', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:51:00');
INSERT INTO `sys_job_log` VALUES ('1273', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:52:00');
INSERT INTO `sys_job_log` VALUES ('1274', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 17:53:00');
INSERT INTO `sys_job_log` VALUES ('1275', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:54:00');
INSERT INTO `sys_job_log` VALUES ('1276', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 17:55:00');
INSERT INTO `sys_job_log` VALUES ('1277', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:56:00');
INSERT INTO `sys_job_log` VALUES ('1278', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 17:57:00');
INSERT INTO `sys_job_log` VALUES ('1279', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:58:00');
INSERT INTO `sys_job_log` VALUES ('1280', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 17:59:00');
INSERT INTO `sys_job_log` VALUES ('1281', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:00:00');
INSERT INTO `sys_job_log` VALUES ('1282', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 18:01:00');
INSERT INTO `sys_job_log` VALUES ('1283', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:02:00');
INSERT INTO `sys_job_log` VALUES ('1284', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:03:00');
INSERT INTO `sys_job_log` VALUES ('1285', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:04:00');
INSERT INTO `sys_job_log` VALUES ('1286', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 18:05:00');
INSERT INTO `sys_job_log` VALUES ('1287', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:06:00');
INSERT INTO `sys_job_log` VALUES ('1288', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:07:00');
INSERT INTO `sys_job_log` VALUES ('1289', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:08:00');
INSERT INTO `sys_job_log` VALUES ('1290', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 18:09:00');
INSERT INTO `sys_job_log` VALUES ('1291', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:10:00');
INSERT INTO `sys_job_log` VALUES ('1292', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 18:11:00');
INSERT INTO `sys_job_log` VALUES ('1293', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:12:00');
INSERT INTO `sys_job_log` VALUES ('1294', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:13:00');
INSERT INTO `sys_job_log` VALUES ('1295', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:14:00');
INSERT INTO `sys_job_log` VALUES ('1296', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 18:15:00');
INSERT INTO `sys_job_log` VALUES ('1297', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 18:16:00');
INSERT INTO `sys_job_log` VALUES ('1298', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 18:17:00');
INSERT INTO `sys_job_log` VALUES ('1299', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 18:18:00');
INSERT INTO `sys_job_log` VALUES ('1300', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:19:00');
INSERT INTO `sys_job_log` VALUES ('1301', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:20:00');
INSERT INTO `sys_job_log` VALUES ('1302', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:21:00');
INSERT INTO `sys_job_log` VALUES ('1303', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 18:22:00');
INSERT INTO `sys_job_log` VALUES ('1304', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:23:00');
INSERT INTO `sys_job_log` VALUES ('1305', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:24:00');
INSERT INTO `sys_job_log` VALUES ('1306', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:25:00');
INSERT INTO `sys_job_log` VALUES ('1307', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:26:00');
INSERT INTO `sys_job_log` VALUES ('1308', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 18:27:00');
INSERT INTO `sys_job_log` VALUES ('1309', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 18:28:00');
INSERT INTO `sys_job_log` VALUES ('1310', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:29:00');
INSERT INTO `sys_job_log` VALUES ('1311', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 18:30:00');
INSERT INTO `sys_job_log` VALUES ('1312', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 18:31:00');
INSERT INTO `sys_job_log` VALUES ('1313', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:32:00');
INSERT INTO `sys_job_log` VALUES ('1314', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 18:33:00');
INSERT INTO `sys_job_log` VALUES ('1315', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:34:00');
INSERT INTO `sys_job_log` VALUES ('1316', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:35:00');
INSERT INTO `sys_job_log` VALUES ('1317', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 18:36:00');
INSERT INTO `sys_job_log` VALUES ('1318', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 18:37:00');
INSERT INTO `sys_job_log` VALUES ('1319', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 18:38:00');
INSERT INTO `sys_job_log` VALUES ('1320', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 18:39:00');
INSERT INTO `sys_job_log` VALUES ('1321', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：36毫秒', '0', '', '2021-11-09 18:45:00');
INSERT INTO `sys_job_log` VALUES ('1322', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-09 18:46:00');
INSERT INTO `sys_job_log` VALUES ('1323', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 18:47:00');
INSERT INTO `sys_job_log` VALUES ('1324', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 18:48:00');
INSERT INTO `sys_job_log` VALUES ('1325', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 18:49:00');
INSERT INTO `sys_job_log` VALUES ('1326', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 18:50:00');
INSERT INTO `sys_job_log` VALUES ('1327', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 18:51:00');
INSERT INTO `sys_job_log` VALUES ('1328', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 18:52:00');
INSERT INTO `sys_job_log` VALUES ('1329', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 18:53:00');
INSERT INTO `sys_job_log` VALUES ('1330', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 18:54:00');
INSERT INTO `sys_job_log` VALUES ('1331', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 18:55:00');
INSERT INTO `sys_job_log` VALUES ('1332', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 18:56:00');
INSERT INTO `sys_job_log` VALUES ('1333', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 18:57:00');
INSERT INTO `sys_job_log` VALUES ('1334', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-09 18:58:00');
INSERT INTO `sys_job_log` VALUES ('1335', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 18:59:00');
INSERT INTO `sys_job_log` VALUES ('1336', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 19:00:00');
INSERT INTO `sys_job_log` VALUES ('1337', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-09 19:01:00');
INSERT INTO `sys_job_log` VALUES ('1338', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 19:02:00');
INSERT INTO `sys_job_log` VALUES ('1339', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 19:03:00');
INSERT INTO `sys_job_log` VALUES ('1340', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-09 19:04:00');
INSERT INTO `sys_job_log` VALUES ('1341', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 19:05:00');
INSERT INTO `sys_job_log` VALUES ('1342', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 19:06:00');
INSERT INTO `sys_job_log` VALUES ('1343', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 19:07:00');
INSERT INTO `sys_job_log` VALUES ('1344', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-09 19:08:00');
INSERT INTO `sys_job_log` VALUES ('1345', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:09:00');
INSERT INTO `sys_job_log` VALUES ('1346', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 19:10:00');
INSERT INTO `sys_job_log` VALUES ('1347', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-09 19:11:00');
INSERT INTO `sys_job_log` VALUES ('1348', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-09 19:12:00');
INSERT INTO `sys_job_log` VALUES ('1349', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:13:00');
INSERT INTO `sys_job_log` VALUES ('1350', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 19:14:00');
INSERT INTO `sys_job_log` VALUES ('1351', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 19:15:00');
INSERT INTO `sys_job_log` VALUES ('1352', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:16:00');
INSERT INTO `sys_job_log` VALUES ('1353', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 19:17:00');
INSERT INTO `sys_job_log` VALUES ('1354', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 19:18:00');
INSERT INTO `sys_job_log` VALUES ('1355', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:19:00');
INSERT INTO `sys_job_log` VALUES ('1356', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:20:00');
INSERT INTO `sys_job_log` VALUES ('1357', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-09 19:21:00');
INSERT INTO `sys_job_log` VALUES ('1358', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-09 19:22:00');
INSERT INTO `sys_job_log` VALUES ('1359', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 19:23:00');
INSERT INTO `sys_job_log` VALUES ('1360', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:24:00');
INSERT INTO `sys_job_log` VALUES ('1361', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 19:25:00');
INSERT INTO `sys_job_log` VALUES ('1362', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 19:26:00');
INSERT INTO `sys_job_log` VALUES ('1363', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-09 19:27:00');
INSERT INTO `sys_job_log` VALUES ('1364', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 19:28:00');
INSERT INTO `sys_job_log` VALUES ('1365', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:29:00');
INSERT INTO `sys_job_log` VALUES ('1366', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:30:00');
INSERT INTO `sys_job_log` VALUES ('1367', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 19:31:00');
INSERT INTO `sys_job_log` VALUES ('1368', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:32:00');
INSERT INTO `sys_job_log` VALUES ('1369', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:33:00');
INSERT INTO `sys_job_log` VALUES ('1370', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 19:34:00');
INSERT INTO `sys_job_log` VALUES ('1371', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 19:35:00');
INSERT INTO `sys_job_log` VALUES ('1372', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-09 19:36:00');
INSERT INTO `sys_job_log` VALUES ('1373', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:37:00');
INSERT INTO `sys_job_log` VALUES ('1374', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:38:00');
INSERT INTO `sys_job_log` VALUES ('1375', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 19:39:00');
INSERT INTO `sys_job_log` VALUES ('1376', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 19:40:00');
INSERT INTO `sys_job_log` VALUES ('1377', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 19:41:00');
INSERT INTO `sys_job_log` VALUES ('1378', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-09 19:42:00');
INSERT INTO `sys_job_log` VALUES ('1379', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-09 19:43:00');
INSERT INTO `sys_job_log` VALUES ('1380', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-09 19:44:00');
INSERT INTO `sys_job_log` VALUES ('1381', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 19:45:00');
INSERT INTO `sys_job_log` VALUES ('1382', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 19:46:00');
INSERT INTO `sys_job_log` VALUES ('1383', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 19:47:00');
INSERT INTO `sys_job_log` VALUES ('1384', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 19:48:00');
INSERT INTO `sys_job_log` VALUES ('1385', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 19:49:00');
INSERT INTO `sys_job_log` VALUES ('1386', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 19:50:00');
INSERT INTO `sys_job_log` VALUES ('1387', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:51:00');
INSERT INTO `sys_job_log` VALUES ('1388', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 19:52:00');
INSERT INTO `sys_job_log` VALUES ('1389', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:53:00');
INSERT INTO `sys_job_log` VALUES ('1390', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 19:54:00');
INSERT INTO `sys_job_log` VALUES ('1391', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 19:55:00');
INSERT INTO `sys_job_log` VALUES ('1392', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 19:56:00');
INSERT INTO `sys_job_log` VALUES ('1393', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 19:57:00');
INSERT INTO `sys_job_log` VALUES ('1394', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 19:58:00');
INSERT INTO `sys_job_log` VALUES ('1395', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 19:59:00');
INSERT INTO `sys_job_log` VALUES ('1396', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:00:00');
INSERT INTO `sys_job_log` VALUES ('1397', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 20:01:00');
INSERT INTO `sys_job_log` VALUES ('1398', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:02:00');
INSERT INTO `sys_job_log` VALUES ('1399', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 20:03:00');
INSERT INTO `sys_job_log` VALUES ('1400', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:04:00');
INSERT INTO `sys_job_log` VALUES ('1401', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:05:00');
INSERT INTO `sys_job_log` VALUES ('1402', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 20:06:00');
INSERT INTO `sys_job_log` VALUES ('1403', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-09 20:07:00');
INSERT INTO `sys_job_log` VALUES ('1404', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:08:00');
INSERT INTO `sys_job_log` VALUES ('1405', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 20:09:00');
INSERT INTO `sys_job_log` VALUES ('1406', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-09 20:10:00');
INSERT INTO `sys_job_log` VALUES ('1407', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 20:11:00');
INSERT INTO `sys_job_log` VALUES ('1408', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 20:12:00');
INSERT INTO `sys_job_log` VALUES ('1409', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 20:13:00');
INSERT INTO `sys_job_log` VALUES ('1410', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-09 20:14:00');
INSERT INTO `sys_job_log` VALUES ('1411', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 20:15:00');
INSERT INTO `sys_job_log` VALUES ('1412', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-09 20:16:00');
INSERT INTO `sys_job_log` VALUES ('1413', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 20:17:00');
INSERT INTO `sys_job_log` VALUES ('1414', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 20:18:00');
INSERT INTO `sys_job_log` VALUES ('1415', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 20:19:00');
INSERT INTO `sys_job_log` VALUES ('1416', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 20:20:00');
INSERT INTO `sys_job_log` VALUES ('1417', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 20:21:00');
INSERT INTO `sys_job_log` VALUES ('1418', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：39毫秒', '0', '', '2021-11-09 20:22:00');
INSERT INTO `sys_job_log` VALUES ('1419', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 20:23:00');
INSERT INTO `sys_job_log` VALUES ('1420', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 20:24:00');
INSERT INTO `sys_job_log` VALUES ('1421', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 20:25:00');
INSERT INTO `sys_job_log` VALUES ('1422', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-09 20:26:00');
INSERT INTO `sys_job_log` VALUES ('1423', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:27:00');
INSERT INTO `sys_job_log` VALUES ('1424', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 20:28:00');
INSERT INTO `sys_job_log` VALUES ('1425', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 20:29:00');
INSERT INTO `sys_job_log` VALUES ('1426', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-09 20:30:00');
INSERT INTO `sys_job_log` VALUES ('1427', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 20:31:00');
INSERT INTO `sys_job_log` VALUES ('1428', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-09 20:32:00');
INSERT INTO `sys_job_log` VALUES ('1429', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:33:00');
INSERT INTO `sys_job_log` VALUES ('1430', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 20:34:00');
INSERT INTO `sys_job_log` VALUES ('1431', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 20:35:00');
INSERT INTO `sys_job_log` VALUES ('1432', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:36:00');
INSERT INTO `sys_job_log` VALUES ('1433', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 20:37:00');
INSERT INTO `sys_job_log` VALUES ('1434', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:38:00');
INSERT INTO `sys_job_log` VALUES ('1435', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 20:39:00');
INSERT INTO `sys_job_log` VALUES ('1436', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 20:40:00');
INSERT INTO `sys_job_log` VALUES ('1437', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:41:00');
INSERT INTO `sys_job_log` VALUES ('1438', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:42:00');
INSERT INTO `sys_job_log` VALUES ('1439', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 20:43:00');
INSERT INTO `sys_job_log` VALUES ('1440', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 20:44:00');
INSERT INTO `sys_job_log` VALUES ('1441', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 20:45:00');
INSERT INTO `sys_job_log` VALUES ('1442', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 20:46:00');
INSERT INTO `sys_job_log` VALUES ('1443', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 20:47:00');
INSERT INTO `sys_job_log` VALUES ('1444', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 20:48:00');
INSERT INTO `sys_job_log` VALUES ('1445', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 20:49:00');
INSERT INTO `sys_job_log` VALUES ('1446', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 20:50:00');
INSERT INTO `sys_job_log` VALUES ('1447', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 20:51:00');
INSERT INTO `sys_job_log` VALUES ('1448', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 20:52:00');
INSERT INTO `sys_job_log` VALUES ('1449', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 20:53:00');
INSERT INTO `sys_job_log` VALUES ('1450', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-09 20:54:00');
INSERT INTO `sys_job_log` VALUES ('1451', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 20:55:00');
INSERT INTO `sys_job_log` VALUES ('1452', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-09 20:56:00');
INSERT INTO `sys_job_log` VALUES ('1453', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 20:57:00');
INSERT INTO `sys_job_log` VALUES ('1454', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 20:58:00');
INSERT INTO `sys_job_log` VALUES ('1455', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 20:59:00');
INSERT INTO `sys_job_log` VALUES ('1456', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:00:00');
INSERT INTO `sys_job_log` VALUES ('1457', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:01:00');
INSERT INTO `sys_job_log` VALUES ('1458', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-09 21:02:00');
INSERT INTO `sys_job_log` VALUES ('1459', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 21:03:00');
INSERT INTO `sys_job_log` VALUES ('1460', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 21:04:00');
INSERT INTO `sys_job_log` VALUES ('1461', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:05:00');
INSERT INTO `sys_job_log` VALUES ('1462', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 21:06:00');
INSERT INTO `sys_job_log` VALUES ('1463', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-09 21:07:00');
INSERT INTO `sys_job_log` VALUES ('1464', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 21:08:00');
INSERT INTO `sys_job_log` VALUES ('1465', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:09:00');
INSERT INTO `sys_job_log` VALUES ('1466', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:10:00');
INSERT INTO `sys_job_log` VALUES ('1467', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:11:00');
INSERT INTO `sys_job_log` VALUES ('1468', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-09 21:12:00');
INSERT INTO `sys_job_log` VALUES ('1469', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 21:13:00');
INSERT INTO `sys_job_log` VALUES ('1470', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:14:00');
INSERT INTO `sys_job_log` VALUES ('1471', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 21:15:00');
INSERT INTO `sys_job_log` VALUES ('1472', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:16:00');
INSERT INTO `sys_job_log` VALUES ('1473', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-09 21:17:00');
INSERT INTO `sys_job_log` VALUES ('1474', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:18:00');
INSERT INTO `sys_job_log` VALUES ('1475', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 21:19:00');
INSERT INTO `sys_job_log` VALUES ('1476', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:20:00');
INSERT INTO `sys_job_log` VALUES ('1477', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 21:21:00');
INSERT INTO `sys_job_log` VALUES ('1478', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:22:00');
INSERT INTO `sys_job_log` VALUES ('1479', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 21:23:00');
INSERT INTO `sys_job_log` VALUES ('1480', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-09 21:24:00');
INSERT INTO `sys_job_log` VALUES ('1481', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：55毫秒', '0', '', '2021-11-09 21:28:00');
INSERT INTO `sys_job_log` VALUES ('1482', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-09 21:29:00');
INSERT INTO `sys_job_log` VALUES ('1483', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：81毫秒', '0', '', '2021-11-09 21:30:00');
INSERT INTO `sys_job_log` VALUES ('1484', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:31:00');
INSERT INTO `sys_job_log` VALUES ('1485', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-09 21:32:00');
INSERT INTO `sys_job_log` VALUES ('1486', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 21:33:00');
INSERT INTO `sys_job_log` VALUES ('1487', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 21:34:00');
INSERT INTO `sys_job_log` VALUES ('1488', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-09 21:35:00');
INSERT INTO `sys_job_log` VALUES ('1489', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 21:36:00');
INSERT INTO `sys_job_log` VALUES ('1490', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:37:00');
INSERT INTO `sys_job_log` VALUES ('1491', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-09 21:38:00');
INSERT INTO `sys_job_log` VALUES ('1492', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 21:39:00');
INSERT INTO `sys_job_log` VALUES ('1493', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 21:40:00');
INSERT INTO `sys_job_log` VALUES ('1494', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 21:41:00');
INSERT INTO `sys_job_log` VALUES ('1495', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:42:00');
INSERT INTO `sys_job_log` VALUES ('1496', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 21:43:00');
INSERT INTO `sys_job_log` VALUES ('1497', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 21:44:00');
INSERT INTO `sys_job_log` VALUES ('1498', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 21:45:00');
INSERT INTO `sys_job_log` VALUES ('1499', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 21:46:00');
INSERT INTO `sys_job_log` VALUES ('1500', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 21:47:00');
INSERT INTO `sys_job_log` VALUES ('1501', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:48:00');
INSERT INTO `sys_job_log` VALUES ('1502', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 21:49:00');
INSERT INTO `sys_job_log` VALUES ('1503', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:50:00');
INSERT INTO `sys_job_log` VALUES ('1504', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-09 21:51:00');
INSERT INTO `sys_job_log` VALUES ('1505', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 21:52:00');
INSERT INTO `sys_job_log` VALUES ('1506', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:53:00');
INSERT INTO `sys_job_log` VALUES ('1507', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 21:54:00');
INSERT INTO `sys_job_log` VALUES ('1508', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 21:55:00');
INSERT INTO `sys_job_log` VALUES ('1509', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:56:00');
INSERT INTO `sys_job_log` VALUES ('1510', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:57:00');
INSERT INTO `sys_job_log` VALUES ('1511', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 21:58:00');
INSERT INTO `sys_job_log` VALUES ('1512', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 21:59:00');
INSERT INTO `sys_job_log` VALUES ('1513', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:00:00');
INSERT INTO `sys_job_log` VALUES ('1514', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 22:01:00');
INSERT INTO `sys_job_log` VALUES ('1515', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:02:00');
INSERT INTO `sys_job_log` VALUES ('1516', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 22:03:00');
INSERT INTO `sys_job_log` VALUES ('1517', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 22:04:00');
INSERT INTO `sys_job_log` VALUES ('1518', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-09 22:05:00');
INSERT INTO `sys_job_log` VALUES ('1519', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:06:00');
INSERT INTO `sys_job_log` VALUES ('1520', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:07:00');
INSERT INTO `sys_job_log` VALUES ('1521', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 22:08:00');
INSERT INTO `sys_job_log` VALUES ('1522', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:09:00');
INSERT INTO `sys_job_log` VALUES ('1523', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 22:10:00');
INSERT INTO `sys_job_log` VALUES ('1524', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:11:00');
INSERT INTO `sys_job_log` VALUES ('1525', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 22:12:00');
INSERT INTO `sys_job_log` VALUES ('1526', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-09 22:13:00');
INSERT INTO `sys_job_log` VALUES ('1527', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:14:00');
INSERT INTO `sys_job_log` VALUES ('1528', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:15:00');
INSERT INTO `sys_job_log` VALUES ('1529', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 22:16:00');
INSERT INTO `sys_job_log` VALUES ('1530', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:17:00');
INSERT INTO `sys_job_log` VALUES ('1531', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 22:18:00');
INSERT INTO `sys_job_log` VALUES ('1532', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:19:00');
INSERT INTO `sys_job_log` VALUES ('1533', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-09 22:20:00');
INSERT INTO `sys_job_log` VALUES ('1534', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 22:21:00');
INSERT INTO `sys_job_log` VALUES ('1535', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 22:22:00');
INSERT INTO `sys_job_log` VALUES ('1536', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:23:00');
INSERT INTO `sys_job_log` VALUES ('1537', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:24:00');
INSERT INTO `sys_job_log` VALUES ('1538', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:25:00');
INSERT INTO `sys_job_log` VALUES ('1539', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 22:26:00');
INSERT INTO `sys_job_log` VALUES ('1540', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:27:00');
INSERT INTO `sys_job_log` VALUES ('1541', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:28:00');
INSERT INTO `sys_job_log` VALUES ('1542', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:29:00');
INSERT INTO `sys_job_log` VALUES ('1543', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:30:00');
INSERT INTO `sys_job_log` VALUES ('1544', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 22:31:00');
INSERT INTO `sys_job_log` VALUES ('1545', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:32:00');
INSERT INTO `sys_job_log` VALUES ('1546', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:33:00');
INSERT INTO `sys_job_log` VALUES ('1547', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 22:34:00');
INSERT INTO `sys_job_log` VALUES ('1548', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 22:35:00');
INSERT INTO `sys_job_log` VALUES ('1549', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:36:00');
INSERT INTO `sys_job_log` VALUES ('1550', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 22:37:00');
INSERT INTO `sys_job_log` VALUES ('1551', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 22:38:00');
INSERT INTO `sys_job_log` VALUES ('1552', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:39:00');
INSERT INTO `sys_job_log` VALUES ('1553', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:40:00');
INSERT INTO `sys_job_log` VALUES ('1554', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:41:00');
INSERT INTO `sys_job_log` VALUES ('1555', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 22:42:00');
INSERT INTO `sys_job_log` VALUES ('1556', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 22:43:00');
INSERT INTO `sys_job_log` VALUES ('1557', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 22:44:00');
INSERT INTO `sys_job_log` VALUES ('1558', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 22:45:00');
INSERT INTO `sys_job_log` VALUES ('1559', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 22:46:00');
INSERT INTO `sys_job_log` VALUES ('1560', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-09 22:47:00');
INSERT INTO `sys_job_log` VALUES ('1561', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:48:00');
INSERT INTO `sys_job_log` VALUES ('1562', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 22:49:00');
INSERT INTO `sys_job_log` VALUES ('1563', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:50:00');
INSERT INTO `sys_job_log` VALUES ('1564', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 22:51:00');
INSERT INTO `sys_job_log` VALUES ('1565', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:52:00');
INSERT INTO `sys_job_log` VALUES ('1566', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 22:53:00');
INSERT INTO `sys_job_log` VALUES ('1567', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-09 22:54:00');
INSERT INTO `sys_job_log` VALUES ('1568', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:55:00');
INSERT INTO `sys_job_log` VALUES ('1569', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:56:00');
INSERT INTO `sys_job_log` VALUES ('1570', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:57:00');
INSERT INTO `sys_job_log` VALUES ('1571', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 22:58:00');
INSERT INTO `sys_job_log` VALUES ('1572', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 22:59:00');
INSERT INTO `sys_job_log` VALUES ('1573', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 23:00:00');
INSERT INTO `sys_job_log` VALUES ('1574', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 23:01:00');
INSERT INTO `sys_job_log` VALUES ('1575', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:02:00');
INSERT INTO `sys_job_log` VALUES ('1576', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 23:03:00');
INSERT INTO `sys_job_log` VALUES ('1577', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:04:00');
INSERT INTO `sys_job_log` VALUES ('1578', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 23:05:00');
INSERT INTO `sys_job_log` VALUES ('1579', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:06:00');
INSERT INTO `sys_job_log` VALUES ('1580', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 23:07:00');
INSERT INTO `sys_job_log` VALUES ('1581', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:08:00');
INSERT INTO `sys_job_log` VALUES ('1582', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-09 23:09:00');
INSERT INTO `sys_job_log` VALUES ('1583', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 23:10:00');
INSERT INTO `sys_job_log` VALUES ('1584', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:11:00');
INSERT INTO `sys_job_log` VALUES ('1585', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 23:12:00');
INSERT INTO `sys_job_log` VALUES ('1586', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 23:13:00');
INSERT INTO `sys_job_log` VALUES ('1587', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:14:00');
INSERT INTO `sys_job_log` VALUES ('1588', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 23:15:00');
INSERT INTO `sys_job_log` VALUES ('1589', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-09 23:16:00');
INSERT INTO `sys_job_log` VALUES ('1590', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 23:17:00');
INSERT INTO `sys_job_log` VALUES ('1591', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-09 23:18:00');
INSERT INTO `sys_job_log` VALUES ('1592', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:19:00');
INSERT INTO `sys_job_log` VALUES ('1593', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 23:20:00');
INSERT INTO `sys_job_log` VALUES ('1594', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:21:00');
INSERT INTO `sys_job_log` VALUES ('1595', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 23:22:00');
INSERT INTO `sys_job_log` VALUES ('1596', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:23:00');
INSERT INTO `sys_job_log` VALUES ('1597', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:24:00');
INSERT INTO `sys_job_log` VALUES ('1598', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 23:25:00');
INSERT INTO `sys_job_log` VALUES ('1599', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:26:00');
INSERT INTO `sys_job_log` VALUES ('1600', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 23:27:00');
INSERT INTO `sys_job_log` VALUES ('1601', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 23:28:00');
INSERT INTO `sys_job_log` VALUES ('1602', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 23:29:00');
INSERT INTO `sys_job_log` VALUES ('1603', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 23:30:00');
INSERT INTO `sys_job_log` VALUES ('1604', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:31:00');
INSERT INTO `sys_job_log` VALUES ('1605', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:32:00');
INSERT INTO `sys_job_log` VALUES ('1606', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:33:00');
INSERT INTO `sys_job_log` VALUES ('1607', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-09 23:34:00');
INSERT INTO `sys_job_log` VALUES ('1608', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 23:35:00');
INSERT INTO `sys_job_log` VALUES ('1609', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:36:00');
INSERT INTO `sys_job_log` VALUES ('1610', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:37:00');
INSERT INTO `sys_job_log` VALUES ('1611', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 23:38:00');
INSERT INTO `sys_job_log` VALUES ('1612', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-09 23:39:00');
INSERT INTO `sys_job_log` VALUES ('1613', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:40:00');
INSERT INTO `sys_job_log` VALUES ('1614', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:41:00');
INSERT INTO `sys_job_log` VALUES ('1615', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-09 23:42:00');
INSERT INTO `sys_job_log` VALUES ('1616', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:43:00');
INSERT INTO `sys_job_log` VALUES ('1617', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 23:44:00');
INSERT INTO `sys_job_log` VALUES ('1618', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 23:45:00');
INSERT INTO `sys_job_log` VALUES ('1619', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-09 23:46:00');
INSERT INTO `sys_job_log` VALUES ('1620', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 23:47:00');
INSERT INTO `sys_job_log` VALUES ('1621', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 23:48:00');
INSERT INTO `sys_job_log` VALUES ('1622', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-09 23:49:00');
INSERT INTO `sys_job_log` VALUES ('1623', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:50:00');
INSERT INTO `sys_job_log` VALUES ('1624', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-09 23:51:00');
INSERT INTO `sys_job_log` VALUES ('1625', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:52:00');
INSERT INTO `sys_job_log` VALUES ('1626', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-09 23:53:00');
INSERT INTO `sys_job_log` VALUES ('1627', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-09 23:54:00');
INSERT INTO `sys_job_log` VALUES ('1628', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-09 23:55:00');
INSERT INTO `sys_job_log` VALUES ('1629', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-09 23:56:00');
INSERT INTO `sys_job_log` VALUES ('1630', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-09 23:57:00');
INSERT INTO `sys_job_log` VALUES ('1631', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-09 23:58:00');
INSERT INTO `sys_job_log` VALUES ('1632', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-09 23:59:00');
INSERT INTO `sys_job_log` VALUES ('1633', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 00:00:00');
INSERT INTO `sys_job_log` VALUES ('1634', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:01:00');
INSERT INTO `sys_job_log` VALUES ('1635', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:02:00');
INSERT INTO `sys_job_log` VALUES ('1636', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 00:03:00');
INSERT INTO `sys_job_log` VALUES ('1637', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 00:04:00');
INSERT INTO `sys_job_log` VALUES ('1638', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:05:00');
INSERT INTO `sys_job_log` VALUES ('1639', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 00:06:00');
INSERT INTO `sys_job_log` VALUES ('1640', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:07:00');
INSERT INTO `sys_job_log` VALUES ('1641', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 00:08:00');
INSERT INTO `sys_job_log` VALUES ('1642', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 00:09:00');
INSERT INTO `sys_job_log` VALUES ('1643', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 00:10:00');
INSERT INTO `sys_job_log` VALUES ('1644', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 00:11:00');
INSERT INTO `sys_job_log` VALUES ('1645', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 00:12:00');
INSERT INTO `sys_job_log` VALUES ('1646', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 00:13:00');
INSERT INTO `sys_job_log` VALUES ('1647', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 00:14:00');
INSERT INTO `sys_job_log` VALUES ('1648', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 00:15:00');
INSERT INTO `sys_job_log` VALUES ('1649', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:16:00');
INSERT INTO `sys_job_log` VALUES ('1650', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 00:17:00');
INSERT INTO `sys_job_log` VALUES ('1651', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 00:18:00');
INSERT INTO `sys_job_log` VALUES ('1652', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:19:00');
INSERT INTO `sys_job_log` VALUES ('1653', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:20:00');
INSERT INTO `sys_job_log` VALUES ('1654', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：111毫秒', '0', '', '2021-11-10 00:21:00');
INSERT INTO `sys_job_log` VALUES ('1655', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:22:00');
INSERT INTO `sys_job_log` VALUES ('1656', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 00:23:00');
INSERT INTO `sys_job_log` VALUES ('1657', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:24:00');
INSERT INTO `sys_job_log` VALUES ('1658', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 00:25:00');
INSERT INTO `sys_job_log` VALUES ('1659', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 00:26:00');
INSERT INTO `sys_job_log` VALUES ('1660', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:27:00');
INSERT INTO `sys_job_log` VALUES ('1661', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:28:00');
INSERT INTO `sys_job_log` VALUES ('1662', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:29:00');
INSERT INTO `sys_job_log` VALUES ('1663', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 00:30:00');
INSERT INTO `sys_job_log` VALUES ('1664', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 00:31:00');
INSERT INTO `sys_job_log` VALUES ('1665', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 00:32:00');
INSERT INTO `sys_job_log` VALUES ('1666', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:33:00');
INSERT INTO `sys_job_log` VALUES ('1667', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 00:34:00');
INSERT INTO `sys_job_log` VALUES ('1668', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:35:00');
INSERT INTO `sys_job_log` VALUES ('1669', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 00:36:00');
INSERT INTO `sys_job_log` VALUES ('1670', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 00:37:00');
INSERT INTO `sys_job_log` VALUES ('1671', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 00:38:00');
INSERT INTO `sys_job_log` VALUES ('1672', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 00:39:00');
INSERT INTO `sys_job_log` VALUES ('1673', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 00:40:00');
INSERT INTO `sys_job_log` VALUES ('1674', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 00:41:00');
INSERT INTO `sys_job_log` VALUES ('1675', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 00:42:00');
INSERT INTO `sys_job_log` VALUES ('1676', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 00:43:00');
INSERT INTO `sys_job_log` VALUES ('1677', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:44:00');
INSERT INTO `sys_job_log` VALUES ('1678', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 00:45:00');
INSERT INTO `sys_job_log` VALUES ('1679', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 00:46:00');
INSERT INTO `sys_job_log` VALUES ('1680', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 00:47:00');
INSERT INTO `sys_job_log` VALUES ('1681', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:48:00');
INSERT INTO `sys_job_log` VALUES ('1682', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:49:00');
INSERT INTO `sys_job_log` VALUES ('1683', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 00:50:00');
INSERT INTO `sys_job_log` VALUES ('1684', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 00:51:00');
INSERT INTO `sys_job_log` VALUES ('1685', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 00:52:00');
INSERT INTO `sys_job_log` VALUES ('1686', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 00:53:00');
INSERT INTO `sys_job_log` VALUES ('1687', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 00:54:00');
INSERT INTO `sys_job_log` VALUES ('1688', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 00:55:00');
INSERT INTO `sys_job_log` VALUES ('1689', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:56:00');
INSERT INTO `sys_job_log` VALUES ('1690', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 00:57:00');
INSERT INTO `sys_job_log` VALUES ('1691', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 00:58:00');
INSERT INTO `sys_job_log` VALUES ('1692', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 00:59:00');
INSERT INTO `sys_job_log` VALUES ('1693', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：47毫秒', '0', '', '2021-11-10 01:02:01');
INSERT INTO `sys_job_log` VALUES ('1694', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-10 01:03:00');
INSERT INTO `sys_job_log` VALUES ('1695', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:04:00');
INSERT INTO `sys_job_log` VALUES ('1696', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 01:05:00');
INSERT INTO `sys_job_log` VALUES ('1697', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：90毫秒', '0', '', '2021-11-10 01:06:00');
INSERT INTO `sys_job_log` VALUES ('1698', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 01:07:00');
INSERT INTO `sys_job_log` VALUES ('1699', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 01:08:00');
INSERT INTO `sys_job_log` VALUES ('1700', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：29毫秒', '0', '', '2021-11-10 01:09:00');
INSERT INTO `sys_job_log` VALUES ('1701', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：47毫秒', '0', '', '2021-11-10 01:10:00');
INSERT INTO `sys_job_log` VALUES ('1702', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 01:11:00');
INSERT INTO `sys_job_log` VALUES ('1703', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 01:12:00');
INSERT INTO `sys_job_log` VALUES ('1704', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 01:13:00');
INSERT INTO `sys_job_log` VALUES ('1705', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:14:00');
INSERT INTO `sys_job_log` VALUES ('1706', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 01:15:00');
INSERT INTO `sys_job_log` VALUES ('1707', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 01:16:02');
INSERT INTO `sys_job_log` VALUES ('1708', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 01:17:00');
INSERT INTO `sys_job_log` VALUES ('1709', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：34毫秒', '0', '', '2021-11-10 01:18:00');
INSERT INTO `sys_job_log` VALUES ('1710', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-10 01:19:01');
INSERT INTO `sys_job_log` VALUES ('1711', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 01:20:01');
INSERT INTO `sys_job_log` VALUES ('1712', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 01:21:01');
INSERT INTO `sys_job_log` VALUES ('1713', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 01:22:00');
INSERT INTO `sys_job_log` VALUES ('1714', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：52毫秒', '0', '', '2021-11-10 01:23:00');
INSERT INTO `sys_job_log` VALUES ('1715', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 01:24:00');
INSERT INTO `sys_job_log` VALUES ('1716', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 01:25:00');
INSERT INTO `sys_job_log` VALUES ('1717', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 01:26:00');
INSERT INTO `sys_job_log` VALUES ('1718', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 01:27:00');
INSERT INTO `sys_job_log` VALUES ('1719', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 01:28:00');
INSERT INTO `sys_job_log` VALUES ('1720', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 01:29:00');
INSERT INTO `sys_job_log` VALUES ('1721', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:30:00');
INSERT INTO `sys_job_log` VALUES ('1722', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 01:31:00');
INSERT INTO `sys_job_log` VALUES ('1723', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 01:32:00');
INSERT INTO `sys_job_log` VALUES ('1724', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:33:00');
INSERT INTO `sys_job_log` VALUES ('1725', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 01:34:00');
INSERT INTO `sys_job_log` VALUES ('1726', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 01:35:00');
INSERT INTO `sys_job_log` VALUES ('1727', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:36:00');
INSERT INTO `sys_job_log` VALUES ('1728', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 01:37:00');
INSERT INTO `sys_job_log` VALUES ('1729', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：31毫秒', '0', '', '2021-11-10 01:38:00');
INSERT INTO `sys_job_log` VALUES ('1730', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 01:39:00');
INSERT INTO `sys_job_log` VALUES ('1731', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 01:40:00');
INSERT INTO `sys_job_log` VALUES ('1732', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 01:41:00');
INSERT INTO `sys_job_log` VALUES ('1733', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 01:42:00');
INSERT INTO `sys_job_log` VALUES ('1734', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-10 01:43:00');
INSERT INTO `sys_job_log` VALUES ('1735', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 01:44:00');
INSERT INTO `sys_job_log` VALUES ('1736', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 01:45:00');
INSERT INTO `sys_job_log` VALUES ('1737', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 01:46:00');
INSERT INTO `sys_job_log` VALUES ('1738', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 01:47:00');
INSERT INTO `sys_job_log` VALUES ('1739', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:48:00');
INSERT INTO `sys_job_log` VALUES ('1740', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 01:49:00');
INSERT INTO `sys_job_log` VALUES ('1741', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 01:50:00');
INSERT INTO `sys_job_log` VALUES ('1742', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 01:51:00');
INSERT INTO `sys_job_log` VALUES ('1743', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 01:52:00');
INSERT INTO `sys_job_log` VALUES ('1744', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 01:53:00');
INSERT INTO `sys_job_log` VALUES ('1745', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 01:54:00');
INSERT INTO `sys_job_log` VALUES ('1746', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:55:00');
INSERT INTO `sys_job_log` VALUES ('1747', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 01:56:00');
INSERT INTO `sys_job_log` VALUES ('1748', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 01:57:00');
INSERT INTO `sys_job_log` VALUES ('1749', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 01:58:00');
INSERT INTO `sys_job_log` VALUES ('1750', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 01:59:00');
INSERT INTO `sys_job_log` VALUES ('1751', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 02:00:00');
INSERT INTO `sys_job_log` VALUES ('1752', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 02:01:00');
INSERT INTO `sys_job_log` VALUES ('1753', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 02:02:00');
INSERT INTO `sys_job_log` VALUES ('1754', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 02:03:00');
INSERT INTO `sys_job_log` VALUES ('1755', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 02:04:00');
INSERT INTO `sys_job_log` VALUES ('1756', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 02:05:00');
INSERT INTO `sys_job_log` VALUES ('1757', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 02:06:00');
INSERT INTO `sys_job_log` VALUES ('1758', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 02:07:00');
INSERT INTO `sys_job_log` VALUES ('1759', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 02:08:00');
INSERT INTO `sys_job_log` VALUES ('1760', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 02:09:00');
INSERT INTO `sys_job_log` VALUES ('1761', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：32毫秒', '0', '', '2021-11-10 02:10:00');
INSERT INTO `sys_job_log` VALUES ('1762', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 02:11:00');
INSERT INTO `sys_job_log` VALUES ('1763', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:12:00');
INSERT INTO `sys_job_log` VALUES ('1764', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-10 02:13:00');
INSERT INTO `sys_job_log` VALUES ('1765', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:14:00');
INSERT INTO `sys_job_log` VALUES ('1766', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 02:15:00');
INSERT INTO `sys_job_log` VALUES ('1767', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 02:16:00');
INSERT INTO `sys_job_log` VALUES ('1768', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 02:17:00');
INSERT INTO `sys_job_log` VALUES ('1769', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 02:18:00');
INSERT INTO `sys_job_log` VALUES ('1770', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:19:00');
INSERT INTO `sys_job_log` VALUES ('1771', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 02:20:00');
INSERT INTO `sys_job_log` VALUES ('1772', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 02:21:00');
INSERT INTO `sys_job_log` VALUES ('1773', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 02:22:00');
INSERT INTO `sys_job_log` VALUES ('1774', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 02:23:00');
INSERT INTO `sys_job_log` VALUES ('1775', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 02:24:00');
INSERT INTO `sys_job_log` VALUES ('1776', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 02:25:00');
INSERT INTO `sys_job_log` VALUES ('1777', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 02:26:00');
INSERT INTO `sys_job_log` VALUES ('1778', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 02:27:00');
INSERT INTO `sys_job_log` VALUES ('1779', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 02:28:00');
INSERT INTO `sys_job_log` VALUES ('1780', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 02:29:00');
INSERT INTO `sys_job_log` VALUES ('1781', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 02:30:00');
INSERT INTO `sys_job_log` VALUES ('1782', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 02:31:00');
INSERT INTO `sys_job_log` VALUES ('1783', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 02:32:00');
INSERT INTO `sys_job_log` VALUES ('1784', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 02:33:00');
INSERT INTO `sys_job_log` VALUES ('1785', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 02:34:00');
INSERT INTO `sys_job_log` VALUES ('1786', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 02:35:00');
INSERT INTO `sys_job_log` VALUES ('1787', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:36:00');
INSERT INTO `sys_job_log` VALUES ('1788', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 02:37:00');
INSERT INTO `sys_job_log` VALUES ('1789', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 02:38:00');
INSERT INTO `sys_job_log` VALUES ('1790', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 02:39:00');
INSERT INTO `sys_job_log` VALUES ('1791', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 02:40:00');
INSERT INTO `sys_job_log` VALUES ('1792', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:41:00');
INSERT INTO `sys_job_log` VALUES ('1793', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 02:42:00');
INSERT INTO `sys_job_log` VALUES ('1794', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:43:00');
INSERT INTO `sys_job_log` VALUES ('1795', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 02:44:00');
INSERT INTO `sys_job_log` VALUES ('1796', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 02:45:00');
INSERT INTO `sys_job_log` VALUES ('1797', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 02:46:00');
INSERT INTO `sys_job_log` VALUES ('1798', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 02:47:00');
INSERT INTO `sys_job_log` VALUES ('1799', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 02:48:00');
INSERT INTO `sys_job_log` VALUES ('1800', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:49:00');
INSERT INTO `sys_job_log` VALUES ('1801', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 02:50:00');
INSERT INTO `sys_job_log` VALUES ('1802', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-10 02:51:00');
INSERT INTO `sys_job_log` VALUES ('1803', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 02:52:00');
INSERT INTO `sys_job_log` VALUES ('1804', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 02:53:00');
INSERT INTO `sys_job_log` VALUES ('1805', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 02:54:00');
INSERT INTO `sys_job_log` VALUES ('1806', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 02:55:00');
INSERT INTO `sys_job_log` VALUES ('1807', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 02:56:00');
INSERT INTO `sys_job_log` VALUES ('1808', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 02:57:00');
INSERT INTO `sys_job_log` VALUES ('1809', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 02:58:00');
INSERT INTO `sys_job_log` VALUES ('1810', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 02:59:00');
INSERT INTO `sys_job_log` VALUES ('1811', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 03:00:00');
INSERT INTO `sys_job_log` VALUES ('1812', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:01:00');
INSERT INTO `sys_job_log` VALUES ('1813', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:02:00');
INSERT INTO `sys_job_log` VALUES ('1814', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 03:03:00');
INSERT INTO `sys_job_log` VALUES ('1815', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 03:04:00');
INSERT INTO `sys_job_log` VALUES ('1816', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 03:05:00');
INSERT INTO `sys_job_log` VALUES ('1817', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 03:06:00');
INSERT INTO `sys_job_log` VALUES ('1818', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 03:07:00');
INSERT INTO `sys_job_log` VALUES ('1819', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:08:00');
INSERT INTO `sys_job_log` VALUES ('1820', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 03:09:00');
INSERT INTO `sys_job_log` VALUES ('1821', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：33毫秒', '0', '', '2021-11-10 03:10:00');
INSERT INTO `sys_job_log` VALUES ('1822', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 03:11:00');
INSERT INTO `sys_job_log` VALUES ('1823', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 03:12:00');
INSERT INTO `sys_job_log` VALUES ('1824', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 03:13:00');
INSERT INTO `sys_job_log` VALUES ('1825', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 03:14:00');
INSERT INTO `sys_job_log` VALUES ('1826', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 03:15:00');
INSERT INTO `sys_job_log` VALUES ('1827', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 03:16:00');
INSERT INTO `sys_job_log` VALUES ('1828', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 03:17:00');
INSERT INTO `sys_job_log` VALUES ('1829', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:18:00');
INSERT INTO `sys_job_log` VALUES ('1830', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 03:19:00');
INSERT INTO `sys_job_log` VALUES ('1831', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 03:20:00');
INSERT INTO `sys_job_log` VALUES ('1832', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 03:21:00');
INSERT INTO `sys_job_log` VALUES ('1833', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 03:22:00');
INSERT INTO `sys_job_log` VALUES ('1834', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 03:23:00');
INSERT INTO `sys_job_log` VALUES ('1835', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 03:24:00');
INSERT INTO `sys_job_log` VALUES ('1836', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:25:00');
INSERT INTO `sys_job_log` VALUES ('1837', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 03:26:00');
INSERT INTO `sys_job_log` VALUES ('1838', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-10 03:27:00');
INSERT INTO `sys_job_log` VALUES ('1839', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:28:00');
INSERT INTO `sys_job_log` VALUES ('1840', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 03:29:00');
INSERT INTO `sys_job_log` VALUES ('1841', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 03:30:00');
INSERT INTO `sys_job_log` VALUES ('1842', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 03:31:00');
INSERT INTO `sys_job_log` VALUES ('1843', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 03:32:00');
INSERT INTO `sys_job_log` VALUES ('1844', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 03:33:00');
INSERT INTO `sys_job_log` VALUES ('1845', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 03:34:00');
INSERT INTO `sys_job_log` VALUES ('1846', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:35:00');
INSERT INTO `sys_job_log` VALUES ('1847', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 03:36:00');
INSERT INTO `sys_job_log` VALUES ('1848', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 03:37:00');
INSERT INTO `sys_job_log` VALUES ('1849', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 03:38:00');
INSERT INTO `sys_job_log` VALUES ('1850', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 03:39:00');
INSERT INTO `sys_job_log` VALUES ('1851', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 03:40:00');
INSERT INTO `sys_job_log` VALUES ('1852', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 03:41:00');
INSERT INTO `sys_job_log` VALUES ('1853', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：34毫秒', '0', '', '2021-11-10 03:42:00');
INSERT INTO `sys_job_log` VALUES ('1854', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-10 03:43:00');
INSERT INTO `sys_job_log` VALUES ('1855', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 03:44:00');
INSERT INTO `sys_job_log` VALUES ('1856', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:45:00');
INSERT INTO `sys_job_log` VALUES ('1857', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 03:46:00');
INSERT INTO `sys_job_log` VALUES ('1858', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 03:47:00');
INSERT INTO `sys_job_log` VALUES ('1859', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 03:48:00');
INSERT INTO `sys_job_log` VALUES ('1860', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 03:49:00');
INSERT INTO `sys_job_log` VALUES ('1861', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 03:50:00');
INSERT INTO `sys_job_log` VALUES ('1862', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 03:51:00');
INSERT INTO `sys_job_log` VALUES ('1863', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 03:52:00');
INSERT INTO `sys_job_log` VALUES ('1864', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 03:53:00');
INSERT INTO `sys_job_log` VALUES ('1865', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 03:54:00');
INSERT INTO `sys_job_log` VALUES ('1866', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 03:55:00');
INSERT INTO `sys_job_log` VALUES ('1867', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 03:56:00');
INSERT INTO `sys_job_log` VALUES ('1868', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 03:57:00');
INSERT INTO `sys_job_log` VALUES ('1869', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 03:58:00');
INSERT INTO `sys_job_log` VALUES ('1870', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 03:59:00');
INSERT INTO `sys_job_log` VALUES ('1871', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 04:00:00');
INSERT INTO `sys_job_log` VALUES ('1872', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 04:01:00');
INSERT INTO `sys_job_log` VALUES ('1873', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 04:02:00');
INSERT INTO `sys_job_log` VALUES ('1874', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:03:00');
INSERT INTO `sys_job_log` VALUES ('1875', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:04:00');
INSERT INTO `sys_job_log` VALUES ('1876', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 04:05:00');
INSERT INTO `sys_job_log` VALUES ('1877', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 04:06:00');
INSERT INTO `sys_job_log` VALUES ('1878', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 04:07:00');
INSERT INTO `sys_job_log` VALUES ('1879', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 04:08:00');
INSERT INTO `sys_job_log` VALUES ('1880', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 04:09:00');
INSERT INTO `sys_job_log` VALUES ('1881', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 04:10:00');
INSERT INTO `sys_job_log` VALUES ('1882', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 04:11:00');
INSERT INTO `sys_job_log` VALUES ('1883', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 04:12:00');
INSERT INTO `sys_job_log` VALUES ('1884', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 04:13:00');
INSERT INTO `sys_job_log` VALUES ('1885', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 04:14:00');
INSERT INTO `sys_job_log` VALUES ('1886', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 04:15:00');
INSERT INTO `sys_job_log` VALUES ('1887', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 04:16:00');
INSERT INTO `sys_job_log` VALUES ('1888', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 04:17:00');
INSERT INTO `sys_job_log` VALUES ('1889', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:18:00');
INSERT INTO `sys_job_log` VALUES ('1890', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 04:19:00');
INSERT INTO `sys_job_log` VALUES ('1891', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 04:20:00');
INSERT INTO `sys_job_log` VALUES ('1892', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 04:21:00');
INSERT INTO `sys_job_log` VALUES ('1893', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：36毫秒', '0', '', '2021-11-10 04:22:00');
INSERT INTO `sys_job_log` VALUES ('1894', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 04:23:00');
INSERT INTO `sys_job_log` VALUES ('1895', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 04:24:00');
INSERT INTO `sys_job_log` VALUES ('1896', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 04:25:00');
INSERT INTO `sys_job_log` VALUES ('1897', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:26:00');
INSERT INTO `sys_job_log` VALUES ('1898', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 04:27:00');
INSERT INTO `sys_job_log` VALUES ('1899', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:28:00');
INSERT INTO `sys_job_log` VALUES ('1900', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 04:29:00');
INSERT INTO `sys_job_log` VALUES ('1901', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 04:30:00');
INSERT INTO `sys_job_log` VALUES ('1902', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 04:31:00');
INSERT INTO `sys_job_log` VALUES ('1903', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 04:32:00');
INSERT INTO `sys_job_log` VALUES ('1904', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 04:33:00');
INSERT INTO `sys_job_log` VALUES ('1905', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:34:00');
INSERT INTO `sys_job_log` VALUES ('1906', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 04:35:00');
INSERT INTO `sys_job_log` VALUES ('1907', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 04:36:00');
INSERT INTO `sys_job_log` VALUES ('1908', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 04:37:00');
INSERT INTO `sys_job_log` VALUES ('1909', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 04:38:00');
INSERT INTO `sys_job_log` VALUES ('1910', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:39:00');
INSERT INTO `sys_job_log` VALUES ('1911', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 04:40:00');
INSERT INTO `sys_job_log` VALUES ('1912', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 04:41:00');
INSERT INTO `sys_job_log` VALUES ('1913', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 04:42:00');
INSERT INTO `sys_job_log` VALUES ('1914', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 04:43:00');
INSERT INTO `sys_job_log` VALUES ('1915', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 04:44:00');
INSERT INTO `sys_job_log` VALUES ('1916', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 04:45:00');
INSERT INTO `sys_job_log` VALUES ('1917', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 04:46:00');
INSERT INTO `sys_job_log` VALUES ('1918', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 04:47:00');
INSERT INTO `sys_job_log` VALUES ('1919', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 04:48:00');
INSERT INTO `sys_job_log` VALUES ('1920', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 04:49:00');
INSERT INTO `sys_job_log` VALUES ('1921', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 04:50:00');
INSERT INTO `sys_job_log` VALUES ('1922', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 04:51:00');
INSERT INTO `sys_job_log` VALUES ('1923', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：29毫秒', '0', '', '2021-11-10 04:52:00');
INSERT INTO `sys_job_log` VALUES ('1924', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 04:53:00');
INSERT INTO `sys_job_log` VALUES ('1925', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 04:54:00');
INSERT INTO `sys_job_log` VALUES ('1926', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 04:55:00');
INSERT INTO `sys_job_log` VALUES ('1927', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 04:56:00');
INSERT INTO `sys_job_log` VALUES ('1928', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 04:57:00');
INSERT INTO `sys_job_log` VALUES ('1929', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 04:58:00');
INSERT INTO `sys_job_log` VALUES ('1930', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 04:59:00');
INSERT INTO `sys_job_log` VALUES ('1931', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 05:00:00');
INSERT INTO `sys_job_log` VALUES ('1932', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 05:01:00');
INSERT INTO `sys_job_log` VALUES ('1933', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 05:02:00');
INSERT INTO `sys_job_log` VALUES ('1934', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 05:03:00');
INSERT INTO `sys_job_log` VALUES ('1935', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 05:04:00');
INSERT INTO `sys_job_log` VALUES ('1936', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 05:05:00');
INSERT INTO `sys_job_log` VALUES ('1937', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 05:06:00');
INSERT INTO `sys_job_log` VALUES ('1938', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 05:07:00');
INSERT INTO `sys_job_log` VALUES ('1939', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 05:08:00');
INSERT INTO `sys_job_log` VALUES ('1940', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 05:09:00');
INSERT INTO `sys_job_log` VALUES ('1941', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 05:10:00');
INSERT INTO `sys_job_log` VALUES ('1942', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 05:11:00');
INSERT INTO `sys_job_log` VALUES ('1943', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 05:12:00');
INSERT INTO `sys_job_log` VALUES ('1944', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 05:13:00');
INSERT INTO `sys_job_log` VALUES ('1945', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 05:14:00');
INSERT INTO `sys_job_log` VALUES ('1946', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 05:15:00');
INSERT INTO `sys_job_log` VALUES ('1947', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 05:16:00');
INSERT INTO `sys_job_log` VALUES ('1948', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 05:17:00');
INSERT INTO `sys_job_log` VALUES ('1949', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 05:18:00');
INSERT INTO `sys_job_log` VALUES ('1950', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 05:19:00');
INSERT INTO `sys_job_log` VALUES ('1951', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 05:20:00');
INSERT INTO `sys_job_log` VALUES ('1952', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 05:21:00');
INSERT INTO `sys_job_log` VALUES ('1953', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 05:22:00');
INSERT INTO `sys_job_log` VALUES ('1954', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 05:23:00');
INSERT INTO `sys_job_log` VALUES ('1955', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 05:24:00');
INSERT INTO `sys_job_log` VALUES ('1956', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 05:25:00');
INSERT INTO `sys_job_log` VALUES ('1957', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 05:26:00');
INSERT INTO `sys_job_log` VALUES ('1958', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 05:27:00');
INSERT INTO `sys_job_log` VALUES ('1959', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 05:28:00');
INSERT INTO `sys_job_log` VALUES ('1960', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 05:29:00');
INSERT INTO `sys_job_log` VALUES ('1961', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 05:30:00');
INSERT INTO `sys_job_log` VALUES ('1962', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 05:31:00');
INSERT INTO `sys_job_log` VALUES ('1963', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-10 05:32:00');
INSERT INTO `sys_job_log` VALUES ('1964', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 05:33:00');
INSERT INTO `sys_job_log` VALUES ('1965', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 05:34:00');
INSERT INTO `sys_job_log` VALUES ('1966', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 05:35:00');
INSERT INTO `sys_job_log` VALUES ('1967', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 05:36:00');
INSERT INTO `sys_job_log` VALUES ('1968', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 05:37:00');
INSERT INTO `sys_job_log` VALUES ('1969', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 05:38:00');
INSERT INTO `sys_job_log` VALUES ('1970', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 05:39:00');
INSERT INTO `sys_job_log` VALUES ('1971', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 05:40:00');
INSERT INTO `sys_job_log` VALUES ('1972', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 05:41:00');
INSERT INTO `sys_job_log` VALUES ('1973', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 05:42:00');
INSERT INTO `sys_job_log` VALUES ('1974', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 05:43:00');
INSERT INTO `sys_job_log` VALUES ('1975', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 05:44:00');
INSERT INTO `sys_job_log` VALUES ('1976', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 05:45:00');
INSERT INTO `sys_job_log` VALUES ('1977', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 05:46:00');
INSERT INTO `sys_job_log` VALUES ('1978', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 05:47:00');
INSERT INTO `sys_job_log` VALUES ('1979', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 05:48:00');
INSERT INTO `sys_job_log` VALUES ('1980', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 05:49:00');
INSERT INTO `sys_job_log` VALUES ('1981', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 05:50:00');
INSERT INTO `sys_job_log` VALUES ('1982', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 05:51:00');
INSERT INTO `sys_job_log` VALUES ('1983', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 05:52:00');
INSERT INTO `sys_job_log` VALUES ('1984', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 05:53:00');
INSERT INTO `sys_job_log` VALUES ('1985', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 05:54:00');
INSERT INTO `sys_job_log` VALUES ('1986', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 05:55:00');
INSERT INTO `sys_job_log` VALUES ('1987', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 05:56:00');
INSERT INTO `sys_job_log` VALUES ('1988', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 05:57:00');
INSERT INTO `sys_job_log` VALUES ('1989', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 05:58:00');
INSERT INTO `sys_job_log` VALUES ('1990', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 05:59:00');
INSERT INTO `sys_job_log` VALUES ('1991', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:00:00');
INSERT INTO `sys_job_log` VALUES ('1992', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 06:01:00');
INSERT INTO `sys_job_log` VALUES ('1993', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:02:00');
INSERT INTO `sys_job_log` VALUES ('1994', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:03:00');
INSERT INTO `sys_job_log` VALUES ('1995', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：32毫秒', '0', '', '2021-11-10 06:04:00');
INSERT INTO `sys_job_log` VALUES ('1996', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:05:00');
INSERT INTO `sys_job_log` VALUES ('1997', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 06:06:00');
INSERT INTO `sys_job_log` VALUES ('1998', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 06:07:00');
INSERT INTO `sys_job_log` VALUES ('1999', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 06:08:00');
INSERT INTO `sys_job_log` VALUES ('2000', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 06:09:00');
INSERT INTO `sys_job_log` VALUES ('2001', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:10:00');
INSERT INTO `sys_job_log` VALUES ('2002', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:11:00');
INSERT INTO `sys_job_log` VALUES ('2003', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 06:12:00');
INSERT INTO `sys_job_log` VALUES ('2004', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 06:13:00');
INSERT INTO `sys_job_log` VALUES ('2005', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 06:14:00');
INSERT INTO `sys_job_log` VALUES ('2006', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 06:15:00');
INSERT INTO `sys_job_log` VALUES ('2007', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 06:16:00');
INSERT INTO `sys_job_log` VALUES ('2008', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:17:00');
INSERT INTO `sys_job_log` VALUES ('2009', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 06:18:00');
INSERT INTO `sys_job_log` VALUES ('2010', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 06:19:00');
INSERT INTO `sys_job_log` VALUES ('2011', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 06:20:00');
INSERT INTO `sys_job_log` VALUES ('2012', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：32毫秒', '0', '', '2021-11-10 06:21:00');
INSERT INTO `sys_job_log` VALUES ('2013', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 06:22:00');
INSERT INTO `sys_job_log` VALUES ('2014', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:23:00');
INSERT INTO `sys_job_log` VALUES ('2015', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 06:24:00');
INSERT INTO `sys_job_log` VALUES ('2016', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 06:25:00');
INSERT INTO `sys_job_log` VALUES ('2017', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 06:26:00');
INSERT INTO `sys_job_log` VALUES ('2018', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-10 06:27:00');
INSERT INTO `sys_job_log` VALUES ('2019', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 06:28:00');
INSERT INTO `sys_job_log` VALUES ('2020', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 06:29:00');
INSERT INTO `sys_job_log` VALUES ('2021', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:30:00');
INSERT INTO `sys_job_log` VALUES ('2022', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 06:31:00');
INSERT INTO `sys_job_log` VALUES ('2023', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 06:32:00');
INSERT INTO `sys_job_log` VALUES ('2024', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:33:00');
INSERT INTO `sys_job_log` VALUES ('2025', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 06:34:00');
INSERT INTO `sys_job_log` VALUES ('2026', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 06:35:00');
INSERT INTO `sys_job_log` VALUES ('2027', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:36:00');
INSERT INTO `sys_job_log` VALUES ('2028', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 06:37:00');
INSERT INTO `sys_job_log` VALUES ('2029', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:38:00');
INSERT INTO `sys_job_log` VALUES ('2030', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 06:39:00');
INSERT INTO `sys_job_log` VALUES ('2031', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 06:40:00');
INSERT INTO `sys_job_log` VALUES ('2032', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:41:00');
INSERT INTO `sys_job_log` VALUES ('2033', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-10 06:42:00');
INSERT INTO `sys_job_log` VALUES ('2034', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 06:43:00');
INSERT INTO `sys_job_log` VALUES ('2035', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 06:44:00');
INSERT INTO `sys_job_log` VALUES ('2036', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 06:45:00');
INSERT INTO `sys_job_log` VALUES ('2037', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:46:00');
INSERT INTO `sys_job_log` VALUES ('2038', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 06:47:00');
INSERT INTO `sys_job_log` VALUES ('2039', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 06:48:00');
INSERT INTO `sys_job_log` VALUES ('2040', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 06:49:00');
INSERT INTO `sys_job_log` VALUES ('2041', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 06:50:00');
INSERT INTO `sys_job_log` VALUES ('2042', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:51:00');
INSERT INTO `sys_job_log` VALUES ('2043', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 06:52:00');
INSERT INTO `sys_job_log` VALUES ('2044', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:53:00');
INSERT INTO `sys_job_log` VALUES ('2045', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 06:54:00');
INSERT INTO `sys_job_log` VALUES ('2046', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 06:55:00');
INSERT INTO `sys_job_log` VALUES ('2047', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 06:56:00');
INSERT INTO `sys_job_log` VALUES ('2048', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 06:57:00');
INSERT INTO `sys_job_log` VALUES ('2049', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 06:58:00');
INSERT INTO `sys_job_log` VALUES ('2050', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 06:59:00');
INSERT INTO `sys_job_log` VALUES ('2051', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 07:00:00');
INSERT INTO `sys_job_log` VALUES ('2052', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:01:00');
INSERT INTO `sys_job_log` VALUES ('2053', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 07:02:00');
INSERT INTO `sys_job_log` VALUES ('2054', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 07:03:00');
INSERT INTO `sys_job_log` VALUES ('2055', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 07:04:00');
INSERT INTO `sys_job_log` VALUES ('2056', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:05:00');
INSERT INTO `sys_job_log` VALUES ('2057', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 07:06:00');
INSERT INTO `sys_job_log` VALUES ('2058', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 07:07:00');
INSERT INTO `sys_job_log` VALUES ('2059', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 07:08:00');
INSERT INTO `sys_job_log` VALUES ('2060', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-10 07:09:00');
INSERT INTO `sys_job_log` VALUES ('2061', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 07:10:00');
INSERT INTO `sys_job_log` VALUES ('2062', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 07:11:00');
INSERT INTO `sys_job_log` VALUES ('2063', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 07:12:00');
INSERT INTO `sys_job_log` VALUES ('2064', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 07:13:00');
INSERT INTO `sys_job_log` VALUES ('2065', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:14:00');
INSERT INTO `sys_job_log` VALUES ('2066', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 07:15:00');
INSERT INTO `sys_job_log` VALUES ('2067', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:16:00');
INSERT INTO `sys_job_log` VALUES ('2068', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:17:00');
INSERT INTO `sys_job_log` VALUES ('2069', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 07:18:00');
INSERT INTO `sys_job_log` VALUES ('2070', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:19:00');
INSERT INTO `sys_job_log` VALUES ('2071', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 07:20:00');
INSERT INTO `sys_job_log` VALUES ('2072', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 07:21:00');
INSERT INTO `sys_job_log` VALUES ('2073', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 07:22:00');
INSERT INTO `sys_job_log` VALUES ('2074', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:23:00');
INSERT INTO `sys_job_log` VALUES ('2075', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 07:24:00');
INSERT INTO `sys_job_log` VALUES ('2076', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：34毫秒', '0', '', '2021-11-10 07:25:00');
INSERT INTO `sys_job_log` VALUES ('2077', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 07:26:00');
INSERT INTO `sys_job_log` VALUES ('2078', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 07:27:00');
INSERT INTO `sys_job_log` VALUES ('2079', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 07:28:00');
INSERT INTO `sys_job_log` VALUES ('2080', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 07:29:00');
INSERT INTO `sys_job_log` VALUES ('2081', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 07:30:00');
INSERT INTO `sys_job_log` VALUES ('2082', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 07:31:00');
INSERT INTO `sys_job_log` VALUES ('2083', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 07:32:00');
INSERT INTO `sys_job_log` VALUES ('2084', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 07:33:00');
INSERT INTO `sys_job_log` VALUES ('2085', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 07:34:00');
INSERT INTO `sys_job_log` VALUES ('2086', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 07:35:00');
INSERT INTO `sys_job_log` VALUES ('2087', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 07:36:00');
INSERT INTO `sys_job_log` VALUES ('2088', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:37:00');
INSERT INTO `sys_job_log` VALUES ('2089', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 07:38:00');
INSERT INTO `sys_job_log` VALUES ('2090', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 07:39:00');
INSERT INTO `sys_job_log` VALUES ('2091', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 07:40:00');
INSERT INTO `sys_job_log` VALUES ('2092', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 07:41:00');
INSERT INTO `sys_job_log` VALUES ('2093', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 07:42:00');
INSERT INTO `sys_job_log` VALUES ('2094', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 07:43:00');
INSERT INTO `sys_job_log` VALUES ('2095', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:44:00');
INSERT INTO `sys_job_log` VALUES ('2096', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 07:45:00');
INSERT INTO `sys_job_log` VALUES ('2097', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 07:46:00');
INSERT INTO `sys_job_log` VALUES ('2098', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 07:47:00');
INSERT INTO `sys_job_log` VALUES ('2099', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 07:48:00');
INSERT INTO `sys_job_log` VALUES ('2100', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 07:49:00');
INSERT INTO `sys_job_log` VALUES ('2101', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 07:50:00');
INSERT INTO `sys_job_log` VALUES ('2102', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 07:51:00');
INSERT INTO `sys_job_log` VALUES ('2103', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 07:52:00');
INSERT INTO `sys_job_log` VALUES ('2104', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:53:00');
INSERT INTO `sys_job_log` VALUES ('2105', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 07:54:00');
INSERT INTO `sys_job_log` VALUES ('2106', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 07:55:00');
INSERT INTO `sys_job_log` VALUES ('2107', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 07:56:00');
INSERT INTO `sys_job_log` VALUES ('2108', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 07:57:00');
INSERT INTO `sys_job_log` VALUES ('2109', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 07:58:00');
INSERT INTO `sys_job_log` VALUES ('2110', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 07:59:00');
INSERT INTO `sys_job_log` VALUES ('2111', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:00:00');
INSERT INTO `sys_job_log` VALUES ('2112', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 08:01:00');
INSERT INTO `sys_job_log` VALUES ('2113', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 08:02:00');
INSERT INTO `sys_job_log` VALUES ('2114', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 08:03:00');
INSERT INTO `sys_job_log` VALUES ('2115', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 08:04:00');
INSERT INTO `sys_job_log` VALUES ('2116', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 08:05:00');
INSERT INTO `sys_job_log` VALUES ('2117', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 08:06:00');
INSERT INTO `sys_job_log` VALUES ('2118', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:07:00');
INSERT INTO `sys_job_log` VALUES ('2119', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 08:08:00');
INSERT INTO `sys_job_log` VALUES ('2120', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:09:00');
INSERT INTO `sys_job_log` VALUES ('2121', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:10:00');
INSERT INTO `sys_job_log` VALUES ('2122', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 08:11:00');
INSERT INTO `sys_job_log` VALUES ('2123', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 08:12:00');
INSERT INTO `sys_job_log` VALUES ('2124', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 08:13:00');
INSERT INTO `sys_job_log` VALUES ('2125', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 08:14:00');
INSERT INTO `sys_job_log` VALUES ('2126', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-10 08:15:00');
INSERT INTO `sys_job_log` VALUES ('2127', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:16:00');
INSERT INTO `sys_job_log` VALUES ('2128', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 08:17:00');
INSERT INTO `sys_job_log` VALUES ('2129', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 08:18:00');
INSERT INTO `sys_job_log` VALUES ('2130', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：63毫秒', '0', '', '2021-11-10 08:19:00');
INSERT INTO `sys_job_log` VALUES ('2131', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:20:00');
INSERT INTO `sys_job_log` VALUES ('2132', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 08:21:00');
INSERT INTO `sys_job_log` VALUES ('2133', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 08:22:00');
INSERT INTO `sys_job_log` VALUES ('2134', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 08:23:00');
INSERT INTO `sys_job_log` VALUES ('2135', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 08:24:00');
INSERT INTO `sys_job_log` VALUES ('2136', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 08:25:00');
INSERT INTO `sys_job_log` VALUES ('2137', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：29毫秒', '0', '', '2021-11-10 08:26:00');
INSERT INTO `sys_job_log` VALUES ('2138', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 08:27:00');
INSERT INTO `sys_job_log` VALUES ('2139', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:28:00');
INSERT INTO `sys_job_log` VALUES ('2140', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 08:29:00');
INSERT INTO `sys_job_log` VALUES ('2141', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:30:00');
INSERT INTO `sys_job_log` VALUES ('2142', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 08:31:00');
INSERT INTO `sys_job_log` VALUES ('2143', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 08:32:00');
INSERT INTO `sys_job_log` VALUES ('2144', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:33:00');
INSERT INTO `sys_job_log` VALUES ('2145', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 08:34:00');
INSERT INTO `sys_job_log` VALUES ('2146', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:35:00');
INSERT INTO `sys_job_log` VALUES ('2147', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:36:00');
INSERT INTO `sys_job_log` VALUES ('2148', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 08:37:00');
INSERT INTO `sys_job_log` VALUES ('2149', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:38:00');
INSERT INTO `sys_job_log` VALUES ('2150', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 08:39:00');
INSERT INTO `sys_job_log` VALUES ('2151', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:40:00');
INSERT INTO `sys_job_log` VALUES ('2152', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 08:41:00');
INSERT INTO `sys_job_log` VALUES ('2153', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:42:00');
INSERT INTO `sys_job_log` VALUES ('2154', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:43:00');
INSERT INTO `sys_job_log` VALUES ('2155', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 08:44:00');
INSERT INTO `sys_job_log` VALUES ('2156', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 08:45:00');
INSERT INTO `sys_job_log` VALUES ('2157', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 08:46:00');
INSERT INTO `sys_job_log` VALUES ('2158', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 08:47:00');
INSERT INTO `sys_job_log` VALUES ('2159', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:48:00');
INSERT INTO `sys_job_log` VALUES ('2160', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 08:49:00');
INSERT INTO `sys_job_log` VALUES ('2161', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 08:50:00');
INSERT INTO `sys_job_log` VALUES ('2162', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 08:51:00');
INSERT INTO `sys_job_log` VALUES ('2163', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:52:00');
INSERT INTO `sys_job_log` VALUES ('2164', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 08:53:00');
INSERT INTO `sys_job_log` VALUES ('2165', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 08:54:00');
INSERT INTO `sys_job_log` VALUES ('2166', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 08:55:00');
INSERT INTO `sys_job_log` VALUES ('2167', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 08:56:00');
INSERT INTO `sys_job_log` VALUES ('2168', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 08:57:00');
INSERT INTO `sys_job_log` VALUES ('2169', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 08:58:00');
INSERT INTO `sys_job_log` VALUES ('2170', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 08:59:00');
INSERT INTO `sys_job_log` VALUES ('2171', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 09:00:00');
INSERT INTO `sys_job_log` VALUES ('2172', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 09:01:00');
INSERT INTO `sys_job_log` VALUES ('2173', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 09:02:00');
INSERT INTO `sys_job_log` VALUES ('2174', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 09:03:00');
INSERT INTO `sys_job_log` VALUES ('2175', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:04:00');
INSERT INTO `sys_job_log` VALUES ('2176', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:05:00');
INSERT INTO `sys_job_log` VALUES ('2177', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:06:00');
INSERT INTO `sys_job_log` VALUES ('2178', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：34毫秒', '0', '', '2021-11-10 09:07:00');
INSERT INTO `sys_job_log` VALUES ('2179', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 09:08:00');
INSERT INTO `sys_job_log` VALUES ('2180', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 09:09:00');
INSERT INTO `sys_job_log` VALUES ('2181', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 09:10:00');
INSERT INTO `sys_job_log` VALUES ('2182', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 09:11:00');
INSERT INTO `sys_job_log` VALUES ('2183', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 09:12:00');
INSERT INTO `sys_job_log` VALUES ('2184', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 09:13:00');
INSERT INTO `sys_job_log` VALUES ('2185', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 09:14:00');
INSERT INTO `sys_job_log` VALUES ('2186', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:15:00');
INSERT INTO `sys_job_log` VALUES ('2187', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 09:16:00');
INSERT INTO `sys_job_log` VALUES ('2188', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 09:17:00');
INSERT INTO `sys_job_log` VALUES ('2189', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:18:00');
INSERT INTO `sys_job_log` VALUES ('2190', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 09:19:00');
INSERT INTO `sys_job_log` VALUES ('2191', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 09:20:00');
INSERT INTO `sys_job_log` VALUES ('2192', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:21:00');
INSERT INTO `sys_job_log` VALUES ('2193', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:22:00');
INSERT INTO `sys_job_log` VALUES ('2194', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 09:23:00');
INSERT INTO `sys_job_log` VALUES ('2195', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 09:24:00');
INSERT INTO `sys_job_log` VALUES ('2196', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 09:25:00');
INSERT INTO `sys_job_log` VALUES ('2197', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 09:26:00');
INSERT INTO `sys_job_log` VALUES ('2198', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 09:27:00');
INSERT INTO `sys_job_log` VALUES ('2199', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 09:28:00');
INSERT INTO `sys_job_log` VALUES ('2200', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:29:00');
INSERT INTO `sys_job_log` VALUES ('2201', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:30:00');
INSERT INTO `sys_job_log` VALUES ('2202', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 09:31:00');
INSERT INTO `sys_job_log` VALUES ('2203', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 09:32:00');
INSERT INTO `sys_job_log` VALUES ('2204', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 09:33:00');
INSERT INTO `sys_job_log` VALUES ('2205', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:34:00');
INSERT INTO `sys_job_log` VALUES ('2206', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:35:00');
INSERT INTO `sys_job_log` VALUES ('2207', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:36:00');
INSERT INTO `sys_job_log` VALUES ('2208', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 09:37:00');
INSERT INTO `sys_job_log` VALUES ('2209', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 09:38:00');
INSERT INTO `sys_job_log` VALUES ('2210', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:39:00');
INSERT INTO `sys_job_log` VALUES ('2211', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:40:00');
INSERT INTO `sys_job_log` VALUES ('2212', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:41:00');
INSERT INTO `sys_job_log` VALUES ('2213', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 09:42:00');
INSERT INTO `sys_job_log` VALUES ('2214', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 09:43:00');
INSERT INTO `sys_job_log` VALUES ('2215', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 09:44:00');
INSERT INTO `sys_job_log` VALUES ('2216', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 09:45:00');
INSERT INTO `sys_job_log` VALUES ('2217', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 09:46:00');
INSERT INTO `sys_job_log` VALUES ('2218', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 09:47:00');
INSERT INTO `sys_job_log` VALUES ('2219', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 09:48:00');
INSERT INTO `sys_job_log` VALUES ('2220', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 09:49:00');
INSERT INTO `sys_job_log` VALUES ('2221', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:50:00');
INSERT INTO `sys_job_log` VALUES ('2222', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 09:51:00');
INSERT INTO `sys_job_log` VALUES ('2223', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 09:52:00');
INSERT INTO `sys_job_log` VALUES ('2224', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 09:53:00');
INSERT INTO `sys_job_log` VALUES ('2225', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 09:54:00');
INSERT INTO `sys_job_log` VALUES ('2226', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 09:55:00');
INSERT INTO `sys_job_log` VALUES ('2227', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 09:56:00');
INSERT INTO `sys_job_log` VALUES ('2228', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 09:57:00');
INSERT INTO `sys_job_log` VALUES ('2229', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 09:58:00');
INSERT INTO `sys_job_log` VALUES ('2230', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 09:59:00');
INSERT INTO `sys_job_log` VALUES ('2231', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 10:00:00');
INSERT INTO `sys_job_log` VALUES ('2232', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 10:01:00');
INSERT INTO `sys_job_log` VALUES ('2233', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:02:00');
INSERT INTO `sys_job_log` VALUES ('2234', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 10:03:00');
INSERT INTO `sys_job_log` VALUES ('2235', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 10:04:00');
INSERT INTO `sys_job_log` VALUES ('2236', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:05:00');
INSERT INTO `sys_job_log` VALUES ('2237', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 10:06:00');
INSERT INTO `sys_job_log` VALUES ('2238', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 10:07:00');
INSERT INTO `sys_job_log` VALUES ('2239', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 10:08:00');
INSERT INTO `sys_job_log` VALUES ('2240', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 10:09:00');
INSERT INTO `sys_job_log` VALUES ('2241', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:10:00');
INSERT INTO `sys_job_log` VALUES ('2242', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:11:00');
INSERT INTO `sys_job_log` VALUES ('2243', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:12:00');
INSERT INTO `sys_job_log` VALUES ('2244', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:13:00');
INSERT INTO `sys_job_log` VALUES ('2245', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:14:00');
INSERT INTO `sys_job_log` VALUES ('2246', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:15:00');
INSERT INTO `sys_job_log` VALUES ('2247', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 10:16:00');
INSERT INTO `sys_job_log` VALUES ('2248', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 10:17:00');
INSERT INTO `sys_job_log` VALUES ('2249', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:18:00');
INSERT INTO `sys_job_log` VALUES ('2250', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:19:00');
INSERT INTO `sys_job_log` VALUES ('2251', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:20:00');
INSERT INTO `sys_job_log` VALUES ('2252', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 10:21:00');
INSERT INTO `sys_job_log` VALUES ('2253', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:22:00');
INSERT INTO `sys_job_log` VALUES ('2254', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 10:23:00');
INSERT INTO `sys_job_log` VALUES ('2255', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:24:00');
INSERT INTO `sys_job_log` VALUES ('2256', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 10:25:00');
INSERT INTO `sys_job_log` VALUES ('2257', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 10:26:00');
INSERT INTO `sys_job_log` VALUES ('2258', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:27:00');
INSERT INTO `sys_job_log` VALUES ('2259', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 10:28:00');
INSERT INTO `sys_job_log` VALUES ('2260', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:29:00');
INSERT INTO `sys_job_log` VALUES ('2261', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:30:00');
INSERT INTO `sys_job_log` VALUES ('2262', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 10:31:00');
INSERT INTO `sys_job_log` VALUES ('2263', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:32:00');
INSERT INTO `sys_job_log` VALUES ('2264', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:33:00');
INSERT INTO `sys_job_log` VALUES ('2265', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 10:34:00');
INSERT INTO `sys_job_log` VALUES ('2266', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:35:00');
INSERT INTO `sys_job_log` VALUES ('2267', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:36:00');
INSERT INTO `sys_job_log` VALUES ('2268', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 10:37:00');
INSERT INTO `sys_job_log` VALUES ('2269', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 10:38:00');
INSERT INTO `sys_job_log` VALUES ('2270', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:39:00');
INSERT INTO `sys_job_log` VALUES ('2271', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:40:00');
INSERT INTO `sys_job_log` VALUES ('2272', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 10:41:00');
INSERT INTO `sys_job_log` VALUES ('2273', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:42:00');
INSERT INTO `sys_job_log` VALUES ('2274', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 10:43:00');
INSERT INTO `sys_job_log` VALUES ('2275', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:44:00');
INSERT INTO `sys_job_log` VALUES ('2276', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 10:45:00');
INSERT INTO `sys_job_log` VALUES ('2277', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 10:46:00');
INSERT INTO `sys_job_log` VALUES ('2278', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:47:00');
INSERT INTO `sys_job_log` VALUES ('2279', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 10:48:00');
INSERT INTO `sys_job_log` VALUES ('2280', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 10:49:00');
INSERT INTO `sys_job_log` VALUES ('2281', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 10:50:00');
INSERT INTO `sys_job_log` VALUES ('2282', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:51:00');
INSERT INTO `sys_job_log` VALUES ('2283', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 10:52:00');
INSERT INTO `sys_job_log` VALUES ('2284', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 10:53:00');
INSERT INTO `sys_job_log` VALUES ('2285', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 10:54:00');
INSERT INTO `sys_job_log` VALUES ('2286', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-10 10:55:00');
INSERT INTO `sys_job_log` VALUES ('2287', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 10:56:00');
INSERT INTO `sys_job_log` VALUES ('2288', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:57:00');
INSERT INTO `sys_job_log` VALUES ('2289', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 10:58:00');
INSERT INTO `sys_job_log` VALUES ('2290', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 10:59:00');
INSERT INTO `sys_job_log` VALUES ('2291', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 11:00:00');
INSERT INTO `sys_job_log` VALUES ('2292', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 11:01:00');
INSERT INTO `sys_job_log` VALUES ('2293', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 11:02:00');
INSERT INTO `sys_job_log` VALUES ('2294', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 11:03:00');
INSERT INTO `sys_job_log` VALUES ('2295', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:04:00');
INSERT INTO `sys_job_log` VALUES ('2296', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 11:05:00');
INSERT INTO `sys_job_log` VALUES ('2297', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:06:00');
INSERT INTO `sys_job_log` VALUES ('2298', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:07:00');
INSERT INTO `sys_job_log` VALUES ('2299', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:08:00');
INSERT INTO `sys_job_log` VALUES ('2300', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 11:09:00');
INSERT INTO `sys_job_log` VALUES ('2301', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:10:00');
INSERT INTO `sys_job_log` VALUES ('2302', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:11:00');
INSERT INTO `sys_job_log` VALUES ('2303', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:12:00');
INSERT INTO `sys_job_log` VALUES ('2304', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:13:00');
INSERT INTO `sys_job_log` VALUES ('2305', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 11:14:00');
INSERT INTO `sys_job_log` VALUES ('2306', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:15:00');
INSERT INTO `sys_job_log` VALUES ('2307', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:16:00');
INSERT INTO `sys_job_log` VALUES ('2308', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 11:17:00');
INSERT INTO `sys_job_log` VALUES ('2309', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:18:00');
INSERT INTO `sys_job_log` VALUES ('2310', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:19:00');
INSERT INTO `sys_job_log` VALUES ('2311', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:20:00');
INSERT INTO `sys_job_log` VALUES ('2312', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:21:00');
INSERT INTO `sys_job_log` VALUES ('2313', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:22:00');
INSERT INTO `sys_job_log` VALUES ('2314', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:23:00');
INSERT INTO `sys_job_log` VALUES ('2315', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:24:00');
INSERT INTO `sys_job_log` VALUES ('2316', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 11:25:00');
INSERT INTO `sys_job_log` VALUES ('2317', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:26:00');
INSERT INTO `sys_job_log` VALUES ('2318', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:27:00');
INSERT INTO `sys_job_log` VALUES ('2319', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:28:00');
INSERT INTO `sys_job_log` VALUES ('2320', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:29:00');
INSERT INTO `sys_job_log` VALUES ('2321', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:30:00');
INSERT INTO `sys_job_log` VALUES ('2322', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:31:00');
INSERT INTO `sys_job_log` VALUES ('2323', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:32:00');
INSERT INTO `sys_job_log` VALUES ('2324', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 11:33:00');
INSERT INTO `sys_job_log` VALUES ('2325', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 11:34:00');
INSERT INTO `sys_job_log` VALUES ('2326', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:35:00');
INSERT INTO `sys_job_log` VALUES ('2327', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:36:00');
INSERT INTO `sys_job_log` VALUES ('2328', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:37:00');
INSERT INTO `sys_job_log` VALUES ('2329', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 11:38:00');
INSERT INTO `sys_job_log` VALUES ('2330', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 11:39:00');
INSERT INTO `sys_job_log` VALUES ('2331', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:40:00');
INSERT INTO `sys_job_log` VALUES ('2332', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:41:00');
INSERT INTO `sys_job_log` VALUES ('2333', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:42:00');
INSERT INTO `sys_job_log` VALUES ('2334', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:43:00');
INSERT INTO `sys_job_log` VALUES ('2335', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:44:00');
INSERT INTO `sys_job_log` VALUES ('2336', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:45:00');
INSERT INTO `sys_job_log` VALUES ('2337', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:46:00');
INSERT INTO `sys_job_log` VALUES ('2338', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:47:00');
INSERT INTO `sys_job_log` VALUES ('2339', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:48:00');
INSERT INTO `sys_job_log` VALUES ('2340', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 11:49:00');
INSERT INTO `sys_job_log` VALUES ('2341', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:50:00');
INSERT INTO `sys_job_log` VALUES ('2342', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 11:51:00');
INSERT INTO `sys_job_log` VALUES ('2343', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:52:00');
INSERT INTO `sys_job_log` VALUES ('2344', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:53:00');
INSERT INTO `sys_job_log` VALUES ('2345', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 11:54:00');
INSERT INTO `sys_job_log` VALUES ('2346', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 11:55:00');
INSERT INTO `sys_job_log` VALUES ('2347', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 11:56:00');
INSERT INTO `sys_job_log` VALUES ('2348', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 11:57:00');
INSERT INTO `sys_job_log` VALUES ('2349', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 11:58:00');
INSERT INTO `sys_job_log` VALUES ('2350', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 11:59:00');
INSERT INTO `sys_job_log` VALUES ('2351', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:00:00');
INSERT INTO `sys_job_log` VALUES ('2352', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 12:01:00');
INSERT INTO `sys_job_log` VALUES ('2353', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 12:02:00');
INSERT INTO `sys_job_log` VALUES ('2354', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:03:00');
INSERT INTO `sys_job_log` VALUES ('2355', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 12:04:00');
INSERT INTO `sys_job_log` VALUES ('2356', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 12:05:00');
INSERT INTO `sys_job_log` VALUES ('2357', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:06:00');
INSERT INTO `sys_job_log` VALUES ('2358', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:07:00');
INSERT INTO `sys_job_log` VALUES ('2359', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 12:08:00');
INSERT INTO `sys_job_log` VALUES ('2360', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 12:09:00');
INSERT INTO `sys_job_log` VALUES ('2361', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 12:10:00');
INSERT INTO `sys_job_log` VALUES ('2362', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:11:00');
INSERT INTO `sys_job_log` VALUES ('2363', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:12:00');
INSERT INTO `sys_job_log` VALUES ('2364', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 12:13:00');
INSERT INTO `sys_job_log` VALUES ('2365', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 12:14:00');
INSERT INTO `sys_job_log` VALUES ('2366', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 12:15:00');
INSERT INTO `sys_job_log` VALUES ('2367', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 12:16:00');
INSERT INTO `sys_job_log` VALUES ('2368', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 12:17:00');
INSERT INTO `sys_job_log` VALUES ('2369', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 12:18:00');
INSERT INTO `sys_job_log` VALUES ('2370', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 12:19:00');
INSERT INTO `sys_job_log` VALUES ('2371', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 12:20:00');
INSERT INTO `sys_job_log` VALUES ('2372', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 12:21:00');
INSERT INTO `sys_job_log` VALUES ('2373', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 12:22:00');
INSERT INTO `sys_job_log` VALUES ('2374', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 12:23:00');
INSERT INTO `sys_job_log` VALUES ('2375', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 12:24:00');
INSERT INTO `sys_job_log` VALUES ('2376', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 12:25:00');
INSERT INTO `sys_job_log` VALUES ('2377', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 12:26:00');
INSERT INTO `sys_job_log` VALUES ('2378', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 12:27:00');
INSERT INTO `sys_job_log` VALUES ('2379', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 12:28:00');
INSERT INTO `sys_job_log` VALUES ('2380', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 12:29:00');
INSERT INTO `sys_job_log` VALUES ('2381', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 12:30:00');
INSERT INTO `sys_job_log` VALUES ('2382', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 12:31:00');
INSERT INTO `sys_job_log` VALUES ('2383', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:32:00');
INSERT INTO `sys_job_log` VALUES ('2384', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 12:33:00');
INSERT INTO `sys_job_log` VALUES ('2385', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：26毫秒', '0', '', '2021-11-10 12:34:00');
INSERT INTO `sys_job_log` VALUES ('2386', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 12:35:00');
INSERT INTO `sys_job_log` VALUES ('2387', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 12:36:00');
INSERT INTO `sys_job_log` VALUES ('2388', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 12:37:00');
INSERT INTO `sys_job_log` VALUES ('2389', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 12:38:00');
INSERT INTO `sys_job_log` VALUES ('2390', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 12:39:00');
INSERT INTO `sys_job_log` VALUES ('2391', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 12:40:00');
INSERT INTO `sys_job_log` VALUES ('2392', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 12:41:00');
INSERT INTO `sys_job_log` VALUES ('2393', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 12:42:00');
INSERT INTO `sys_job_log` VALUES ('2394', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 12:43:00');
INSERT INTO `sys_job_log` VALUES ('2395', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 12:44:00');
INSERT INTO `sys_job_log` VALUES ('2396', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 12:45:00');
INSERT INTO `sys_job_log` VALUES ('2397', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 12:46:00');
INSERT INTO `sys_job_log` VALUES ('2398', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 12:47:00');
INSERT INTO `sys_job_log` VALUES ('2399', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 12:48:00');
INSERT INTO `sys_job_log` VALUES ('2400', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:49:00');
INSERT INTO `sys_job_log` VALUES ('2401', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 12:50:00');
INSERT INTO `sys_job_log` VALUES ('2402', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:51:00');
INSERT INTO `sys_job_log` VALUES ('2403', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:52:00');
INSERT INTO `sys_job_log` VALUES ('2404', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 12:53:00');
INSERT INTO `sys_job_log` VALUES ('2405', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:54:00');
INSERT INTO `sys_job_log` VALUES ('2406', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 12:55:00');
INSERT INTO `sys_job_log` VALUES ('2407', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:56:00');
INSERT INTO `sys_job_log` VALUES ('2408', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:57:00');
INSERT INTO `sys_job_log` VALUES ('2409', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:58:00');
INSERT INTO `sys_job_log` VALUES ('2410', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 12:59:00');
INSERT INTO `sys_job_log` VALUES ('2411', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 13:00:00');
INSERT INTO `sys_job_log` VALUES ('2412', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 13:01:00');
INSERT INTO `sys_job_log` VALUES ('2413', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 13:02:00');
INSERT INTO `sys_job_log` VALUES ('2414', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 13:03:00');
INSERT INTO `sys_job_log` VALUES ('2415', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:04:00');
INSERT INTO `sys_job_log` VALUES ('2416', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 13:05:00');
INSERT INTO `sys_job_log` VALUES ('2417', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:06:00');
INSERT INTO `sys_job_log` VALUES ('2418', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:07:00');
INSERT INTO `sys_job_log` VALUES ('2419', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:08:00');
INSERT INTO `sys_job_log` VALUES ('2420', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 13:09:00');
INSERT INTO `sys_job_log` VALUES ('2421', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:10:00');
INSERT INTO `sys_job_log` VALUES ('2422', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 13:11:00');
INSERT INTO `sys_job_log` VALUES ('2423', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 13:12:00');
INSERT INTO `sys_job_log` VALUES ('2424', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 13:13:00');
INSERT INTO `sys_job_log` VALUES ('2425', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 13:14:00');
INSERT INTO `sys_job_log` VALUES ('2426', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:15:00');
INSERT INTO `sys_job_log` VALUES ('2427', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:16:00');
INSERT INTO `sys_job_log` VALUES ('2428', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 13:17:00');
INSERT INTO `sys_job_log` VALUES ('2429', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 13:18:00');
INSERT INTO `sys_job_log` VALUES ('2430', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:19:00');
INSERT INTO `sys_job_log` VALUES ('2431', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:20:00');
INSERT INTO `sys_job_log` VALUES ('2432', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:21:00');
INSERT INTO `sys_job_log` VALUES ('2433', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 13:22:00');
INSERT INTO `sys_job_log` VALUES ('2434', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 13:23:00');
INSERT INTO `sys_job_log` VALUES ('2435', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:24:00');
INSERT INTO `sys_job_log` VALUES ('2436', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:25:00');
INSERT INTO `sys_job_log` VALUES ('2437', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 13:26:00');
INSERT INTO `sys_job_log` VALUES ('2438', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 13:27:00');
INSERT INTO `sys_job_log` VALUES ('2439', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 13:28:00');
INSERT INTO `sys_job_log` VALUES ('2440', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 13:29:00');
INSERT INTO `sys_job_log` VALUES ('2441', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 13:30:00');
INSERT INTO `sys_job_log` VALUES ('2442', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 13:31:00');
INSERT INTO `sys_job_log` VALUES ('2443', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:32:00');
INSERT INTO `sys_job_log` VALUES ('2444', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 13:33:00');
INSERT INTO `sys_job_log` VALUES ('2445', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 13:34:00');
INSERT INTO `sys_job_log` VALUES ('2446', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 13:35:00');
INSERT INTO `sys_job_log` VALUES ('2447', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 13:36:00');
INSERT INTO `sys_job_log` VALUES ('2448', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 13:37:00');
INSERT INTO `sys_job_log` VALUES ('2449', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 13:38:00');
INSERT INTO `sys_job_log` VALUES ('2450', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:39:00');
INSERT INTO `sys_job_log` VALUES ('2451', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 13:40:00');
INSERT INTO `sys_job_log` VALUES ('2452', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:41:00');
INSERT INTO `sys_job_log` VALUES ('2453', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 13:42:00');
INSERT INTO `sys_job_log` VALUES ('2454', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:43:00');
INSERT INTO `sys_job_log` VALUES ('2455', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 13:44:00');
INSERT INTO `sys_job_log` VALUES ('2456', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 13:45:00');
INSERT INTO `sys_job_log` VALUES ('2457', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 13:46:00');
INSERT INTO `sys_job_log` VALUES ('2458', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 13:47:00');
INSERT INTO `sys_job_log` VALUES ('2459', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 13:48:00');
INSERT INTO `sys_job_log` VALUES ('2460', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:49:00');
INSERT INTO `sys_job_log` VALUES ('2461', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 13:50:00');
INSERT INTO `sys_job_log` VALUES ('2462', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 13:51:00');
INSERT INTO `sys_job_log` VALUES ('2463', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:52:00');
INSERT INTO `sys_job_log` VALUES ('2464', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 13:53:00');
INSERT INTO `sys_job_log` VALUES ('2465', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:54:00');
INSERT INTO `sys_job_log` VALUES ('2466', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 13:55:00');
INSERT INTO `sys_job_log` VALUES ('2467', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:56:00');
INSERT INTO `sys_job_log` VALUES ('2468', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 13:57:00');
INSERT INTO `sys_job_log` VALUES ('2469', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 13:58:00');
INSERT INTO `sys_job_log` VALUES ('2470', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 13:59:00');
INSERT INTO `sys_job_log` VALUES ('2471', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:00:00');
INSERT INTO `sys_job_log` VALUES ('2472', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:01:00');
INSERT INTO `sys_job_log` VALUES ('2473', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 14:02:00');
INSERT INTO `sys_job_log` VALUES ('2474', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 14:03:00');
INSERT INTO `sys_job_log` VALUES ('2475', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 14:04:00');
INSERT INTO `sys_job_log` VALUES ('2476', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 14:05:00');
INSERT INTO `sys_job_log` VALUES ('2477', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 14:06:00');
INSERT INTO `sys_job_log` VALUES ('2478', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 14:07:00');
INSERT INTO `sys_job_log` VALUES ('2479', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 14:08:00');
INSERT INTO `sys_job_log` VALUES ('2480', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:09:00');
INSERT INTO `sys_job_log` VALUES ('2481', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-10 14:10:00');
INSERT INTO `sys_job_log` VALUES ('2482', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 14:11:00');
INSERT INTO `sys_job_log` VALUES ('2483', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 14:12:00');
INSERT INTO `sys_job_log` VALUES ('2484', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:13:00');
INSERT INTO `sys_job_log` VALUES ('2485', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 14:14:00');
INSERT INTO `sys_job_log` VALUES ('2486', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:15:00');
INSERT INTO `sys_job_log` VALUES ('2487', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 14:16:00');
INSERT INTO `sys_job_log` VALUES ('2488', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 14:17:00');
INSERT INTO `sys_job_log` VALUES ('2489', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 14:18:00');
INSERT INTO `sys_job_log` VALUES ('2490', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 14:19:00');
INSERT INTO `sys_job_log` VALUES ('2491', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 14:20:00');
INSERT INTO `sys_job_log` VALUES ('2492', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:21:00');
INSERT INTO `sys_job_log` VALUES ('2493', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 14:22:00');
INSERT INTO `sys_job_log` VALUES ('2494', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：53毫秒', '0', '', '2021-11-10 14:26:00');
INSERT INTO `sys_job_log` VALUES ('2495', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：89毫秒', '0', '', '2021-11-10 14:27:00');
INSERT INTO `sys_job_log` VALUES ('2496', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 14:28:00');
INSERT INTO `sys_job_log` VALUES ('2497', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:29:00');
INSERT INTO `sys_job_log` VALUES ('2498', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 14:30:00');
INSERT INTO `sys_job_log` VALUES ('2499', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 14:31:00');
INSERT INTO `sys_job_log` VALUES ('2500', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 14:32:00');
INSERT INTO `sys_job_log` VALUES ('2501', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 14:33:00');
INSERT INTO `sys_job_log` VALUES ('2502', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 14:34:00');
INSERT INTO `sys_job_log` VALUES ('2503', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:35:00');
INSERT INTO `sys_job_log` VALUES ('2504', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:36:00');
INSERT INTO `sys_job_log` VALUES ('2505', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:37:00');
INSERT INTO `sys_job_log` VALUES ('2506', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:38:00');
INSERT INTO `sys_job_log` VALUES ('2507', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:39:00');
INSERT INTO `sys_job_log` VALUES ('2508', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 14:40:00');
INSERT INTO `sys_job_log` VALUES ('2509', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 14:41:00');
INSERT INTO `sys_job_log` VALUES ('2510', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:42:00');
INSERT INTO `sys_job_log` VALUES ('2511', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:43:00');
INSERT INTO `sys_job_log` VALUES ('2512', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 14:44:00');
INSERT INTO `sys_job_log` VALUES ('2513', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 14:45:00');
INSERT INTO `sys_job_log` VALUES ('2514', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:46:00');
INSERT INTO `sys_job_log` VALUES ('2515', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 14:47:00');
INSERT INTO `sys_job_log` VALUES ('2516', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:48:00');
INSERT INTO `sys_job_log` VALUES ('2517', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 14:49:00');
INSERT INTO `sys_job_log` VALUES ('2518', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:50:00');
INSERT INTO `sys_job_log` VALUES ('2519', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:51:00');
INSERT INTO `sys_job_log` VALUES ('2520', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:52:00');
INSERT INTO `sys_job_log` VALUES ('2521', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:53:00');
INSERT INTO `sys_job_log` VALUES ('2522', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:54:00');
INSERT INTO `sys_job_log` VALUES ('2523', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 14:55:00');
INSERT INTO `sys_job_log` VALUES ('2524', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:56:00');
INSERT INTO `sys_job_log` VALUES ('2525', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:57:00');
INSERT INTO `sys_job_log` VALUES ('2526', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 14:58:00');
INSERT INTO `sys_job_log` VALUES ('2527', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 14:59:00');
INSERT INTO `sys_job_log` VALUES ('2528', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:00:00');
INSERT INTO `sys_job_log` VALUES ('2529', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:01:00');
INSERT INTO `sys_job_log` VALUES ('2530', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:02:00');
INSERT INTO `sys_job_log` VALUES ('2531', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:03:00');
INSERT INTO `sys_job_log` VALUES ('2532', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:04:00');
INSERT INTO `sys_job_log` VALUES ('2533', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:05:00');
INSERT INTO `sys_job_log` VALUES ('2534', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 15:06:00');
INSERT INTO `sys_job_log` VALUES ('2535', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 15:07:00');
INSERT INTO `sys_job_log` VALUES ('2536', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:08:00');
INSERT INTO `sys_job_log` VALUES ('2537', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:09:00');
INSERT INTO `sys_job_log` VALUES ('2538', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:10:00');
INSERT INTO `sys_job_log` VALUES ('2539', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 15:11:00');
INSERT INTO `sys_job_log` VALUES ('2540', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:12:00');
INSERT INTO `sys_job_log` VALUES ('2541', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:13:00');
INSERT INTO `sys_job_log` VALUES ('2542', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:14:00');
INSERT INTO `sys_job_log` VALUES ('2543', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 15:15:00');
INSERT INTO `sys_job_log` VALUES ('2544', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:16:00');
INSERT INTO `sys_job_log` VALUES ('2545', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:17:00');
INSERT INTO `sys_job_log` VALUES ('2546', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:18:00');
INSERT INTO `sys_job_log` VALUES ('2547', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:19:00');
INSERT INTO `sys_job_log` VALUES ('2548', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:20:00');
INSERT INTO `sys_job_log` VALUES ('2549', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:21:00');
INSERT INTO `sys_job_log` VALUES ('2550', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 15:22:00');
INSERT INTO `sys_job_log` VALUES ('2551', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:23:00');
INSERT INTO `sys_job_log` VALUES ('2552', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 15:24:00');
INSERT INTO `sys_job_log` VALUES ('2553', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 15:25:00');
INSERT INTO `sys_job_log` VALUES ('2554', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:26:00');
INSERT INTO `sys_job_log` VALUES ('2555', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:27:00');
INSERT INTO `sys_job_log` VALUES ('2556', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:28:00');
INSERT INTO `sys_job_log` VALUES ('2557', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 15:29:00');
INSERT INTO `sys_job_log` VALUES ('2558', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 15:30:00');
INSERT INTO `sys_job_log` VALUES ('2559', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:31:00');
INSERT INTO `sys_job_log` VALUES ('2560', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:32:00');
INSERT INTO `sys_job_log` VALUES ('2561', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:33:00');
INSERT INTO `sys_job_log` VALUES ('2562', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:34:00');
INSERT INTO `sys_job_log` VALUES ('2563', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:35:00');
INSERT INTO `sys_job_log` VALUES ('2564', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:36:00');
INSERT INTO `sys_job_log` VALUES ('2565', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:37:00');
INSERT INTO `sys_job_log` VALUES ('2566', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 15:38:00');
INSERT INTO `sys_job_log` VALUES ('2567', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:39:00');
INSERT INTO `sys_job_log` VALUES ('2568', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:40:00');
INSERT INTO `sys_job_log` VALUES ('2569', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:41:00');
INSERT INTO `sys_job_log` VALUES ('2570', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 15:42:00');
INSERT INTO `sys_job_log` VALUES ('2571', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:43:00');
INSERT INTO `sys_job_log` VALUES ('2572', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:44:00');
INSERT INTO `sys_job_log` VALUES ('2573', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 15:45:00');
INSERT INTO `sys_job_log` VALUES ('2574', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 15:46:00');
INSERT INTO `sys_job_log` VALUES ('2575', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 15:47:00');
INSERT INTO `sys_job_log` VALUES ('2576', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 15:48:00');
INSERT INTO `sys_job_log` VALUES ('2577', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:49:00');
INSERT INTO `sys_job_log` VALUES ('2578', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 15:50:00');
INSERT INTO `sys_job_log` VALUES ('2579', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 15:51:00');
INSERT INTO `sys_job_log` VALUES ('2580', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:52:00');
INSERT INTO `sys_job_log` VALUES ('2581', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:53:00');
INSERT INTO `sys_job_log` VALUES ('2582', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 15:54:00');
INSERT INTO `sys_job_log` VALUES ('2583', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:55:00');
INSERT INTO `sys_job_log` VALUES ('2584', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:56:00');
INSERT INTO `sys_job_log` VALUES ('2585', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:57:00');
INSERT INTO `sys_job_log` VALUES ('2586', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:58:00');
INSERT INTO `sys_job_log` VALUES ('2587', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 15:59:00');
INSERT INTO `sys_job_log` VALUES ('2588', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:00:00');
INSERT INTO `sys_job_log` VALUES ('2589', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 16:01:00');
INSERT INTO `sys_job_log` VALUES ('2590', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 16:02:00');
INSERT INTO `sys_job_log` VALUES ('2591', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:03:00');
INSERT INTO `sys_job_log` VALUES ('2592', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:04:00');
INSERT INTO `sys_job_log` VALUES ('2593', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 16:05:00');
INSERT INTO `sys_job_log` VALUES ('2594', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:06:00');
INSERT INTO `sys_job_log` VALUES ('2595', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:07:00');
INSERT INTO `sys_job_log` VALUES ('2596', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 16:08:00');
INSERT INTO `sys_job_log` VALUES ('2597', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:09:00');
INSERT INTO `sys_job_log` VALUES ('2598', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 16:10:00');
INSERT INTO `sys_job_log` VALUES ('2599', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 16:11:00');
INSERT INTO `sys_job_log` VALUES ('2600', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 16:12:00');
INSERT INTO `sys_job_log` VALUES ('2601', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:13:00');
INSERT INTO `sys_job_log` VALUES ('2602', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 16:14:00');
INSERT INTO `sys_job_log` VALUES ('2603', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:15:00');
INSERT INTO `sys_job_log` VALUES ('2604', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 16:16:00');
INSERT INTO `sys_job_log` VALUES ('2605', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 16:17:00');
INSERT INTO `sys_job_log` VALUES ('2606', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:18:00');
INSERT INTO `sys_job_log` VALUES ('2607', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 16:19:00');
INSERT INTO `sys_job_log` VALUES ('2608', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 16:20:00');
INSERT INTO `sys_job_log` VALUES ('2609', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:21:00');
INSERT INTO `sys_job_log` VALUES ('2610', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:22:00');
INSERT INTO `sys_job_log` VALUES ('2611', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 16:23:00');
INSERT INTO `sys_job_log` VALUES ('2612', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:24:00');
INSERT INTO `sys_job_log` VALUES ('2613', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 16:25:00');
INSERT INTO `sys_job_log` VALUES ('2614', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 16:26:00');
INSERT INTO `sys_job_log` VALUES ('2615', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 16:27:00');
INSERT INTO `sys_job_log` VALUES ('2616', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-10 16:28:00');
INSERT INTO `sys_job_log` VALUES ('2617', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:29:00');
INSERT INTO `sys_job_log` VALUES ('2618', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:30:00');
INSERT INTO `sys_job_log` VALUES ('2619', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:31:00');
INSERT INTO `sys_job_log` VALUES ('2620', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:32:00');
INSERT INTO `sys_job_log` VALUES ('2621', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 16:33:00');
INSERT INTO `sys_job_log` VALUES ('2622', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:34:00');
INSERT INTO `sys_job_log` VALUES ('2623', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 16:35:00');
INSERT INTO `sys_job_log` VALUES ('2624', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:36:00');
INSERT INTO `sys_job_log` VALUES ('2625', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 16:37:00');
INSERT INTO `sys_job_log` VALUES ('2626', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:38:00');
INSERT INTO `sys_job_log` VALUES ('2627', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 16:39:00');
INSERT INTO `sys_job_log` VALUES ('2628', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 16:40:00');
INSERT INTO `sys_job_log` VALUES ('2629', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 16:41:00');
INSERT INTO `sys_job_log` VALUES ('2630', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 16:42:00');
INSERT INTO `sys_job_log` VALUES ('2631', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 16:43:00');
INSERT INTO `sys_job_log` VALUES ('2632', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 16:44:00');
INSERT INTO `sys_job_log` VALUES ('2633', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 16:45:00');
INSERT INTO `sys_job_log` VALUES ('2634', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 16:46:00');
INSERT INTO `sys_job_log` VALUES ('2635', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 16:47:00');
INSERT INTO `sys_job_log` VALUES ('2636', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:48:00');
INSERT INTO `sys_job_log` VALUES ('2637', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:49:00');
INSERT INTO `sys_job_log` VALUES ('2638', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 16:50:00');
INSERT INTO `sys_job_log` VALUES ('2639', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 16:51:00');
INSERT INTO `sys_job_log` VALUES ('2640', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 16:52:00');
INSERT INTO `sys_job_log` VALUES ('2641', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:53:00');
INSERT INTO `sys_job_log` VALUES ('2642', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 16:54:00');
INSERT INTO `sys_job_log` VALUES ('2643', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:55:00');
INSERT INTO `sys_job_log` VALUES ('2644', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:56:00');
INSERT INTO `sys_job_log` VALUES ('2645', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 16:57:00');
INSERT INTO `sys_job_log` VALUES ('2646', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 16:58:00');
INSERT INTO `sys_job_log` VALUES ('2647', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 16:59:00');
INSERT INTO `sys_job_log` VALUES ('2648', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 17:00:00');
INSERT INTO `sys_job_log` VALUES ('2649', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 17:01:00');
INSERT INTO `sys_job_log` VALUES ('2650', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:02:00');
INSERT INTO `sys_job_log` VALUES ('2651', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:03:00');
INSERT INTO `sys_job_log` VALUES ('2652', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 17:04:00');
INSERT INTO `sys_job_log` VALUES ('2653', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:05:00');
INSERT INTO `sys_job_log` VALUES ('2654', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 17:06:00');
INSERT INTO `sys_job_log` VALUES ('2655', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:07:00');
INSERT INTO `sys_job_log` VALUES ('2656', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:08:00');
INSERT INTO `sys_job_log` VALUES ('2657', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:09:00');
INSERT INTO `sys_job_log` VALUES ('2658', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:10:00');
INSERT INTO `sys_job_log` VALUES ('2659', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:11:00');
INSERT INTO `sys_job_log` VALUES ('2660', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:12:00');
INSERT INTO `sys_job_log` VALUES ('2661', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 17:13:00');
INSERT INTO `sys_job_log` VALUES ('2662', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:14:00');
INSERT INTO `sys_job_log` VALUES ('2663', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 17:15:00');
INSERT INTO `sys_job_log` VALUES ('2664', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 17:16:00');
INSERT INTO `sys_job_log` VALUES ('2665', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 17:17:00');
INSERT INTO `sys_job_log` VALUES ('2666', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:18:00');
INSERT INTO `sys_job_log` VALUES ('2667', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:19:00');
INSERT INTO `sys_job_log` VALUES ('2668', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:20:00');
INSERT INTO `sys_job_log` VALUES ('2669', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:21:00');
INSERT INTO `sys_job_log` VALUES ('2670', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:22:00');
INSERT INTO `sys_job_log` VALUES ('2671', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:23:00');
INSERT INTO `sys_job_log` VALUES ('2672', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 17:24:00');
INSERT INTO `sys_job_log` VALUES ('2673', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:25:00');
INSERT INTO `sys_job_log` VALUES ('2674', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:26:00');
INSERT INTO `sys_job_log` VALUES ('2675', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:27:00');
INSERT INTO `sys_job_log` VALUES ('2676', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:28:00');
INSERT INTO `sys_job_log` VALUES ('2677', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:29:00');
INSERT INTO `sys_job_log` VALUES ('2678', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:30:00');
INSERT INTO `sys_job_log` VALUES ('2679', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:31:00');
INSERT INTO `sys_job_log` VALUES ('2680', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:32:00');
INSERT INTO `sys_job_log` VALUES ('2681', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:33:00');
INSERT INTO `sys_job_log` VALUES ('2682', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:34:00');
INSERT INTO `sys_job_log` VALUES ('2683', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:35:00');
INSERT INTO `sys_job_log` VALUES ('2684', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:36:00');
INSERT INTO `sys_job_log` VALUES ('2685', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:37:00');
INSERT INTO `sys_job_log` VALUES ('2686', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:38:00');
INSERT INTO `sys_job_log` VALUES ('2687', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 17:39:00');
INSERT INTO `sys_job_log` VALUES ('2688', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 17:40:00');
INSERT INTO `sys_job_log` VALUES ('2689', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 17:41:00');
INSERT INTO `sys_job_log` VALUES ('2690', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 17:42:00');
INSERT INTO `sys_job_log` VALUES ('2691', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 17:43:00');
INSERT INTO `sys_job_log` VALUES ('2692', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 17:44:00');
INSERT INTO `sys_job_log` VALUES ('2693', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 17:45:00');
INSERT INTO `sys_job_log` VALUES ('2694', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 17:46:00');
INSERT INTO `sys_job_log` VALUES ('2695', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 17:47:00');
INSERT INTO `sys_job_log` VALUES ('2696', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:48:00');
INSERT INTO `sys_job_log` VALUES ('2697', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 17:49:00');
INSERT INTO `sys_job_log` VALUES ('2698', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 17:50:00');
INSERT INTO `sys_job_log` VALUES ('2699', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:51:00');
INSERT INTO `sys_job_log` VALUES ('2700', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:52:00');
INSERT INTO `sys_job_log` VALUES ('2701', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 17:53:00');
INSERT INTO `sys_job_log` VALUES ('2702', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-10 17:54:00');
INSERT INTO `sys_job_log` VALUES ('2703', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 17:55:00');
INSERT INTO `sys_job_log` VALUES ('2704', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 17:56:00');
INSERT INTO `sys_job_log` VALUES ('2705', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 17:57:00');
INSERT INTO `sys_job_log` VALUES ('2706', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 17:58:00');
INSERT INTO `sys_job_log` VALUES ('2707', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 17:59:00');
INSERT INTO `sys_job_log` VALUES ('2708', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:00:00');
INSERT INTO `sys_job_log` VALUES ('2709', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 18:01:00');
INSERT INTO `sys_job_log` VALUES ('2710', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 18:02:00');
INSERT INTO `sys_job_log` VALUES ('2711', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 18:03:00');
INSERT INTO `sys_job_log` VALUES ('2712', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 18:04:00');
INSERT INTO `sys_job_log` VALUES ('2713', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 18:05:00');
INSERT INTO `sys_job_log` VALUES ('2714', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 18:06:00');
INSERT INTO `sys_job_log` VALUES ('2715', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:07:00');
INSERT INTO `sys_job_log` VALUES ('2716', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 18:08:00');
INSERT INTO `sys_job_log` VALUES ('2717', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 18:09:00');
INSERT INTO `sys_job_log` VALUES ('2718', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 18:10:00');
INSERT INTO `sys_job_log` VALUES ('2719', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 18:11:00');
INSERT INTO `sys_job_log` VALUES ('2720', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 18:12:00');
INSERT INTO `sys_job_log` VALUES ('2721', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:13:00');
INSERT INTO `sys_job_log` VALUES ('2722', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 18:14:00');
INSERT INTO `sys_job_log` VALUES ('2723', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 18:15:00');
INSERT INTO `sys_job_log` VALUES ('2724', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 18:16:00');
INSERT INTO `sys_job_log` VALUES ('2725', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 18:17:00');
INSERT INTO `sys_job_log` VALUES ('2726', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:18:00');
INSERT INTO `sys_job_log` VALUES ('2727', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 18:19:00');
INSERT INTO `sys_job_log` VALUES ('2728', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:20:00');
INSERT INTO `sys_job_log` VALUES ('2729', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 18:21:00');
INSERT INTO `sys_job_log` VALUES ('2730', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 18:22:00');
INSERT INTO `sys_job_log` VALUES ('2731', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 18:23:00');
INSERT INTO `sys_job_log` VALUES ('2732', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 18:24:00');
INSERT INTO `sys_job_log` VALUES ('2733', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:25:00');
INSERT INTO `sys_job_log` VALUES ('2734', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 18:26:00');
INSERT INTO `sys_job_log` VALUES ('2735', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 18:27:00');
INSERT INTO `sys_job_log` VALUES ('2736', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 18:28:00');
INSERT INTO `sys_job_log` VALUES ('2737', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 18:29:00');
INSERT INTO `sys_job_log` VALUES ('2738', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 18:30:00');
INSERT INTO `sys_job_log` VALUES ('2739', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 18:31:00');
INSERT INTO `sys_job_log` VALUES ('2740', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:32:00');
INSERT INTO `sys_job_log` VALUES ('2741', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 18:33:00');
INSERT INTO `sys_job_log` VALUES ('2742', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 18:34:00');
INSERT INTO `sys_job_log` VALUES ('2743', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 18:35:00');
INSERT INTO `sys_job_log` VALUES ('2744', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 18:36:00');
INSERT INTO `sys_job_log` VALUES ('2745', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 18:37:00');
INSERT INTO `sys_job_log` VALUES ('2746', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 18:38:00');
INSERT INTO `sys_job_log` VALUES ('2747', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 18:39:00');
INSERT INTO `sys_job_log` VALUES ('2748', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 18:40:00');
INSERT INTO `sys_job_log` VALUES ('2749', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 18:41:00');
INSERT INTO `sys_job_log` VALUES ('2750', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 18:42:00');
INSERT INTO `sys_job_log` VALUES ('2751', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 18:43:00');
INSERT INTO `sys_job_log` VALUES ('2752', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 18:44:00');
INSERT INTO `sys_job_log` VALUES ('2753', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 18:45:00');
INSERT INTO `sys_job_log` VALUES ('2754', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 18:46:00');
INSERT INTO `sys_job_log` VALUES ('2755', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 18:47:00');
INSERT INTO `sys_job_log` VALUES ('2756', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 18:48:00');
INSERT INTO `sys_job_log` VALUES ('2757', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 18:49:00');
INSERT INTO `sys_job_log` VALUES ('2758', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 18:50:00');
INSERT INTO `sys_job_log` VALUES ('2759', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 18:51:00');
INSERT INTO `sys_job_log` VALUES ('2760', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 18:52:00');
INSERT INTO `sys_job_log` VALUES ('2761', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 18:53:00');
INSERT INTO `sys_job_log` VALUES ('2762', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 18:54:00');
INSERT INTO `sys_job_log` VALUES ('2763', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 18:55:00');
INSERT INTO `sys_job_log` VALUES ('2764', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 18:56:00');
INSERT INTO `sys_job_log` VALUES ('2765', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 18:57:00');
INSERT INTO `sys_job_log` VALUES ('2766', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 18:58:00');
INSERT INTO `sys_job_log` VALUES ('2767', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 18:59:00');
INSERT INTO `sys_job_log` VALUES ('2768', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:00:00');
INSERT INTO `sys_job_log` VALUES ('2769', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 19:01:00');
INSERT INTO `sys_job_log` VALUES ('2770', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 19:02:00');
INSERT INTO `sys_job_log` VALUES ('2771', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 19:03:00');
INSERT INTO `sys_job_log` VALUES ('2772', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 19:04:00');
INSERT INTO `sys_job_log` VALUES ('2773', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 19:05:00');
INSERT INTO `sys_job_log` VALUES ('2774', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:06:00');
INSERT INTO `sys_job_log` VALUES ('2775', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:07:00');
INSERT INTO `sys_job_log` VALUES ('2776', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 19:08:00');
INSERT INTO `sys_job_log` VALUES ('2777', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 19:09:00');
INSERT INTO `sys_job_log` VALUES ('2778', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 19:10:00');
INSERT INTO `sys_job_log` VALUES ('2779', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:11:00');
INSERT INTO `sys_job_log` VALUES ('2780', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 19:12:00');
INSERT INTO `sys_job_log` VALUES ('2781', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 19:13:00');
INSERT INTO `sys_job_log` VALUES ('2782', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 19:14:00');
INSERT INTO `sys_job_log` VALUES ('2783', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 19:15:00');
INSERT INTO `sys_job_log` VALUES ('2784', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:16:00');
INSERT INTO `sys_job_log` VALUES ('2785', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 19:17:00');
INSERT INTO `sys_job_log` VALUES ('2786', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:18:00');
INSERT INTO `sys_job_log` VALUES ('2787', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 19:19:00');
INSERT INTO `sys_job_log` VALUES ('2788', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 19:20:00');
INSERT INTO `sys_job_log` VALUES ('2789', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 19:21:00');
INSERT INTO `sys_job_log` VALUES ('2790', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 19:22:00');
INSERT INTO `sys_job_log` VALUES ('2791', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 19:23:00');
INSERT INTO `sys_job_log` VALUES ('2792', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 19:24:00');
INSERT INTO `sys_job_log` VALUES ('2793', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 19:25:00');
INSERT INTO `sys_job_log` VALUES ('2794', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:26:00');
INSERT INTO `sys_job_log` VALUES ('2795', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:27:00');
INSERT INTO `sys_job_log` VALUES ('2796', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 19:28:00');
INSERT INTO `sys_job_log` VALUES ('2797', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 19:29:00');
INSERT INTO `sys_job_log` VALUES ('2798', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 19:30:00');
INSERT INTO `sys_job_log` VALUES ('2799', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:31:00');
INSERT INTO `sys_job_log` VALUES ('2800', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:32:00');
INSERT INTO `sys_job_log` VALUES ('2801', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:33:00');
INSERT INTO `sys_job_log` VALUES ('2802', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 19:34:00');
INSERT INTO `sys_job_log` VALUES ('2803', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 19:35:00');
INSERT INTO `sys_job_log` VALUES ('2804', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 19:36:00');
INSERT INTO `sys_job_log` VALUES ('2805', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:37:00');
INSERT INTO `sys_job_log` VALUES ('2806', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:38:00');
INSERT INTO `sys_job_log` VALUES ('2807', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:39:00');
INSERT INTO `sys_job_log` VALUES ('2808', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 19:40:00');
INSERT INTO `sys_job_log` VALUES ('2809', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 19:41:00');
INSERT INTO `sys_job_log` VALUES ('2810', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 19:42:00');
INSERT INTO `sys_job_log` VALUES ('2811', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 19:43:00');
INSERT INTO `sys_job_log` VALUES ('2812', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 19:44:00');
INSERT INTO `sys_job_log` VALUES ('2813', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 19:45:00');
INSERT INTO `sys_job_log` VALUES ('2814', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 19:46:00');
INSERT INTO `sys_job_log` VALUES ('2815', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 19:47:00');
INSERT INTO `sys_job_log` VALUES ('2816', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 19:48:00');
INSERT INTO `sys_job_log` VALUES ('2817', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:49:00');
INSERT INTO `sys_job_log` VALUES ('2818', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:50:00');
INSERT INTO `sys_job_log` VALUES ('2819', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:51:00');
INSERT INTO `sys_job_log` VALUES ('2820', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 19:52:00');
INSERT INTO `sys_job_log` VALUES ('2821', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 19:53:00');
INSERT INTO `sys_job_log` VALUES ('2822', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:54:00');
INSERT INTO `sys_job_log` VALUES ('2823', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 19:55:00');
INSERT INTO `sys_job_log` VALUES ('2824', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 19:56:00');
INSERT INTO `sys_job_log` VALUES ('2825', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 19:57:00');
INSERT INTO `sys_job_log` VALUES ('2826', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 19:58:00');
INSERT INTO `sys_job_log` VALUES ('2827', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 19:59:00');
INSERT INTO `sys_job_log` VALUES ('2828', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:00:00');
INSERT INTO `sys_job_log` VALUES ('2829', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 20:01:00');
INSERT INTO `sys_job_log` VALUES ('2830', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 20:02:00');
INSERT INTO `sys_job_log` VALUES ('2831', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:03:00');
INSERT INTO `sys_job_log` VALUES ('2832', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 20:04:00');
INSERT INTO `sys_job_log` VALUES ('2833', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:05:00');
INSERT INTO `sys_job_log` VALUES ('2834', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 20:06:00');
INSERT INTO `sys_job_log` VALUES ('2835', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 20:07:00');
INSERT INTO `sys_job_log` VALUES ('2836', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 20:08:00');
INSERT INTO `sys_job_log` VALUES ('2837', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 20:09:00');
INSERT INTO `sys_job_log` VALUES ('2838', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 20:10:00');
INSERT INTO `sys_job_log` VALUES ('2839', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 20:11:00');
INSERT INTO `sys_job_log` VALUES ('2840', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:12:00');
INSERT INTO `sys_job_log` VALUES ('2841', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 20:13:00');
INSERT INTO `sys_job_log` VALUES ('2842', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:14:00');
INSERT INTO `sys_job_log` VALUES ('2843', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:15:00');
INSERT INTO `sys_job_log` VALUES ('2844', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 20:16:00');
INSERT INTO `sys_job_log` VALUES ('2845', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 20:17:00');
INSERT INTO `sys_job_log` VALUES ('2846', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 20:18:00');
INSERT INTO `sys_job_log` VALUES ('2847', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 20:19:00');
INSERT INTO `sys_job_log` VALUES ('2848', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:20:00');
INSERT INTO `sys_job_log` VALUES ('2849', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 20:21:00');
INSERT INTO `sys_job_log` VALUES ('2850', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 20:22:00');
INSERT INTO `sys_job_log` VALUES ('2851', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 20:23:00');
INSERT INTO `sys_job_log` VALUES ('2852', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 20:24:00');
INSERT INTO `sys_job_log` VALUES ('2853', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 20:25:00');
INSERT INTO `sys_job_log` VALUES ('2854', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 20:26:00');
INSERT INTO `sys_job_log` VALUES ('2855', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 20:27:00');
INSERT INTO `sys_job_log` VALUES ('2856', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 20:28:00');
INSERT INTO `sys_job_log` VALUES ('2857', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:29:00');
INSERT INTO `sys_job_log` VALUES ('2858', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 20:30:00');
INSERT INTO `sys_job_log` VALUES ('2859', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 20:31:00');
INSERT INTO `sys_job_log` VALUES ('2860', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 20:32:00');
INSERT INTO `sys_job_log` VALUES ('2861', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:33:00');
INSERT INTO `sys_job_log` VALUES ('2862', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-10 20:34:00');
INSERT INTO `sys_job_log` VALUES ('2863', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:35:00');
INSERT INTO `sys_job_log` VALUES ('2864', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:36:00');
INSERT INTO `sys_job_log` VALUES ('2865', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-10 20:37:00');
INSERT INTO `sys_job_log` VALUES ('2866', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:38:00');
INSERT INTO `sys_job_log` VALUES ('2867', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:39:00');
INSERT INTO `sys_job_log` VALUES ('2868', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:40:00');
INSERT INTO `sys_job_log` VALUES ('2869', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 20:41:00');
INSERT INTO `sys_job_log` VALUES ('2870', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:42:00');
INSERT INTO `sys_job_log` VALUES ('2871', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:43:00');
INSERT INTO `sys_job_log` VALUES ('2872', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 20:44:00');
INSERT INTO `sys_job_log` VALUES ('2873', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 20:45:00');
INSERT INTO `sys_job_log` VALUES ('2874', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 20:46:00');
INSERT INTO `sys_job_log` VALUES ('2875', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 20:47:00');
INSERT INTO `sys_job_log` VALUES ('2876', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 20:48:00');
INSERT INTO `sys_job_log` VALUES ('2877', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-10 20:49:00');
INSERT INTO `sys_job_log` VALUES ('2878', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 20:50:00');
INSERT INTO `sys_job_log` VALUES ('2879', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 20:51:00');
INSERT INTO `sys_job_log` VALUES ('2880', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:52:00');
INSERT INTO `sys_job_log` VALUES ('2881', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 20:53:00');
INSERT INTO `sys_job_log` VALUES ('2882', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:54:00');
INSERT INTO `sys_job_log` VALUES ('2883', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:55:00');
INSERT INTO `sys_job_log` VALUES ('2884', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 20:56:00');
INSERT INTO `sys_job_log` VALUES ('2885', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 20:57:00');
INSERT INTO `sys_job_log` VALUES ('2886', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:58:00');
INSERT INTO `sys_job_log` VALUES ('2887', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 20:59:00');
INSERT INTO `sys_job_log` VALUES ('2888', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:00:00');
INSERT INTO `sys_job_log` VALUES ('2889', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:01:00');
INSERT INTO `sys_job_log` VALUES ('2890', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:02:00');
INSERT INTO `sys_job_log` VALUES ('2891', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:03:00');
INSERT INTO `sys_job_log` VALUES ('2892', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:04:00');
INSERT INTO `sys_job_log` VALUES ('2893', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:05:00');
INSERT INTO `sys_job_log` VALUES ('2894', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:06:00');
INSERT INTO `sys_job_log` VALUES ('2895', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:07:00');
INSERT INTO `sys_job_log` VALUES ('2896', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:08:00');
INSERT INTO `sys_job_log` VALUES ('2897', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 21:09:00');
INSERT INTO `sys_job_log` VALUES ('2898', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:10:00');
INSERT INTO `sys_job_log` VALUES ('2899', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:11:00');
INSERT INTO `sys_job_log` VALUES ('2900', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 21:12:00');
INSERT INTO `sys_job_log` VALUES ('2901', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:13:00');
INSERT INTO `sys_job_log` VALUES ('2902', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 21:14:00');
INSERT INTO `sys_job_log` VALUES ('2903', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:15:00');
INSERT INTO `sys_job_log` VALUES ('2904', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 21:16:00');
INSERT INTO `sys_job_log` VALUES ('2905', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:17:00');
INSERT INTO `sys_job_log` VALUES ('2906', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:18:00');
INSERT INTO `sys_job_log` VALUES ('2907', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 21:19:00');
INSERT INTO `sys_job_log` VALUES ('2908', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 21:20:00');
INSERT INTO `sys_job_log` VALUES ('2909', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 21:21:00');
INSERT INTO `sys_job_log` VALUES ('2910', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:22:00');
INSERT INTO `sys_job_log` VALUES ('2911', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:23:00');
INSERT INTO `sys_job_log` VALUES ('2912', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 21:24:00');
INSERT INTO `sys_job_log` VALUES ('2913', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：50毫秒', '0', '', '2021-11-10 21:26:00');
INSERT INTO `sys_job_log` VALUES ('2914', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 21:27:00');
INSERT INTO `sys_job_log` VALUES ('2915', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 21:28:00');
INSERT INTO `sys_job_log` VALUES ('2916', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 21:29:00');
INSERT INTO `sys_job_log` VALUES ('2917', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 21:30:00');
INSERT INTO `sys_job_log` VALUES ('2918', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:31:00');
INSERT INTO `sys_job_log` VALUES ('2919', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 21:32:00');
INSERT INTO `sys_job_log` VALUES ('2920', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 21:33:00');
INSERT INTO `sys_job_log` VALUES ('2921', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:34:00');
INSERT INTO `sys_job_log` VALUES ('2922', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 21:35:00');
INSERT INTO `sys_job_log` VALUES ('2923', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:36:00');
INSERT INTO `sys_job_log` VALUES ('2924', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:37:00');
INSERT INTO `sys_job_log` VALUES ('2925', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:38:00');
INSERT INTO `sys_job_log` VALUES ('2926', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:39:00');
INSERT INTO `sys_job_log` VALUES ('2927', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:40:00');
INSERT INTO `sys_job_log` VALUES ('2928', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 21:41:00');
INSERT INTO `sys_job_log` VALUES ('2929', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 21:42:00');
INSERT INTO `sys_job_log` VALUES ('2930', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 21:43:00');
INSERT INTO `sys_job_log` VALUES ('2931', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:44:00');
INSERT INTO `sys_job_log` VALUES ('2932', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 21:45:00');
INSERT INTO `sys_job_log` VALUES ('2933', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 21:46:00');
INSERT INTO `sys_job_log` VALUES ('2934', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:47:00');
INSERT INTO `sys_job_log` VALUES ('2935', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:48:00');
INSERT INTO `sys_job_log` VALUES ('2936', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:49:00');
INSERT INTO `sys_job_log` VALUES ('2937', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 21:50:00');
INSERT INTO `sys_job_log` VALUES ('2938', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:51:00');
INSERT INTO `sys_job_log` VALUES ('2939', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 21:52:00');
INSERT INTO `sys_job_log` VALUES ('2940', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:53:00');
INSERT INTO `sys_job_log` VALUES ('2941', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:54:00');
INSERT INTO `sys_job_log` VALUES ('2942', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 21:55:00');
INSERT INTO `sys_job_log` VALUES ('2943', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 21:56:00');
INSERT INTO `sys_job_log` VALUES ('2944', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 21:57:00');
INSERT INTO `sys_job_log` VALUES ('2945', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 21:58:00');
INSERT INTO `sys_job_log` VALUES ('2946', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 21:59:00');
INSERT INTO `sys_job_log` VALUES ('2947', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:00:00');
INSERT INTO `sys_job_log` VALUES ('2948', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 22:01:00');
INSERT INTO `sys_job_log` VALUES ('2949', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:02:00');
INSERT INTO `sys_job_log` VALUES ('2950', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 22:03:00');
INSERT INTO `sys_job_log` VALUES ('2951', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:04:00');
INSERT INTO `sys_job_log` VALUES ('2952', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 22:05:00');
INSERT INTO `sys_job_log` VALUES ('2953', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-10 22:06:00');
INSERT INTO `sys_job_log` VALUES ('2954', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:07:00');
INSERT INTO `sys_job_log` VALUES ('2955', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 22:08:00');
INSERT INTO `sys_job_log` VALUES ('2956', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:09:00');
INSERT INTO `sys_job_log` VALUES ('2957', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:10:00');
INSERT INTO `sys_job_log` VALUES ('2958', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 22:11:00');
INSERT INTO `sys_job_log` VALUES ('2959', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:12:00');
INSERT INTO `sys_job_log` VALUES ('2960', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 22:13:00');
INSERT INTO `sys_job_log` VALUES ('2961', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:14:00');
INSERT INTO `sys_job_log` VALUES ('2962', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:15:00');
INSERT INTO `sys_job_log` VALUES ('2963', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-10 22:16:00');
INSERT INTO `sys_job_log` VALUES ('2964', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:17:00');
INSERT INTO `sys_job_log` VALUES ('2965', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 22:18:00');
INSERT INTO `sys_job_log` VALUES ('2966', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:19:00');
INSERT INTO `sys_job_log` VALUES ('2967', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:20:00');
INSERT INTO `sys_job_log` VALUES ('2968', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:21:00');
INSERT INTO `sys_job_log` VALUES ('2969', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 22:22:00');
INSERT INTO `sys_job_log` VALUES ('2970', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:23:00');
INSERT INTO `sys_job_log` VALUES ('2971', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:24:00');
INSERT INTO `sys_job_log` VALUES ('2972', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:25:00');
INSERT INTO `sys_job_log` VALUES ('2973', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:26:00');
INSERT INTO `sys_job_log` VALUES ('2974', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:27:00');
INSERT INTO `sys_job_log` VALUES ('2975', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:28:00');
INSERT INTO `sys_job_log` VALUES ('2976', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:29:00');
INSERT INTO `sys_job_log` VALUES ('2977', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:30:00');
INSERT INTO `sys_job_log` VALUES ('2978', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 22:31:00');
INSERT INTO `sys_job_log` VALUES ('2979', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:32:00');
INSERT INTO `sys_job_log` VALUES ('2980', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:33:00');
INSERT INTO `sys_job_log` VALUES ('2981', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:34:00');
INSERT INTO `sys_job_log` VALUES ('2982', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 22:35:00');
INSERT INTO `sys_job_log` VALUES ('2983', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:36:00');
INSERT INTO `sys_job_log` VALUES ('2984', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:37:00');
INSERT INTO `sys_job_log` VALUES ('2985', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:38:00');
INSERT INTO `sys_job_log` VALUES ('2986', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 22:39:00');
INSERT INTO `sys_job_log` VALUES ('2987', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:40:00');
INSERT INTO `sys_job_log` VALUES ('2988', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 22:41:00');
INSERT INTO `sys_job_log` VALUES ('2989', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 22:42:00');
INSERT INTO `sys_job_log` VALUES ('2990', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:43:00');
INSERT INTO `sys_job_log` VALUES ('2991', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 22:44:00');
INSERT INTO `sys_job_log` VALUES ('2992', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 22:45:00');
INSERT INTO `sys_job_log` VALUES ('2993', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 22:46:00');
INSERT INTO `sys_job_log` VALUES ('2994', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 22:47:00');
INSERT INTO `sys_job_log` VALUES ('2995', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 22:48:00');
INSERT INTO `sys_job_log` VALUES ('2996', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 22:49:00');
INSERT INTO `sys_job_log` VALUES ('2997', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 22:50:00');
INSERT INTO `sys_job_log` VALUES ('2998', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:51:00');
INSERT INTO `sys_job_log` VALUES ('2999', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:52:00');
INSERT INTO `sys_job_log` VALUES ('3000', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 22:53:00');
INSERT INTO `sys_job_log` VALUES ('3001', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-10 22:54:00');
INSERT INTO `sys_job_log` VALUES ('3002', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 22:55:00');
INSERT INTO `sys_job_log` VALUES ('3003', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 22:56:00');
INSERT INTO `sys_job_log` VALUES ('3004', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 22:57:00');
INSERT INTO `sys_job_log` VALUES ('3005', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 22:58:00');
INSERT INTO `sys_job_log` VALUES ('3006', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-10 22:59:00');
INSERT INTO `sys_job_log` VALUES ('3007', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 23:00:00');
INSERT INTO `sys_job_log` VALUES ('3008', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 23:01:00');
INSERT INTO `sys_job_log` VALUES ('3009', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:02:00');
INSERT INTO `sys_job_log` VALUES ('3010', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 23:03:00');
INSERT INTO `sys_job_log` VALUES ('3011', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-10 23:04:00');
INSERT INTO `sys_job_log` VALUES ('3012', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 23:05:00');
INSERT INTO `sys_job_log` VALUES ('3013', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:06:00');
INSERT INTO `sys_job_log` VALUES ('3014', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:07:00');
INSERT INTO `sys_job_log` VALUES ('3015', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:08:00');
INSERT INTO `sys_job_log` VALUES ('3016', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 23:09:00');
INSERT INTO `sys_job_log` VALUES ('3017', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-10 23:10:00');
INSERT INTO `sys_job_log` VALUES ('3018', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 23:11:00');
INSERT INTO `sys_job_log` VALUES ('3019', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-10 23:12:00');
INSERT INTO `sys_job_log` VALUES ('3020', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 23:13:00');
INSERT INTO `sys_job_log` VALUES ('3021', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-10 23:14:00');
INSERT INTO `sys_job_log` VALUES ('3022', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-10 23:15:00');
INSERT INTO `sys_job_log` VALUES ('3023', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-10 23:16:00');
INSERT INTO `sys_job_log` VALUES ('3024', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:17:00');
INSERT INTO `sys_job_log` VALUES ('3025', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:18:00');
INSERT INTO `sys_job_log` VALUES ('3026', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-10 23:19:00');
INSERT INTO `sys_job_log` VALUES ('3027', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:20:00');
INSERT INTO `sys_job_log` VALUES ('3028', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-10 23:21:00');
INSERT INTO `sys_job_log` VALUES ('3029', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 23:22:00');
INSERT INTO `sys_job_log` VALUES ('3030', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:23:00');
INSERT INTO `sys_job_log` VALUES ('3031', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:24:00');
INSERT INTO `sys_job_log` VALUES ('3032', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:25:00');
INSERT INTO `sys_job_log` VALUES ('3033', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:26:00');
INSERT INTO `sys_job_log` VALUES ('3034', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 23:27:00');
INSERT INTO `sys_job_log` VALUES ('3035', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 23:28:00');
INSERT INTO `sys_job_log` VALUES ('3036', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 23:29:00');
INSERT INTO `sys_job_log` VALUES ('3037', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:30:00');
INSERT INTO `sys_job_log` VALUES ('3038', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:31:00');
INSERT INTO `sys_job_log` VALUES ('3039', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:32:00');
INSERT INTO `sys_job_log` VALUES ('3040', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:33:00');
INSERT INTO `sys_job_log` VALUES ('3041', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 23:34:00');
INSERT INTO `sys_job_log` VALUES ('3042', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:35:00');
INSERT INTO `sys_job_log` VALUES ('3043', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 23:36:00');
INSERT INTO `sys_job_log` VALUES ('3044', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 23:37:00');
INSERT INTO `sys_job_log` VALUES ('3045', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 23:38:00');
INSERT INTO `sys_job_log` VALUES ('3046', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 23:39:00');
INSERT INTO `sys_job_log` VALUES ('3047', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 23:40:00');
INSERT INTO `sys_job_log` VALUES ('3048', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 23:41:00');
INSERT INTO `sys_job_log` VALUES ('3049', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 23:42:00');
INSERT INTO `sys_job_log` VALUES ('3050', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:43:00');
INSERT INTO `sys_job_log` VALUES ('3051', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 23:44:00');
INSERT INTO `sys_job_log` VALUES ('3052', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 23:45:00');
INSERT INTO `sys_job_log` VALUES ('3053', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 23:46:00');
INSERT INTO `sys_job_log` VALUES ('3054', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:47:00');
INSERT INTO `sys_job_log` VALUES ('3055', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-10 23:48:00');
INSERT INTO `sys_job_log` VALUES ('3056', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 23:49:00');
INSERT INTO `sys_job_log` VALUES ('3057', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-10 23:50:00');
INSERT INTO `sys_job_log` VALUES ('3058', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-10 23:51:00');
INSERT INTO `sys_job_log` VALUES ('3059', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 23:52:00');
INSERT INTO `sys_job_log` VALUES ('3060', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-10 23:53:00');
INSERT INTO `sys_job_log` VALUES ('3061', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-10 23:54:00');
INSERT INTO `sys_job_log` VALUES ('3062', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-10 23:55:00');
INSERT INTO `sys_job_log` VALUES ('3063', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-10 23:56:00');
INSERT INTO `sys_job_log` VALUES ('3064', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-10 23:57:00');
INSERT INTO `sys_job_log` VALUES ('3065', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-10 23:58:00');
INSERT INTO `sys_job_log` VALUES ('3066', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-10 23:59:00');
INSERT INTO `sys_job_log` VALUES ('3067', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 00:00:00');
INSERT INTO `sys_job_log` VALUES ('3068', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 00:01:00');
INSERT INTO `sys_job_log` VALUES ('3069', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 00:02:00');
INSERT INTO `sys_job_log` VALUES ('3070', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 00:03:00');
INSERT INTO `sys_job_log` VALUES ('3071', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:04:00');
INSERT INTO `sys_job_log` VALUES ('3072', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 00:05:00');
INSERT INTO `sys_job_log` VALUES ('3073', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：40毫秒', '0', '', '2021-11-11 00:06:00');
INSERT INTO `sys_job_log` VALUES ('3074', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 00:07:00');
INSERT INTO `sys_job_log` VALUES ('3075', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 00:08:00');
INSERT INTO `sys_job_log` VALUES ('3076', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 00:09:00');
INSERT INTO `sys_job_log` VALUES ('3077', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:10:00');
INSERT INTO `sys_job_log` VALUES ('3078', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 00:11:00');
INSERT INTO `sys_job_log` VALUES ('3079', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 00:12:00');
INSERT INTO `sys_job_log` VALUES ('3080', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:13:00');
INSERT INTO `sys_job_log` VALUES ('3081', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 00:14:00');
INSERT INTO `sys_job_log` VALUES ('3082', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:15:00');
INSERT INTO `sys_job_log` VALUES ('3083', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 00:16:00');
INSERT INTO `sys_job_log` VALUES ('3084', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 00:17:00');
INSERT INTO `sys_job_log` VALUES ('3085', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 00:18:00');
INSERT INTO `sys_job_log` VALUES ('3086', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 00:19:00');
INSERT INTO `sys_job_log` VALUES ('3087', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 00:20:00');
INSERT INTO `sys_job_log` VALUES ('3088', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 00:21:00');
INSERT INTO `sys_job_log` VALUES ('3089', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 00:22:00');
INSERT INTO `sys_job_log` VALUES ('3090', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 00:23:00');
INSERT INTO `sys_job_log` VALUES ('3091', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-11 00:24:00');
INSERT INTO `sys_job_log` VALUES ('3092', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 00:25:00');
INSERT INTO `sys_job_log` VALUES ('3093', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 00:26:00');
INSERT INTO `sys_job_log` VALUES ('3094', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 00:27:00');
INSERT INTO `sys_job_log` VALUES ('3095', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 00:28:00');
INSERT INTO `sys_job_log` VALUES ('3096', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 00:29:00');
INSERT INTO `sys_job_log` VALUES ('3097', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 00:30:00');
INSERT INTO `sys_job_log` VALUES ('3098', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 00:31:00');
INSERT INTO `sys_job_log` VALUES ('3099', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 00:32:00');
INSERT INTO `sys_job_log` VALUES ('3100', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 00:33:00');
INSERT INTO `sys_job_log` VALUES ('3101', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:34:00');
INSERT INTO `sys_job_log` VALUES ('3102', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 00:35:00');
INSERT INTO `sys_job_log` VALUES ('3103', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 00:36:00');
INSERT INTO `sys_job_log` VALUES ('3104', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 00:37:00');
INSERT INTO `sys_job_log` VALUES ('3105', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：41毫秒', '0', '', '2021-11-11 00:38:00');
INSERT INTO `sys_job_log` VALUES ('3106', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:39:00');
INSERT INTO `sys_job_log` VALUES ('3107', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 00:40:00');
INSERT INTO `sys_job_log` VALUES ('3108', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 00:41:00');
INSERT INTO `sys_job_log` VALUES ('3109', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 00:42:00');
INSERT INTO `sys_job_log` VALUES ('3110', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:43:00');
INSERT INTO `sys_job_log` VALUES ('3111', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 00:44:00');
INSERT INTO `sys_job_log` VALUES ('3112', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 00:45:00');
INSERT INTO `sys_job_log` VALUES ('3113', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 00:46:00');
INSERT INTO `sys_job_log` VALUES ('3114', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 00:47:00');
INSERT INTO `sys_job_log` VALUES ('3115', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 00:48:00');
INSERT INTO `sys_job_log` VALUES ('3116', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 00:49:00');
INSERT INTO `sys_job_log` VALUES ('3117', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 00:50:00');
INSERT INTO `sys_job_log` VALUES ('3118', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 00:51:00');
INSERT INTO `sys_job_log` VALUES ('3119', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 00:52:00');
INSERT INTO `sys_job_log` VALUES ('3120', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 00:53:00');
INSERT INTO `sys_job_log` VALUES ('3121', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 00:54:00');
INSERT INTO `sys_job_log` VALUES ('3122', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 00:55:00');
INSERT INTO `sys_job_log` VALUES ('3123', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 00:56:00');
INSERT INTO `sys_job_log` VALUES ('3124', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 00:57:00');
INSERT INTO `sys_job_log` VALUES ('3125', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 00:58:00');
INSERT INTO `sys_job_log` VALUES ('3126', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 00:59:00');
INSERT INTO `sys_job_log` VALUES ('3127', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 01:00:00');
INSERT INTO `sys_job_log` VALUES ('3128', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:01:00');
INSERT INTO `sys_job_log` VALUES ('3129', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 01:02:00');
INSERT INTO `sys_job_log` VALUES ('3130', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-11 01:03:00');
INSERT INTO `sys_job_log` VALUES ('3131', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 01:04:00');
INSERT INTO `sys_job_log` VALUES ('3132', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 01:05:00');
INSERT INTO `sys_job_log` VALUES ('3133', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:06:00');
INSERT INTO `sys_job_log` VALUES ('3134', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 01:07:00');
INSERT INTO `sys_job_log` VALUES ('3135', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 01:08:00');
INSERT INTO `sys_job_log` VALUES ('3136', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 01:09:00');
INSERT INTO `sys_job_log` VALUES ('3137', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 01:10:00');
INSERT INTO `sys_job_log` VALUES ('3138', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 01:11:00');
INSERT INTO `sys_job_log` VALUES ('3139', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:12:00');
INSERT INTO `sys_job_log` VALUES ('3140', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 01:13:00');
INSERT INTO `sys_job_log` VALUES ('3141', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 01:14:01');
INSERT INTO `sys_job_log` VALUES ('3142', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 01:15:00');
INSERT INTO `sys_job_log` VALUES ('3143', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 01:16:00');
INSERT INTO `sys_job_log` VALUES ('3144', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-11 01:17:01');
INSERT INTO `sys_job_log` VALUES ('3145', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 01:18:00');
INSERT INTO `sys_job_log` VALUES ('3146', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 01:19:00');
INSERT INTO `sys_job_log` VALUES ('3147', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:20:00');
INSERT INTO `sys_job_log` VALUES ('3148', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 01:21:01');
INSERT INTO `sys_job_log` VALUES ('3149', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:22:00');
INSERT INTO `sys_job_log` VALUES ('3150', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:23:00');
INSERT INTO `sys_job_log` VALUES ('3151', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:24:00');
INSERT INTO `sys_job_log` VALUES ('3152', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 01:25:00');
INSERT INTO `sys_job_log` VALUES ('3153', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:26:00');
INSERT INTO `sys_job_log` VALUES ('3154', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 01:27:00');
INSERT INTO `sys_job_log` VALUES ('3155', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 01:28:00');
INSERT INTO `sys_job_log` VALUES ('3156', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:29:00');
INSERT INTO `sys_job_log` VALUES ('3157', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 01:30:00');
INSERT INTO `sys_job_log` VALUES ('3158', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 01:31:00');
INSERT INTO `sys_job_log` VALUES ('3159', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:32:00');
INSERT INTO `sys_job_log` VALUES ('3160', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 01:33:00');
INSERT INTO `sys_job_log` VALUES ('3161', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 01:34:00');
INSERT INTO `sys_job_log` VALUES ('3162', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:35:00');
INSERT INTO `sys_job_log` VALUES ('3163', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 01:36:00');
INSERT INTO `sys_job_log` VALUES ('3164', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 01:37:00');
INSERT INTO `sys_job_log` VALUES ('3165', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 01:38:00');
INSERT INTO `sys_job_log` VALUES ('3166', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 01:39:00');
INSERT INTO `sys_job_log` VALUES ('3167', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 01:40:00');
INSERT INTO `sys_job_log` VALUES ('3168', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 01:41:00');
INSERT INTO `sys_job_log` VALUES ('3169', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 01:42:00');
INSERT INTO `sys_job_log` VALUES ('3170', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 01:43:00');
INSERT INTO `sys_job_log` VALUES ('3171', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:44:00');
INSERT INTO `sys_job_log` VALUES ('3172', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:45:00');
INSERT INTO `sys_job_log` VALUES ('3173', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:46:00');
INSERT INTO `sys_job_log` VALUES ('3174', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 01:47:00');
INSERT INTO `sys_job_log` VALUES ('3175', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 01:48:00');
INSERT INTO `sys_job_log` VALUES ('3176', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 01:49:00');
INSERT INTO `sys_job_log` VALUES ('3177', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 01:50:00');
INSERT INTO `sys_job_log` VALUES ('3178', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 01:51:00');
INSERT INTO `sys_job_log` VALUES ('3179', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 01:52:00');
INSERT INTO `sys_job_log` VALUES ('3180', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 01:53:00');
INSERT INTO `sys_job_log` VALUES ('3181', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:54:00');
INSERT INTO `sys_job_log` VALUES ('3182', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 01:55:00');
INSERT INTO `sys_job_log` VALUES ('3183', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 01:56:00');
INSERT INTO `sys_job_log` VALUES ('3184', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 01:57:00');
INSERT INTO `sys_job_log` VALUES ('3185', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 01:58:00');
INSERT INTO `sys_job_log` VALUES ('3186', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 01:59:00');
INSERT INTO `sys_job_log` VALUES ('3187', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 02:00:00');
INSERT INTO `sys_job_log` VALUES ('3188', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 02:01:00');
INSERT INTO `sys_job_log` VALUES ('3189', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 02:02:00');
INSERT INTO `sys_job_log` VALUES ('3190', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 02:03:00');
INSERT INTO `sys_job_log` VALUES ('3191', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 02:04:00');
INSERT INTO `sys_job_log` VALUES ('3192', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 02:05:00');
INSERT INTO `sys_job_log` VALUES ('3193', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 02:06:00');
INSERT INTO `sys_job_log` VALUES ('3194', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-11 02:07:00');
INSERT INTO `sys_job_log` VALUES ('3195', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 02:08:00');
INSERT INTO `sys_job_log` VALUES ('3196', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:09:00');
INSERT INTO `sys_job_log` VALUES ('3197', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:10:00');
INSERT INTO `sys_job_log` VALUES ('3198', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 02:11:00');
INSERT INTO `sys_job_log` VALUES ('3199', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 02:12:00');
INSERT INTO `sys_job_log` VALUES ('3200', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 02:13:00');
INSERT INTO `sys_job_log` VALUES ('3201', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 02:14:00');
INSERT INTO `sys_job_log` VALUES ('3202', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 02:15:00');
INSERT INTO `sys_job_log` VALUES ('3203', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 02:16:00');
INSERT INTO `sys_job_log` VALUES ('3204', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 02:17:00');
INSERT INTO `sys_job_log` VALUES ('3205', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:18:00');
INSERT INTO `sys_job_log` VALUES ('3206', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 02:19:00');
INSERT INTO `sys_job_log` VALUES ('3207', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 02:20:00');
INSERT INTO `sys_job_log` VALUES ('3208', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:21:00');
INSERT INTO `sys_job_log` VALUES ('3209', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 02:22:00');
INSERT INTO `sys_job_log` VALUES ('3210', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 02:23:00');
INSERT INTO `sys_job_log` VALUES ('3211', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:24:00');
INSERT INTO `sys_job_log` VALUES ('3212', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 02:25:00');
INSERT INTO `sys_job_log` VALUES ('3213', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 02:26:00');
INSERT INTO `sys_job_log` VALUES ('3214', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:27:00');
INSERT INTO `sys_job_log` VALUES ('3215', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:28:00');
INSERT INTO `sys_job_log` VALUES ('3216', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 02:29:00');
INSERT INTO `sys_job_log` VALUES ('3217', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:30:00');
INSERT INTO `sys_job_log` VALUES ('3218', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:31:00');
INSERT INTO `sys_job_log` VALUES ('3219', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:32:00');
INSERT INTO `sys_job_log` VALUES ('3220', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 02:33:00');
INSERT INTO `sys_job_log` VALUES ('3221', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 02:34:00');
INSERT INTO `sys_job_log` VALUES ('3222', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 02:35:00');
INSERT INTO `sys_job_log` VALUES ('3223', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:36:00');
INSERT INTO `sys_job_log` VALUES ('3224', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 02:37:00');
INSERT INTO `sys_job_log` VALUES ('3225', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:38:00');
INSERT INTO `sys_job_log` VALUES ('3226', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 02:39:00');
INSERT INTO `sys_job_log` VALUES ('3227', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 02:40:00');
INSERT INTO `sys_job_log` VALUES ('3228', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 02:41:00');
INSERT INTO `sys_job_log` VALUES ('3229', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 02:42:00');
INSERT INTO `sys_job_log` VALUES ('3230', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:43:00');
INSERT INTO `sys_job_log` VALUES ('3231', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 02:44:00');
INSERT INTO `sys_job_log` VALUES ('3232', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:45:00');
INSERT INTO `sys_job_log` VALUES ('3233', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 02:46:00');
INSERT INTO `sys_job_log` VALUES ('3234', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 02:47:00');
INSERT INTO `sys_job_log` VALUES ('3235', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:48:00');
INSERT INTO `sys_job_log` VALUES ('3236', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 02:49:00');
INSERT INTO `sys_job_log` VALUES ('3237', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 02:50:00');
INSERT INTO `sys_job_log` VALUES ('3238', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 02:51:00');
INSERT INTO `sys_job_log` VALUES ('3239', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 02:52:00');
INSERT INTO `sys_job_log` VALUES ('3240', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 02:53:00');
INSERT INTO `sys_job_log` VALUES ('3241', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 02:54:00');
INSERT INTO `sys_job_log` VALUES ('3242', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 02:55:00');
INSERT INTO `sys_job_log` VALUES ('3243', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 02:56:00');
INSERT INTO `sys_job_log` VALUES ('3244', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 02:57:00');
INSERT INTO `sys_job_log` VALUES ('3245', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 02:58:00');
INSERT INTO `sys_job_log` VALUES ('3246', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 02:59:00');
INSERT INTO `sys_job_log` VALUES ('3247', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 03:00:00');
INSERT INTO `sys_job_log` VALUES ('3248', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 03:01:00');
INSERT INTO `sys_job_log` VALUES ('3249', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 03:02:00');
INSERT INTO `sys_job_log` VALUES ('3250', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 03:03:00');
INSERT INTO `sys_job_log` VALUES ('3251', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 03:04:00');
INSERT INTO `sys_job_log` VALUES ('3252', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 03:05:00');
INSERT INTO `sys_job_log` VALUES ('3253', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 03:06:00');
INSERT INTO `sys_job_log` VALUES ('3254', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 03:07:00');
INSERT INTO `sys_job_log` VALUES ('3255', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 03:08:00');
INSERT INTO `sys_job_log` VALUES ('3256', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 03:09:00');
INSERT INTO `sys_job_log` VALUES ('3257', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 03:10:00');
INSERT INTO `sys_job_log` VALUES ('3258', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 03:11:00');
INSERT INTO `sys_job_log` VALUES ('3259', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 03:12:00');
INSERT INTO `sys_job_log` VALUES ('3260', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 03:13:00');
INSERT INTO `sys_job_log` VALUES ('3261', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 03:14:00');
INSERT INTO `sys_job_log` VALUES ('3262', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 03:15:00');
INSERT INTO `sys_job_log` VALUES ('3263', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 03:16:00');
INSERT INTO `sys_job_log` VALUES ('3264', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 03:17:00');
INSERT INTO `sys_job_log` VALUES ('3265', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 03:18:00');
INSERT INTO `sys_job_log` VALUES ('3266', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 03:19:00');
INSERT INTO `sys_job_log` VALUES ('3267', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 03:20:00');
INSERT INTO `sys_job_log` VALUES ('3268', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 03:21:00');
INSERT INTO `sys_job_log` VALUES ('3269', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 03:22:00');
INSERT INTO `sys_job_log` VALUES ('3270', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 03:23:00');
INSERT INTO `sys_job_log` VALUES ('3271', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 03:24:00');
INSERT INTO `sys_job_log` VALUES ('3272', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 03:25:00');
INSERT INTO `sys_job_log` VALUES ('3273', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 03:26:00');
INSERT INTO `sys_job_log` VALUES ('3274', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 03:27:00');
INSERT INTO `sys_job_log` VALUES ('3275', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 03:28:00');
INSERT INTO `sys_job_log` VALUES ('3276', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 03:29:00');
INSERT INTO `sys_job_log` VALUES ('3277', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 03:30:00');
INSERT INTO `sys_job_log` VALUES ('3278', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 03:31:00');
INSERT INTO `sys_job_log` VALUES ('3279', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 03:32:00');
INSERT INTO `sys_job_log` VALUES ('3280', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 03:33:00');
INSERT INTO `sys_job_log` VALUES ('3281', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 03:34:00');
INSERT INTO `sys_job_log` VALUES ('3282', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 03:35:00');
INSERT INTO `sys_job_log` VALUES ('3283', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 03:36:00');
INSERT INTO `sys_job_log` VALUES ('3284', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 03:37:00');
INSERT INTO `sys_job_log` VALUES ('3285', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 03:38:00');
INSERT INTO `sys_job_log` VALUES ('3286', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 03:39:00');
INSERT INTO `sys_job_log` VALUES ('3287', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 03:40:00');
INSERT INTO `sys_job_log` VALUES ('3288', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 03:41:00');
INSERT INTO `sys_job_log` VALUES ('3289', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 03:42:00');
INSERT INTO `sys_job_log` VALUES ('3290', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 03:43:00');
INSERT INTO `sys_job_log` VALUES ('3291', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 03:44:00');
INSERT INTO `sys_job_log` VALUES ('3292', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 03:45:00');
INSERT INTO `sys_job_log` VALUES ('3293', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 03:46:00');
INSERT INTO `sys_job_log` VALUES ('3294', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 03:47:00');
INSERT INTO `sys_job_log` VALUES ('3295', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 03:48:00');
INSERT INTO `sys_job_log` VALUES ('3296', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 03:49:00');
INSERT INTO `sys_job_log` VALUES ('3297', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 03:50:00');
INSERT INTO `sys_job_log` VALUES ('3298', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 03:51:00');
INSERT INTO `sys_job_log` VALUES ('3299', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 03:52:00');
INSERT INTO `sys_job_log` VALUES ('3300', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 03:53:00');
INSERT INTO `sys_job_log` VALUES ('3301', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 03:54:00');
INSERT INTO `sys_job_log` VALUES ('3302', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 03:55:00');
INSERT INTO `sys_job_log` VALUES ('3303', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 03:56:00');
INSERT INTO `sys_job_log` VALUES ('3304', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 03:57:00');
INSERT INTO `sys_job_log` VALUES ('3305', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：34毫秒', '0', '', '2021-11-11 03:58:00');
INSERT INTO `sys_job_log` VALUES ('3306', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 03:59:00');
INSERT INTO `sys_job_log` VALUES ('3307', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:00:00');
INSERT INTO `sys_job_log` VALUES ('3308', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 04:01:00');
INSERT INTO `sys_job_log` VALUES ('3309', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 04:02:00');
INSERT INTO `sys_job_log` VALUES ('3310', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 04:03:00');
INSERT INTO `sys_job_log` VALUES ('3311', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 04:04:00');
INSERT INTO `sys_job_log` VALUES ('3312', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:05:00');
INSERT INTO `sys_job_log` VALUES ('3313', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:06:00');
INSERT INTO `sys_job_log` VALUES ('3314', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-11 04:07:00');
INSERT INTO `sys_job_log` VALUES ('3315', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 04:08:00');
INSERT INTO `sys_job_log` VALUES ('3316', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-11 04:09:00');
INSERT INTO `sys_job_log` VALUES ('3317', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 04:10:00');
INSERT INTO `sys_job_log` VALUES ('3318', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 04:11:00');
INSERT INTO `sys_job_log` VALUES ('3319', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 04:12:00');
INSERT INTO `sys_job_log` VALUES ('3320', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:13:00');
INSERT INTO `sys_job_log` VALUES ('3321', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:14:00');
INSERT INTO `sys_job_log` VALUES ('3322', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 04:15:00');
INSERT INTO `sys_job_log` VALUES ('3323', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:16:00');
INSERT INTO `sys_job_log` VALUES ('3324', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 04:17:00');
INSERT INTO `sys_job_log` VALUES ('3325', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:18:00');
INSERT INTO `sys_job_log` VALUES ('3326', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 04:19:00');
INSERT INTO `sys_job_log` VALUES ('3327', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 04:20:00');
INSERT INTO `sys_job_log` VALUES ('3328', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 04:21:00');
INSERT INTO `sys_job_log` VALUES ('3329', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 04:22:00');
INSERT INTO `sys_job_log` VALUES ('3330', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:23:00');
INSERT INTO `sys_job_log` VALUES ('3331', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 04:24:00');
INSERT INTO `sys_job_log` VALUES ('3332', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:25:00');
INSERT INTO `sys_job_log` VALUES ('3333', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 04:26:00');
INSERT INTO `sys_job_log` VALUES ('3334', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 04:27:00');
INSERT INTO `sys_job_log` VALUES ('3335', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 04:28:00');
INSERT INTO `sys_job_log` VALUES ('3336', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 04:29:00');
INSERT INTO `sys_job_log` VALUES ('3337', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 04:30:00');
INSERT INTO `sys_job_log` VALUES ('3338', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 04:31:00');
INSERT INTO `sys_job_log` VALUES ('3339', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:32:00');
INSERT INTO `sys_job_log` VALUES ('3340', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 04:33:00');
INSERT INTO `sys_job_log` VALUES ('3341', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 04:34:00');
INSERT INTO `sys_job_log` VALUES ('3342', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:35:00');
INSERT INTO `sys_job_log` VALUES ('3343', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 04:36:00');
INSERT INTO `sys_job_log` VALUES ('3344', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 04:37:00');
INSERT INTO `sys_job_log` VALUES ('3345', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 04:38:00');
INSERT INTO `sys_job_log` VALUES ('3346', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:39:00');
INSERT INTO `sys_job_log` VALUES ('3347', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 04:40:00');
INSERT INTO `sys_job_log` VALUES ('3348', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 04:41:00');
INSERT INTO `sys_job_log` VALUES ('3349', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 04:42:00');
INSERT INTO `sys_job_log` VALUES ('3350', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 04:43:00');
INSERT INTO `sys_job_log` VALUES ('3351', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 04:44:00');
INSERT INTO `sys_job_log` VALUES ('3352', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 04:45:00');
INSERT INTO `sys_job_log` VALUES ('3353', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:46:00');
INSERT INTO `sys_job_log` VALUES ('3354', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 04:47:00');
INSERT INTO `sys_job_log` VALUES ('3355', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:48:00');
INSERT INTO `sys_job_log` VALUES ('3356', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 04:49:00');
INSERT INTO `sys_job_log` VALUES ('3357', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 04:50:00');
INSERT INTO `sys_job_log` VALUES ('3358', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:51:00');
INSERT INTO `sys_job_log` VALUES ('3359', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 04:52:00');
INSERT INTO `sys_job_log` VALUES ('3360', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 04:53:00');
INSERT INTO `sys_job_log` VALUES ('3361', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 04:54:00');
INSERT INTO `sys_job_log` VALUES ('3362', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 04:55:00');
INSERT INTO `sys_job_log` VALUES ('3363', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 04:56:00');
INSERT INTO `sys_job_log` VALUES ('3364', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 04:57:00');
INSERT INTO `sys_job_log` VALUES ('3365', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 04:58:00');
INSERT INTO `sys_job_log` VALUES ('3366', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 04:59:00');
INSERT INTO `sys_job_log` VALUES ('3367', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 05:00:00');
INSERT INTO `sys_job_log` VALUES ('3368', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 05:01:00');
INSERT INTO `sys_job_log` VALUES ('3369', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 05:02:00');
INSERT INTO `sys_job_log` VALUES ('3370', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 05:03:00');
INSERT INTO `sys_job_log` VALUES ('3371', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 05:04:00');
INSERT INTO `sys_job_log` VALUES ('3372', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 05:05:00');
INSERT INTO `sys_job_log` VALUES ('3373', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 05:06:00');
INSERT INTO `sys_job_log` VALUES ('3374', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 05:07:00');
INSERT INTO `sys_job_log` VALUES ('3375', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 05:08:00');
INSERT INTO `sys_job_log` VALUES ('3376', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 05:09:00');
INSERT INTO `sys_job_log` VALUES ('3377', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 05:10:00');
INSERT INTO `sys_job_log` VALUES ('3378', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 05:11:00');
INSERT INTO `sys_job_log` VALUES ('3379', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 05:12:00');
INSERT INTO `sys_job_log` VALUES ('3380', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 05:13:00');
INSERT INTO `sys_job_log` VALUES ('3381', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:14:00');
INSERT INTO `sys_job_log` VALUES ('3382', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 05:15:00');
INSERT INTO `sys_job_log` VALUES ('3383', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:16:00');
INSERT INTO `sys_job_log` VALUES ('3384', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 05:17:00');
INSERT INTO `sys_job_log` VALUES ('3385', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 05:18:00');
INSERT INTO `sys_job_log` VALUES ('3386', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 05:19:00');
INSERT INTO `sys_job_log` VALUES ('3387', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 05:20:00');
INSERT INTO `sys_job_log` VALUES ('3388', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 05:21:00');
INSERT INTO `sys_job_log` VALUES ('3389', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:22:00');
INSERT INTO `sys_job_log` VALUES ('3390', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 05:23:00');
INSERT INTO `sys_job_log` VALUES ('3391', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 05:24:00');
INSERT INTO `sys_job_log` VALUES ('3392', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 05:25:00');
INSERT INTO `sys_job_log` VALUES ('3393', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 05:26:00');
INSERT INTO `sys_job_log` VALUES ('3394', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 05:27:00');
INSERT INTO `sys_job_log` VALUES ('3395', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:28:00');
INSERT INTO `sys_job_log` VALUES ('3396', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:29:00');
INSERT INTO `sys_job_log` VALUES ('3397', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:30:00');
INSERT INTO `sys_job_log` VALUES ('3398', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 05:31:00');
INSERT INTO `sys_job_log` VALUES ('3399', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 05:32:00');
INSERT INTO `sys_job_log` VALUES ('3400', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 05:33:00');
INSERT INTO `sys_job_log` VALUES ('3401', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 05:34:00');
INSERT INTO `sys_job_log` VALUES ('3402', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 05:35:00');
INSERT INTO `sys_job_log` VALUES ('3403', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 05:36:00');
INSERT INTO `sys_job_log` VALUES ('3404', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 05:37:00');
INSERT INTO `sys_job_log` VALUES ('3405', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 05:38:00');
INSERT INTO `sys_job_log` VALUES ('3406', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 05:39:00');
INSERT INTO `sys_job_log` VALUES ('3407', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 05:40:00');
INSERT INTO `sys_job_log` VALUES ('3408', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 05:41:00');
INSERT INTO `sys_job_log` VALUES ('3409', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 05:42:00');
INSERT INTO `sys_job_log` VALUES ('3410', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:43:00');
INSERT INTO `sys_job_log` VALUES ('3411', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 05:44:00');
INSERT INTO `sys_job_log` VALUES ('3412', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 05:45:00');
INSERT INTO `sys_job_log` VALUES ('3413', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 05:46:00');
INSERT INTO `sys_job_log` VALUES ('3414', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 05:47:00');
INSERT INTO `sys_job_log` VALUES ('3415', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 05:48:00');
INSERT INTO `sys_job_log` VALUES ('3416', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 05:49:00');
INSERT INTO `sys_job_log` VALUES ('3417', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 05:50:00');
INSERT INTO `sys_job_log` VALUES ('3418', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 05:51:00');
INSERT INTO `sys_job_log` VALUES ('3419', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 05:52:00');
INSERT INTO `sys_job_log` VALUES ('3420', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 05:53:00');
INSERT INTO `sys_job_log` VALUES ('3421', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 05:54:00');
INSERT INTO `sys_job_log` VALUES ('3422', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 05:55:00');
INSERT INTO `sys_job_log` VALUES ('3423', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 05:56:00');
INSERT INTO `sys_job_log` VALUES ('3424', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 05:57:00');
INSERT INTO `sys_job_log` VALUES ('3425', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 05:58:00');
INSERT INTO `sys_job_log` VALUES ('3426', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 05:59:00');
INSERT INTO `sys_job_log` VALUES ('3427', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 06:00:00');
INSERT INTO `sys_job_log` VALUES ('3428', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:01:00');
INSERT INTO `sys_job_log` VALUES ('3429', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 06:02:00');
INSERT INTO `sys_job_log` VALUES ('3430', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:03:00');
INSERT INTO `sys_job_log` VALUES ('3431', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 06:04:00');
INSERT INTO `sys_job_log` VALUES ('3432', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 06:05:00');
INSERT INTO `sys_job_log` VALUES ('3433', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 06:06:00');
INSERT INTO `sys_job_log` VALUES ('3434', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:07:00');
INSERT INTO `sys_job_log` VALUES ('3435', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:08:00');
INSERT INTO `sys_job_log` VALUES ('3436', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:09:00');
INSERT INTO `sys_job_log` VALUES ('3437', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:10:00');
INSERT INTO `sys_job_log` VALUES ('3438', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 06:11:00');
INSERT INTO `sys_job_log` VALUES ('3439', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 06:12:00');
INSERT INTO `sys_job_log` VALUES ('3440', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 06:13:00');
INSERT INTO `sys_job_log` VALUES ('3441', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 06:14:00');
INSERT INTO `sys_job_log` VALUES ('3442', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 06:15:00');
INSERT INTO `sys_job_log` VALUES ('3443', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 06:16:00');
INSERT INTO `sys_job_log` VALUES ('3444', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 06:17:00');
INSERT INTO `sys_job_log` VALUES ('3445', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 06:18:00');
INSERT INTO `sys_job_log` VALUES ('3446', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 06:19:00');
INSERT INTO `sys_job_log` VALUES ('3447', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:20:00');
INSERT INTO `sys_job_log` VALUES ('3448', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 06:21:00');
INSERT INTO `sys_job_log` VALUES ('3449', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 06:22:00');
INSERT INTO `sys_job_log` VALUES ('3450', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 06:23:00');
INSERT INTO `sys_job_log` VALUES ('3451', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:24:00');
INSERT INTO `sys_job_log` VALUES ('3452', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 06:25:00');
INSERT INTO `sys_job_log` VALUES ('3453', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 06:26:00');
INSERT INTO `sys_job_log` VALUES ('3454', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 06:27:00');
INSERT INTO `sys_job_log` VALUES ('3455', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 06:28:00');
INSERT INTO `sys_job_log` VALUES ('3456', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 06:29:00');
INSERT INTO `sys_job_log` VALUES ('3457', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:30:00');
INSERT INTO `sys_job_log` VALUES ('3458', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:31:00');
INSERT INTO `sys_job_log` VALUES ('3459', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 06:32:00');
INSERT INTO `sys_job_log` VALUES ('3460', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 06:33:00');
INSERT INTO `sys_job_log` VALUES ('3461', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:34:00');
INSERT INTO `sys_job_log` VALUES ('3462', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 06:35:00');
INSERT INTO `sys_job_log` VALUES ('3463', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 06:36:00');
INSERT INTO `sys_job_log` VALUES ('3464', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 06:37:00');
INSERT INTO `sys_job_log` VALUES ('3465', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 06:38:00');
INSERT INTO `sys_job_log` VALUES ('3466', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:39:00');
INSERT INTO `sys_job_log` VALUES ('3467', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 06:40:00');
INSERT INTO `sys_job_log` VALUES ('3468', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:41:00');
INSERT INTO `sys_job_log` VALUES ('3469', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 06:42:00');
INSERT INTO `sys_job_log` VALUES ('3470', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:43:00');
INSERT INTO `sys_job_log` VALUES ('3471', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 06:44:00');
INSERT INTO `sys_job_log` VALUES ('3472', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:45:00');
INSERT INTO `sys_job_log` VALUES ('3473', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 06:46:00');
INSERT INTO `sys_job_log` VALUES ('3474', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 06:47:00');
INSERT INTO `sys_job_log` VALUES ('3475', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 06:48:00');
INSERT INTO `sys_job_log` VALUES ('3476', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 06:49:00');
INSERT INTO `sys_job_log` VALUES ('3477', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 06:50:00');
INSERT INTO `sys_job_log` VALUES ('3478', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 06:51:00');
INSERT INTO `sys_job_log` VALUES ('3479', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 06:52:00');
INSERT INTO `sys_job_log` VALUES ('3480', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 06:53:00');
INSERT INTO `sys_job_log` VALUES ('3481', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 06:54:00');
INSERT INTO `sys_job_log` VALUES ('3482', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 06:55:00');
INSERT INTO `sys_job_log` VALUES ('3483', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 06:56:00');
INSERT INTO `sys_job_log` VALUES ('3484', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 06:57:00');
INSERT INTO `sys_job_log` VALUES ('3485', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 06:58:00');
INSERT INTO `sys_job_log` VALUES ('3486', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 06:59:00');
INSERT INTO `sys_job_log` VALUES ('3487', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 07:00:00');
INSERT INTO `sys_job_log` VALUES ('3488', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 07:01:00');
INSERT INTO `sys_job_log` VALUES ('3489', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 07:02:00');
INSERT INTO `sys_job_log` VALUES ('3490', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 07:03:00');
INSERT INTO `sys_job_log` VALUES ('3491', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 07:04:00');
INSERT INTO `sys_job_log` VALUES ('3492', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:05:00');
INSERT INTO `sys_job_log` VALUES ('3493', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 07:06:00');
INSERT INTO `sys_job_log` VALUES ('3494', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 07:07:00');
INSERT INTO `sys_job_log` VALUES ('3495', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:08:00');
INSERT INTO `sys_job_log` VALUES ('3496', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:09:00');
INSERT INTO `sys_job_log` VALUES ('3497', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 07:10:00');
INSERT INTO `sys_job_log` VALUES ('3498', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:11:00');
INSERT INTO `sys_job_log` VALUES ('3499', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 07:12:00');
INSERT INTO `sys_job_log` VALUES ('3500', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:13:00');
INSERT INTO `sys_job_log` VALUES ('3501', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 07:14:00');
INSERT INTO `sys_job_log` VALUES ('3502', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:15:00');
INSERT INTO `sys_job_log` VALUES ('3503', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 07:16:00');
INSERT INTO `sys_job_log` VALUES ('3504', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:17:00');
INSERT INTO `sys_job_log` VALUES ('3505', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 07:18:00');
INSERT INTO `sys_job_log` VALUES ('3506', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 07:19:00');
INSERT INTO `sys_job_log` VALUES ('3507', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 07:20:00');
INSERT INTO `sys_job_log` VALUES ('3508', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 07:21:00');
INSERT INTO `sys_job_log` VALUES ('3509', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:22:00');
INSERT INTO `sys_job_log` VALUES ('3510', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 07:23:00');
INSERT INTO `sys_job_log` VALUES ('3511', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 07:24:00');
INSERT INTO `sys_job_log` VALUES ('3512', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 07:25:00');
INSERT INTO `sys_job_log` VALUES ('3513', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:26:00');
INSERT INTO `sys_job_log` VALUES ('3514', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:27:00');
INSERT INTO `sys_job_log` VALUES ('3515', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:28:00');
INSERT INTO `sys_job_log` VALUES ('3516', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:29:00');
INSERT INTO `sys_job_log` VALUES ('3517', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:30:00');
INSERT INTO `sys_job_log` VALUES ('3518', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:31:00');
INSERT INTO `sys_job_log` VALUES ('3519', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 07:32:00');
INSERT INTO `sys_job_log` VALUES ('3520', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:33:00');
INSERT INTO `sys_job_log` VALUES ('3521', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 07:34:00');
INSERT INTO `sys_job_log` VALUES ('3522', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:35:00');
INSERT INTO `sys_job_log` VALUES ('3523', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 07:36:00');
INSERT INTO `sys_job_log` VALUES ('3524', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:37:00');
INSERT INTO `sys_job_log` VALUES ('3525', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 07:38:00');
INSERT INTO `sys_job_log` VALUES ('3526', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 07:39:00');
INSERT INTO `sys_job_log` VALUES ('3527', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 07:40:00');
INSERT INTO `sys_job_log` VALUES ('3528', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 07:41:00');
INSERT INTO `sys_job_log` VALUES ('3529', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:42:00');
INSERT INTO `sys_job_log` VALUES ('3530', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 07:43:00');
INSERT INTO `sys_job_log` VALUES ('3531', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 07:44:00');
INSERT INTO `sys_job_log` VALUES ('3532', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:45:00');
INSERT INTO `sys_job_log` VALUES ('3533', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:46:00');
INSERT INTO `sys_job_log` VALUES ('3534', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 07:47:00');
INSERT INTO `sys_job_log` VALUES ('3535', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 07:48:00');
INSERT INTO `sys_job_log` VALUES ('3536', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 07:49:00');
INSERT INTO `sys_job_log` VALUES ('3537', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 07:50:00');
INSERT INTO `sys_job_log` VALUES ('3538', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 07:51:00');
INSERT INTO `sys_job_log` VALUES ('3539', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 07:52:00');
INSERT INTO `sys_job_log` VALUES ('3540', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 07:53:00');
INSERT INTO `sys_job_log` VALUES ('3541', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 07:54:00');
INSERT INTO `sys_job_log` VALUES ('3542', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 07:55:00');
INSERT INTO `sys_job_log` VALUES ('3543', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 07:56:00');
INSERT INTO `sys_job_log` VALUES ('3544', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 07:57:00');
INSERT INTO `sys_job_log` VALUES ('3545', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 07:58:00');
INSERT INTO `sys_job_log` VALUES ('3546', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 07:59:00');
INSERT INTO `sys_job_log` VALUES ('3547', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 08:00:00');
INSERT INTO `sys_job_log` VALUES ('3548', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-11 08:01:00');
INSERT INTO `sys_job_log` VALUES ('3549', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 08:02:00');
INSERT INTO `sys_job_log` VALUES ('3550', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 08:03:00');
INSERT INTO `sys_job_log` VALUES ('3551', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:04:00');
INSERT INTO `sys_job_log` VALUES ('3552', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 08:05:00');
INSERT INTO `sys_job_log` VALUES ('3553', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 08:06:00');
INSERT INTO `sys_job_log` VALUES ('3554', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 08:07:00');
INSERT INTO `sys_job_log` VALUES ('3555', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:08:00');
INSERT INTO `sys_job_log` VALUES ('3556', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 08:09:00');
INSERT INTO `sys_job_log` VALUES ('3557', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 08:10:00');
INSERT INTO `sys_job_log` VALUES ('3558', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 08:11:00');
INSERT INTO `sys_job_log` VALUES ('3559', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 08:12:00');
INSERT INTO `sys_job_log` VALUES ('3560', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 08:13:00');
INSERT INTO `sys_job_log` VALUES ('3561', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 08:14:00');
INSERT INTO `sys_job_log` VALUES ('3562', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 08:15:00');
INSERT INTO `sys_job_log` VALUES ('3563', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:16:00');
INSERT INTO `sys_job_log` VALUES ('3564', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 08:17:00');
INSERT INTO `sys_job_log` VALUES ('3565', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 08:18:00');
INSERT INTO `sys_job_log` VALUES ('3566', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 08:19:00');
INSERT INTO `sys_job_log` VALUES ('3567', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:20:00');
INSERT INTO `sys_job_log` VALUES ('3568', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 08:21:00');
INSERT INTO `sys_job_log` VALUES ('3569', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 08:22:00');
INSERT INTO `sys_job_log` VALUES ('3570', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:23:00');
INSERT INTO `sys_job_log` VALUES ('3571', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 08:24:00');
INSERT INTO `sys_job_log` VALUES ('3572', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:25:00');
INSERT INTO `sys_job_log` VALUES ('3573', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 08:26:00');
INSERT INTO `sys_job_log` VALUES ('3574', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 08:27:00');
INSERT INTO `sys_job_log` VALUES ('3575', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 08:28:00');
INSERT INTO `sys_job_log` VALUES ('3576', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:29:00');
INSERT INTO `sys_job_log` VALUES ('3577', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:30:00');
INSERT INTO `sys_job_log` VALUES ('3578', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:31:00');
INSERT INTO `sys_job_log` VALUES ('3579', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 08:32:00');
INSERT INTO `sys_job_log` VALUES ('3580', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:33:00');
INSERT INTO `sys_job_log` VALUES ('3581', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 08:34:00');
INSERT INTO `sys_job_log` VALUES ('3582', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 08:35:00');
INSERT INTO `sys_job_log` VALUES ('3583', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:36:00');
INSERT INTO `sys_job_log` VALUES ('3584', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 08:37:00');
INSERT INTO `sys_job_log` VALUES ('3585', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 08:38:00');
INSERT INTO `sys_job_log` VALUES ('3586', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 08:39:00');
INSERT INTO `sys_job_log` VALUES ('3587', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 08:40:00');
INSERT INTO `sys_job_log` VALUES ('3588', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:41:00');
INSERT INTO `sys_job_log` VALUES ('3589', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:42:00');
INSERT INTO `sys_job_log` VALUES ('3590', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 08:43:00');
INSERT INTO `sys_job_log` VALUES ('3591', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:44:00');
INSERT INTO `sys_job_log` VALUES ('3592', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 08:45:00');
INSERT INTO `sys_job_log` VALUES ('3593', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:46:00');
INSERT INTO `sys_job_log` VALUES ('3594', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 08:47:00');
INSERT INTO `sys_job_log` VALUES ('3595', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:48:00');
INSERT INTO `sys_job_log` VALUES ('3596', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 08:49:00');
INSERT INTO `sys_job_log` VALUES ('3597', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 08:50:00');
INSERT INTO `sys_job_log` VALUES ('3598', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 08:51:00');
INSERT INTO `sys_job_log` VALUES ('3599', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:52:00');
INSERT INTO `sys_job_log` VALUES ('3600', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 08:53:00');
INSERT INTO `sys_job_log` VALUES ('3601', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 08:54:00');
INSERT INTO `sys_job_log` VALUES ('3602', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 08:55:00');
INSERT INTO `sys_job_log` VALUES ('3603', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 08:56:00');
INSERT INTO `sys_job_log` VALUES ('3604', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 08:57:00');
INSERT INTO `sys_job_log` VALUES ('3605', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 08:58:00');
INSERT INTO `sys_job_log` VALUES ('3606', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 08:59:00');
INSERT INTO `sys_job_log` VALUES ('3607', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 09:00:00');
INSERT INTO `sys_job_log` VALUES ('3608', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 09:01:00');
INSERT INTO `sys_job_log` VALUES ('3609', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 09:02:00');
INSERT INTO `sys_job_log` VALUES ('3610', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 09:03:00');
INSERT INTO `sys_job_log` VALUES ('3611', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 09:04:00');
INSERT INTO `sys_job_log` VALUES ('3612', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-11 09:05:00');
INSERT INTO `sys_job_log` VALUES ('3613', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 09:06:00');
INSERT INTO `sys_job_log` VALUES ('3614', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 09:07:00');
INSERT INTO `sys_job_log` VALUES ('3615', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:08:00');
INSERT INTO `sys_job_log` VALUES ('3616', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 09:09:00');
INSERT INTO `sys_job_log` VALUES ('3617', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:10:00');
INSERT INTO `sys_job_log` VALUES ('3618', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 09:11:00');
INSERT INTO `sys_job_log` VALUES ('3619', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 09:12:00');
INSERT INTO `sys_job_log` VALUES ('3620', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 09:13:00');
INSERT INTO `sys_job_log` VALUES ('3621', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 09:14:00');
INSERT INTO `sys_job_log` VALUES ('3622', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:15:00');
INSERT INTO `sys_job_log` VALUES ('3623', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 09:16:00');
INSERT INTO `sys_job_log` VALUES ('3624', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 09:17:00');
INSERT INTO `sys_job_log` VALUES ('3625', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 09:18:00');
INSERT INTO `sys_job_log` VALUES ('3626', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 09:19:00');
INSERT INTO `sys_job_log` VALUES ('3627', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 09:20:00');
INSERT INTO `sys_job_log` VALUES ('3628', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 09:21:00');
INSERT INTO `sys_job_log` VALUES ('3629', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 09:22:00');
INSERT INTO `sys_job_log` VALUES ('3630', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 09:23:00');
INSERT INTO `sys_job_log` VALUES ('3631', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 09:24:00');
INSERT INTO `sys_job_log` VALUES ('3632', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 09:25:00');
INSERT INTO `sys_job_log` VALUES ('3633', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 09:26:00');
INSERT INTO `sys_job_log` VALUES ('3634', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 09:27:00');
INSERT INTO `sys_job_log` VALUES ('3635', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 09:28:00');
INSERT INTO `sys_job_log` VALUES ('3636', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 09:29:00');
INSERT INTO `sys_job_log` VALUES ('3637', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 09:30:00');
INSERT INTO `sys_job_log` VALUES ('3638', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 09:31:00');
INSERT INTO `sys_job_log` VALUES ('3639', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:32:00');
INSERT INTO `sys_job_log` VALUES ('3640', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 09:33:00');
INSERT INTO `sys_job_log` VALUES ('3641', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 09:34:00');
INSERT INTO `sys_job_log` VALUES ('3642', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 09:35:00');
INSERT INTO `sys_job_log` VALUES ('3643', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:36:00');
INSERT INTO `sys_job_log` VALUES ('3644', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 09:37:00');
INSERT INTO `sys_job_log` VALUES ('3645', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 09:38:00');
INSERT INTO `sys_job_log` VALUES ('3646', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 09:39:00');
INSERT INTO `sys_job_log` VALUES ('3647', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 09:40:00');
INSERT INTO `sys_job_log` VALUES ('3648', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:41:00');
INSERT INTO `sys_job_log` VALUES ('3649', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-11 09:42:00');
INSERT INTO `sys_job_log` VALUES ('3650', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 09:43:00');
INSERT INTO `sys_job_log` VALUES ('3651', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:44:00');
INSERT INTO `sys_job_log` VALUES ('3652', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 09:45:00');
INSERT INTO `sys_job_log` VALUES ('3653', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 09:46:00');
INSERT INTO `sys_job_log` VALUES ('3654', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 09:47:00');
INSERT INTO `sys_job_log` VALUES ('3655', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 09:48:00');
INSERT INTO `sys_job_log` VALUES ('3656', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 09:49:00');
INSERT INTO `sys_job_log` VALUES ('3657', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 09:50:00');
INSERT INTO `sys_job_log` VALUES ('3658', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 09:51:00');
INSERT INTO `sys_job_log` VALUES ('3659', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 09:52:00');
INSERT INTO `sys_job_log` VALUES ('3660', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 09:53:00');
INSERT INTO `sys_job_log` VALUES ('3661', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 09:54:00');
INSERT INTO `sys_job_log` VALUES ('3662', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 09:55:00');
INSERT INTO `sys_job_log` VALUES ('3663', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 09:56:00');
INSERT INTO `sys_job_log` VALUES ('3664', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 09:57:00');
INSERT INTO `sys_job_log` VALUES ('3665', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 09:58:00');
INSERT INTO `sys_job_log` VALUES ('3666', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 09:59:00');
INSERT INTO `sys_job_log` VALUES ('3667', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 10:00:00');
INSERT INTO `sys_job_log` VALUES ('3668', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:01:00');
INSERT INTO `sys_job_log` VALUES ('3669', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:02:00');
INSERT INTO `sys_job_log` VALUES ('3670', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 10:03:00');
INSERT INTO `sys_job_log` VALUES ('3671', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 10:04:00');
INSERT INTO `sys_job_log` VALUES ('3672', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 10:05:00');
INSERT INTO `sys_job_log` VALUES ('3673', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 10:06:00');
INSERT INTO `sys_job_log` VALUES ('3674', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:07:00');
INSERT INTO `sys_job_log` VALUES ('3675', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 10:08:00');
INSERT INTO `sys_job_log` VALUES ('3676', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 10:09:00');
INSERT INTO `sys_job_log` VALUES ('3677', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:10:00');
INSERT INTO `sys_job_log` VALUES ('3678', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 10:11:00');
INSERT INTO `sys_job_log` VALUES ('3679', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 10:13:00');
INSERT INTO `sys_job_log` VALUES ('3680', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:14:00');
INSERT INTO `sys_job_log` VALUES ('3681', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:15:00');
INSERT INTO `sys_job_log` VALUES ('3682', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 10:16:00');
INSERT INTO `sys_job_log` VALUES ('3683', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 10:17:00');
INSERT INTO `sys_job_log` VALUES ('3684', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 10:18:00');
INSERT INTO `sys_job_log` VALUES ('3685', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 10:19:00');
INSERT INTO `sys_job_log` VALUES ('3686', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-11 10:20:00');
INSERT INTO `sys_job_log` VALUES ('3687', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 10:21:00');
INSERT INTO `sys_job_log` VALUES ('3688', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 10:22:00');
INSERT INTO `sys_job_log` VALUES ('3689', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 10:23:00');
INSERT INTO `sys_job_log` VALUES ('3690', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 10:24:00');
INSERT INTO `sys_job_log` VALUES ('3691', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 10:25:00');
INSERT INTO `sys_job_log` VALUES ('3692', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:26:00');
INSERT INTO `sys_job_log` VALUES ('3693', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:27:00');
INSERT INTO `sys_job_log` VALUES ('3694', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:28:00');
INSERT INTO `sys_job_log` VALUES ('3695', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 10:29:00');
INSERT INTO `sys_job_log` VALUES ('3696', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 10:30:00');
INSERT INTO `sys_job_log` VALUES ('3697', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:31:00');
INSERT INTO `sys_job_log` VALUES ('3698', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:32:00');
INSERT INTO `sys_job_log` VALUES ('3699', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 10:33:00');
INSERT INTO `sys_job_log` VALUES ('3700', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 10:34:00');
INSERT INTO `sys_job_log` VALUES ('3701', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:35:00');
INSERT INTO `sys_job_log` VALUES ('3702', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 10:36:00');
INSERT INTO `sys_job_log` VALUES ('3703', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:37:00');
INSERT INTO `sys_job_log` VALUES ('3704', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 10:38:00');
INSERT INTO `sys_job_log` VALUES ('3705', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:39:00');
INSERT INTO `sys_job_log` VALUES ('3706', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:40:00');
INSERT INTO `sys_job_log` VALUES ('3707', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:41:00');
INSERT INTO `sys_job_log` VALUES ('3708', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:42:00');
INSERT INTO `sys_job_log` VALUES ('3709', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:43:00');
INSERT INTO `sys_job_log` VALUES ('3710', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:44:00');
INSERT INTO `sys_job_log` VALUES ('3711', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:45:00');
INSERT INTO `sys_job_log` VALUES ('3712', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 10:46:00');
INSERT INTO `sys_job_log` VALUES ('3713', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:47:00');
INSERT INTO `sys_job_log` VALUES ('3714', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 10:48:00');
INSERT INTO `sys_job_log` VALUES ('3715', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 10:49:00');
INSERT INTO `sys_job_log` VALUES ('3716', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:50:00');
INSERT INTO `sys_job_log` VALUES ('3717', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:51:00');
INSERT INTO `sys_job_log` VALUES ('3718', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:52:00');
INSERT INTO `sys_job_log` VALUES ('3719', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:53:00');
INSERT INTO `sys_job_log` VALUES ('3720', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 10:54:00');
INSERT INTO `sys_job_log` VALUES ('3721', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 10:55:00');
INSERT INTO `sys_job_log` VALUES ('3722', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:56:00');
INSERT INTO `sys_job_log` VALUES ('3723', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 10:57:00');
INSERT INTO `sys_job_log` VALUES ('3724', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 10:58:00');
INSERT INTO `sys_job_log` VALUES ('3725', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 10:59:00');
INSERT INTO `sys_job_log` VALUES ('3726', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 11:00:00');
INSERT INTO `sys_job_log` VALUES ('3727', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:01:00');
INSERT INTO `sys_job_log` VALUES ('3728', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 11:02:00');
INSERT INTO `sys_job_log` VALUES ('3729', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 11:03:00');
INSERT INTO `sys_job_log` VALUES ('3730', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 11:04:00');
INSERT INTO `sys_job_log` VALUES ('3731', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:05:00');
INSERT INTO `sys_job_log` VALUES ('3732', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:06:00');
INSERT INTO `sys_job_log` VALUES ('3733', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 11:07:00');
INSERT INTO `sys_job_log` VALUES ('3734', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 11:08:00');
INSERT INTO `sys_job_log` VALUES ('3735', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 11:09:00');
INSERT INTO `sys_job_log` VALUES ('3736', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 11:10:00');
INSERT INTO `sys_job_log` VALUES ('3737', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 11:11:00');
INSERT INTO `sys_job_log` VALUES ('3738', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 11:12:00');
INSERT INTO `sys_job_log` VALUES ('3739', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 11:13:00');
INSERT INTO `sys_job_log` VALUES ('3740', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 11:14:00');
INSERT INTO `sys_job_log` VALUES ('3741', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:15:00');
INSERT INTO `sys_job_log` VALUES ('3742', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 11:16:00');
INSERT INTO `sys_job_log` VALUES ('3743', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 11:17:00');
INSERT INTO `sys_job_log` VALUES ('3744', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 11:18:00');
INSERT INTO `sys_job_log` VALUES ('3745', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 11:19:00');
INSERT INTO `sys_job_log` VALUES ('3746', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-11 11:20:00');
INSERT INTO `sys_job_log` VALUES ('3747', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 11:21:00');
INSERT INTO `sys_job_log` VALUES ('3748', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 11:22:00');
INSERT INTO `sys_job_log` VALUES ('3749', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 11:23:00');
INSERT INTO `sys_job_log` VALUES ('3750', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 11:24:00');
INSERT INTO `sys_job_log` VALUES ('3751', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 11:25:00');
INSERT INTO `sys_job_log` VALUES ('3752', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 11:26:00');
INSERT INTO `sys_job_log` VALUES ('3753', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:27:00');
INSERT INTO `sys_job_log` VALUES ('3754', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 11:28:00');
INSERT INTO `sys_job_log` VALUES ('3755', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:29:00');
INSERT INTO `sys_job_log` VALUES ('3756', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:30:00');
INSERT INTO `sys_job_log` VALUES ('3757', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 11:31:00');
INSERT INTO `sys_job_log` VALUES ('3758', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:32:00');
INSERT INTO `sys_job_log` VALUES ('3759', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:33:00');
INSERT INTO `sys_job_log` VALUES ('3760', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 11:34:00');
INSERT INTO `sys_job_log` VALUES ('3761', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:35:00');
INSERT INTO `sys_job_log` VALUES ('3762', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 11:36:00');
INSERT INTO `sys_job_log` VALUES ('3763', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 11:37:00');
INSERT INTO `sys_job_log` VALUES ('3764', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:38:00');
INSERT INTO `sys_job_log` VALUES ('3765', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 11:39:00');
INSERT INTO `sys_job_log` VALUES ('3766', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:40:00');
INSERT INTO `sys_job_log` VALUES ('3767', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 11:41:00');
INSERT INTO `sys_job_log` VALUES ('3768', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 11:42:00');
INSERT INTO `sys_job_log` VALUES ('3769', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 11:43:00');
INSERT INTO `sys_job_log` VALUES ('3770', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 11:44:00');
INSERT INTO `sys_job_log` VALUES ('3771', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 11:45:00');
INSERT INTO `sys_job_log` VALUES ('3772', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:46:00');
INSERT INTO `sys_job_log` VALUES ('3773', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:47:00');
INSERT INTO `sys_job_log` VALUES ('3774', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:48:00');
INSERT INTO `sys_job_log` VALUES ('3775', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:49:00');
INSERT INTO `sys_job_log` VALUES ('3776', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:50:00');
INSERT INTO `sys_job_log` VALUES ('3777', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:51:00');
INSERT INTO `sys_job_log` VALUES ('3778', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：40毫秒', '0', '', '2021-11-11 11:52:04');
INSERT INTO `sys_job_log` VALUES ('3779', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 11:53:00');
INSERT INTO `sys_job_log` VALUES ('3780', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:54:00');
INSERT INTO `sys_job_log` VALUES ('3781', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 11:55:00');
INSERT INTO `sys_job_log` VALUES ('3782', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 11:56:00');
INSERT INTO `sys_job_log` VALUES ('3783', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 11:57:00');
INSERT INTO `sys_job_log` VALUES ('3784', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 11:58:00');
INSERT INTO `sys_job_log` VALUES ('3785', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 11:59:00');
INSERT INTO `sys_job_log` VALUES ('3786', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:00:00');
INSERT INTO `sys_job_log` VALUES ('3787', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:01:00');
INSERT INTO `sys_job_log` VALUES ('3788', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 12:02:00');
INSERT INTO `sys_job_log` VALUES ('3789', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 12:03:00');
INSERT INTO `sys_job_log` VALUES ('3790', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:04:00');
INSERT INTO `sys_job_log` VALUES ('3791', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：29毫秒', '0', '', '2021-11-11 12:05:00');
INSERT INTO `sys_job_log` VALUES ('3792', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 12:06:00');
INSERT INTO `sys_job_log` VALUES ('3793', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:07:00');
INSERT INTO `sys_job_log` VALUES ('3794', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 12:08:00');
INSERT INTO `sys_job_log` VALUES ('3795', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:09:00');
INSERT INTO `sys_job_log` VALUES ('3796', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 12:10:00');
INSERT INTO `sys_job_log` VALUES ('3797', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 12:11:00');
INSERT INTO `sys_job_log` VALUES ('3798', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:12:00');
INSERT INTO `sys_job_log` VALUES ('3799', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 12:13:00');
INSERT INTO `sys_job_log` VALUES ('3800', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:14:00');
INSERT INTO `sys_job_log` VALUES ('3801', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:15:00');
INSERT INTO `sys_job_log` VALUES ('3802', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:16:00');
INSERT INTO `sys_job_log` VALUES ('3803', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:17:00');
INSERT INTO `sys_job_log` VALUES ('3804', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:18:00');
INSERT INTO `sys_job_log` VALUES ('3805', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:19:00');
INSERT INTO `sys_job_log` VALUES ('3806', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:20:00');
INSERT INTO `sys_job_log` VALUES ('3807', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：26毫秒', '0', '', '2021-11-11 12:21:00');
INSERT INTO `sys_job_log` VALUES ('3808', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 12:22:00');
INSERT INTO `sys_job_log` VALUES ('3809', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 12:23:00');
INSERT INTO `sys_job_log` VALUES ('3810', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:24:00');
INSERT INTO `sys_job_log` VALUES ('3811', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 12:25:00');
INSERT INTO `sys_job_log` VALUES ('3812', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:26:00');
INSERT INTO `sys_job_log` VALUES ('3813', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:27:00');
INSERT INTO `sys_job_log` VALUES ('3814', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 12:28:00');
INSERT INTO `sys_job_log` VALUES ('3815', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:29:00');
INSERT INTO `sys_job_log` VALUES ('3816', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:30:00');
INSERT INTO `sys_job_log` VALUES ('3817', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 12:31:00');
INSERT INTO `sys_job_log` VALUES ('3818', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:32:00');
INSERT INTO `sys_job_log` VALUES ('3819', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 12:33:00');
INSERT INTO `sys_job_log` VALUES ('3820', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 12:34:00');
INSERT INTO `sys_job_log` VALUES ('3821', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:35:00');
INSERT INTO `sys_job_log` VALUES ('3822', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:36:00');
INSERT INTO `sys_job_log` VALUES ('3823', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:37:00');
INSERT INTO `sys_job_log` VALUES ('3824', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:38:00');
INSERT INTO `sys_job_log` VALUES ('3825', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 12:39:00');
INSERT INTO `sys_job_log` VALUES ('3826', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:40:00');
INSERT INTO `sys_job_log` VALUES ('3827', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:41:00');
INSERT INTO `sys_job_log` VALUES ('3828', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:42:00');
INSERT INTO `sys_job_log` VALUES ('3829', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:43:00');
INSERT INTO `sys_job_log` VALUES ('3830', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 12:44:00');
INSERT INTO `sys_job_log` VALUES ('3831', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 12:45:00');
INSERT INTO `sys_job_log` VALUES ('3832', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 12:46:00');
INSERT INTO `sys_job_log` VALUES ('3833', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:47:00');
INSERT INTO `sys_job_log` VALUES ('3834', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 12:48:00');
INSERT INTO `sys_job_log` VALUES ('3835', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 12:49:00');
INSERT INTO `sys_job_log` VALUES ('3836', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:50:00');
INSERT INTO `sys_job_log` VALUES ('3837', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 12:51:00');
INSERT INTO `sys_job_log` VALUES ('3838', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:52:00');
INSERT INTO `sys_job_log` VALUES ('3839', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:53:00');
INSERT INTO `sys_job_log` VALUES ('3840', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 12:54:00');
INSERT INTO `sys_job_log` VALUES ('3841', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:55:00');
INSERT INTO `sys_job_log` VALUES ('3842', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 12:56:00');
INSERT INTO `sys_job_log` VALUES ('3843', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 12:57:00');
INSERT INTO `sys_job_log` VALUES ('3844', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 12:58:00');
INSERT INTO `sys_job_log` VALUES ('3845', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 12:59:00');
INSERT INTO `sys_job_log` VALUES ('3846', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 13:00:00');
INSERT INTO `sys_job_log` VALUES ('3847', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 13:01:00');
INSERT INTO `sys_job_log` VALUES ('3848', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:02:00');
INSERT INTO `sys_job_log` VALUES ('3849', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:03:00');
INSERT INTO `sys_job_log` VALUES ('3850', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 13:04:00');
INSERT INTO `sys_job_log` VALUES ('3851', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 13:05:00');
INSERT INTO `sys_job_log` VALUES ('3852', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:06:00');
INSERT INTO `sys_job_log` VALUES ('3853', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 13:07:00');
INSERT INTO `sys_job_log` VALUES ('3854', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:08:00');
INSERT INTO `sys_job_log` VALUES ('3855', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:09:00');
INSERT INTO `sys_job_log` VALUES ('3856', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-11 13:10:00');
INSERT INTO `sys_job_log` VALUES ('3857', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 13:11:00');
INSERT INTO `sys_job_log` VALUES ('3858', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:12:00');
INSERT INTO `sys_job_log` VALUES ('3859', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:13:00');
INSERT INTO `sys_job_log` VALUES ('3860', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:14:00');
INSERT INTO `sys_job_log` VALUES ('3861', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:15:00');
INSERT INTO `sys_job_log` VALUES ('3862', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 13:16:00');
INSERT INTO `sys_job_log` VALUES ('3863', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:17:00');
INSERT INTO `sys_job_log` VALUES ('3864', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 13:18:00');
INSERT INTO `sys_job_log` VALUES ('3865', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 13:19:00');
INSERT INTO `sys_job_log` VALUES ('3866', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 13:20:00');
INSERT INTO `sys_job_log` VALUES ('3867', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:21:00');
INSERT INTO `sys_job_log` VALUES ('3868', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：51毫秒', '0', '', '2021-11-11 13:22:00');
INSERT INTO `sys_job_log` VALUES ('3869', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:23:00');
INSERT INTO `sys_job_log` VALUES ('3870', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 13:24:00');
INSERT INTO `sys_job_log` VALUES ('3871', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 13:25:00');
INSERT INTO `sys_job_log` VALUES ('3872', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 13:26:00');
INSERT INTO `sys_job_log` VALUES ('3873', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 13:27:00');
INSERT INTO `sys_job_log` VALUES ('3874', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 13:28:00');
INSERT INTO `sys_job_log` VALUES ('3875', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:29:00');
INSERT INTO `sys_job_log` VALUES ('3876', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 13:30:00');
INSERT INTO `sys_job_log` VALUES ('3877', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:31:00');
INSERT INTO `sys_job_log` VALUES ('3878', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 13:32:00');
INSERT INTO `sys_job_log` VALUES ('3879', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 13:33:00');
INSERT INTO `sys_job_log` VALUES ('3880', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 13:34:00');
INSERT INTO `sys_job_log` VALUES ('3881', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 13:35:00');
INSERT INTO `sys_job_log` VALUES ('3882', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 13:36:00');
INSERT INTO `sys_job_log` VALUES ('3883', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 13:37:00');
INSERT INTO `sys_job_log` VALUES ('3884', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:38:00');
INSERT INTO `sys_job_log` VALUES ('3885', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 13:39:00');
INSERT INTO `sys_job_log` VALUES ('3886', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:40:00');
INSERT INTO `sys_job_log` VALUES ('3887', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 13:41:00');
INSERT INTO `sys_job_log` VALUES ('3888', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:42:00');
INSERT INTO `sys_job_log` VALUES ('3889', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 13:43:00');
INSERT INTO `sys_job_log` VALUES ('3890', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 13:44:00');
INSERT INTO `sys_job_log` VALUES ('3891', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:45:00');
INSERT INTO `sys_job_log` VALUES ('3892', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 13:46:00');
INSERT INTO `sys_job_log` VALUES ('3893', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 13:47:00');
INSERT INTO `sys_job_log` VALUES ('3894', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 13:48:00');
INSERT INTO `sys_job_log` VALUES ('3895', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 13:49:00');
INSERT INTO `sys_job_log` VALUES ('3896', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-11 13:50:00');
INSERT INTO `sys_job_log` VALUES ('3897', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 13:51:00');
INSERT INTO `sys_job_log` VALUES ('3898', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 13:52:00');
INSERT INTO `sys_job_log` VALUES ('3899', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 13:53:00');
INSERT INTO `sys_job_log` VALUES ('3900', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 13:54:00');
INSERT INTO `sys_job_log` VALUES ('3901', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 13:55:00');
INSERT INTO `sys_job_log` VALUES ('3902', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 13:56:00');
INSERT INTO `sys_job_log` VALUES ('3903', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 13:57:00');
INSERT INTO `sys_job_log` VALUES ('3904', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 13:58:00');
INSERT INTO `sys_job_log` VALUES ('3905', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 13:59:00');
INSERT INTO `sys_job_log` VALUES ('3906', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:00:00');
INSERT INTO `sys_job_log` VALUES ('3907', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 14:01:00');
INSERT INTO `sys_job_log` VALUES ('3908', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:02:00');
INSERT INTO `sys_job_log` VALUES ('3909', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:03:00');
INSERT INTO `sys_job_log` VALUES ('3910', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:04:00');
INSERT INTO `sys_job_log` VALUES ('3911', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:05:00');
INSERT INTO `sys_job_log` VALUES ('3912', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:06:00');
INSERT INTO `sys_job_log` VALUES ('3913', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:07:00');
INSERT INTO `sys_job_log` VALUES ('3914', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:08:00');
INSERT INTO `sys_job_log` VALUES ('3915', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:09:00');
INSERT INTO `sys_job_log` VALUES ('3916', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:10:00');
INSERT INTO `sys_job_log` VALUES ('3917', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 14:11:00');
INSERT INTO `sys_job_log` VALUES ('3918', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:12:00');
INSERT INTO `sys_job_log` VALUES ('3919', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 14:13:00');
INSERT INTO `sys_job_log` VALUES ('3920', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 14:14:00');
INSERT INTO `sys_job_log` VALUES ('3921', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:15:00');
INSERT INTO `sys_job_log` VALUES ('3922', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 14:16:00');
INSERT INTO `sys_job_log` VALUES ('3923', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 14:17:00');
INSERT INTO `sys_job_log` VALUES ('3924', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:18:00');
INSERT INTO `sys_job_log` VALUES ('3925', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:19:00');
INSERT INTO `sys_job_log` VALUES ('3926', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:20:00');
INSERT INTO `sys_job_log` VALUES ('3927', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:21:00');
INSERT INTO `sys_job_log` VALUES ('3928', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:22:00');
INSERT INTO `sys_job_log` VALUES ('3929', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:23:00');
INSERT INTO `sys_job_log` VALUES ('3930', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:24:00');
INSERT INTO `sys_job_log` VALUES ('3931', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:25:00');
INSERT INTO `sys_job_log` VALUES ('3932', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 14:26:00');
INSERT INTO `sys_job_log` VALUES ('3933', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 14:27:00');
INSERT INTO `sys_job_log` VALUES ('3934', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:28:00');
INSERT INTO `sys_job_log` VALUES ('3935', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:29:00');
INSERT INTO `sys_job_log` VALUES ('3936', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:30:00');
INSERT INTO `sys_job_log` VALUES ('3937', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:31:00');
INSERT INTO `sys_job_log` VALUES ('3938', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:32:00');
INSERT INTO `sys_job_log` VALUES ('3939', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:33:00');
INSERT INTO `sys_job_log` VALUES ('3940', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 14:34:00');
INSERT INTO `sys_job_log` VALUES ('3941', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:35:00');
INSERT INTO `sys_job_log` VALUES ('3942', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 14:36:00');
INSERT INTO `sys_job_log` VALUES ('3943', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:37:00');
INSERT INTO `sys_job_log` VALUES ('3944', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 14:38:00');
INSERT INTO `sys_job_log` VALUES ('3945', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 14:39:00');
INSERT INTO `sys_job_log` VALUES ('3946', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 14:40:00');
INSERT INTO `sys_job_log` VALUES ('3947', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 14:41:00');
INSERT INTO `sys_job_log` VALUES ('3948', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 14:42:00');
INSERT INTO `sys_job_log` VALUES ('3949', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:43:00');
INSERT INTO `sys_job_log` VALUES ('3950', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:44:00');
INSERT INTO `sys_job_log` VALUES ('3951', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:45:00');
INSERT INTO `sys_job_log` VALUES ('3952', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 14:46:00');
INSERT INTO `sys_job_log` VALUES ('3953', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 14:47:00');
INSERT INTO `sys_job_log` VALUES ('3954', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 14:48:00');
INSERT INTO `sys_job_log` VALUES ('3955', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 14:49:00');
INSERT INTO `sys_job_log` VALUES ('3956', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 14:50:00');
INSERT INTO `sys_job_log` VALUES ('3957', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:51:00');
INSERT INTO `sys_job_log` VALUES ('3958', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:52:00');
INSERT INTO `sys_job_log` VALUES ('3959', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 14:53:00');
INSERT INTO `sys_job_log` VALUES ('3960', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 14:54:00');
INSERT INTO `sys_job_log` VALUES ('3961', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 14:55:00');
INSERT INTO `sys_job_log` VALUES ('3962', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:56:00');
INSERT INTO `sys_job_log` VALUES ('3963', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 14:57:00');
INSERT INTO `sys_job_log` VALUES ('3964', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 14:58:00');
INSERT INTO `sys_job_log` VALUES ('3965', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 14:59:00');
INSERT INTO `sys_job_log` VALUES ('3966', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 15:00:00');
INSERT INTO `sys_job_log` VALUES ('3967', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:01:00');
INSERT INTO `sys_job_log` VALUES ('3968', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 15:02:00');
INSERT INTO `sys_job_log` VALUES ('3969', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:03:00');
INSERT INTO `sys_job_log` VALUES ('3970', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 15:04:00');
INSERT INTO `sys_job_log` VALUES ('3971', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 15:05:00');
INSERT INTO `sys_job_log` VALUES ('3972', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 15:06:00');
INSERT INTO `sys_job_log` VALUES ('3973', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 15:07:00');
INSERT INTO `sys_job_log` VALUES ('3974', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:08:00');
INSERT INTO `sys_job_log` VALUES ('3975', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:09:00');
INSERT INTO `sys_job_log` VALUES ('3976', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:10:00');
INSERT INTO `sys_job_log` VALUES ('3977', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 15:11:00');
INSERT INTO `sys_job_log` VALUES ('3978', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 15:12:00');
INSERT INTO `sys_job_log` VALUES ('3979', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:13:00');
INSERT INTO `sys_job_log` VALUES ('3980', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:14:00');
INSERT INTO `sys_job_log` VALUES ('3981', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:15:00');
INSERT INTO `sys_job_log` VALUES ('3982', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 15:16:00');
INSERT INTO `sys_job_log` VALUES ('3983', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:17:00');
INSERT INTO `sys_job_log` VALUES ('3984', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 15:18:00');
INSERT INTO `sys_job_log` VALUES ('3985', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 15:19:00');
INSERT INTO `sys_job_log` VALUES ('3986', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 15:20:00');
INSERT INTO `sys_job_log` VALUES ('3987', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 15:21:00');
INSERT INTO `sys_job_log` VALUES ('3988', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:22:00');
INSERT INTO `sys_job_log` VALUES ('3989', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:23:00');
INSERT INTO `sys_job_log` VALUES ('3990', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:24:00');
INSERT INTO `sys_job_log` VALUES ('3991', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:25:00');
INSERT INTO `sys_job_log` VALUES ('3992', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 15:26:00');
INSERT INTO `sys_job_log` VALUES ('3993', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:27:00');
INSERT INTO `sys_job_log` VALUES ('3994', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 15:28:00');
INSERT INTO `sys_job_log` VALUES ('3995', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 15:29:00');
INSERT INTO `sys_job_log` VALUES ('3996', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 15:30:00');
INSERT INTO `sys_job_log` VALUES ('3997', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:31:00');
INSERT INTO `sys_job_log` VALUES ('3998', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:32:00');
INSERT INTO `sys_job_log` VALUES ('3999', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 15:33:00');
INSERT INTO `sys_job_log` VALUES ('4000', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 15:34:00');
INSERT INTO `sys_job_log` VALUES ('4001', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 15:35:00');
INSERT INTO `sys_job_log` VALUES ('4002', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:36:00');
INSERT INTO `sys_job_log` VALUES ('4003', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 15:37:00');
INSERT INTO `sys_job_log` VALUES ('4004', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:38:00');
INSERT INTO `sys_job_log` VALUES ('4005', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:39:00');
INSERT INTO `sys_job_log` VALUES ('4006', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 15:40:00');
INSERT INTO `sys_job_log` VALUES ('4007', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 15:41:00');
INSERT INTO `sys_job_log` VALUES ('4008', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:42:00');
INSERT INTO `sys_job_log` VALUES ('4009', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:43:00');
INSERT INTO `sys_job_log` VALUES ('4010', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 15:44:00');
INSERT INTO `sys_job_log` VALUES ('4011', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 15:45:00');
INSERT INTO `sys_job_log` VALUES ('4012', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 15:46:00');
INSERT INTO `sys_job_log` VALUES ('4013', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 15:47:00');
INSERT INTO `sys_job_log` VALUES ('4014', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:48:00');
INSERT INTO `sys_job_log` VALUES ('4015', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 15:49:00');
INSERT INTO `sys_job_log` VALUES ('4016', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 15:50:00');
INSERT INTO `sys_job_log` VALUES ('4017', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 15:51:00');
INSERT INTO `sys_job_log` VALUES ('4018', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:52:00');
INSERT INTO `sys_job_log` VALUES ('4019', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:53:00');
INSERT INTO `sys_job_log` VALUES ('4020', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 15:54:00');
INSERT INTO `sys_job_log` VALUES ('4021', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:55:00');
INSERT INTO `sys_job_log` VALUES ('4022', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:56:00');
INSERT INTO `sys_job_log` VALUES ('4023', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 15:57:00');
INSERT INTO `sys_job_log` VALUES ('4024', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 15:58:00');
INSERT INTO `sys_job_log` VALUES ('4025', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 15:59:00');
INSERT INTO `sys_job_log` VALUES ('4026', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 16:00:00');
INSERT INTO `sys_job_log` VALUES ('4027', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 16:01:00');
INSERT INTO `sys_job_log` VALUES ('4028', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 16:02:00');
INSERT INTO `sys_job_log` VALUES ('4029', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 16:03:00');
INSERT INTO `sys_job_log` VALUES ('4030', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:04:00');
INSERT INTO `sys_job_log` VALUES ('4031', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 16:05:00');
INSERT INTO `sys_job_log` VALUES ('4032', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 16:06:00');
INSERT INTO `sys_job_log` VALUES ('4033', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 16:07:00');
INSERT INTO `sys_job_log` VALUES ('4034', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 16:08:00');
INSERT INTO `sys_job_log` VALUES ('4035', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 16:09:00');
INSERT INTO `sys_job_log` VALUES ('4036', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:10:00');
INSERT INTO `sys_job_log` VALUES ('4037', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-11 16:11:00');
INSERT INTO `sys_job_log` VALUES ('4038', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 16:12:00');
INSERT INTO `sys_job_log` VALUES ('4039', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 16:13:00');
INSERT INTO `sys_job_log` VALUES ('4040', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:14:00');
INSERT INTO `sys_job_log` VALUES ('4041', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 16:15:00');
INSERT INTO `sys_job_log` VALUES ('4042', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 16:16:00');
INSERT INTO `sys_job_log` VALUES ('4043', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 16:17:00');
INSERT INTO `sys_job_log` VALUES ('4044', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 16:18:00');
INSERT INTO `sys_job_log` VALUES ('4045', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:19:00');
INSERT INTO `sys_job_log` VALUES ('4046', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 16:20:00');
INSERT INTO `sys_job_log` VALUES ('4047', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 16:21:00');
INSERT INTO `sys_job_log` VALUES ('4048', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 16:22:00');
INSERT INTO `sys_job_log` VALUES ('4049', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 16:23:00');
INSERT INTO `sys_job_log` VALUES ('4050', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 16:24:00');
INSERT INTO `sys_job_log` VALUES ('4051', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 16:25:00');
INSERT INTO `sys_job_log` VALUES ('4052', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 16:26:00');
INSERT INTO `sys_job_log` VALUES ('4053', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:27:00');
INSERT INTO `sys_job_log` VALUES ('4054', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 16:28:00');
INSERT INTO `sys_job_log` VALUES ('4055', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 16:29:00');
INSERT INTO `sys_job_log` VALUES ('4056', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 16:30:00');
INSERT INTO `sys_job_log` VALUES ('4057', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 16:31:00');
INSERT INTO `sys_job_log` VALUES ('4058', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:32:00');
INSERT INTO `sys_job_log` VALUES ('4059', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 16:33:00');
INSERT INTO `sys_job_log` VALUES ('4060', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 16:34:00');
INSERT INTO `sys_job_log` VALUES ('4061', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 16:35:00');
INSERT INTO `sys_job_log` VALUES ('4062', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 16:36:00');
INSERT INTO `sys_job_log` VALUES ('4063', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 16:37:00');
INSERT INTO `sys_job_log` VALUES ('4064', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:38:00');
INSERT INTO `sys_job_log` VALUES ('4065', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 16:39:00');
INSERT INTO `sys_job_log` VALUES ('4066', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 16:40:00');
INSERT INTO `sys_job_log` VALUES ('4067', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 16:41:00');
INSERT INTO `sys_job_log` VALUES ('4068', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 16:42:00');
INSERT INTO `sys_job_log` VALUES ('4069', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 16:43:00');
INSERT INTO `sys_job_log` VALUES ('4070', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 16:44:00');
INSERT INTO `sys_job_log` VALUES ('4071', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 16:45:00');
INSERT INTO `sys_job_log` VALUES ('4072', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 16:46:00');
INSERT INTO `sys_job_log` VALUES ('4073', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:47:00');
INSERT INTO `sys_job_log` VALUES ('4074', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 16:48:00');
INSERT INTO `sys_job_log` VALUES ('4075', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 16:49:00');
INSERT INTO `sys_job_log` VALUES ('4076', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 16:50:00');
INSERT INTO `sys_job_log` VALUES ('4077', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 16:51:00');
INSERT INTO `sys_job_log` VALUES ('4078', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 16:52:00');
INSERT INTO `sys_job_log` VALUES ('4079', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 16:53:00');
INSERT INTO `sys_job_log` VALUES ('4080', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 16:54:00');
INSERT INTO `sys_job_log` VALUES ('4081', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 16:55:00');
INSERT INTO `sys_job_log` VALUES ('4082', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 16:56:00');
INSERT INTO `sys_job_log` VALUES ('4083', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 16:57:00');
INSERT INTO `sys_job_log` VALUES ('4084', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 16:58:00');
INSERT INTO `sys_job_log` VALUES ('4085', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 16:59:00');
INSERT INTO `sys_job_log` VALUES ('4086', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:00:00');
INSERT INTO `sys_job_log` VALUES ('4087', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 17:01:00');
INSERT INTO `sys_job_log` VALUES ('4088', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 17:02:00');
INSERT INTO `sys_job_log` VALUES ('4089', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 17:03:00');
INSERT INTO `sys_job_log` VALUES ('4090', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 17:04:00');
INSERT INTO `sys_job_log` VALUES ('4091', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 17:05:00');
INSERT INTO `sys_job_log` VALUES ('4092', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 17:06:00');
INSERT INTO `sys_job_log` VALUES ('4093', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:07:00');
INSERT INTO `sys_job_log` VALUES ('4094', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 17:08:00');
INSERT INTO `sys_job_log` VALUES ('4095', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:09:00');
INSERT INTO `sys_job_log` VALUES ('4096', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-11 17:10:00');
INSERT INTO `sys_job_log` VALUES ('4097', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:11:00');
INSERT INTO `sys_job_log` VALUES ('4098', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:12:00');
INSERT INTO `sys_job_log` VALUES ('4099', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 17:13:00');
INSERT INTO `sys_job_log` VALUES ('4100', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 17:14:00');
INSERT INTO `sys_job_log` VALUES ('4101', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 17:15:00');
INSERT INTO `sys_job_log` VALUES ('4102', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 17:16:00');
INSERT INTO `sys_job_log` VALUES ('4103', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:17:00');
INSERT INTO `sys_job_log` VALUES ('4104', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 17:18:00');
INSERT INTO `sys_job_log` VALUES ('4105', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 17:19:00');
INSERT INTO `sys_job_log` VALUES ('4106', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:20:00');
INSERT INTO `sys_job_log` VALUES ('4107', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 17:21:00');
INSERT INTO `sys_job_log` VALUES ('4108', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:22:00');
INSERT INTO `sys_job_log` VALUES ('4109', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:23:00');
INSERT INTO `sys_job_log` VALUES ('4110', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:24:00');
INSERT INTO `sys_job_log` VALUES ('4111', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 17:25:00');
INSERT INTO `sys_job_log` VALUES ('4112', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:26:00');
INSERT INTO `sys_job_log` VALUES ('4113', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 17:27:00');
INSERT INTO `sys_job_log` VALUES ('4114', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:28:00');
INSERT INTO `sys_job_log` VALUES ('4115', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 17:29:00');
INSERT INTO `sys_job_log` VALUES ('4116', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 17:30:00');
INSERT INTO `sys_job_log` VALUES ('4117', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:31:00');
INSERT INTO `sys_job_log` VALUES ('4118', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:32:00');
INSERT INTO `sys_job_log` VALUES ('4119', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:33:00');
INSERT INTO `sys_job_log` VALUES ('4120', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:34:00');
INSERT INTO `sys_job_log` VALUES ('4121', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:35:00');
INSERT INTO `sys_job_log` VALUES ('4122', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:36:00');
INSERT INTO `sys_job_log` VALUES ('4123', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 17:37:00');
INSERT INTO `sys_job_log` VALUES ('4124', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:38:00');
INSERT INTO `sys_job_log` VALUES ('4125', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:39:00');
INSERT INTO `sys_job_log` VALUES ('4126', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:40:00');
INSERT INTO `sys_job_log` VALUES ('4127', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 17:41:00');
INSERT INTO `sys_job_log` VALUES ('4128', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 17:42:00');
INSERT INTO `sys_job_log` VALUES ('4129', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:43:00');
INSERT INTO `sys_job_log` VALUES ('4130', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:44:00');
INSERT INTO `sys_job_log` VALUES ('4131', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:45:00');
INSERT INTO `sys_job_log` VALUES ('4132', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-11 17:46:00');
INSERT INTO `sys_job_log` VALUES ('4133', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 17:47:00');
INSERT INTO `sys_job_log` VALUES ('4134', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:48:00');
INSERT INTO `sys_job_log` VALUES ('4135', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 17:49:00');
INSERT INTO `sys_job_log` VALUES ('4136', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 17:50:00');
INSERT INTO `sys_job_log` VALUES ('4137', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 17:51:00');
INSERT INTO `sys_job_log` VALUES ('4138', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 17:52:00');
INSERT INTO `sys_job_log` VALUES ('4139', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:53:00');
INSERT INTO `sys_job_log` VALUES ('4140', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 17:54:00');
INSERT INTO `sys_job_log` VALUES ('4141', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 17:55:00');
INSERT INTO `sys_job_log` VALUES ('4142', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 17:56:00');
INSERT INTO `sys_job_log` VALUES ('4143', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 17:57:00');
INSERT INTO `sys_job_log` VALUES ('4144', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 17:58:00');
INSERT INTO `sys_job_log` VALUES ('4145', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 17:59:00');
INSERT INTO `sys_job_log` VALUES ('4146', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 18:00:00');
INSERT INTO `sys_job_log` VALUES ('4147', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:01:00');
INSERT INTO `sys_job_log` VALUES ('4148', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 18:02:00');
INSERT INTO `sys_job_log` VALUES ('4149', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 18:03:00');
INSERT INTO `sys_job_log` VALUES ('4150', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 18:04:00');
INSERT INTO `sys_job_log` VALUES ('4151', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 18:05:00');
INSERT INTO `sys_job_log` VALUES ('4152', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:06:00');
INSERT INTO `sys_job_log` VALUES ('4153', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:07:00');
INSERT INTO `sys_job_log` VALUES ('4154', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：159毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:08:14');
INSERT INTO `sys_job_log` VALUES ('4155', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:09:00');
INSERT INTO `sys_job_log` VALUES ('4156', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:10:00');
INSERT INTO `sys_job_log` VALUES ('4157', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:11:00');
INSERT INTO `sys_job_log` VALUES ('4158', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:12:00');
INSERT INTO `sys_job_log` VALUES ('4159', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:13:00');
INSERT INTO `sys_job_log` VALUES ('4160', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:14:00');
INSERT INTO `sys_job_log` VALUES ('4161', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:15:00');
INSERT INTO `sys_job_log` VALUES ('4162', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:16:00');
INSERT INTO `sys_job_log` VALUES ('4163', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:17:00');
INSERT INTO `sys_job_log` VALUES ('4164', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:18:00');
INSERT INTO `sys_job_log` VALUES ('4165', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:19:00');
INSERT INTO `sys_job_log` VALUES ('4166', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:20:00');
INSERT INTO `sys_job_log` VALUES ('4167', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:21:00');
INSERT INTO `sys_job_log` VALUES ('4168', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '1', 'java.lang.reflect.InvocationTargetException\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:497)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:61)\r\n	at com.ruoyi.quartz.util.JobInvokeUtil.invokeMethod(JobInvokeUtil.java:33)\r\n	at com.ruoyi.quartz.util.QuartzJobExecution.doExecute(QuartzJobExecution.java:17)\r\n	at com.ruoyi.quartz.util.AbstractQuartzJob.execute(AbstractQuartzJob.java:44)\r\n	at org.quartz.core.JobRunShell.run(JobRunShell.java:202)\r\n	at org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\r\nCaused by: org.springframework.jdbc.BadSqlGrammarException: \r\n### Error querying database.  Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n### The error may exist in com/ruoyi/system/mapper/ZkActivityInfoMapper.java (best guess)\r\n### The error may involve defaultParameterMap\r\n### The error occurred while setting parameters\r\n### SQL: SELECT  id,p_activity_id,title_type,dept_ids,theme,type,type_name,activity_label,activity_date,address,host_user,recorder,nv_personnel,duration,photo,create_time,create_user,update_time,last_update_user,p_dept_id,p_dept_name,release_time,over_time,execution_time,status,is_del,push_status,speaker,speaker_job,subject_dept_id,subject_activity_id,attendance_rate,leave_rate  FROM zk_activity_info     WHERE (title_type = ? AND push_status = ?)\r\n### Cause: java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\n; bad SQL grammar []; nested exception is java.sql.SQLSyntaxErrorException: Unknown column \'leave_rate\' in \'field list\'\r\n	at org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator.doTranslate(SQLErrorCodeSQLExceptionTranslator.java:239)\r\n	at org.springframework.jdbc.support.Abstract', '2021-11-11 18:22:00');
INSERT INTO `sys_job_log` VALUES ('4169', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:23:00');
INSERT INTO `sys_job_log` VALUES ('4170', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:24:00');
INSERT INTO `sys_job_log` VALUES ('4171', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:25:00');
INSERT INTO `sys_job_log` VALUES ('4172', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 18:26:00');
INSERT INTO `sys_job_log` VALUES ('4173', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 18:27:00');
INSERT INTO `sys_job_log` VALUES ('4174', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 18:28:00');
INSERT INTO `sys_job_log` VALUES ('4175', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 18:29:00');
INSERT INTO `sys_job_log` VALUES ('4176', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 18:30:00');
INSERT INTO `sys_job_log` VALUES ('4177', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:31:00');
INSERT INTO `sys_job_log` VALUES ('4178', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 18:32:00');
INSERT INTO `sys_job_log` VALUES ('4179', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 18:33:00');
INSERT INTO `sys_job_log` VALUES ('4180', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:34:00');
INSERT INTO `sys_job_log` VALUES ('4181', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 18:35:00');
INSERT INTO `sys_job_log` VALUES ('4182', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 18:36:00');
INSERT INTO `sys_job_log` VALUES ('4183', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 18:37:00');
INSERT INTO `sys_job_log` VALUES ('4184', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 18:38:00');
INSERT INTO `sys_job_log` VALUES ('4185', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 18:39:00');
INSERT INTO `sys_job_log` VALUES ('4186', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 18:40:00');
INSERT INTO `sys_job_log` VALUES ('4187', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:41:00');
INSERT INTO `sys_job_log` VALUES ('4188', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 18:42:00');
INSERT INTO `sys_job_log` VALUES ('4189', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 18:43:00');
INSERT INTO `sys_job_log` VALUES ('4190', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 18:44:00');
INSERT INTO `sys_job_log` VALUES ('4191', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:45:00');
INSERT INTO `sys_job_log` VALUES ('4192', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 18:46:00');
INSERT INTO `sys_job_log` VALUES ('4193', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 18:47:00');
INSERT INTO `sys_job_log` VALUES ('4194', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 18:48:00');
INSERT INTO `sys_job_log` VALUES ('4195', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 18:49:00');
INSERT INTO `sys_job_log` VALUES ('4196', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 18:50:00');
INSERT INTO `sys_job_log` VALUES ('4197', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:51:00');
INSERT INTO `sys_job_log` VALUES ('4198', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 18:52:00');
INSERT INTO `sys_job_log` VALUES ('4199', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：45毫秒', '0', '', '2021-11-11 18:53:00');
INSERT INTO `sys_job_log` VALUES ('4200', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 18:54:00');
INSERT INTO `sys_job_log` VALUES ('4201', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 18:55:00');
INSERT INTO `sys_job_log` VALUES ('4202', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 18:56:00');
INSERT INTO `sys_job_log` VALUES ('4203', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 18:57:00');
INSERT INTO `sys_job_log` VALUES ('4204', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 18:58:00');
INSERT INTO `sys_job_log` VALUES ('4205', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 18:59:00');
INSERT INTO `sys_job_log` VALUES ('4206', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:00:00');
INSERT INTO `sys_job_log` VALUES ('4207', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 19:01:00');
INSERT INTO `sys_job_log` VALUES ('4208', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 19:02:00');
INSERT INTO `sys_job_log` VALUES ('4209', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:03:00');
INSERT INTO `sys_job_log` VALUES ('4210', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 19:04:00');
INSERT INTO `sys_job_log` VALUES ('4211', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 19:05:00');
INSERT INTO `sys_job_log` VALUES ('4212', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 19:06:00');
INSERT INTO `sys_job_log` VALUES ('4213', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 19:07:00');
INSERT INTO `sys_job_log` VALUES ('4214', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:08:00');
INSERT INTO `sys_job_log` VALUES ('4215', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-11 19:09:00');
INSERT INTO `sys_job_log` VALUES ('4216', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 19:10:00');
INSERT INTO `sys_job_log` VALUES ('4217', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 19:11:00');
INSERT INTO `sys_job_log` VALUES ('4218', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:12:00');
INSERT INTO `sys_job_log` VALUES ('4219', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:13:00');
INSERT INTO `sys_job_log` VALUES ('4220', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 19:14:00');
INSERT INTO `sys_job_log` VALUES ('4221', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:15:00');
INSERT INTO `sys_job_log` VALUES ('4222', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 19:16:00');
INSERT INTO `sys_job_log` VALUES ('4223', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 19:17:00');
INSERT INTO `sys_job_log` VALUES ('4224', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：32毫秒', '0', '', '2021-11-11 19:18:00');
INSERT INTO `sys_job_log` VALUES ('4225', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 19:19:00');
INSERT INTO `sys_job_log` VALUES ('4226', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:20:00');
INSERT INTO `sys_job_log` VALUES ('4227', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 19:21:00');
INSERT INTO `sys_job_log` VALUES ('4228', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 19:22:00');
INSERT INTO `sys_job_log` VALUES ('4229', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 19:23:00');
INSERT INTO `sys_job_log` VALUES ('4230', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 19:24:00');
INSERT INTO `sys_job_log` VALUES ('4231', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:25:00');
INSERT INTO `sys_job_log` VALUES ('4232', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:26:00');
INSERT INTO `sys_job_log` VALUES ('4233', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 19:27:00');
INSERT INTO `sys_job_log` VALUES ('4234', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:28:00');
INSERT INTO `sys_job_log` VALUES ('4235', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 19:29:00');
INSERT INTO `sys_job_log` VALUES ('4236', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:30:00');
INSERT INTO `sys_job_log` VALUES ('4237', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 19:31:00');
INSERT INTO `sys_job_log` VALUES ('4238', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 19:32:00');
INSERT INTO `sys_job_log` VALUES ('4239', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:33:00');
INSERT INTO `sys_job_log` VALUES ('4240', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 19:34:00');
INSERT INTO `sys_job_log` VALUES ('4241', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:35:00');
INSERT INTO `sys_job_log` VALUES ('4242', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:36:00');
INSERT INTO `sys_job_log` VALUES ('4243', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 19:37:00');
INSERT INTO `sys_job_log` VALUES ('4244', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:38:00');
INSERT INTO `sys_job_log` VALUES ('4245', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:39:00');
INSERT INTO `sys_job_log` VALUES ('4246', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:40:00');
INSERT INTO `sys_job_log` VALUES ('4247', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 19:41:00');
INSERT INTO `sys_job_log` VALUES ('4248', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 19:42:00');
INSERT INTO `sys_job_log` VALUES ('4249', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:43:00');
INSERT INTO `sys_job_log` VALUES ('4250', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:44:00');
INSERT INTO `sys_job_log` VALUES ('4251', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 19:45:00');
INSERT INTO `sys_job_log` VALUES ('4252', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 19:46:00');
INSERT INTO `sys_job_log` VALUES ('4253', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8183毫秒', '0', '', '2021-11-11 19:47:08');
INSERT INTO `sys_job_log` VALUES ('4254', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 19:48:00');
INSERT INTO `sys_job_log` VALUES ('4255', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 19:49:00');
INSERT INTO `sys_job_log` VALUES ('4256', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:50:00');
INSERT INTO `sys_job_log` VALUES ('4257', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7225毫秒', '0', '', '2021-11-11 19:51:07');
INSERT INTO `sys_job_log` VALUES ('4258', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 19:52:00');
INSERT INTO `sys_job_log` VALUES ('4259', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7624毫秒', '0', '', '2021-11-11 19:53:07');
INSERT INTO `sys_job_log` VALUES ('4260', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 19:54:00');
INSERT INTO `sys_job_log` VALUES ('4261', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 19:55:00');
INSERT INTO `sys_job_log` VALUES ('4262', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 19:56:00');
INSERT INTO `sys_job_log` VALUES ('4263', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 19:57:00');
INSERT INTO `sys_job_log` VALUES ('4264', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 19:58:00');
INSERT INTO `sys_job_log` VALUES ('4265', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 19:59:00');
INSERT INTO `sys_job_log` VALUES ('4266', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 20:00:00');
INSERT INTO `sys_job_log` VALUES ('4267', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 20:01:00');
INSERT INTO `sys_job_log` VALUES ('4268', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 20:02:00');
INSERT INTO `sys_job_log` VALUES ('4269', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 20:03:00');
INSERT INTO `sys_job_log` VALUES ('4270', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 20:04:00');
INSERT INTO `sys_job_log` VALUES ('4271', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 20:05:00');
INSERT INTO `sys_job_log` VALUES ('4272', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 20:06:00');
INSERT INTO `sys_job_log` VALUES ('4273', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 20:07:00');
INSERT INTO `sys_job_log` VALUES ('4274', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 20:08:00');
INSERT INTO `sys_job_log` VALUES ('4275', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 20:09:00');
INSERT INTO `sys_job_log` VALUES ('4276', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 20:10:00');
INSERT INTO `sys_job_log` VALUES ('4277', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:11:00');
INSERT INTO `sys_job_log` VALUES ('4278', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 20:12:00');
INSERT INTO `sys_job_log` VALUES ('4279', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 20:13:00');
INSERT INTO `sys_job_log` VALUES ('4280', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 20:14:00');
INSERT INTO `sys_job_log` VALUES ('4281', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 20:15:00');
INSERT INTO `sys_job_log` VALUES ('4282', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 20:16:00');
INSERT INTO `sys_job_log` VALUES ('4283', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:17:00');
INSERT INTO `sys_job_log` VALUES ('4284', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 20:18:00');
INSERT INTO `sys_job_log` VALUES ('4285', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 20:19:00');
INSERT INTO `sys_job_log` VALUES ('4286', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 20:20:00');
INSERT INTO `sys_job_log` VALUES ('4287', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 20:21:00');
INSERT INTO `sys_job_log` VALUES ('4288', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 20:22:00');
INSERT INTO `sys_job_log` VALUES ('4289', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 20:23:00');
INSERT INTO `sys_job_log` VALUES ('4290', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-11 20:24:00');
INSERT INTO `sys_job_log` VALUES ('4291', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 20:25:00');
INSERT INTO `sys_job_log` VALUES ('4292', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:26:00');
INSERT INTO `sys_job_log` VALUES ('4293', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:27:00');
INSERT INTO `sys_job_log` VALUES ('4294', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 20:28:00');
INSERT INTO `sys_job_log` VALUES ('4295', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 20:29:00');
INSERT INTO `sys_job_log` VALUES ('4296', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 20:30:00');
INSERT INTO `sys_job_log` VALUES ('4297', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 20:31:00');
INSERT INTO `sys_job_log` VALUES ('4298', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:32:00');
INSERT INTO `sys_job_log` VALUES ('4299', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 20:33:00');
INSERT INTO `sys_job_log` VALUES ('4300', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:34:00');
INSERT INTO `sys_job_log` VALUES ('4301', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 20:35:00');
INSERT INTO `sys_job_log` VALUES ('4302', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 20:36:00');
INSERT INTO `sys_job_log` VALUES ('4303', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-11 20:37:00');
INSERT INTO `sys_job_log` VALUES ('4304', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 20:38:00');
INSERT INTO `sys_job_log` VALUES ('4305', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:39:00');
INSERT INTO `sys_job_log` VALUES ('4306', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 20:40:00');
INSERT INTO `sys_job_log` VALUES ('4307', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:41:00');
INSERT INTO `sys_job_log` VALUES ('4308', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 20:42:00');
INSERT INTO `sys_job_log` VALUES ('4309', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 20:43:00');
INSERT INTO `sys_job_log` VALUES ('4310', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 20:44:00');
INSERT INTO `sys_job_log` VALUES ('4311', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 20:45:00');
INSERT INTO `sys_job_log` VALUES ('4312', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 20:46:00');
INSERT INTO `sys_job_log` VALUES ('4313', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 20:47:00');
INSERT INTO `sys_job_log` VALUES ('4314', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 20:48:00');
INSERT INTO `sys_job_log` VALUES ('4315', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:49:00');
INSERT INTO `sys_job_log` VALUES ('4316', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 20:50:00');
INSERT INTO `sys_job_log` VALUES ('4317', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 20:51:00');
INSERT INTO `sys_job_log` VALUES ('4318', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-11 20:52:00');
INSERT INTO `sys_job_log` VALUES ('4319', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 20:53:00');
INSERT INTO `sys_job_log` VALUES ('4320', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 20:54:00');
INSERT INTO `sys_job_log` VALUES ('4321', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 20:55:00');
INSERT INTO `sys_job_log` VALUES ('4322', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：29毫秒', '0', '', '2021-11-11 20:56:00');
INSERT INTO `sys_job_log` VALUES ('4323', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 20:57:00');
INSERT INTO `sys_job_log` VALUES ('4324', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 20:58:00');
INSERT INTO `sys_job_log` VALUES ('4325', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 20:59:00');
INSERT INTO `sys_job_log` VALUES ('4326', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 21:00:00');
INSERT INTO `sys_job_log` VALUES ('4327', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:01:00');
INSERT INTO `sys_job_log` VALUES ('4328', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 21:02:00');
INSERT INTO `sys_job_log` VALUES ('4329', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 21:03:00');
INSERT INTO `sys_job_log` VALUES ('4330', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 21:04:00');
INSERT INTO `sys_job_log` VALUES ('4331', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 21:05:00');
INSERT INTO `sys_job_log` VALUES ('4332', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 21:06:00');
INSERT INTO `sys_job_log` VALUES ('4333', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 21:07:00');
INSERT INTO `sys_job_log` VALUES ('4334', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 21:08:00');
INSERT INTO `sys_job_log` VALUES ('4335', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 21:09:00');
INSERT INTO `sys_job_log` VALUES ('4336', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 21:10:00');
INSERT INTO `sys_job_log` VALUES ('4337', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 21:11:00');
INSERT INTO `sys_job_log` VALUES ('4338', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 21:12:00');
INSERT INTO `sys_job_log` VALUES ('4339', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 21:13:00');
INSERT INTO `sys_job_log` VALUES ('4340', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 21:14:00');
INSERT INTO `sys_job_log` VALUES ('4341', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 21:15:00');
INSERT INTO `sys_job_log` VALUES ('4342', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 21:16:00');
INSERT INTO `sys_job_log` VALUES ('4343', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:17:00');
INSERT INTO `sys_job_log` VALUES ('4344', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 21:18:00');
INSERT INTO `sys_job_log` VALUES ('4345', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 21:19:00');
INSERT INTO `sys_job_log` VALUES ('4346', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 21:20:00');
INSERT INTO `sys_job_log` VALUES ('4347', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 21:21:00');
INSERT INTO `sys_job_log` VALUES ('4348', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:22:00');
INSERT INTO `sys_job_log` VALUES ('4349', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 21:23:00');
INSERT INTO `sys_job_log` VALUES ('4350', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 21:24:00');
INSERT INTO `sys_job_log` VALUES ('4351', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 21:25:00');
INSERT INTO `sys_job_log` VALUES ('4352', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:26:00');
INSERT INTO `sys_job_log` VALUES ('4353', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：29毫秒', '0', '', '2021-11-11 21:28:00');
INSERT INTO `sys_job_log` VALUES ('4354', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 21:29:00');
INSERT INTO `sys_job_log` VALUES ('4355', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 21:30:00');
INSERT INTO `sys_job_log` VALUES ('4356', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 21:31:00');
INSERT INTO `sys_job_log` VALUES ('4357', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 21:32:00');
INSERT INTO `sys_job_log` VALUES ('4358', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 21:33:00');
INSERT INTO `sys_job_log` VALUES ('4359', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:34:00');
INSERT INTO `sys_job_log` VALUES ('4360', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 21:35:00');
INSERT INTO `sys_job_log` VALUES ('4361', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 21:36:00');
INSERT INTO `sys_job_log` VALUES ('4362', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 21:37:00');
INSERT INTO `sys_job_log` VALUES ('4363', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 21:38:00');
INSERT INTO `sys_job_log` VALUES ('4364', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 21:39:00');
INSERT INTO `sys_job_log` VALUES ('4365', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:40:00');
INSERT INTO `sys_job_log` VALUES ('4366', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 21:41:00');
INSERT INTO `sys_job_log` VALUES ('4367', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 21:42:00');
INSERT INTO `sys_job_log` VALUES ('4368', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 21:43:00');
INSERT INTO `sys_job_log` VALUES ('4369', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:44:00');
INSERT INTO `sys_job_log` VALUES ('4370', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 21:45:00');
INSERT INTO `sys_job_log` VALUES ('4371', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 21:46:00');
INSERT INTO `sys_job_log` VALUES ('4372', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 21:47:00');
INSERT INTO `sys_job_log` VALUES ('4373', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 21:48:00');
INSERT INTO `sys_job_log` VALUES ('4374', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 21:49:00');
INSERT INTO `sys_job_log` VALUES ('4375', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 21:50:00');
INSERT INTO `sys_job_log` VALUES ('4376', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 21:51:00');
INSERT INTO `sys_job_log` VALUES ('4377', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 21:52:00');
INSERT INTO `sys_job_log` VALUES ('4378', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 21:53:00');
INSERT INTO `sys_job_log` VALUES ('4379', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 21:54:00');
INSERT INTO `sys_job_log` VALUES ('4380', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 21:55:00');
INSERT INTO `sys_job_log` VALUES ('4381', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-11 21:56:00');
INSERT INTO `sys_job_log` VALUES ('4382', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 21:57:00');
INSERT INTO `sys_job_log` VALUES ('4383', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 21:58:00');
INSERT INTO `sys_job_log` VALUES ('4384', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 21:59:00');
INSERT INTO `sys_job_log` VALUES ('4385', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 22:00:00');
INSERT INTO `sys_job_log` VALUES ('4386', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 22:01:00');
INSERT INTO `sys_job_log` VALUES ('4387', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 22:02:00');
INSERT INTO `sys_job_log` VALUES ('4388', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 22:03:00');
INSERT INTO `sys_job_log` VALUES ('4389', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 22:04:00');
INSERT INTO `sys_job_log` VALUES ('4390', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 22:05:00');
INSERT INTO `sys_job_log` VALUES ('4391', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 22:06:00');
INSERT INTO `sys_job_log` VALUES ('4392', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 22:07:00');
INSERT INTO `sys_job_log` VALUES ('4393', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 22:08:00');
INSERT INTO `sys_job_log` VALUES ('4394', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 22:09:00');
INSERT INTO `sys_job_log` VALUES ('4395', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 22:10:00');
INSERT INTO `sys_job_log` VALUES ('4396', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 22:11:00');
INSERT INTO `sys_job_log` VALUES ('4397', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 22:12:00');
INSERT INTO `sys_job_log` VALUES ('4398', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 22:13:00');
INSERT INTO `sys_job_log` VALUES ('4399', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 22:14:00');
INSERT INTO `sys_job_log` VALUES ('4400', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 22:15:00');
INSERT INTO `sys_job_log` VALUES ('4401', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 22:16:00');
INSERT INTO `sys_job_log` VALUES ('4402', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 22:17:00');
INSERT INTO `sys_job_log` VALUES ('4403', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 22:18:00');
INSERT INTO `sys_job_log` VALUES ('4404', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 22:19:00');
INSERT INTO `sys_job_log` VALUES ('4405', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 22:20:00');
INSERT INTO `sys_job_log` VALUES ('4406', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：35毫秒', '0', '', '2021-11-11 22:21:00');
INSERT INTO `sys_job_log` VALUES ('4407', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 22:22:00');
INSERT INTO `sys_job_log` VALUES ('4408', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 22:23:00');
INSERT INTO `sys_job_log` VALUES ('4409', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 22:24:00');
INSERT INTO `sys_job_log` VALUES ('4410', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 22:25:00');
INSERT INTO `sys_job_log` VALUES ('4411', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：34毫秒', '0', '', '2021-11-11 22:27:00');
INSERT INTO `sys_job_log` VALUES ('4412', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-11 22:28:00');
INSERT INTO `sys_job_log` VALUES ('4413', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 22:29:00');
INSERT INTO `sys_job_log` VALUES ('4414', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 22:30:00');
INSERT INTO `sys_job_log` VALUES ('4415', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 22:31:00');
INSERT INTO `sys_job_log` VALUES ('4416', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 22:32:00');
INSERT INTO `sys_job_log` VALUES ('4417', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 22:33:00');
INSERT INTO `sys_job_log` VALUES ('4418', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-11 22:34:00');
INSERT INTO `sys_job_log` VALUES ('4419', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 22:35:00');
INSERT INTO `sys_job_log` VALUES ('4420', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-11 22:36:00');
INSERT INTO `sys_job_log` VALUES ('4421', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 22:37:00');
INSERT INTO `sys_job_log` VALUES ('4422', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 22:38:00');
INSERT INTO `sys_job_log` VALUES ('4423', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 22:39:00');
INSERT INTO `sys_job_log` VALUES ('4424', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 22:40:00');
INSERT INTO `sys_job_log` VALUES ('4425', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-11 22:41:00');
INSERT INTO `sys_job_log` VALUES ('4426', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 22:42:00');
INSERT INTO `sys_job_log` VALUES ('4427', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 22:43:00');
INSERT INTO `sys_job_log` VALUES ('4428', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 22:44:00');
INSERT INTO `sys_job_log` VALUES ('4429', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 22:45:00');
INSERT INTO `sys_job_log` VALUES ('4430', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-11 22:46:00');
INSERT INTO `sys_job_log` VALUES ('4431', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 22:47:00');
INSERT INTO `sys_job_log` VALUES ('4432', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 22:48:00');
INSERT INTO `sys_job_log` VALUES ('4433', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-11 22:49:00');
INSERT INTO `sys_job_log` VALUES ('4434', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-11 22:50:00');
INSERT INTO `sys_job_log` VALUES ('4435', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 22:51:00');
INSERT INTO `sys_job_log` VALUES ('4436', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 22:52:00');
INSERT INTO `sys_job_log` VALUES ('4437', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：30毫秒', '0', '', '2021-11-11 22:53:00');
INSERT INTO `sys_job_log` VALUES ('4438', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 22:54:00');
INSERT INTO `sys_job_log` VALUES ('4439', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 22:55:00');
INSERT INTO `sys_job_log` VALUES ('4440', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 22:56:00');
INSERT INTO `sys_job_log` VALUES ('4441', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 22:57:00');
INSERT INTO `sys_job_log` VALUES ('4442', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 22:58:00');
INSERT INTO `sys_job_log` VALUES ('4443', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 22:59:00');
INSERT INTO `sys_job_log` VALUES ('4444', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 23:00:00');
INSERT INTO `sys_job_log` VALUES ('4445', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 23:01:00');
INSERT INTO `sys_job_log` VALUES ('4446', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 23:02:00');
INSERT INTO `sys_job_log` VALUES ('4447', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 23:03:00');
INSERT INTO `sys_job_log` VALUES ('4448', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 23:04:00');
INSERT INTO `sys_job_log` VALUES ('4449', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 23:05:00');
INSERT INTO `sys_job_log` VALUES ('4450', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:06:00');
INSERT INTO `sys_job_log` VALUES ('4451', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 23:07:00');
INSERT INTO `sys_job_log` VALUES ('4452', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 23:08:00');
INSERT INTO `sys_job_log` VALUES ('4453', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 23:09:00');
INSERT INTO `sys_job_log` VALUES ('4454', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-11 23:10:00');
INSERT INTO `sys_job_log` VALUES ('4455', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 23:11:00');
INSERT INTO `sys_job_log` VALUES ('4456', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 23:12:00');
INSERT INTO `sys_job_log` VALUES ('4457', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 23:13:00');
INSERT INTO `sys_job_log` VALUES ('4458', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-11 23:14:00');
INSERT INTO `sys_job_log` VALUES ('4459', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 23:15:00');
INSERT INTO `sys_job_log` VALUES ('4460', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-11 23:16:00');
INSERT INTO `sys_job_log` VALUES ('4461', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 23:17:00');
INSERT INTO `sys_job_log` VALUES ('4462', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-11 23:18:00');
INSERT INTO `sys_job_log` VALUES ('4463', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 23:19:00');
INSERT INTO `sys_job_log` VALUES ('4464', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-11 23:20:00');
INSERT INTO `sys_job_log` VALUES ('4465', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:21:00');
INSERT INTO `sys_job_log` VALUES ('4466', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-11 23:22:00');
INSERT INTO `sys_job_log` VALUES ('4467', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:23:00');
INSERT INTO `sys_job_log` VALUES ('4468', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:24:00');
INSERT INTO `sys_job_log` VALUES ('4469', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 23:25:00');
INSERT INTO `sys_job_log` VALUES ('4470', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:26:00');
INSERT INTO `sys_job_log` VALUES ('4471', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 23:27:00');
INSERT INTO `sys_job_log` VALUES ('4472', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 23:28:00');
INSERT INTO `sys_job_log` VALUES ('4473', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 23:29:00');
INSERT INTO `sys_job_log` VALUES ('4474', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 23:30:00');
INSERT INTO `sys_job_log` VALUES ('4475', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:31:00');
INSERT INTO `sys_job_log` VALUES ('4476', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 23:32:00');
INSERT INTO `sys_job_log` VALUES ('4477', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-11 23:33:00');
INSERT INTO `sys_job_log` VALUES ('4478', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 23:34:00');
INSERT INTO `sys_job_log` VALUES ('4479', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-11 23:35:00');
INSERT INTO `sys_job_log` VALUES ('4480', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:36:00');
INSERT INTO `sys_job_log` VALUES ('4481', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-11 23:37:00');
INSERT INTO `sys_job_log` VALUES ('4482', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:38:00');
INSERT INTO `sys_job_log` VALUES ('4483', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:39:00');
INSERT INTO `sys_job_log` VALUES ('4484', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:40:00');
INSERT INTO `sys_job_log` VALUES ('4485', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 23:41:00');
INSERT INTO `sys_job_log` VALUES ('4486', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:42:00');
INSERT INTO `sys_job_log` VALUES ('4487', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 23:43:00');
INSERT INTO `sys_job_log` VALUES ('4488', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:44:00');
INSERT INTO `sys_job_log` VALUES ('4489', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-11 23:45:00');
INSERT INTO `sys_job_log` VALUES ('4490', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 23:46:00');
INSERT INTO `sys_job_log` VALUES ('4491', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:47:00');
INSERT INTO `sys_job_log` VALUES ('4492', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：29毫秒', '0', '', '2021-11-11 23:48:00');
INSERT INTO `sys_job_log` VALUES ('4493', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:49:00');
INSERT INTO `sys_job_log` VALUES ('4494', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:50:00');
INSERT INTO `sys_job_log` VALUES ('4495', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-11 23:51:00');
INSERT INTO `sys_job_log` VALUES ('4496', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-11 23:52:00');
INSERT INTO `sys_job_log` VALUES ('4497', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-11 23:53:00');
INSERT INTO `sys_job_log` VALUES ('4498', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-11 23:54:00');
INSERT INTO `sys_job_log` VALUES ('4499', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-11 23:55:00');
INSERT INTO `sys_job_log` VALUES ('4500', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-11 23:56:00');
INSERT INTO `sys_job_log` VALUES ('4501', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-11 23:57:00');
INSERT INTO `sys_job_log` VALUES ('4502', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-11 23:58:00');
INSERT INTO `sys_job_log` VALUES ('4503', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-11 23:59:00');
INSERT INTO `sys_job_log` VALUES ('4504', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:00:00');
INSERT INTO `sys_job_log` VALUES ('4505', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 00:01:00');
INSERT INTO `sys_job_log` VALUES ('4506', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 00:02:00');
INSERT INTO `sys_job_log` VALUES ('4507', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 00:03:00');
INSERT INTO `sys_job_log` VALUES ('4508', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 00:04:00');
INSERT INTO `sys_job_log` VALUES ('4509', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:05:00');
INSERT INTO `sys_job_log` VALUES ('4510', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:06:00');
INSERT INTO `sys_job_log` VALUES ('4511', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:07:00');
INSERT INTO `sys_job_log` VALUES ('4512', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 00:08:00');
INSERT INTO `sys_job_log` VALUES ('4513', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 00:09:00');
INSERT INTO `sys_job_log` VALUES ('4514', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 00:10:00');
INSERT INTO `sys_job_log` VALUES ('4515', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 00:11:00');
INSERT INTO `sys_job_log` VALUES ('4516', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 00:12:00');
INSERT INTO `sys_job_log` VALUES ('4517', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:13:00');
INSERT INTO `sys_job_log` VALUES ('4518', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:14:00');
INSERT INTO `sys_job_log` VALUES ('4519', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 00:15:00');
INSERT INTO `sys_job_log` VALUES ('4520', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 00:16:00');
INSERT INTO `sys_job_log` VALUES ('4521', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 00:17:00');
INSERT INTO `sys_job_log` VALUES ('4522', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-12 00:18:00');
INSERT INTO `sys_job_log` VALUES ('4523', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 00:19:00');
INSERT INTO `sys_job_log` VALUES ('4524', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 00:20:00');
INSERT INTO `sys_job_log` VALUES ('4525', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 00:21:00');
INSERT INTO `sys_job_log` VALUES ('4526', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 00:22:00');
INSERT INTO `sys_job_log` VALUES ('4527', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 00:23:00');
INSERT INTO `sys_job_log` VALUES ('4528', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:24:00');
INSERT INTO `sys_job_log` VALUES ('4529', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 00:25:00');
INSERT INTO `sys_job_log` VALUES ('4530', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 00:26:00');
INSERT INTO `sys_job_log` VALUES ('4531', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:27:00');
INSERT INTO `sys_job_log` VALUES ('4532', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 00:28:00');
INSERT INTO `sys_job_log` VALUES ('4533', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 00:29:00');
INSERT INTO `sys_job_log` VALUES ('4534', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 00:30:00');
INSERT INTO `sys_job_log` VALUES ('4535', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:31:00');
INSERT INTO `sys_job_log` VALUES ('4536', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 00:32:00');
INSERT INTO `sys_job_log` VALUES ('4537', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:33:00');
INSERT INTO `sys_job_log` VALUES ('4538', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 00:34:00');
INSERT INTO `sys_job_log` VALUES ('4539', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 00:35:00');
INSERT INTO `sys_job_log` VALUES ('4540', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:36:00');
INSERT INTO `sys_job_log` VALUES ('4541', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 00:37:00');
INSERT INTO `sys_job_log` VALUES ('4542', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 00:38:00');
INSERT INTO `sys_job_log` VALUES ('4543', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:39:00');
INSERT INTO `sys_job_log` VALUES ('4544', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 00:40:00');
INSERT INTO `sys_job_log` VALUES ('4545', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 00:41:00');
INSERT INTO `sys_job_log` VALUES ('4546', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:42:00');
INSERT INTO `sys_job_log` VALUES ('4547', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:43:00');
INSERT INTO `sys_job_log` VALUES ('4548', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:44:00');
INSERT INTO `sys_job_log` VALUES ('4549', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:45:00');
INSERT INTO `sys_job_log` VALUES ('4550', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:46:00');
INSERT INTO `sys_job_log` VALUES ('4551', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 00:47:00');
INSERT INTO `sys_job_log` VALUES ('4552', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 00:48:00');
INSERT INTO `sys_job_log` VALUES ('4553', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 00:49:00');
INSERT INTO `sys_job_log` VALUES ('4554', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 00:50:00');
INSERT INTO `sys_job_log` VALUES ('4555', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:51:00');
INSERT INTO `sys_job_log` VALUES ('4556', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 00:52:00');
INSERT INTO `sys_job_log` VALUES ('4557', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：49毫秒', '0', '', '2021-11-12 00:53:00');
INSERT INTO `sys_job_log` VALUES ('4558', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 00:54:00');
INSERT INTO `sys_job_log` VALUES ('4559', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 00:55:00');
INSERT INTO `sys_job_log` VALUES ('4560', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 00:56:00');
INSERT INTO `sys_job_log` VALUES ('4561', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 00:57:00');
INSERT INTO `sys_job_log` VALUES ('4562', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 00:58:00');
INSERT INTO `sys_job_log` VALUES ('4563', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 00:59:00');
INSERT INTO `sys_job_log` VALUES ('4564', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 01:00:00');
INSERT INTO `sys_job_log` VALUES ('4565', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:01:00');
INSERT INTO `sys_job_log` VALUES ('4566', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 01:02:00');
INSERT INTO `sys_job_log` VALUES ('4567', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 01:03:00');
INSERT INTO `sys_job_log` VALUES ('4568', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-12 01:04:00');
INSERT INTO `sys_job_log` VALUES ('4569', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:05:00');
INSERT INTO `sys_job_log` VALUES ('4570', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 01:06:00');
INSERT INTO `sys_job_log` VALUES ('4571', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:07:00');
INSERT INTO `sys_job_log` VALUES ('4572', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 01:08:00');
INSERT INTO `sys_job_log` VALUES ('4573', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:09:00');
INSERT INTO `sys_job_log` VALUES ('4574', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 01:10:00');
INSERT INTO `sys_job_log` VALUES ('4575', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 01:11:00');
INSERT INTO `sys_job_log` VALUES ('4576', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 01:12:01');
INSERT INTO `sys_job_log` VALUES ('4577', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:13:00');
INSERT INTO `sys_job_log` VALUES ('4578', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 01:14:00');
INSERT INTO `sys_job_log` VALUES ('4579', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 01:15:00');
INSERT INTO `sys_job_log` VALUES ('4580', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:16:00');
INSERT INTO `sys_job_log` VALUES ('4581', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-12 01:17:00');
INSERT INTO `sys_job_log` VALUES ('4582', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:18:00');
INSERT INTO `sys_job_log` VALUES ('4583', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:19:00');
INSERT INTO `sys_job_log` VALUES ('4584', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 01:20:00');
INSERT INTO `sys_job_log` VALUES ('4585', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 01:21:00');
INSERT INTO `sys_job_log` VALUES ('4586', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 01:22:00');
INSERT INTO `sys_job_log` VALUES ('4587', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 01:23:00');
INSERT INTO `sys_job_log` VALUES ('4588', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:24:00');
INSERT INTO `sys_job_log` VALUES ('4589', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:25:00');
INSERT INTO `sys_job_log` VALUES ('4590', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 01:26:00');
INSERT INTO `sys_job_log` VALUES ('4591', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:27:00');
INSERT INTO `sys_job_log` VALUES ('4592', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:28:00');
INSERT INTO `sys_job_log` VALUES ('4593', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:29:00');
INSERT INTO `sys_job_log` VALUES ('4594', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:30:00');
INSERT INTO `sys_job_log` VALUES ('4595', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 01:31:00');
INSERT INTO `sys_job_log` VALUES ('4596', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:32:00');
INSERT INTO `sys_job_log` VALUES ('4597', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:33:00');
INSERT INTO `sys_job_log` VALUES ('4598', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 01:34:00');
INSERT INTO `sys_job_log` VALUES ('4599', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 01:35:00');
INSERT INTO `sys_job_log` VALUES ('4600', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 01:36:00');
INSERT INTO `sys_job_log` VALUES ('4601', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 01:37:00');
INSERT INTO `sys_job_log` VALUES ('4602', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 01:38:00');
INSERT INTO `sys_job_log` VALUES ('4603', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 01:39:00');
INSERT INTO `sys_job_log` VALUES ('4604', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 01:40:00');
INSERT INTO `sys_job_log` VALUES ('4605', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：45毫秒', '0', '', '2021-11-12 01:42:00');
INSERT INTO `sys_job_log` VALUES ('4606', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：91毫秒', '0', '', '2021-11-12 01:43:00');
INSERT INTO `sys_job_log` VALUES ('4607', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 01:44:00');
INSERT INTO `sys_job_log` VALUES ('4608', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:45:00');
INSERT INTO `sys_job_log` VALUES ('4609', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 01:46:00');
INSERT INTO `sys_job_log` VALUES ('4610', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：31毫秒', '0', '', '2021-11-12 01:47:00');
INSERT INTO `sys_job_log` VALUES ('4611', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 01:48:00');
INSERT INTO `sys_job_log` VALUES ('4612', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 01:49:00');
INSERT INTO `sys_job_log` VALUES ('4613', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:50:00');
INSERT INTO `sys_job_log` VALUES ('4614', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 01:51:00');
INSERT INTO `sys_job_log` VALUES ('4615', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 01:52:00');
INSERT INTO `sys_job_log` VALUES ('4616', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 01:53:00');
INSERT INTO `sys_job_log` VALUES ('4617', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-12 01:54:00');
INSERT INTO `sys_job_log` VALUES ('4618', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 01:55:00');
INSERT INTO `sys_job_log` VALUES ('4619', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 01:56:00');
INSERT INTO `sys_job_log` VALUES ('4620', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 01:57:00');
INSERT INTO `sys_job_log` VALUES ('4621', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 01:58:00');
INSERT INTO `sys_job_log` VALUES ('4622', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 01:59:00');
INSERT INTO `sys_job_log` VALUES ('4623', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 02:00:00');
INSERT INTO `sys_job_log` VALUES ('4624', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 02:01:00');
INSERT INTO `sys_job_log` VALUES ('4625', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 02:02:00');
INSERT INTO `sys_job_log` VALUES ('4626', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 02:03:00');
INSERT INTO `sys_job_log` VALUES ('4627', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-12 02:04:00');
INSERT INTO `sys_job_log` VALUES ('4628', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 02:05:00');
INSERT INTO `sys_job_log` VALUES ('4629', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 02:06:00');
INSERT INTO `sys_job_log` VALUES ('4630', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 02:07:00');
INSERT INTO `sys_job_log` VALUES ('4631', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-12 02:08:00');
INSERT INTO `sys_job_log` VALUES ('4632', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 02:09:00');
INSERT INTO `sys_job_log` VALUES ('4633', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 02:10:00');
INSERT INTO `sys_job_log` VALUES ('4634', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:11:00');
INSERT INTO `sys_job_log` VALUES ('4635', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 02:12:00');
INSERT INTO `sys_job_log` VALUES ('4636', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 02:13:00');
INSERT INTO `sys_job_log` VALUES ('4637', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-12 02:14:00');
INSERT INTO `sys_job_log` VALUES ('4638', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 02:15:00');
INSERT INTO `sys_job_log` VALUES ('4639', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 02:16:00');
INSERT INTO `sys_job_log` VALUES ('4640', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 02:17:00');
INSERT INTO `sys_job_log` VALUES ('4641', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:18:00');
INSERT INTO `sys_job_log` VALUES ('4642', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 02:19:00');
INSERT INTO `sys_job_log` VALUES ('4643', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 02:20:00');
INSERT INTO `sys_job_log` VALUES ('4644', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:21:00');
INSERT INTO `sys_job_log` VALUES ('4645', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 02:22:00');
INSERT INTO `sys_job_log` VALUES ('4646', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 02:23:00');
INSERT INTO `sys_job_log` VALUES ('4647', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 02:24:00');
INSERT INTO `sys_job_log` VALUES ('4648', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-12 02:25:00');
INSERT INTO `sys_job_log` VALUES ('4649', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 02:26:00');
INSERT INTO `sys_job_log` VALUES ('4650', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 02:27:00');
INSERT INTO `sys_job_log` VALUES ('4651', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 02:28:00');
INSERT INTO `sys_job_log` VALUES ('4652', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 02:29:00');
INSERT INTO `sys_job_log` VALUES ('4653', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 02:30:00');
INSERT INTO `sys_job_log` VALUES ('4654', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 02:31:00');
INSERT INTO `sys_job_log` VALUES ('4655', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 02:32:00');
INSERT INTO `sys_job_log` VALUES ('4656', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 02:33:00');
INSERT INTO `sys_job_log` VALUES ('4657', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 02:34:00');
INSERT INTO `sys_job_log` VALUES ('4658', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 02:35:00');
INSERT INTO `sys_job_log` VALUES ('4659', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-12 02:36:00');
INSERT INTO `sys_job_log` VALUES ('4660', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 02:37:00');
INSERT INTO `sys_job_log` VALUES ('4661', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 02:38:00');
INSERT INTO `sys_job_log` VALUES ('4662', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 02:39:00');
INSERT INTO `sys_job_log` VALUES ('4663', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-12 02:40:00');
INSERT INTO `sys_job_log` VALUES ('4664', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 02:41:00');
INSERT INTO `sys_job_log` VALUES ('4665', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:42:00');
INSERT INTO `sys_job_log` VALUES ('4666', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-12 02:43:00');
INSERT INTO `sys_job_log` VALUES ('4667', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 02:44:00');
INSERT INTO `sys_job_log` VALUES ('4668', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:45:00');
INSERT INTO `sys_job_log` VALUES ('4669', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:46:00');
INSERT INTO `sys_job_log` VALUES ('4670', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 02:47:00');
INSERT INTO `sys_job_log` VALUES ('4671', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 02:48:00');
INSERT INTO `sys_job_log` VALUES ('4672', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 02:49:00');
INSERT INTO `sys_job_log` VALUES ('4673', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:50:00');
INSERT INTO `sys_job_log` VALUES ('4674', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 02:51:00');
INSERT INTO `sys_job_log` VALUES ('4675', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 02:52:00');
INSERT INTO `sys_job_log` VALUES ('4676', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 02:53:00');
INSERT INTO `sys_job_log` VALUES ('4677', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 02:54:00');
INSERT INTO `sys_job_log` VALUES ('4678', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 02:55:00');
INSERT INTO `sys_job_log` VALUES ('4679', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 02:56:00');
INSERT INTO `sys_job_log` VALUES ('4680', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 02:57:00');
INSERT INTO `sys_job_log` VALUES ('4681', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 02:58:00');
INSERT INTO `sys_job_log` VALUES ('4682', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 02:59:00');
INSERT INTO `sys_job_log` VALUES ('4683', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:00:00');
INSERT INTO `sys_job_log` VALUES ('4684', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-12 03:01:00');
INSERT INTO `sys_job_log` VALUES ('4685', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 03:02:00');
INSERT INTO `sys_job_log` VALUES ('4686', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 03:03:00');
INSERT INTO `sys_job_log` VALUES ('4687', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-12 03:04:00');
INSERT INTO `sys_job_log` VALUES ('4688', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 03:05:00');
INSERT INTO `sys_job_log` VALUES ('4689', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：35毫秒', '0', '', '2021-11-12 03:06:00');
INSERT INTO `sys_job_log` VALUES ('4690', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-12 03:07:00');
INSERT INTO `sys_job_log` VALUES ('4691', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 03:08:00');
INSERT INTO `sys_job_log` VALUES ('4692', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 03:09:00');
INSERT INTO `sys_job_log` VALUES ('4693', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:10:00');
INSERT INTO `sys_job_log` VALUES ('4694', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-12 03:11:00');
INSERT INTO `sys_job_log` VALUES ('4695', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 03:12:00');
INSERT INTO `sys_job_log` VALUES ('4696', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 03:13:00');
INSERT INTO `sys_job_log` VALUES ('4697', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:14:00');
INSERT INTO `sys_job_log` VALUES ('4698', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:15:00');
INSERT INTO `sys_job_log` VALUES ('4699', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 03:16:00');
INSERT INTO `sys_job_log` VALUES ('4700', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 03:17:00');
INSERT INTO `sys_job_log` VALUES ('4701', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:18:00');
INSERT INTO `sys_job_log` VALUES ('4702', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 03:19:00');
INSERT INTO `sys_job_log` VALUES ('4703', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 03:20:00');
INSERT INTO `sys_job_log` VALUES ('4704', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 03:21:00');
INSERT INTO `sys_job_log` VALUES ('4705', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 03:22:00');
INSERT INTO `sys_job_log` VALUES ('4706', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 03:23:00');
INSERT INTO `sys_job_log` VALUES ('4707', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:24:00');
INSERT INTO `sys_job_log` VALUES ('4708', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 03:25:00');
INSERT INTO `sys_job_log` VALUES ('4709', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:26:00');
INSERT INTO `sys_job_log` VALUES ('4710', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 03:27:00');
INSERT INTO `sys_job_log` VALUES ('4711', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:28:00');
INSERT INTO `sys_job_log` VALUES ('4712', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 03:29:00');
INSERT INTO `sys_job_log` VALUES ('4713', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:30:00');
INSERT INTO `sys_job_log` VALUES ('4714', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 03:31:00');
INSERT INTO `sys_job_log` VALUES ('4715', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-12 03:32:00');
INSERT INTO `sys_job_log` VALUES ('4716', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 03:33:00');
INSERT INTO `sys_job_log` VALUES ('4717', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 03:34:00');
INSERT INTO `sys_job_log` VALUES ('4718', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:35:00');
INSERT INTO `sys_job_log` VALUES ('4719', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 03:36:00');
INSERT INTO `sys_job_log` VALUES ('4720', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 03:37:00');
INSERT INTO `sys_job_log` VALUES ('4721', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 03:38:00');
INSERT INTO `sys_job_log` VALUES ('4722', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 03:39:00');
INSERT INTO `sys_job_log` VALUES ('4723', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:40:00');
INSERT INTO `sys_job_log` VALUES ('4724', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:41:00');
INSERT INTO `sys_job_log` VALUES ('4725', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 03:42:00');
INSERT INTO `sys_job_log` VALUES ('4726', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 03:43:00');
INSERT INTO `sys_job_log` VALUES ('4727', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 03:44:00');
INSERT INTO `sys_job_log` VALUES ('4728', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 03:45:00');
INSERT INTO `sys_job_log` VALUES ('4729', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:46:00');
INSERT INTO `sys_job_log` VALUES ('4730', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:47:00');
INSERT INTO `sys_job_log` VALUES ('4731', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 03:48:00');
INSERT INTO `sys_job_log` VALUES ('4732', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:49:00');
INSERT INTO `sys_job_log` VALUES ('4733', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:50:00');
INSERT INTO `sys_job_log` VALUES ('4734', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 03:51:00');
INSERT INTO `sys_job_log` VALUES ('4735', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 03:52:00');
INSERT INTO `sys_job_log` VALUES ('4736', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-12 03:53:00');
INSERT INTO `sys_job_log` VALUES ('4737', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:54:00');
INSERT INTO `sys_job_log` VALUES ('4738', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 03:55:00');
INSERT INTO `sys_job_log` VALUES ('4739', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 03:56:00');
INSERT INTO `sys_job_log` VALUES ('4740', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 03:57:00');
INSERT INTO `sys_job_log` VALUES ('4741', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 03:58:00');
INSERT INTO `sys_job_log` VALUES ('4742', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 03:59:00');
INSERT INTO `sys_job_log` VALUES ('4743', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 04:00:00');
INSERT INTO `sys_job_log` VALUES ('4744', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 04:01:00');
INSERT INTO `sys_job_log` VALUES ('4745', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 04:02:00');
INSERT INTO `sys_job_log` VALUES ('4746', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:03:00');
INSERT INTO `sys_job_log` VALUES ('4747', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 04:04:00');
INSERT INTO `sys_job_log` VALUES ('4748', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:05:00');
INSERT INTO `sys_job_log` VALUES ('4749', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 04:06:00');
INSERT INTO `sys_job_log` VALUES ('4750', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:07:00');
INSERT INTO `sys_job_log` VALUES ('4751', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:08:00');
INSERT INTO `sys_job_log` VALUES ('4752', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 04:09:00');
INSERT INTO `sys_job_log` VALUES ('4753', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 04:10:00');
INSERT INTO `sys_job_log` VALUES ('4754', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 04:11:00');
INSERT INTO `sys_job_log` VALUES ('4755', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 04:12:00');
INSERT INTO `sys_job_log` VALUES ('4756', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:13:00');
INSERT INTO `sys_job_log` VALUES ('4757', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:14:00');
INSERT INTO `sys_job_log` VALUES ('4758', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 04:15:00');
INSERT INTO `sys_job_log` VALUES ('4759', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 04:16:00');
INSERT INTO `sys_job_log` VALUES ('4760', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:17:00');
INSERT INTO `sys_job_log` VALUES ('4761', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 04:18:00');
INSERT INTO `sys_job_log` VALUES ('4762', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 04:19:00');
INSERT INTO `sys_job_log` VALUES ('4763', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:20:00');
INSERT INTO `sys_job_log` VALUES ('4764', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 04:21:00');
INSERT INTO `sys_job_log` VALUES ('4765', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 04:22:00');
INSERT INTO `sys_job_log` VALUES ('4766', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:23:00');
INSERT INTO `sys_job_log` VALUES ('4767', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 04:24:00');
INSERT INTO `sys_job_log` VALUES ('4768', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:25:00');
INSERT INTO `sys_job_log` VALUES ('4769', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:26:00');
INSERT INTO `sys_job_log` VALUES ('4770', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:27:00');
INSERT INTO `sys_job_log` VALUES ('4771', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 04:28:00');
INSERT INTO `sys_job_log` VALUES ('4772', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 04:29:00');
INSERT INTO `sys_job_log` VALUES ('4773', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 04:30:00');
INSERT INTO `sys_job_log` VALUES ('4774', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 04:31:00');
INSERT INTO `sys_job_log` VALUES ('4775', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 04:32:00');
INSERT INTO `sys_job_log` VALUES ('4776', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 04:33:00');
INSERT INTO `sys_job_log` VALUES ('4777', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 04:34:00');
INSERT INTO `sys_job_log` VALUES ('4778', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 04:35:00');
INSERT INTO `sys_job_log` VALUES ('4779', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 04:36:00');
INSERT INTO `sys_job_log` VALUES ('4780', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 04:37:00');
INSERT INTO `sys_job_log` VALUES ('4781', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 04:38:00');
INSERT INTO `sys_job_log` VALUES ('4782', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:39:00');
INSERT INTO `sys_job_log` VALUES ('4783', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 04:40:00');
INSERT INTO `sys_job_log` VALUES ('4784', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:41:00');
INSERT INTO `sys_job_log` VALUES ('4785', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 04:42:00');
INSERT INTO `sys_job_log` VALUES ('4786', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 04:43:00');
INSERT INTO `sys_job_log` VALUES ('4787', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 04:44:00');
INSERT INTO `sys_job_log` VALUES ('4788', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 04:45:00');
INSERT INTO `sys_job_log` VALUES ('4789', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 04:46:00');
INSERT INTO `sys_job_log` VALUES ('4790', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 04:47:00');
INSERT INTO `sys_job_log` VALUES ('4791', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 04:48:00');
INSERT INTO `sys_job_log` VALUES ('4792', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 04:49:00');
INSERT INTO `sys_job_log` VALUES ('4793', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 04:50:00');
INSERT INTO `sys_job_log` VALUES ('4794', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 04:51:00');
INSERT INTO `sys_job_log` VALUES ('4795', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 04:52:00');
INSERT INTO `sys_job_log` VALUES ('4796', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 04:53:00');
INSERT INTO `sys_job_log` VALUES ('4797', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 04:54:00');
INSERT INTO `sys_job_log` VALUES ('4798', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 04:55:00');
INSERT INTO `sys_job_log` VALUES ('4799', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 04:56:00');
INSERT INTO `sys_job_log` VALUES ('4800', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 04:57:00');
INSERT INTO `sys_job_log` VALUES ('4801', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：0毫秒', '0', '', '2021-11-12 04:58:00');
INSERT INTO `sys_job_log` VALUES ('4802', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 04:59:00');
INSERT INTO `sys_job_log` VALUES ('4803', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 05:00:00');
INSERT INTO `sys_job_log` VALUES ('4804', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:01:00');
INSERT INTO `sys_job_log` VALUES ('4805', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 05:02:00');
INSERT INTO `sys_job_log` VALUES ('4806', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:03:00');
INSERT INTO `sys_job_log` VALUES ('4807', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 05:04:00');
INSERT INTO `sys_job_log` VALUES ('4808', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 05:05:00');
INSERT INTO `sys_job_log` VALUES ('4809', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 05:06:00');
INSERT INTO `sys_job_log` VALUES ('4810', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 05:07:00');
INSERT INTO `sys_job_log` VALUES ('4811', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 05:08:00');
INSERT INTO `sys_job_log` VALUES ('4812', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 05:09:00');
INSERT INTO `sys_job_log` VALUES ('4813', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 05:10:00');
INSERT INTO `sys_job_log` VALUES ('4814', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 05:11:00');
INSERT INTO `sys_job_log` VALUES ('4815', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 05:12:00');
INSERT INTO `sys_job_log` VALUES ('4816', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 05:13:00');
INSERT INTO `sys_job_log` VALUES ('4817', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:14:00');
INSERT INTO `sys_job_log` VALUES ('4818', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:15:00');
INSERT INTO `sys_job_log` VALUES ('4819', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 05:16:00');
INSERT INTO `sys_job_log` VALUES ('4820', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:17:00');
INSERT INTO `sys_job_log` VALUES ('4821', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 05:18:00');
INSERT INTO `sys_job_log` VALUES ('4822', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:19:00');
INSERT INTO `sys_job_log` VALUES ('4823', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 05:20:00');
INSERT INTO `sys_job_log` VALUES ('4824', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 05:21:00');
INSERT INTO `sys_job_log` VALUES ('4825', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 05:22:00');
INSERT INTO `sys_job_log` VALUES ('4826', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 05:23:00');
INSERT INTO `sys_job_log` VALUES ('4827', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 05:24:00');
INSERT INTO `sys_job_log` VALUES ('4828', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:25:00');
INSERT INTO `sys_job_log` VALUES ('4829', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 05:26:00');
INSERT INTO `sys_job_log` VALUES ('4830', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:27:00');
INSERT INTO `sys_job_log` VALUES ('4831', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 05:28:00');
INSERT INTO `sys_job_log` VALUES ('4832', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:29:00');
INSERT INTO `sys_job_log` VALUES ('4833', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 05:30:00');
INSERT INTO `sys_job_log` VALUES ('4834', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 05:31:00');
INSERT INTO `sys_job_log` VALUES ('4835', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 05:32:00');
INSERT INTO `sys_job_log` VALUES ('4836', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:33:00');
INSERT INTO `sys_job_log` VALUES ('4837', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 05:34:00');
INSERT INTO `sys_job_log` VALUES ('4838', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:35:00');
INSERT INTO `sys_job_log` VALUES ('4839', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:36:00');
INSERT INTO `sys_job_log` VALUES ('4840', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:37:00');
INSERT INTO `sys_job_log` VALUES ('4841', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 05:38:00');
INSERT INTO `sys_job_log` VALUES ('4842', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 05:39:00');
INSERT INTO `sys_job_log` VALUES ('4843', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 05:40:00');
INSERT INTO `sys_job_log` VALUES ('4844', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:41:00');
INSERT INTO `sys_job_log` VALUES ('4845', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 05:42:00');
INSERT INTO `sys_job_log` VALUES ('4846', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 05:43:00');
INSERT INTO `sys_job_log` VALUES ('4847', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 05:44:00');
INSERT INTO `sys_job_log` VALUES ('4848', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:45:00');
INSERT INTO `sys_job_log` VALUES ('4849', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 05:46:00');
INSERT INTO `sys_job_log` VALUES ('4850', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 05:47:00');
INSERT INTO `sys_job_log` VALUES ('4851', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 05:48:00');
INSERT INTO `sys_job_log` VALUES ('4852', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:49:00');
INSERT INTO `sys_job_log` VALUES ('4853', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:50:00');
INSERT INTO `sys_job_log` VALUES ('4854', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 05:51:00');
INSERT INTO `sys_job_log` VALUES ('4855', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：35毫秒', '0', '', '2021-11-12 05:52:00');
INSERT INTO `sys_job_log` VALUES ('4856', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 05:53:00');
INSERT INTO `sys_job_log` VALUES ('4857', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 05:54:00');
INSERT INTO `sys_job_log` VALUES ('4858', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 05:55:00');
INSERT INTO `sys_job_log` VALUES ('4859', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 05:56:00');
INSERT INTO `sys_job_log` VALUES ('4860', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 05:57:00');
INSERT INTO `sys_job_log` VALUES ('4861', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 05:58:00');
INSERT INTO `sys_job_log` VALUES ('4862', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 05:59:00');
INSERT INTO `sys_job_log` VALUES ('4863', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 06:00:00');
INSERT INTO `sys_job_log` VALUES ('4864', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 06:01:00');
INSERT INTO `sys_job_log` VALUES ('4865', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 06:02:00');
INSERT INTO `sys_job_log` VALUES ('4866', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:03:00');
INSERT INTO `sys_job_log` VALUES ('4867', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 06:04:00');
INSERT INTO `sys_job_log` VALUES ('4868', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:05:00');
INSERT INTO `sys_job_log` VALUES ('4869', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 06:06:00');
INSERT INTO `sys_job_log` VALUES ('4870', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:07:00');
INSERT INTO `sys_job_log` VALUES ('4871', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 06:08:00');
INSERT INTO `sys_job_log` VALUES ('4872', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 06:09:00');
INSERT INTO `sys_job_log` VALUES ('4873', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-12 06:10:00');
INSERT INTO `sys_job_log` VALUES ('4874', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 06:11:00');
INSERT INTO `sys_job_log` VALUES ('4875', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 06:12:00');
INSERT INTO `sys_job_log` VALUES ('4876', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 06:13:00');
INSERT INTO `sys_job_log` VALUES ('4877', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 06:14:00');
INSERT INTO `sys_job_log` VALUES ('4878', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:15:00');
INSERT INTO `sys_job_log` VALUES ('4879', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:16:00');
INSERT INTO `sys_job_log` VALUES ('4880', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 06:17:00');
INSERT INTO `sys_job_log` VALUES ('4881', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 06:18:00');
INSERT INTO `sys_job_log` VALUES ('4882', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 06:19:00');
INSERT INTO `sys_job_log` VALUES ('4883', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 06:20:00');
INSERT INTO `sys_job_log` VALUES ('4884', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:21:00');
INSERT INTO `sys_job_log` VALUES ('4885', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:22:00');
INSERT INTO `sys_job_log` VALUES ('4886', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 06:23:00');
INSERT INTO `sys_job_log` VALUES ('4887', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:24:00');
INSERT INTO `sys_job_log` VALUES ('4888', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 06:25:00');
INSERT INTO `sys_job_log` VALUES ('4889', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 06:26:00');
INSERT INTO `sys_job_log` VALUES ('4890', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 06:27:00');
INSERT INTO `sys_job_log` VALUES ('4891', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 06:28:00');
INSERT INTO `sys_job_log` VALUES ('4892', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 06:29:00');
INSERT INTO `sys_job_log` VALUES ('4893', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:30:00');
INSERT INTO `sys_job_log` VALUES ('4894', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 06:31:00');
INSERT INTO `sys_job_log` VALUES ('4895', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 06:32:00');
INSERT INTO `sys_job_log` VALUES ('4896', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:33:00');
INSERT INTO `sys_job_log` VALUES ('4897', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:34:00');
INSERT INTO `sys_job_log` VALUES ('4898', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 06:35:00');
INSERT INTO `sys_job_log` VALUES ('4899', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 06:36:00');
INSERT INTO `sys_job_log` VALUES ('4900', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 06:37:00');
INSERT INTO `sys_job_log` VALUES ('4901', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：26毫秒', '0', '', '2021-11-12 06:38:00');
INSERT INTO `sys_job_log` VALUES ('4902', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 06:39:00');
INSERT INTO `sys_job_log` VALUES ('4903', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 06:40:00');
INSERT INTO `sys_job_log` VALUES ('4904', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 06:41:00');
INSERT INTO `sys_job_log` VALUES ('4905', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 06:42:00');
INSERT INTO `sys_job_log` VALUES ('4906', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 06:43:00');
INSERT INTO `sys_job_log` VALUES ('4907', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：1毫秒', '0', '', '2021-11-12 06:44:00');
INSERT INTO `sys_job_log` VALUES ('4908', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 06:45:00');
INSERT INTO `sys_job_log` VALUES ('4909', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:46:00');
INSERT INTO `sys_job_log` VALUES ('4910', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 06:47:00');
INSERT INTO `sys_job_log` VALUES ('4911', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 06:48:00');
INSERT INTO `sys_job_log` VALUES ('4912', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:49:00');
INSERT INTO `sys_job_log` VALUES ('4913', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 06:50:00');
INSERT INTO `sys_job_log` VALUES ('4914', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 06:51:00');
INSERT INTO `sys_job_log` VALUES ('4915', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:52:00');
INSERT INTO `sys_job_log` VALUES ('4916', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 06:53:00');
INSERT INTO `sys_job_log` VALUES ('4917', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 06:54:00');
INSERT INTO `sys_job_log` VALUES ('4918', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 06:55:00');
INSERT INTO `sys_job_log` VALUES ('4919', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 06:56:00');
INSERT INTO `sys_job_log` VALUES ('4920', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 06:57:00');
INSERT INTO `sys_job_log` VALUES ('4921', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 06:58:00');
INSERT INTO `sys_job_log` VALUES ('4922', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 06:59:00');
INSERT INTO `sys_job_log` VALUES ('4923', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 07:00:00');
INSERT INTO `sys_job_log` VALUES ('4924', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:01:00');
INSERT INTO `sys_job_log` VALUES ('4925', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 07:02:00');
INSERT INTO `sys_job_log` VALUES ('4926', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:03:00');
INSERT INTO `sys_job_log` VALUES ('4927', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 07:04:00');
INSERT INTO `sys_job_log` VALUES ('4928', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:05:00');
INSERT INTO `sys_job_log` VALUES ('4929', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 07:06:00');
INSERT INTO `sys_job_log` VALUES ('4930', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 07:07:00');
INSERT INTO `sys_job_log` VALUES ('4931', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 07:08:00');
INSERT INTO `sys_job_log` VALUES ('4932', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 07:09:00');
INSERT INTO `sys_job_log` VALUES ('4933', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:10:00');
INSERT INTO `sys_job_log` VALUES ('4934', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:11:00');
INSERT INTO `sys_job_log` VALUES ('4935', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：22毫秒', '0', '', '2021-11-12 07:12:00');
INSERT INTO `sys_job_log` VALUES ('4936', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 07:13:00');
INSERT INTO `sys_job_log` VALUES ('4937', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:14:00');
INSERT INTO `sys_job_log` VALUES ('4938', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:15:00');
INSERT INTO `sys_job_log` VALUES ('4939', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 07:16:00');
INSERT INTO `sys_job_log` VALUES ('4940', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 07:17:00');
INSERT INTO `sys_job_log` VALUES ('4941', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 07:18:00');
INSERT INTO `sys_job_log` VALUES ('4942', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 07:19:00');
INSERT INTO `sys_job_log` VALUES ('4943', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:20:00');
INSERT INTO `sys_job_log` VALUES ('4944', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 07:21:00');
INSERT INTO `sys_job_log` VALUES ('4945', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 07:22:00');
INSERT INTO `sys_job_log` VALUES ('4946', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 07:23:00');
INSERT INTO `sys_job_log` VALUES ('4947', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 07:24:00');
INSERT INTO `sys_job_log` VALUES ('4948', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:25:00');
INSERT INTO `sys_job_log` VALUES ('4949', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:26:00');
INSERT INTO `sys_job_log` VALUES ('4950', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-12 07:27:00');
INSERT INTO `sys_job_log` VALUES ('4951', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 07:28:00');
INSERT INTO `sys_job_log` VALUES ('4952', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 07:29:00');
INSERT INTO `sys_job_log` VALUES ('4953', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 07:30:00');
INSERT INTO `sys_job_log` VALUES ('4954', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 07:31:00');
INSERT INTO `sys_job_log` VALUES ('4955', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:32:00');
INSERT INTO `sys_job_log` VALUES ('4956', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:33:00');
INSERT INTO `sys_job_log` VALUES ('4957', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 07:34:00');
INSERT INTO `sys_job_log` VALUES ('4958', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 07:35:00');
INSERT INTO `sys_job_log` VALUES ('4959', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 07:36:00');
INSERT INTO `sys_job_log` VALUES ('4960', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:37:00');
INSERT INTO `sys_job_log` VALUES ('4961', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:38:00');
INSERT INTO `sys_job_log` VALUES ('4962', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 07:39:00');
INSERT INTO `sys_job_log` VALUES ('4963', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-12 07:40:00');
INSERT INTO `sys_job_log` VALUES ('4964', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 07:41:00');
INSERT INTO `sys_job_log` VALUES ('4965', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 07:42:00');
INSERT INTO `sys_job_log` VALUES ('4966', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 07:43:00');
INSERT INTO `sys_job_log` VALUES ('4967', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 07:44:00');
INSERT INTO `sys_job_log` VALUES ('4968', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 07:45:00');
INSERT INTO `sys_job_log` VALUES ('4969', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 07:46:00');
INSERT INTO `sys_job_log` VALUES ('4970', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 07:47:00');
INSERT INTO `sys_job_log` VALUES ('4971', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 07:48:00');
INSERT INTO `sys_job_log` VALUES ('4972', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:49:00');
INSERT INTO `sys_job_log` VALUES ('4973', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 07:50:00');
INSERT INTO `sys_job_log` VALUES ('4974', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 07:51:00');
INSERT INTO `sys_job_log` VALUES ('4975', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 07:52:00');
INSERT INTO `sys_job_log` VALUES ('4976', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 07:53:00');
INSERT INTO `sys_job_log` VALUES ('4977', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 07:54:00');
INSERT INTO `sys_job_log` VALUES ('4978', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 07:55:00');
INSERT INTO `sys_job_log` VALUES ('4979', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 07:56:00');
INSERT INTO `sys_job_log` VALUES ('4980', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 07:57:00');
INSERT INTO `sys_job_log` VALUES ('4981', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 07:58:00');
INSERT INTO `sys_job_log` VALUES ('4982', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 07:59:00');
INSERT INTO `sys_job_log` VALUES ('4983', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 08:00:00');
INSERT INTO `sys_job_log` VALUES ('4984', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 08:01:00');
INSERT INTO `sys_job_log` VALUES ('4985', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 08:02:00');
INSERT INTO `sys_job_log` VALUES ('4986', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 08:03:00');
INSERT INTO `sys_job_log` VALUES ('4987', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 08:04:00');
INSERT INTO `sys_job_log` VALUES ('4988', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：2毫秒', '0', '', '2021-11-12 08:05:00');
INSERT INTO `sys_job_log` VALUES ('4989', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 08:06:00');
INSERT INTO `sys_job_log` VALUES ('4990', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 08:07:00');
INSERT INTO `sys_job_log` VALUES ('4991', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 08:08:00');
INSERT INTO `sys_job_log` VALUES ('4992', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 08:09:00');
INSERT INTO `sys_job_log` VALUES ('4993', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：33毫秒', '0', '', '2021-11-12 08:10:00');
INSERT INTO `sys_job_log` VALUES ('4994', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 08:11:00');
INSERT INTO `sys_job_log` VALUES ('4995', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：4毫秒', '0', '', '2021-11-12 08:12:00');
INSERT INTO `sys_job_log` VALUES ('4996', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：7毫秒', '0', '', '2021-11-12 08:13:00');
INSERT INTO `sys_job_log` VALUES ('4997', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 08:14:00');
INSERT INTO `sys_job_log` VALUES ('4998', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 08:15:00');
INSERT INTO `sys_job_log` VALUES ('4999', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 08:16:00');
INSERT INTO `sys_job_log` VALUES ('5000', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 08:17:00');
INSERT INTO `sys_job_log` VALUES ('5001', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 08:18:00');
INSERT INTO `sys_job_log` VALUES ('5002', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：8毫秒', '0', '', '2021-11-12 08:19:00');
INSERT INTO `sys_job_log` VALUES ('5003', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-12 08:20:00');
INSERT INTO `sys_job_log` VALUES ('5004', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 08:21:00');
INSERT INTO `sys_job_log` VALUES ('5005', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 08:22:00');
INSERT INTO `sys_job_log` VALUES ('5006', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 08:23:00');
INSERT INTO `sys_job_log` VALUES ('5007', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 08:24:00');
INSERT INTO `sys_job_log` VALUES ('5008', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 08:25:00');
INSERT INTO `sys_job_log` VALUES ('5009', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 08:26:00');
INSERT INTO `sys_job_log` VALUES ('5010', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 08:27:00');
INSERT INTO `sys_job_log` VALUES ('5011', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 08:28:00');
INSERT INTO `sys_job_log` VALUES ('5012', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 08:29:00');
INSERT INTO `sys_job_log` VALUES ('5013', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 08:30:00');
INSERT INTO `sys_job_log` VALUES ('5014', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 08:31:00');
INSERT INTO `sys_job_log` VALUES ('5015', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 08:32:00');
INSERT INTO `sys_job_log` VALUES ('5016', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 08:33:00');
INSERT INTO `sys_job_log` VALUES ('5017', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：26毫秒', '0', '', '2021-11-12 08:34:00');
INSERT INTO `sys_job_log` VALUES ('5018', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 08:35:00');
INSERT INTO `sys_job_log` VALUES ('5019', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 08:36:00');
INSERT INTO `sys_job_log` VALUES ('5020', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 08:37:00');
INSERT INTO `sys_job_log` VALUES ('5021', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-12 08:38:00');
INSERT INTO `sys_job_log` VALUES ('5022', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 08:39:00');
INSERT INTO `sys_job_log` VALUES ('5023', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：24毫秒', '0', '', '2021-11-12 08:40:00');
INSERT INTO `sys_job_log` VALUES ('5024', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 08:41:00');
INSERT INTO `sys_job_log` VALUES ('5025', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 08:42:00');
INSERT INTO `sys_job_log` VALUES ('5026', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 08:43:00');
INSERT INTO `sys_job_log` VALUES ('5027', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 08:44:00');
INSERT INTO `sys_job_log` VALUES ('5028', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 08:45:00');
INSERT INTO `sys_job_log` VALUES ('5029', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 08:46:00');
INSERT INTO `sys_job_log` VALUES ('5030', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 08:47:00');
INSERT INTO `sys_job_log` VALUES ('5031', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 08:48:00');
INSERT INTO `sys_job_log` VALUES ('5032', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 08:49:00');
INSERT INTO `sys_job_log` VALUES ('5033', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：26毫秒', '0', '', '2021-11-12 08:50:00');
INSERT INTO `sys_job_log` VALUES ('5034', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 08:51:00');
INSERT INTO `sys_job_log` VALUES ('5035', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 08:52:00');
INSERT INTO `sys_job_log` VALUES ('5036', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 08:53:00');
INSERT INTO `sys_job_log` VALUES ('5037', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 08:54:00');
INSERT INTO `sys_job_log` VALUES ('5038', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 08:55:00');
INSERT INTO `sys_job_log` VALUES ('5039', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 08:56:00');
INSERT INTO `sys_job_log` VALUES ('5040', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 08:57:00');
INSERT INTO `sys_job_log` VALUES ('5041', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：41毫秒', '0', '', '2021-11-12 08:58:00');
INSERT INTO `sys_job_log` VALUES ('5042', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 08:59:00');
INSERT INTO `sys_job_log` VALUES ('5043', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 09:00:00');
INSERT INTO `sys_job_log` VALUES ('5044', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 09:01:00');
INSERT INTO `sys_job_log` VALUES ('5045', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 09:02:00');
INSERT INTO `sys_job_log` VALUES ('5046', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 09:03:00');
INSERT INTO `sys_job_log` VALUES ('5047', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 09:04:00');
INSERT INTO `sys_job_log` VALUES ('5048', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 09:05:00');
INSERT INTO `sys_job_log` VALUES ('5049', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 09:06:00');
INSERT INTO `sys_job_log` VALUES ('5050', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 09:07:00');
INSERT INTO `sys_job_log` VALUES ('5051', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 09:08:00');
INSERT INTO `sys_job_log` VALUES ('5052', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 09:09:00');
INSERT INTO `sys_job_log` VALUES ('5053', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 09:10:00');
INSERT INTO `sys_job_log` VALUES ('5054', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 09:11:00');
INSERT INTO `sys_job_log` VALUES ('5055', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 09:12:00');
INSERT INTO `sys_job_log` VALUES ('5056', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 09:13:00');
INSERT INTO `sys_job_log` VALUES ('5057', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 09:14:00');
INSERT INTO `sys_job_log` VALUES ('5058', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 09:15:00');
INSERT INTO `sys_job_log` VALUES ('5059', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 09:16:00');
INSERT INTO `sys_job_log` VALUES ('5060', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 09:17:00');
INSERT INTO `sys_job_log` VALUES ('5061', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 09:18:00');
INSERT INTO `sys_job_log` VALUES ('5062', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 09:19:00');
INSERT INTO `sys_job_log` VALUES ('5063', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 09:20:00');
INSERT INTO `sys_job_log` VALUES ('5064', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 09:21:00');
INSERT INTO `sys_job_log` VALUES ('5065', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：28毫秒', '0', '', '2021-11-12 09:22:00');
INSERT INTO `sys_job_log` VALUES ('5066', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 09:23:00');
INSERT INTO `sys_job_log` VALUES ('5067', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 09:24:00');
INSERT INTO `sys_job_log` VALUES ('5068', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 09:25:00');
INSERT INTO `sys_job_log` VALUES ('5069', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 09:26:00');
INSERT INTO `sys_job_log` VALUES ('5070', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：9毫秒', '0', '', '2021-11-12 09:27:00');
INSERT INTO `sys_job_log` VALUES ('5071', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 09:28:00');
INSERT INTO `sys_job_log` VALUES ('5072', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 09:29:00');
INSERT INTO `sys_job_log` VALUES ('5073', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 09:30:00');
INSERT INTO `sys_job_log` VALUES ('5074', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 09:31:00');
INSERT INTO `sys_job_log` VALUES ('5075', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 09:32:00');
INSERT INTO `sys_job_log` VALUES ('5076', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 09:33:00');
INSERT INTO `sys_job_log` VALUES ('5077', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 09:34:00');
INSERT INTO `sys_job_log` VALUES ('5078', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 09:35:00');
INSERT INTO `sys_job_log` VALUES ('5079', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：6毫秒', '0', '', '2021-11-12 09:36:00');
INSERT INTO `sys_job_log` VALUES ('5080', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 09:37:00');
INSERT INTO `sys_job_log` VALUES ('5081', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：11毫秒', '0', '', '2021-11-12 09:38:00');
INSERT INTO `sys_job_log` VALUES ('5082', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 09:39:00');
INSERT INTO `sys_job_log` VALUES ('5083', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 09:40:00');
INSERT INTO `sys_job_log` VALUES ('5084', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：13毫秒', '0', '', '2021-11-12 09:41:00');
INSERT INTO `sys_job_log` VALUES ('5085', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 09:42:00');
INSERT INTO `sys_job_log` VALUES ('5086', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 09:43:00');
INSERT INTO `sys_job_log` VALUES ('5087', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 09:44:00');
INSERT INTO `sys_job_log` VALUES ('5088', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：10毫秒', '0', '', '2021-11-12 09:45:00');
INSERT INTO `sys_job_log` VALUES ('5089', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：14毫秒', '0', '', '2021-11-12 09:46:00');
INSERT INTO `sys_job_log` VALUES ('5090', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：32毫秒', '0', '', '2021-11-12 09:47:00');
INSERT INTO `sys_job_log` VALUES ('5091', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 09:48:00');
INSERT INTO `sys_job_log` VALUES ('5092', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 09:49:00');
INSERT INTO `sys_job_log` VALUES ('5093', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：27毫秒', '0', '', '2021-11-12 09:50:00');
INSERT INTO `sys_job_log` VALUES ('5094', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：19毫秒', '0', '', '2021-11-12 09:51:00');
INSERT INTO `sys_job_log` VALUES ('5095', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：18毫秒', '0', '', '2021-11-12 09:52:00');
INSERT INTO `sys_job_log` VALUES ('5096', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：23毫秒', '0', '', '2021-11-12 09:53:00');
INSERT INTO `sys_job_log` VALUES ('5097', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 09:54:00');
INSERT INTO `sys_job_log` VALUES ('5098', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：16毫秒', '0', '', '2021-11-12 09:55:00');
INSERT INTO `sys_job_log` VALUES ('5099', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 09:56:00');
INSERT INTO `sys_job_log` VALUES ('5100', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：15毫秒', '0', '', '2021-11-12 09:57:00');
INSERT INTO `sys_job_log` VALUES ('5101', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：20毫秒', '0', '', '2021-11-12 09:58:00');
INSERT INTO `sys_job_log` VALUES ('5102', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 09:59:00');
INSERT INTO `sys_job_log` VALUES ('5103', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 10:00:00');
INSERT INTO `sys_job_log` VALUES ('5104', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 10:01:00');
INSERT INTO `sys_job_log` VALUES ('5105', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：21毫秒', '0', '', '2021-11-12 10:02:00');
INSERT INTO `sys_job_log` VALUES ('5106', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 10:03:00');
INSERT INTO `sys_job_log` VALUES ('5107', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：17毫秒', '0', '', '2021-11-12 10:04:00');
INSERT INTO `sys_job_log` VALUES ('5108', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：25毫秒', '0', '', '2021-11-12 10:05:00');
INSERT INTO `sys_job_log` VALUES ('5109', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：12毫秒', '0', '', '2021-11-12 10:06:00');
INSERT INTO `sys_job_log` VALUES ('5110', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：5毫秒', '0', '', '2021-11-12 10:07:00');
INSERT INTO `sys_job_log` VALUES ('5111', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData', '专项活动数据同步 总共耗时：3毫秒', '0', '', '2021-11-12 10:08:00');
INSERT INTO `sys_job_log` VALUES ('5112', '专项活动数据同步', 'DEFAULT', 'specialTask.initSpecialActivityData'