/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.aop;

import com.gaowj.business.ServiceLogBusiness;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.service.security.ServiceManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LogProxy
implements InvocationHandler {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    private Object delegate;
    private String logMessage;
    private String myMethod;
    private String tokenId;
    private int pageNo;
    private int pageSize;

    public LogProxy(Object delegate, String logMessage) {
        this.delegate = delegate;
        this.logMessage = logMessage;
    }

    public LogProxy(Object delegate, String logMessage, String myMethod, String tokenId) {
        this.delegate = delegate;
        this.logMessage = logMessage;
        this.myMethod = myMethod;
        this.tokenId = tokenId;
    }

    public LogProxy(Object delegate, String logMessage, String myMethod, String tokenId, int pageNo, int pageSize) {
        this.delegate = delegate;
        this.logMessage = logMessage;
        this.myMethod = myMethod;
        this.tokenId = tokenId;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
    }

    public static Object get(Object delegate, String logMessage) {
        return Proxy.newProxyInstance(delegate.getClass().getClassLoader(), delegate.getClass().getInterfaces(), (InvocationHandler)new LogProxy(delegate, logMessage));
    }

    public static Object get(Object delegate, String logMessage, String myMethod, String tokenId) {
        return Proxy.newProxyInstance(delegate.getClass().getClassLoader(), delegate.getClass().getInterfaces(), (InvocationHandler)new LogProxy(delegate, logMessage, myMethod, tokenId));
    }

    public static Object get(Object delegate, String logMessage, String myMethod, String tokenId, int pageNo, int pageSize) {
        return Proxy.newProxyInstance(delegate.getClass().getClassLoader(), delegate.getClass().getInterfaces(), (InvocationHandler)new LogProxy(delegate, logMessage, myMethod, tokenId, pageNo, pageSize));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ServiceLogBusiness business = BusinessManager.getBusiness(ServiceLogBusiness.class);
        String username = ServiceManager.getSessionMap().get(this.tokenId);
        HashMap<String, Object> entity = new HashMap<String, Object>();
        entity.put("USERNAME", username);
        entity.put("INTERFACE", this.logMessage);
        entity.put("METHOD", this.myMethod);
        entity.put("PAGENO", this.pageNo);
        entity.put("PAGESIZE", this.pageSize);
        entity.put("CREATE_TIME", new Date());
        entity.put("UPDATE_TIME", new Date());
        business.insert_LogService(entity);
        try {
            if (method.getName().indexOf("insert") > -1) {
                this.logger.warn((Object)("[" + username + "]\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3[" + this.logMessage + "]\u4e2d[" + this.myMethod + "]\u65b9\u6cd5\u589e\u52a0\u4e86" + this.pageSize + "\u884c\u8bb0\u5f55"));
            } else if (method.getName().indexOf("update") > -1) {
                this.logger.warn((Object)("[" + username + "]\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3[" + this.logMessage + "]\u4e2d[" + this.myMethod + "]\u65b9\u6cd5\u4fee\u6539\u4e86" + this.pageSize + "\u884c\u8bb0\u5f55"));
            } else if (method.getName().indexOf("delete") > -1) {
                this.logger.warn((Object)("[" + username + "]\u8c03\u7528\u8fdc\u7a0b\u63a5\u53e3[" + this.logMessage + "]\u4e2d[" + this.myMethod + "]\u65b9\u6cd5\u5220\u9664\u4e86" + this.pageSize + "\u884c\u8bb0\u5f55"));
            }
            return method.invoke(this.delegate, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

