/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.cache;

import com.gaowj.business.SystemCacheBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import org.springframework.cache.Cache;
import org.springframework.cache.support.CompositeCacheManager;

public class SystemCacheBusinessImpl
implements SystemCacheBusiness {
    private CompositeCacheManager cacheManager;

    public void setCacheManager(CompositeCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void ClearAllCache() throws BusinessException {
        Collection collection = this.cacheManager.getCacheNames();
        for (String name : collection) {
            Cache cache = this.cacheManager.getCache(name);
            cache.clear();
        }
    }

    @Override
    public Page<Map<String, Object>> listCache(int pageNo, int pageSize, Map<String, Object> query) {
        List<Map<String, Object>> datas = this.listCache();
        try {
            this.listSort(datas);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int pageStart = (pageNo - 1) * pageSize;
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        int count = datas.size();
        int start = (pageNo - 1) * pageSize;
        int end = 0;
        end = start + pageSize > count ? count : start + pageSize;
        int i = start;
        while (i < end) {
            items.add(datas.get(i));
            ++i;
        }
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public List<Map<String, Object>> listCache() throws BusinessException {
        ArrayList<Map<String, Object>> listCache = new ArrayList<Map<String, Object>>();
        Collection collection = this.cacheManager.getCacheNames();
        for (String name : collection) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("NAME", name);
            if (this.cacheManager.getCache(name).getNativeCache() instanceof Ehcache) {
                Ehcache ehcache = (Ehcache)this.cacheManager.getCache(name).getNativeCache();
                m.put("STATUS", ehcache.getCacheManager().getStatus().toString());
                m.put("MAXELEMENTS", ehcache.getCacheConfiguration().getMaxElementsInMemory());
                m.put("ETERNAL", ehcache.getCacheConfiguration().isEternal());
                m.put("TIMETOIDLESECONDS", ehcache.getCacheConfiguration().getTimeToIdleSeconds());
                m.put("TIMETOLIVESECONDS", ehcache.getCacheConfiguration().getTimeToLiveSeconds());
                m.put("OVERFLOWTODISK", ehcache.getCacheConfiguration().isOverflowToDisk());
                m.put("MAXELEMENTSONDISK", ehcache.getCacheConfiguration().getMaxElementsOnDisk());
                m.put("DISKPERSISTENT", ehcache.getCacheConfiguration().isDiskPersistent());
                m.put("DISKEXPIRYTHREADINTERVALSECONDS", ehcache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds());
                m.put("MEMORYSTOREEVICTIONPOLICY", ehcache.getCacheConfiguration().getMemoryStoreEvictionPolicy().toString());
                Status status = ehcache.getCacheManager().getStatus();
                ehcache.getCacheManager().getStatus();
                if (status.equals(Status.STATUS_ALIVE)) {
                    m.put("SIZE", ehcache.getSize());
                }
                m.put("CACHETYPE", "ehcache-2.8.3");
            }
            listCache.add(m);
        }
        return listCache;
    }

    @Override
    public Page<Map<String, Object>> listCacheKey(int pageNo, int pageSize, Map<String, Object> query) {
        List<Map<String, Object>> datas = this.listCacheKey((String)query.get("NAME"));
        int pageStart = (pageNo - 1) * pageSize;
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        int count = datas.size();
        int start = (pageNo - 1) * pageSize;
        int end = 0;
        end = start + pageSize > count ? count : start + pageSize;
        int i = start;
        while (i < end) {
            items.add(datas.get(i));
            ++i;
        }
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public List<Map<String, Object>> listCacheKey(String cacheName) throws BusinessException {
        ArrayList<Map<String, Object>> listCacheKey = new ArrayList<Map<String, Object>>();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.cacheManager.getCache(cacheName).getNativeCache() instanceof Ehcache) {
            Ehcache ehcache = (Ehcache)this.cacheManager.getCache(cacheName).getNativeCache();
            Status status = ehcache.getCacheManager().getStatus();
            ehcache.getCacheManager().getStatus();
            if (status.equals(Status.STATUS_ALIVE)) {
                for (Object key : ehcache.getKeys()) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    Element ele = ehcache.get(key);
                    if (ele == null || ele.getValue() == null) continue;
                    Object obj = ele.getObjectValue();
                    if (obj instanceof Page) {
                        Page obj_item = (Page)obj;
                        obj = obj_item.getItems().toString();
                    }
                    data.put("KEYID", key);
                    data.put("VALUE", obj);
                    data.put("CREATIONTIME", sf.format(ele.getCreationTime()));
                    data.put("LASTACCESSTIME", sf.format(ele.getLastAccessTime()));
                    data.put("EXPIRATIONTIME", sf.format(ele.getExpirationTime()));
                    data.put("LASTUPDATETIME", sf.format(ele.getLastUpdateTime()));
                    data.put("HITCOUNT", ele.getHitCount());
                    data.put("TIMETOLIVE", ele.getTimeToLive());
                    data.put("TIMETOIDLE", ele.getTimeToIdle());
                    listCacheKey.add(data);
                }
            }
        }
        return listCacheKey;
    }

    @Override
    public boolean shutdownCache(String cacheName) throws BusinessException {
        return false;
    }

    @Override
    public boolean removeCache(String cacheName, String Key) throws BusinessException {
        if (this.cacheManager.getCache(cacheName).getNativeCache() instanceof Ehcache) {
            Ehcache ehcache = (Ehcache)this.cacheManager.getCache(cacheName).getNativeCache();
            return ehcache.remove((Serializable)((Object)Key));
        }
        return false;
    }

    @Override
    public boolean createCache(String cacheName) throws BusinessException {
        return true;
    }

    public void listSort(List<Map<String, Object>> resultList) throws Exception {
        Collections.sort(resultList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                String s2;
                String s1 = (String)o1.get("NAME");
                if (s1.compareTo(s2 = (String)o2.get("NAME")) > 0) {
                    return 1;
                }
                return -1;
            }
        });
    }
}

