/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.listener;

import java.io.File;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ListenerProxoolConfigurator
implements ServletContextListener {
    private static final Log LOG = LogFactory.getLog(ListenerProxoolConfigurator.class);
    private static final String XML_FILE_PROPERTY = "proxoolConfigLocation";
    private boolean autoShutdown = true;

    public void contextInitialized(ServletContextEvent servletConfig) {
        String appDir = servletConfig.getServletContext().getRealPath("/");
        Properties properties = new Properties();
        String value = servletConfig.getServletContext().getInitParameter(XML_FILE_PROPERTY);
        LOG.info((Object)("proxoolConfigLocation:" + value));
        try {
            File file = new File(value);
            if (file.isAbsolute()) {
                JAXPConfigurator.configure((String)value, (boolean)false);
            } else {
                LOG.info((Object)(String.valueOf(appDir) + File.separator + value));
                JAXPConfigurator.configure((String)(String.valueOf(appDir) + File.separator + value), (boolean)false);
            }
        }
        catch (ProxoolException e) {
            LOG.error((Object)("Problem configuring " + value), (Throwable)e);
        }
        if (properties.size() > 0) {
            try {
                PropertyConfigurator.configure((Properties)properties);
            }
            catch (ProxoolException e) {
                LOG.error((Object)"Problem configuring using init properties", (Throwable)e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent s) {
        if (this.autoShutdown) {
            ProxoolFacade.shutdown((int)0);
        }
    }
}

