/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.report;

import com.gaowj.business.ReportBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.report.ReportDAO;
import com.gaowj.business.report.ReportOpeDAO;
import com.gaowj.business.util.Page;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.ibatis.session.RowBounds;

public class ReportBusinessImpl
implements ReportBusiness {
    private ReportDAO reportDAO;
    private ReportOpeDAO reportOpeDAO;

    public ReportDAO getReportDAO() {
        return this.reportDAO;
    }

    public void setReportDAO(ReportDAO reportDAO) {
        this.reportDAO = reportDAO;
    }

    public ReportOpeDAO getReportOpeDAO() {
        return this.reportOpeDAO;
    }

    public void setReportOpeDAO(ReportOpeDAO reportOpeDAO) {
        this.reportOpeDAO = reportOpeDAO;
    }

    @Override
    public Map<String, Object> getBase(String uuid) throws BusinessException {
        Map<String, Object> map = this.reportDAO.get(uuid);
        String XMLINFO = "";
        if (map.get("XML_INFO") != null && map.get("XML_INFO") instanceof Blob) {
            try {
                XMLINFO = IOUtils.toString((InputStream)((Blob)map.get("XML_INFO")).getBinaryStream(), (String)"UTF-8");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (map.get("XML_INFO") != null && map.get("XML_INFO") instanceof byte[]) {
            try {
                XMLINFO = IOUtils.toString((InputStream)new ByteArrayInputStream((byte[])map.get("XML_INFO")), (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        map.put("XML_INFO", XMLINFO);
        return map;
    }

    @Override
    public Map<String, Object> getBaseFromCodeId(String codeId) throws BusinessException {
        Map<String, Object> map = this.reportDAO.getFromCodeId(codeId);
        if (map.get("XML_INFO") != null && map.get("XML_INFO") instanceof Blob) {
            try {
                map.put("XML_INFO", IOUtils.toString((InputStream)((Blob)map.get("XML_INFO")).getBinaryStream(), (String)"UTF-8"));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    @Override
    public void insert(Map<String, Object> entity) throws BusinessException {
        entity.put("UUID", UUID.randomUUID().toString());
        entity.put("TAG_DELETE", "0");
        this.reportDAO.insert(entity);
    }

    @Override
    public void update(Map<String, Object> entity) throws BusinessException {
        this.reportDAO.update(entity);
    }

    @Override
    public int delete(String UUID2) throws BusinessException {
        int useCount = 0;
        if (useCount == 0) {
            this.reportDAO.delete(UUID2);
        }
        return useCount;
    }

    @Override
    public List<Map<String, Object>> listF(Map<String, Object> query) throws BusinessException {
        List<Map<String, Object>> list = this.reportDAO.listTree(query);
        return list;
    }

    @Override
    public int listCount(Map<String, Object> query) throws BusinessException {
        return this.reportDAO.listTreeCount(query);
    }

    @Override
    public List<Map<String, Object>> list(Map<String, Object> query) throws BusinessException {
        List<Map<String, Object>> list = this.reportDAO.listTree(query);
        for (Map<String, Object> map : list) {
            map.remove("XML_INFO");
        }
        return list;
    }

    @Override
    public Page<Map<String, Object>> list(int pageNo, int pageSize, Map<String, Object> query) {
        int pageStart = (pageNo - 1) * pageSize;
        List<Map<String, Object>> items = this.reportDAO.listTree(new RowBounds(pageStart, pageSize), query);
        int count = this.reportDAO.listTreeCount(query);
        for (Map<String, Object> map : items) {
            map.remove("XML_INFO");
        }
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public Page<Map<String, Object>> listDataInfo(int pageNo, int pageSize, Map<String, Object> query) {
        int pageStart = (pageNo - 1) * pageSize;
        List<Map<String, Object>> items = this.reportOpeDAO.listDataInfo(new RowBounds(pageStart, pageSize), query);
        int count = this.reportOpeDAO.listDataInfoCount(query);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public List<Map<String, Object>> listDataInfo(Map<String, Object> query) {
        return this.reportOpeDAO.listDataInfo(query);
    }

    @Override
    public int listDataInfoCount(Map<String, Object> query) {
        return this.reportOpeDAO.listDataInfoCount(query);
    }
}

