/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.scheduler;

import com.gaowj.business.Scheduler1Business;
import com.gaowj.service.jobs.common.MainJob;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.GroupMatcher;

public class Scheduler1BusinessImpl
implements Scheduler1Business {
    private Scheduler scheduler1;

    public Scheduler getScheduler1() {
        return this.scheduler1;
    }

    public void setScheduler1(Scheduler scheduler1) {
        this.scheduler1 = scheduler1;
    }

    @Override
    public void schedule(String cronExpression) {
        this.schedule(null, null, null, null, cronExpression);
    }

    @Override
    public void schedule(String name, String group, MainJob main, JobDataMap dataMap, String cronExpression) {
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        if (group == null || group.trim().equals("")) {
            group = UUID.randomUUID().toString();
        }
        JobDetail job = JobBuilder.newJob(main.getClass()).withIdentity("job_" + name, group).usingJobData(dataMap).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + name, group).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
        try {
            Date ft = this.scheduler1.scheduleJob(job, (Trigger)trigger);
            System.out.println(job.getKey() + " has been scheduled to deploy at: " + ft + " and repeat based on expression: " + trigger.getCronExpression());
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void schedule(Date startTime) {
        this.schedule(startTime, null);
    }

    @Override
    public void schedule(String name, String group, Date startTime) {
        this.schedule(name, group, startTime, null);
    }

    @Override
    public void schedule(Date startTime, Date endTime) {
        this.schedule(startTime, endTime, 0);
    }

    @Override
    public void schedule(String name, String group, Date startTime, Date endTime) {
        this.schedule(name, group, startTime, endTime, 0);
    }

    @Override
    public void schedule(Date startTime, Date endTime, int repeatCount) {
        this.schedule(null, null, startTime, endTime, 0);
    }

    @Override
    public void schedule(String name, String group, Date startTime, Date endTime, int repeatCount) {
        this.schedule(name, group, null, null, startTime, endTime, 0, 0);
    }

    @Override
    public void schedule(Date startTime, Date endTime, int repeatCount, int repeatInterval) {
        this.schedule(null, null, null, null, startTime, endTime, repeatCount, repeatInterval);
    }

    @Override
    public void schedule(String name, String group, MainJob main, JobDataMap dataMap, Date startTime, Date endTime, int repeatCount, int repeatInterval) {
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        if (group == null || group.trim().equals("")) {
            group = UUID.randomUUID().toString();
        }
        JobDetail job = JobBuilder.newJob(main.getClass()).withIdentity("job_" + name, group).usingJobData(dataMap).build();
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity("trigger_" + name, group).startAt(startTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(repeatInterval).withRepeatCount(repeatCount)).endAt(endTime).build();
        try {
            Date ft = this.scheduler1.scheduleJob(job, (Trigger)trigger);
            System.out.println(job.getKey() + " has been scheduled to deploy at: " + ft + " and repeat: " + trigger.getRepeatCount() + " times, every " + trigger.getRepeatInterval() / 1000L + " seconds");
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    public Date parse(String str) {
        SimpleDateFormat format = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = format.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    @Override
    public void standBy() {
        try {
            this.scheduler1.standby();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        try {
            this.scheduler1.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            this.scheduler1.shutdown(true);
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void pauseJob(JobKey jobkey) {
        try {
            if (jobkey == null) {
                this.scheduler1.pauseAll();
            } else {
                this.scheduler1.pauseJob(jobkey);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void resumeJob(JobKey jobkey) {
        try {
            if (jobkey == null) {
                this.scheduler1.resumeAll();
            } else {
                this.scheduler1.resumeJob(jobkey);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteJob(JobKey jobkey) {
        try {
            if (jobkey == null) {
                GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobkey.getGroup());
                this.scheduler1.pauseJobs(groupMatcher);
                Set jobKeySet = this.scheduler1.getJobKeys(groupMatcher);
                for (JobKey jobKey2 : jobKeySet) {
                    List triggerList = this.scheduler1.getTriggersOfJob(jobKey2);
                    for (Trigger trigger : triggerList) {
                        this.scheduler1.pauseTrigger(trigger.getKey());
                        boolean unResult = this.scheduler1.unscheduleJob(trigger.getKey());
                        System.out.println("\u5220\u9664\u89e6\u53d1\u5668(" + trigger.getKey().getName() + "): " + unResult);
                    }
                }
            } else {
                boolean unResult = this.scheduler1.deleteJob(jobkey);
                System.out.println("\u5220\u9664\u4f5c\u4e1a(" + jobkey.getName() + "): " + unResult);
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

