/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.standard;

import com.gaowj.business.StandardBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.standard.StandardDAO;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.standard.utils.CacheKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

public class StandardBusinessImpl
implements StandardBusiness {
    private StandardDAO standardDAO;
    private String prefix = "ST";

    public StandardDAO getStandardDAO() {
        return this.standardDAO;
    }

    public void setStandardDAO(StandardDAO standardDAO) {
        this.standardDAO = standardDAO;
    }

    @Override
    public Page<Map<String, Object>> list_all_tables(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
        int pageStart = (pageNo - 1) * pageSize;
        List<Map<String, Object>> items = this.standardDAO.list_all_tables(new RowBounds(pageStart, pageSize), query);
        int count = this.standardDAO.list_all_tables_count(query);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public List<Map<String, Object>> list_all_tables(Map<String, Object> query) throws BusinessException {
        List<Map<String, Object>> list = this.standardDAO.list_all_tables(query);
        return list;
    }

    @Override
    public int list_all_tables_count(Map<String, Object> query) throws BusinessException {
        return this.standardDAO.list_all_tables_count(query);
    }

    @Override
    public Page<Map<String, Object>> list_all_columns(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
        int pageStart = (pageNo - 1) * pageSize;
        List<Map<String, Object>> items = this.standardDAO.list_all_columns(new RowBounds(pageStart, pageSize), query);
        int count = this.standardDAO.list_all_columns_count(query);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public List<Map<String, Object>> list_all_columns(Map<String, Object> query) throws BusinessException {
        List<Map<String, Object>> list = this.standardDAO.list_all_columns(query);
        return list;
    }

    @Override
    public int list_all_columns_count(Map<String, Object> query) throws BusinessException {
        return this.standardDAO.list_all_columns_count(query);
    }

    @Override
    public Page<Map<String, Object>> list_tables_info(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
        int pageStart = (pageNo - 1) * pageSize;
        List<Map<String, Object>> items = this.standardDAO.list_tables_info(new RowBounds(pageStart, pageSize), query);
        int count = this.standardDAO.list_tables_info_count(query);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public List<Map<String, Object>> list_tables_info(Map<String, Object> query) throws BusinessException {
        List<Map<String, Object>> list = this.standardDAO.list_tables_info(query);
        return list;
    }

    @Override
    public int list_tables_info_count(Map<String, Object> query) throws BusinessException {
        return this.standardDAO.list_tables_info_count(query);
    }

    @Override
    public void delete_tables_info(Map<String, Object> entity) throws BusinessException {
        this.standardDAO.delete_tables_info(entity);
    }

    @Override
    public void insert_tables_info(Map<String, Object> entity) throws BusinessException {
        Set key;
        List list = (List)entity.get("insertInfoList");
        entity.remove("insertInfoList");
        for (Map map : list) {
            if (map.keySet() == null) continue;
            key = map.keySet();
            for (String s : key) {
                if (map.get(s) != null) continue;
                map.put(s, "");
            }
        }
        ArrayList<String> infoListKey = new ArrayList<String>();
        ArrayList<Object> infoList = new ArrayList<Object>();
        key = null;
        for (Map m : list) {
            key = m.keySet();
            for (String str : key) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"tableName", (CharSequence)str)) continue;
                infoList.add(m.get(str));
                infoListKey.add(str);
            }
            infoListKey.add("TAG_DELETE");
            infoList.add("0");
            entity.put("infoListKey", infoListKey);
            entity.put("infoList", infoList);
            this.standardDAO.insert_tables_info(entity);
            infoList.removeAll(infoList);
            infoListKey.removeAll(infoListKey);
        }
    }

    @Override
    public void update_tables_info(Map<String, Object> entity) throws BusinessException {
        List list = (List)entity.get("updateInfoList");
        entity.remove("updateInfoList");
        for (Map map : list) {
            if (map.keySet() == null) continue;
            Set key = map.keySet();
            for (String s : key) {
                if (map.get(s) != null) continue;
                map.put(s, "");
            }
        }
        Set key = null;
        for (Map m : list) {
            ArrayList updateList = new ArrayList();
            key = m.keySet();
            for (String str : key) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"CODE_ID", (CharSequence)str)) {
                    entity.put("CODE_ID", m.get(str));
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"CODELIST", (CharSequence)str)) {
                    entity.put("CODELIST", QueryParamUtil.StringToList((String)m.get(str)));
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)"tableName", (CharSequence)str)) continue;
                HashMap<String, String> updateMap = new HashMap<String, String>();
                updateMap.put("key", str);
                updateMap.put("value", (String)m.get(str));
                updateList.add(updateMap);
            }
            entity.put("info", updateList);
            this.standardDAO.update_tables_info(entity);
        }
    }

    @Override
    public Page<Map<String, Object>> list_tables(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException {
        int pageStart = (pageNo - 1) * pageSize;
        List<Map<String, Object>> items = this.standardDAO.list_tables(new RowBounds(pageStart, pageSize), query);
        int count = this.standardDAO.list_tables_count(query);
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);
        return page;
    }

    @Override
    public List<Map<String, Object>> list_tables(Map<String, Object> query) throws BusinessException {
        List<Map<String, Object>> list = this.standardDAO.list_tables(query);
        return list;
    }

    @Override
    public int list_tables_count(Map<String, Object> query) throws BusinessException {
        return this.standardDAO.list_tables_count(query);
    }

    @Override
    public void insert2Cache() throws BusinessException {
        HashMap<String, Object> query = new HashMap<String, Object>();
        HashMap<String, Object> queryData = new HashMap<String, Object>();
        query.put("FATHER_ID", "0");
        List<Map<String, Object>> list_all_tables = this.list_all_tables(query);
        for (Map<String, Object> entity : list_all_tables) {
            String tname = (String)entity.get("CODE_ID");
            String cacheName = String.valueOf(this.prefix) + "_" + tname;
            System.out.println("\u52a0\u8f7d[" + tname + "]\u5230\u7f13\u5b58>>ehcache11>>\u4e2d......");
            queryData.put("tableName", tname);
            List<Map<String, Object>> tableInfo = this.list_tables_info(queryData);
            CacheKit.put("ehcache11", cacheName.toUpperCase(), tableInfo);
        }
    }

    @Override
    public List<Map<String, Object>> list_tables_info_cache(Map<String, Object> query) throws BusinessException {
        String keyName = (String)query.get("tableName");
        List<Map<String, Object>> list = (List<Map<String, Object>>)CacheKit.get("ehcache11", String.valueOf(this.prefix) + "_" + keyName.toUpperCase());
        if (list == null) {
            list = this.standardDAO.list_tables_info(query);
            CacheKit.put("ehcache11", String.valueOf(this.prefix) + "_" + keyName.toUpperCase(), list);
        }
        return list;
    }

    @Override
    public void updateCache(Map<String, Object> query) throws BusinessException {
        String keyName = (String)query.get("tableName");
        List<Map<String, Object>> list = (List<Map<String, Object>>)CacheKit.get("ehcache11", String.valueOf(this.prefix) + "_" + keyName.toUpperCase());
        if (list == null) {
            list = this.standardDAO.list_tables_info(query);
            CacheKit.put("ehcache11", String.valueOf(this.prefix) + "_" + keyName.toUpperCase(), list);
        } else {
            list = this.standardDAO.list_tables_info(query);
            CacheKit.update("ehcache11", String.valueOf(this.prefix) + "_" + keyName.toUpperCase(), list);
        }
    }
}

