/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.Picture;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.w3c.dom.Document;

public class Word2Html {
    public static void main(String[] argv) {
        try {
            Word2Html.convert2Html("C:\\temp\\LoadRunner11-\u4e2d\u6587\u6559\u7a0b.doc", "C:\\temp\\LoadRunner11-\u4e2d\u6587\u6559\u7a0b.html");
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeFile(String content, String path) {
        FileOutputStream fos = null;
        BufferedWriter bw = null;
        try {
            try {
                File file = new File(path);
                fos = new FileOutputStream(file);
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "GB2312"));
                bw.write(content);
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void convert2Html(String fileName, String outPutFile) throws TransformerException, IOException, ParserConfigurationException {
        HWPFDocument wordDocument = new HWPFDocument((InputStream)new FileInputStream(fileName));
        WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
        wordToHtmlConverter.setPicturesManager(new PicturesManager(){

            public String savePicture(byte[] content, PictureType pictureType, String suggestedName, float widthInches, float heightInches) {
                return "test/" + suggestedName;
            }
        });
        wordToHtmlConverter.processDocument((HWPFDocumentCore)wordDocument);
        List pics = wordDocument.getPicturesTable().getAllPictures();
        if (pics != null) {
            int i = 0;
            while (i < pics.size()) {
                Picture pic = (Picture)pics.get(i);
                try {
                    File file = new File("C:\\temp\\test\\" + pic.suggestFullFileName());
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    pic.writeImageContent((OutputStream)new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        Document htmlDocument = wordToHtmlConverter.getDocument();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOMSource domSource = new DOMSource(htmlDocument);
        StreamResult streamResult = new StreamResult((OutputStream)out);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "ISO-8859-1");
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("method", "html");
        serializer.transform(domSource, streamResult);
        out.close();
        Word2Html.writeFile(new String(out.toByteArray()), outPutFile);
    }
}

