/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.quartzJob;

import com.gaowj.business.QuartzJobBusiness;
import com.gaowj.business.SchedulerBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.DynamicClass;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.gaowj.service.jobs.common.MainJob;
import com.gaowj.service.jobs.common.QrtzManager;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.quartz.JobDataMap;
import org.quartz.JobKey;

public class QuartzJobActAction
extends BasicAction {
    private static final long serialVersionUID = 9113748985900413004L;
    private JSONObject jsonObject = new JSONObject();
    private int rows = 20;
    private int page = 1;

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public int getRows() {
        this.rows = this.getPageSize();
        return this.rows;
    }

    public void setRows(int rows) {
        this.setPageSize(rows);
        this.rows = this.getPageSize();
    }

    public int getPage() {
        this.page = this.getPageNo();
        return this.page;
    }

    public void setPage(int page) {
        this.setPageNo(page);
        this.page = this.getPageNo();
    }

    public String listJob() throws BusinessException {
        QuartzJobBusiness business = BusinessManager.getBusiness(QuartzJobBusiness.class);
        Map<String, Object> query = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            query = QueryParamUtil.StringToDate(query);
            Page<Map<String, Object>> pageRows = business.listQuartzJob(this.pageNo, this.pageSize, query);
            this.setPageCount((pageRows.getCount() - 1) / this.pageSize + 1);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
            data.put("pageNo", this.pageNo);
            data.put("pageSize", this.pageSize);
            data.put("pageCount", this.pageCount);
            data.put("rows", data.get("rowSet"));
            data.put("total", pageRows.getCount());
            this.jsonObject = new JSONObject();
            this.jsonObject.putAll(data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return "json";
    }

    public String listJobAll() throws BusinessException {
        QuartzJobBusiness business = BusinessManager.getBusiness(QuartzJobBusiness.class);
        try {
            Map<String, Object> query = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
            query = QueryParamUtil.StringToDate(query);
            List<Map<String, Object>> listData = business.listQuartzJob(query);
            int listDataCount = listData.size();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("rowSet", QueryParamUtil.DateToString(listData));
            data.put("pageNo", 1);
            data.put("pageSize", listDataCount);
            data.put("pageCount", listDataCount);
            data.put("rows", data.get("rowSet"));
            data.put("total", listDataCount);
            this.jsonObject = new JSONObject();
            this.jsonObject.putAll(data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return "json";
    }

    public String insertJob() throws BusinessException {
        QuartzJobBusiness business = BusinessManager.getBusiness(QuartzJobBusiness.class);
        Map<String, Object> entity = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            entity = QueryParamUtil.StringToDate(entity);
            business.insert_QuartzJob(entity);
            this.jsonObject.putAll(Status.getStatusSuccessMessage("\u4fdd\u5b58\u6210\u529f!"));
        }
        catch (Exception e) {
            this.jsonObject.putAll(Status.getStatusErrorMessage("\u4fdd\u5b58\u5931\u8d25!"));
            e.printStackTrace();
        }
        return "json";
    }

    public String updateJob() throws BusinessException {
        QuartzJobBusiness business = BusinessManager.getBusiness(QuartzJobBusiness.class);
        Map<String, Object> entity = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            entity = QueryParamUtil.StringToDate(entity);
            business.update_QuartzJob(entity);
            this.jsonObject.putAll(Status.getStatusSuccessMessage("\u66f4\u65b0\u6210\u529f!"));
        }
        catch (Exception e) {
            this.jsonObject.putAll(Status.getStatusErrorMessage("\u66f4\u65b0\u5931\u8d25!"));
            e.printStackTrace();
        }
        return "json";
    }

    public String deleteJob() throws BusinessException {
        QuartzJobBusiness business = BusinessManager.getBusiness(QuartzJobBusiness.class);
        String deletekey = RequestUtils.getString(this.request, "deletekey");
        List<String> ListKey = QueryParamUtil.StringToList(deletekey);
        Map<String, Object> entity = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            String is_ids = (String)entity.get("UUID");
            ListKey = QueryParamUtil.StringToList(is_ids);
            business.delete_batch_QuartzJob(ListKey);
            this.jsonObject.putAll(Status.getStatusSuccessMessage("\u5220\u9664\u6210\u529f!"));
        }
        catch (Exception e) {
            this.jsonObject.putAll(Status.getStatusErrorMessage("\u5220\u9664\u5931\u8d25!"));
            e.printStackTrace();
        }
        return "json";
    }

    public String doJobMethod() throws BusinessException {
        Map<String, Object> entity = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            entity = QueryParamUtil.StringToDate(entity);
            SchedulerBusiness business = null;
            if (entity.get("SCHEDULER") == null) {
                String msg = "scheduler not found.";
                try {
                    this.response.sendError(500, msg);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw new BusinessException(msg);
            }
            business = QrtzManager.getSchedulerBusiness(entity.get("SCHEDULER").toString());
            Java_tool jd = new Java_tool();
            String myMethod = (String)entity.get("MYMETHOD");
            String name = (String)entity.get("NAME");
            String group = (String)entity.get("GORUP");
            Date startTime = jd.String2date((String)entity.get("START_DATE"));
            Date endTime = jd.String2date((String)entity.get("END_DATE"));
            Integer repeatCount = Integer.parseInt((String)entity.get("REPEATCOUNT"));
            Integer repeatInterval = Integer.parseInt((String)entity.get("REPEATINTERVAL"));
            MainJob job = (MainJob)DynamicClass.getMyClass(name);
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("name", name);
            dataMap.put("pass", "111");
            dataMap.put("target", myMethod);
            String cronExpression = (String)entity.get("EXPRESSION");
            JobKey key = new JobKey("job_" + job.getClass().getSimpleName(), group);
            if (myMethod.trim().equalsIgnoreCase("deploy")) {
                if (entity.get("IS_SIMPLE").toString().equals("0")) {
                    business.schedule(job.getClass().getSimpleName(), group, job, dataMap, startTime, endTime, repeatCount, repeatInterval);
                } else {
                    business.schedule(job.getClass().getSimpleName(), group, job, dataMap, cronExpression);
                }
            } else if (myMethod.trim().equalsIgnoreCase("start")) {
                business.start();
            } else if (myMethod.trim().equalsIgnoreCase("stop")) {
                business.stop();
            } else if (myMethod.trim().equalsIgnoreCase("standby")) {
                business.standBy();
            } else if (myMethod.trim().equalsIgnoreCase("pause")) {
                business.pauseJob(key);
            } else if (myMethod.trim().equalsIgnoreCase("resume")) {
                business.resumeJob(key);
            } else if (myMethod.trim().equalsIgnoreCase("undeploy")) {
                business.deleteJob(key);
            }
            this.jsonObject.putAll(Status.getStatusSuccessMessage("\u64cd\u4f5c\u6210\u529f!"));
        }
        catch (Exception e) {
            this.jsonObject.putAll(Status.getStatusErrorMessage("\u64cd\u4f5c\u5931\u8d25!"));
            e.printStackTrace();
        }
        return "json";
    }
}

