/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.service.impl;

import com.gaowj.service.FileTransferService;
import com.gaowj.service.common.ServiceException;
import com.gaowj.service.security.ServiceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.lang.StringUtils;

public class FileTransferServiceImpl
implements FileTransferService {
    @Override
    public OMElement upload(OMElement element) throws ServiceException {
        File dir;
        MessageContext context = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        OMElement _fileContent = null;
        OMElement _fileName = null;
        OMElement _fileType = null;
        OMElement _filePath = null;
        OMElement _tokenId = null;
        String ret_filename = "";
        Iterator _iterator = element.getChildElements();
        while (_iterator.hasNext()) {
            OMElement _ele = (OMElement)_iterator.next();
            if (_ele.getLocalName().equalsIgnoreCase("fileContent")) {
                _fileContent = _ele;
            }
            if (_ele.getLocalName().equalsIgnoreCase("fileName")) {
                _fileName = _ele;
            }
            if (_ele.getLocalName().equalsIgnoreCase("fileType")) {
                _fileType = _ele;
            }
            if (_ele.getLocalName().equalsIgnoreCase("filePath")) {
                _filePath = _ele;
            }
            if (!_ele.getLocalName().equalsIgnoreCase("tokenId")) continue;
            _tokenId = _ele;
        }
        String tokenId = null;
        if (_tokenId != null) {
            tokenId = _tokenId.getText();
        }
        ServiceManager.activeToken(tokenId, String.valueOf(FileTransferService.class.getName()) + "_upload", "1");
        System.out.println("\u8c03\u7528\u4e0a\u4f20..");
        if (_fileContent == null || _fileType == null) {
            try {
                throw new AxisFault("Either Image or FileName is null");
            }
            catch (AxisFault e) {
                e.printStackTrace();
            }
        }
        OMText binaryNode = (OMText)_fileContent.getFirstOMChild();
        String fileName = _fileName.getText();
        if (StringUtils.isNotEmpty((String)fileName) && StringUtils.equalsIgnoreCase((String)fileName, (String)"UUID")) {
            fileName = UUID.randomUUID().toString();
        }
        String fileType = _fileType.getText();
        String storeDir = _filePath.getText();
        if (StringUtils.isNotEmpty((String)storeDir) && StringUtils.equalsIgnoreCase((String)storeDir, (String)"UUID")) {
            storeDir = this.getDefaultPath(request);
        }
        if (!(dir = new File(storeDir)).exists()) {
            dir.mkdirs();
        }
        String filePath = String.valueOf(storeDir) + "/" + fileName + "." + fileType;
        ret_filename = String.valueOf(fileName) + "." + fileType;
        File uploadFile = new File(filePath);
        System.out.println("The element for uploadFile: " + filePath);
        DataHandler actualDH = (DataHandler)binaryNode.getDataHandler();
        try {
            FileOutputStream imageOutStream = new FileOutputStream(uploadFile);
            actualDH.writeTo((OutputStream)imageOutStream);
            imageOutStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        QName MY_QNAME = new QName("http://impl.service.gaowj.com", "response", "ns");
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement ele = fac.createOMElement(MY_QNAME);
        ele.setText(ret_filename);
        return ele;
    }

    @Override
    public OMElement download(OMElement element) throws ServiceException {
        OMElement _filePath = null;
        OMElement _fileName = null;
        OMElement _fileType = null;
        OMElement _tokenId = null;
        Iterator _iterator = element.getChildElements();
        while (_iterator.hasNext()) {
            OMElement _ele = (OMElement)_iterator.next();
            if (_ele.getLocalName().equalsIgnoreCase("filePath")) {
                _filePath = _ele;
            }
            if (_ele.getLocalName().equalsIgnoreCase("fileName")) {
                _fileName = _ele;
            }
            if (_ele.getLocalName().equalsIgnoreCase("fileType")) {
                _fileType = _ele;
            }
            if (!_ele.getLocalName().equalsIgnoreCase("tokenId")) continue;
            _tokenId = _ele;
        }
        String tokenId = null;
        if (_tokenId != null) {
            tokenId = _tokenId.getText();
        }
        ServiceManager.activeToken(tokenId, String.valueOf(FileTransferService.class.getName()) + "_download", "1");
        System.out.println("The element for download: " + element);
        String local_filePath = _filePath.getText();
        String fileName = _fileName.getText();
        String fileType = _fileType.getText();
        String filePath = String.valueOf(local_filePath) + "/" + fileName + "." + fileType;
        System.out.println("The filePath for download: " + filePath);
        FileDataSource dataSource = new FileDataSource(filePath);
        DataHandler expectedDH = new DataHandler((DataSource)dataSource);
        QName MY_QNAME = new QName("http://impl.service.gaowj.com", "response", "ns");
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMElement ele = fac.createOMElement(MY_QNAME);
        OMText textData = fac.createOMText((Object)expectedDH, true);
        ele.addChild((OMNode)textData);
        return ele;
    }

    private String getDefaultPath(HttpServletRequest request) {
        String defaultPath = request.getSession().getServletContext().getRealPath("uploadFile/file");
        String confFilePath = request.getSession().getServletContext().getRealPath("WEB-INF/conf/service/service.properties");
        Properties config = new Properties();
        File file = new File(confFilePath);
        try {
            if (!file.exists()) {
                config.setProperty("default_Path", defaultPath);
                config.store(new FileOutputStream(confFilePath), "");
            } else {
                config.load(new FileInputStream(confFilePath));
                if (StringUtils.isNotEmpty((String)config.getProperty("default_Path"))) {
                    defaultPath = config.getProperty("default_Path");
                } else {
                    config.setProperty("default_Path", defaultPath);
                    config.store(new FileOutputStream(confFilePath), "");
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defaultPath;
    }
}

