/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.service.jobs.test;

import com.gaowj.service.jobs.test.HelloJob;
import com.gaowj.service.jobs.test.HelloJob2;
import java.util.Date;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class CronTriggerExample {
    private static SchedulerFactory sf = null;
    private static Scheduler sched = null;

    public void run() throws Exception {
        JobDetail job = JobBuilder.newJob(HelloJob.class).withIdentity("job1", "group1").usingJobData("name", "6666").usingJobData("pass", "111").usingJobData("target", "http://localhost:8080/jwmagic/services/AuthorityService.AuthorityServiceHttpSoap12Endpoint/").build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger1", "group1").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0/10 * * * * ?")).build();
        Date ft = sched.scheduleJob(job, (Trigger)trigger);
        System.out.println(job.getKey() + " has been scheduled to run at: " + ft + " and repeat based on expression: " + trigger.getCronExpression());
        job = JobBuilder.newJob(HelloJob2.class).withIdentity("job2", "group1").build();
        trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity("trigger2", "group1").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0/15 * * * * ?")).build();
        ft = sched.scheduleJob(job, (Trigger)trigger);
        System.out.println(job.getKey() + " has been scheduled to run at: " + ft + " and repeat based on expression: " + trigger.getCronExpression());
        sched.start();
        try {
            Thread.sleep(30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        sched.shutdown(true);
        SchedulerMetaData metaData = sched.getMetaData();
        System.out.println("Executed " + metaData.getNumberOfJobsExecuted() + " jobs.");
    }

    public static void main(String[] args) throws Exception {
        sf = new StdSchedulerFactory();
        sched = sf.getScheduler();
        CronTriggerExample example = new CronTriggerExample();
        example.run();
    }
}

