/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.service.jobs.test;

import com.gaowj.service.jobs.test.HelloJob;
import java.util.Date;
import org.quartz.DateBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class HelloWorldMain {
    public void run() throws Exception {
        System.out.println("------- Initializing ----------------------");
        StdSchedulerFactory sf = new StdSchedulerFactory();
        Scheduler sched = sf.getScheduler();
        System.out.println("------- Initialization Complete -----------");
        Date runTime = DateBuilder.evenMinuteDate((Date)new Date());
        System.out.println("------- Scheduling Job  -------------------");
        JobDetail job = JobBuilder.newJob(HelloJob.class).withIdentity("job1", "group1").build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("trigger1", "group1").startAt(runTime).build();
        sched.scheduleJob(job, trigger);
        System.out.println(job.getKey() + " will run at: " + runTime);
        sched.start();
        System.out.println("------- Started Scheduler -----------------");
        System.out.println("------- Waiting 65 seconds... -------------");
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("------- Shutting Down ---------------------");
        sched.shutdown(true);
        System.out.println("------- Shutdown Complete -----------------");
    }

    public static void main(String[] args) throws Exception {
        HelloWorldMain example = new HelloWorldMain();
        example.run();
    }
}

