/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.service.security;

import com.gaowj.service.common.ServiceException;
import com.gaowj.service.common.UserToken;
import com.gaowj.service.util.ServiceUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.lang.StringUtils;

public class ServiceManager {
    private static Map<String, String> sessionMap = new ConcurrentHashMap<String, String>();
    private static Map<String, Object> sessionInterfaceMap = new ConcurrentHashMap<String, Object>();
    private static Map<String, Object> sessionPageSizeMap = new ConcurrentHashMap<String, Object>();
    private static Map<String, Long> tokenLifeCycleMap = new ConcurrentHashMap<String, Long>();
    private static long sessionTimeout = 900000L;
    private static final ServiceManager INSTANCE = new ServiceManager();
    private static String errorInfo = "";

    private ServiceManager() {
    }

    public static final ServiceManager getInstance() {
        return INSTANCE;
    }

    public static boolean checkToken(String token, String myInterface, String pageSize) {
        if (StringUtils.isBlank((String)token) || sessionMap.get(token) == null) {
            errorInfo = "Invalid token,please authenticate again.";
            return false;
        }
        if (!ServiceManager.checkRemoteIp(token)) {
            errorInfo = "Invalid remote ip,please authenticate again.";
            return false;
        }
        if (!ServiceManager.checkInterface(token, myInterface)) {
            errorInfo = "Invalid Service Method(" + myInterface + "),please authenticate again.";
            return false;
        }
        if (!ServiceManager.checkPageSize(token, pageSize)) {
            errorInfo = "Invalid pageSize,the scope of is 1-" + sessionPageSizeMap.get(token) + ",please authenticate again.";
            return false;
        }
        if (sessionMap.get(token) != null) {
            tokenLifeCycleMap.put(token, System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public static boolean checkInterface(String token, String myInterface) {
        List myInterfaces = (List)sessionInterfaceMap.get(token);
        return myInterfaces.contains(myInterface);
    }

    public static boolean checkRemoteIp(String token) {
        String allowIp;
        MessageContext context = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String remote_ip = ServiceUtil.getClientIp(request);
        return sessionMap.get(token) != null && sessionMap.get(token).split(",").length == 2 && remote_ip.equals(allowIp = sessionMap.get(token).split(",")[1]);
    }

    public static boolean checkPageSize(String token, String pageSize) {
        String client_pageSize = (String)sessionPageSizeMap.get(token);
        if (StringUtils.isEmpty((String)client_pageSize) || StringUtils.isEmpty((String)pageSize) || StringUtils.isBlank((String)client_pageSize) || StringUtils.isBlank((String)pageSize)) {
            return false;
        }
        return Integer.parseInt(client_pageSize) >= Integer.parseInt(pageSize) && Integer.parseInt(pageSize) > 0;
    }

    public static void activeToken(String token, String myInterface, String pageSize) throws ServiceException {
        ServiceManager.clearTimeoutToken();
        if (!ServiceManager.checkToken(token, myInterface, pageSize)) {
            throw new ServiceException(12005L, errorInfo);
        }
    }

    public UserToken getToken(String userName, List<String> person_interfases, String pageSize) {
        UserToken token = new UserToken(userName);
        String tokenId = token.getId();
        sessionMap.put(tokenId, userName);
        tokenLifeCycleMap.put(tokenId, System.currentTimeMillis());
        sessionInterfaceMap.put(tokenId, person_interfases);
        sessionPageSizeMap.put(tokenId, pageSize);
        return token;
    }

    public UserToken getActiveToken(String userName) throws ServiceException {
        ServiceManager.clearTimeoutToken();
        String tokenId = "-1";
        UserToken token = null;
        if (sessionMap.keySet() != null) {
            for (String s : sessionMap.keySet()) {
                if (!sessionMap.get(s).equals(userName)) continue;
                token = new UserToken(s, false);
                break;
            }
        }
        if (token == null) {
            token = new UserToken(tokenId, false);
        }
        return token;
    }

    private static void clearTimeoutToken() {
        for (Map.Entry<String, Long> e : tokenLifeCycleMap.entrySet()) {
            if (System.currentTimeMillis() - e.getValue() <= sessionTimeout) continue;
            sessionMap.remove(e.getKey());
            tokenLifeCycleMap.remove(e.getKey());
            sessionInterfaceMap.remove(e.getKey());
            sessionPageSizeMap.remove(e.getKey());
        }
    }

    public static Map<String, String> getSessionMap() {
        return sessionMap;
    }

    public static Map<String, Object> getSessionInterfaceMap() {
        return sessionInterfaceMap;
    }

    public static Map<String, Object> getSessionPageSizeMap() {
        return sessionPageSizeMap;
    }

    public UserToken getNullToken() {
        return UserToken.getNullToken();
    }

    public UserToken getNotIpToken() {
        return UserToken.getNotIpToken();
    }
}

