/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.service.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import oracle.sql.BLOB;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMText;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class ServiceUtil {
    public static String getProValue(String name) {
        String value = "";
        try {
            InputStream in = new ClassPathResource("struts.properties").getInputStream();
            Properties config = new Properties();
            config.load(in);
            if (config.getProperty(name) != null) {
                value = config.getProperty(name);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return value;
    }

    public static String getServiceParam(String key, String DefaultValue) {
        MessageContext context = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String confFilePath = request.getSession().getServletContext().getRealPath("WEB-INF/conf/service/service.properties");
        Properties config = new Properties();
        File file = new File(confFilePath);
        try {
            if (!file.exists()) {
                config.setProperty(key, DefaultValue);
                config.store(new FileOutputStream(confFilePath), "");
            } else {
                config.load(new FileInputStream(confFilePath));
                if (StringUtils.isNotEmpty((String)config.getProperty(key))) {
                    DefaultValue = config.getProperty(key);
                } else {
                    config.setProperty(key, DefaultValue);
                    config.store(new FileOutputStream(confFilePath), "");
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return DefaultValue;
    }

    public static String getBlobToOEMtext(BLOB b, String Filename, boolean delTempFile) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(b.getBinaryStream());
        String tempFileName = String.valueOf(ServiceUtil.getServicePath("defaultDown_Path", "uploadFile/down")) + "/" + Filename;
        File tempfile = new File(tempFileName);
        FileOutputStream fio = new FileOutputStream(tempfile);
        IOUtils.copy((InputStream)bis, (OutputStream)fio);
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((OutputStream)fio);
        FileDataSource dataSource = new FileDataSource(tempFileName);
        DataHandler expectedDH = new DataHandler((DataSource)dataSource);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMText textData = fac.createOMText((Object)expectedDH, true);
        String ret_s = textData.getText();
        if (delTempFile) {
            tempfile.delete();
        }
        return ret_s;
    }

    public static String getServicePath(String key, String defaultPath) {
        File dir;
        MessageContext context = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)context.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request != null) {
            defaultPath = request.getSession().getServletContext().getRealPath(defaultPath);
        }
        if (!(dir = new File(defaultPath)).exists()) {
            dir.mkdirs();
        }
        String confFilePath = request.getSession().getServletContext().getRealPath("WEB-INF/conf/service/service.properties");
        Properties config = new Properties();
        File file = new File(confFilePath);
        try {
            if (!file.exists()) {
                config.setProperty(key, defaultPath);
                config.store(new FileOutputStream(confFilePath), "");
            } else {
                config.load(new FileInputStream(confFilePath));
                if (StringUtils.isNotEmpty((String)config.getProperty(key))) {
                    defaultPath = config.getProperty(key);
                } else {
                    config.setProperty(key, defaultPath);
                    config.store(new FileOutputStream(confFilePath), "");
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return defaultPath;
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((String)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static void main(String[] args) {
        System.out.println("c:\\crt.tr".lastIndexOf("\\"));
    }
}

