/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.system.back;

import com.gaowj.business.ReportBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.EasyuiJsonUtils;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.gaowj.business.vfs.FileUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class PreviewActAction
extends BasicAction {
    private static final long serialVersionUID = -3751287733259169399L;
    private JSONObject jsonObject = new JSONObject();
    private int rows = 20;
    private int page = 1;

    public JSONObject getJsonObject() {
        return this.jsonObject;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public int getRows() {
        this.rows = this.getPageSize();
        return this.rows;
    }

    public void setRows(int rows) {
        this.setPageSize(rows);
        this.rows = this.getPageSize();
    }

    public int getPage() {
        this.page = this.getPageNo();
        return this.page;
    }

    public void setPage(int page) {
        this.setPageNo(page);
        this.page = this.getPageNo();
    }

    public String listReport() throws BusinessException {
        ReportBusiness business = BusinessManager.getBusiness(ReportBusiness.class);
        Map<String, Object> query = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            query = QueryParamUtil.StringToDate(query);
            Page<Map<String, Object>> pageRows = business.list(this.pageNo, this.pageSize, query);
            this.setPageCount((pageRows.getCount() - 1) / this.pageSize + 1);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("rowSet", QueryParamUtil.DateToString(pageRows.getItems()));
            data.put("pageNo", this.pageNo);
            data.put("pageSize", this.pageSize);
            data.put("pageCount", this.pageCount);
            data.put("rows", data.get("rowSet"));
            data.put("total", pageRows.getCount());
            this.jsonObject = new JSONObject();
            this.jsonObject.putAll(data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return "json";
    }

    public String listReportAll() throws BusinessException {
        ReportBusiness business = BusinessManager.getBusiness(ReportBusiness.class);
        try {
            Map<String, Object> query = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
            query = QueryParamUtil.StringToDate(query);
            List<Map<String, Object>> listData = business.list(query);
            int listDataCount = listData.size();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("rowSet", QueryParamUtil.DateToString(listData));
            data.put("pageNo", 1);
            data.put("pageSize", listDataCount);
            data.put("pageCount", listDataCount);
            data.put("rows", data.get("rowSet"));
            data.put("total", listDataCount);
            this.jsonObject = new JSONObject();
            this.jsonObject.putAll(data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return "json";
    }

    public String listReportTree() throws BusinessException {
        ReportBusiness business = BusinessManager.getBusiness(ReportBusiness.class);
        try {
            Map<String, Object> query = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
            query = QueryParamUtil.StringToDate(query);
            List<Map<String, Object>> listData = business.list(query);
            int listDataCount = listData.size();
            HashMap<String, Object> data = new HashMap<String, Object>();
            List<Map<String, Object>> treeData = QueryParamUtil.DateToString(listData);
            EasyuiJsonUtils.reSetPara("UUID", "CODE_NAME", "FATHER_ID");
            data.put("rowSet", treeData);
            data.put("pageNo", 1);
            data.put("pageSize", listDataCount);
            data.put("pageCount", listDataCount);
            data.put("rows", EasyuiJsonUtils.getTreeJsonData(treeData));
            data.put("total", listDataCount);
            this.jsonObject = new JSONObject();
            this.jsonObject.putAll(data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return "json";
    }

    public String insertReport() throws BusinessException {
        ReportBusiness business = BusinessManager.getBusiness(ReportBusiness.class);
        Map<String, Object> entity = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            entity = QueryParamUtil.StringToDate(entity);
            business.insert(entity);
            this.jsonObject.putAll(Status.getStatusSuccessMessage("\u4fdd\u5b58\u6210\u529f!", (String)entity.get("UUID")));
        }
        catch (Exception e) {
            this.jsonObject.putAll(Status.getStatusErrorMessage("\u4fdd\u5b58\u5931\u8d25!"));
            e.printStackTrace();
        }
        return "json";
    }

    public String updateReport() throws BusinessException {
        ReportBusiness business = BusinessManager.getBusiness(ReportBusiness.class);
        Map<String, Object> entity = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            entity = QueryParamUtil.StringToDate(entity);
            if (entity.get("UPLOADPATH") != null) {
                String ls_file;
                File f;
                FileUtil fileUtil = new FileUtil();
                FileObject baseDir = fileUtil.getFile(entity.get("UPLOADPATH").toString());
                FileObject file = null;
                try {
                    file = baseDir.resolveFile(entity.get("UPLOADNEW").toString());
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
                try {
                    entity.put("XML_INFO", fileUtil.getBytes(file.getContent().getInputStream()));
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                }
                Map<String, Object> dataOld = business.getBase(entity.get("UUID").toString());
                if (dataOld.get("UPLOADPATH") != null && dataOld.get("UPLOADNEW") != null && entity.get("UPLOADNEW") != null && !entity.get("UPLOADNEW").toString().equals(dataOld.get("UPLOADNEW").toString()) && (f = new File(ls_file = String.valueOf(dataOld.get("UPLOADPATH").toString()) + dataOld.get("UPLOADNEW").toString())).exists()) {
                    f.delete();
                }
            }
            business.update(entity);
            this.jsonObject.putAll(Status.getStatusSuccessMessage("\u66f4\u65b0\u6210\u529f!"));
        }
        catch (Exception e) {
            this.jsonObject.putAll(Status.getStatusErrorMessage("\u66f4\u65b0\u5931\u8d25!"));
            e.printStackTrace();
        }
        return "json";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String deleteReport() throws BusinessException {
        ReportBusiness business = BusinessManager.getBusiness(ReportBusiness.class);
        String deletekey = RequestUtils.getString(this.request, "deletekey");
        List<String> ListKey = QueryParamUtil.StringToList(deletekey);
        Map<String, Object> entity = RequestUtils.getUpdateFieldMap(this.request, RequestUtils.UPDATEDATAFIELDPREFIX);
        try {
            String[] is_id = entity.get("CODE").toString().split("\\,");
            HashMap<String, Object> mapquery = new HashMap<String, Object>();
            String[] stringArray = is_id;
            int n = is_id.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    this.jsonObject.putAll(Status.getStatusSuccessMessage("\u5220\u9664\u6210\u529f!"));
                    return "json";
                }
                String string = stringArray[n2];
                mapquery.put("FATHER_ID", string);
                int count = business.listCount(mapquery);
                if (count > 0) {
                    this.jsonObject.putAll(Status.getStatusSuccessMessage("\u6709\u8282\u70b9\u5b58\u5728\u4e0b\u7ea7\u76ee\u5f55,\u5220\u9664\u5931\u8d25!"));
                    return "json";
                }
                business.delete(string);
                ++n2;
            }
        }
        catch (Exception e) {
            this.jsonObject.putAll(Status.getStatusErrorMessage("\u5220\u9664\u5931\u8d25!"));
            e.printStackTrace();
        }
        return "json";
    }

    @Override
    public String download() throws BusinessException {
        String ret_download = "";
        String uuid = this.request.getParameter("uuid");
        String uploadnew = this.request.getParameter("uploadnew");
        String uploadpath = this.request.getParameter("uploadpath");
        if (!new File(String.valueOf(uploadpath) + File.separator + uploadnew).exists()) {
            Object b;
            ReportBusiness business = BusinessManager.getBusiness(ReportBusiness.class);
            HashMap<String, Object> mapquery = new HashMap<String, Object>();
            mapquery.put("UUID", uuid);
            List<Map<String, Object>> list = business.listF(mapquery);
            BufferedInputStream bis = null;
            if (list.get(0).get("XML_INFO") != null && list.get(0).get("XML_INFO") instanceof byte[]) {
                b = (byte[])list.get(0).get("XML_INFO");
                bis = new BufferedInputStream(new ByteArrayInputStream((byte[])b));
            } else if (list.get(0).get("XML_INFO") != null && list.get(0).get("XML_INFO") instanceof Blob) {
                b = (Blob)list.get(0).get("XML_INFO");
                try {
                    bis = new BufferedInputStream(b.getBinaryStream());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                File dir = new File(uploadpath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File tempfile = new File(String.valueOf(uploadpath) + File.separator + uploadnew);
                FileOutputStream fio = new FileOutputStream(tempfile);
                IOUtils.copy((InputStream)bis, (OutputStream)fio);
                IOUtils.closeQuietly((InputStream)bis);
                IOUtils.closeQuietly((OutputStream)fio);
                ret_download = super.download();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ret_download = super.download();
        }
        return ret_download;
    }
}

