/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.tp.sso.client.filter;

import com.neusoft.education.tp.sso.client.CASReceipt;
import com.neusoft.education.tp.sso.client.CheckAliveValidator;
import com.neusoft.education.tp.sso.client.ValidatorFactory;
import com.neusoft.education.tp.sso.client.filter.AbstractCASFilter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DefaultCASFilter
extends AbstractCASFilter {
    private List ignoreAttrs = new ArrayList();

    public DefaultCASFilter() {
        this.ignoreAttrs.add("com.neusoft.education.tp.sso.client.filter.didGateway");
    }

    public boolean isNeedCASLoginOrValidate(HttpServletRequest request, HttpServletResponse response, CASReceipt receipt) {
        if (receipt != null && this.isReceiptAcceptable(receipt)) {
            block6: {
                if (this.checkAlive) {
                    CheckAliveValidator checker = ValidatorFactory.factory((boolean)this.hessian).getCheckAliveValidator();
                    checker.setCaKey(receipt.getCheckAliveKey());
                    checker.setCasCheckAliveUrl(this.casCheckAliveUrl);
                    try {
                        boolean pass = checker.check();
                        if (pass) break block6;
                        HttpSession session = request.getSession();
                        Enumeration keys = session.getAttributeNames();
                        while (keys.hasMoreElements()) {
                            String key = (String)keys.nextElement();
                            if (this.ignoreAttrs.contains(key)) continue;
                            session.removeAttribute(key);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"can't check alive", (Throwable)e);
                        throw new RuntimeException("can't check alive");
                    }
                    return true;
                }
            }
            log.trace((Object)"SSO_FILTER_RECEIPT attribute was present and acceptable - passing  request through filter..");
            return false;
        }
        String url = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && query.trim().length() > 0) {
            url = String.valueOf(url) + "?" + query;
        }
        return !this.isUrlMatch(url, this.notForceAuthUrls);
    }

    public boolean isNeedRedirectToCAS(HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"isNeedRedirectToCAS()");
        return true;
    }

    public boolean isNeedValidate(HttpServletRequest request, HttpServletResponse response) {
        log.debug((Object)"isNeedValidate()");
        return true;
    }

    public boolean userLoginAndValidated(HttpServletRequest request, HttpServletResponse response, CASReceipt receipt) {
        HttpSession session = request.getSession();
        if (session != null) {
            session.setAttribute("com.neusoft.education.tp.sso.client.filter.user", (Object)receipt.getUserName());
            session.setAttribute("com.neusoft.education.tp.sso.client.filter.receipt", (Object)receipt);
            session.removeAttribute("com.neusoft.education.tp.sso.client.filter.didGateway");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("validated ticket to get authenticated receipt [" + receipt + "], now passing request along filter chain."));
        }
        return true;
    }
}

