/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.service.client.utils;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PbeEncrypt {
    public static final String ALGORITHM = "PBEWITHMD5ANDDES";
    private static final int ITERATIONCOUNT = 1000;

    public static byte[] getSalt(String password) throws Exception {
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(password.getBytes());
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        return salt;
    }

    private static Key getPBEKey(String password) throws Exception {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
        SecretKey secretKey = keyFactory.generateSecret(keySpec);
        return secretKey;
    }

    public static String encrypt(String plaintext, String password, byte[] salt) throws Exception {
        Key key = PbeEncrypt.getPBEKey(password);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 1000);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, key, parameterSpec);
        byte[] encipheredData = cipher.doFinal(plaintext.getBytes());
        return PbeEncrypt.bytesToHexString(encipheredData);
    }

    public static String encrypt(String plaintext, String password) throws Exception {
        byte[] salt = PbeEncrypt.getSalt(password);
        return PbeEncrypt.encrypt(plaintext, password, salt);
    }

    public static String decrypt(String ciphertext, String password, byte[] salt) throws Exception {
        Key key = PbeEncrypt.getPBEKey(password);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, 1000);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, key, parameterSpec);
        byte[] passDec = cipher.doFinal(PbeEncrypt.hexStringToBytes(ciphertext));
        return new String(passDec);
    }

    public static String decrypt(String ciphertext, String password) throws Exception {
        byte[] salt = PbeEncrypt.getSalt(password);
        return PbeEncrypt.decrypt(ciphertext, password, salt);
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(PbeEncrypt.charToByte(hexChars[pos]) << 4 | PbeEncrypt.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static void main(String[] args) {
        String str = "\u4f60nbjw12345678nbjw12345678nbjw12345678nbjw12345678nbjw12345678nbjw12345678nbjw12345678";
        String password = "nbjw12345678nbjw12345678nbjw12345678nbjw12345678nbjw12345678nbjw12345678nbjw12345678";
        System.out.println("\u660e\u6587:" + str);
        System.out.println("\u5bc6\u7801:" + password);
        try {
            String ciphertext = PbeEncrypt.encrypt(str, password);
            System.out.println("\u5bc6\u6587:" + password);
            String plaintext = PbeEncrypt.decrypt(ciphertext, password);
            System.out.println("\u660e\u6587:" + plaintext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

