/*
 * Decompiled with CFR 0.152.
 */
package com.neusoft.education.tp.sso.client;

import com.neusoft.education.tp.sso.client.CASAuthenticationException;
import com.neusoft.education.tp.sso.client.ServiceValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASReceipt
implements Serializable {
    private static final long serialVersionUID = 7512766476105471387L;
    private static Log log = LogFactory.getLog(CASReceipt.class);
    private String pgtIou;
    private boolean primaryAuthentication = false;
    private String proxyCallbackUrl;
    private List<String> proxyList = new ArrayList<String>();
    private String userName;
    private Map<String, String> userMap;
    private String caKey;

    public static CASReceipt getReceipt(ServiceValidator sv) throws CASAuthenticationException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering getReceipt(ProxyTicketValidator=[" + sv + "])"));
        }
        if (!sv.isAuthenticationSuccesful()) {
            try {
                sv.validate();
            }
            catch (Exception e) {
                CASAuthenticationException casException = new CASAuthenticationException("Unable to validate ProxyTicketValidator [" + sv + "]", e);
                log.error((Object)casException);
                throw casException;
            }
        }
        if (!sv.isAuthenticationSuccesful()) {
            log.error((Object)("validation of [" + sv + "] was not successful."));
            throw new CASAuthenticationException("Unable to validate ProxyTicketValidator [" + sv + "]");
        }
        CASReceipt receipt = new CASReceipt();
        receipt.userName = sv.getUser();
        receipt.userMap = sv.getUserMap();
        receipt.caKey = sv.getCheckAliveKey();
        if (!receipt.validate()) {
            throw new CASAuthenticationException("Validation of [" + sv + "] did not result in an internally consistent CASReceipt.");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from getReceipt() with return value [" + receipt + "]"));
        }
        return receipt;
    }

    public String getPgtIou() {
        return this.pgtIou;
    }

    public String getProxyCallbackUrl() {
        return this.proxyCallbackUrl;
    }

    public List<String> getProxyList() {
        return Collections.unmodifiableList(this.proxyList);
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isPrimaryAuthentication() {
        return this.primaryAuthentication;
    }

    public boolean isProxied() {
        return !this.proxyList.isEmpty();
    }

    public String getProxyingService() {
        if (this.proxyList.isEmpty()) {
            return null;
        }
        return this.proxyList.get(0);
    }

    public void setPgtIou(String pgtIou) {
        this.pgtIou = pgtIou;
    }

    public void setPrimaryAuthentication(boolean primaryAuthentication) {
        this.primaryAuthentication = primaryAuthentication;
    }

    public void setProxyCallbackUrl(String proxyCallbackUrl) {
        this.proxyCallbackUrl = proxyCallbackUrl;
    }

    public void setProxyList(List<String> proxyList) {
        this.proxyList = proxyList;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Map<String, String> getUserMap() {
        return this.userMap;
    }

    public void setUserMap(Map<String, String> userMap) {
        this.userMap = userMap;
    }

    public String getCheckAliveKey() {
        return this.caKey;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(CASReceipt.class.getName());
        sb.append(" userName=[");
        sb.append(this.userName);
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }

    private boolean validate() {
        boolean valid = true;
        if (this.userName == null) {
            log.error((Object)("Receipt was invalid because userName was null. Receipt:[" + this + "]"));
            valid = false;
        }
        if (this.proxyList == null) {
            log.error((Object)("receipt was invalid because proxyList was null.  Receipt:[" + this + "]"));
            valid = false;
        }
        if (this.primaryAuthentication && !this.proxyList.isEmpty()) {
            log.error((Object)("If authentication was by primary credentials then it could not have been proxied. Yet, primaryAuthentication is true where proxyList is not empty.  Receipt:[" + this + "]"));
            valid = false;
        }
        return valid;
    }
}

