/*
 * Decompiled with CFR 0.152.
 */
package com.neusoft.education.tp.sso.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Util {
    private static Log log = LogFactory.getLog(Util.class);

    public static String getService(HttpServletRequest request, String server, boolean encoding) throws ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("entering getService(" + request + ", " + server + ")"));
        }
        if (server == null) {
            log.error((Object)"getService() argument \"server\" was illegally null.");
            throw new IllegalArgumentException("name of server is required");
        }
        StringBuffer sb = new StringBuffer();
        if (request.isSecure()) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(server);
        sb.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            int ticketLoc = request.getQueryString().indexOf("ticket=");
            if (ticketLoc == -1) {
                sb.append("?" + request.getQueryString());
            } else if (ticketLoc > 0) {
                ticketLoc = request.getQueryString().indexOf("&ticket=");
                if (ticketLoc == -1) {
                    sb.append("?" + request.getQueryString());
                } else if (ticketLoc > 0) {
                    sb.append("?" + request.getQueryString().substring(0, ticketLoc));
                }
            }
        }
        if (encoding) {
            String encodedService = null;
            try {
                encodedService = URLEncoder.encode(sb.toString(), System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning from getService() with encoded service [" + encodedService + "]"));
            }
            return encodedService;
        }
        return sb.toString();
    }
}

