/*
 * Decompiled with CFR 0.152.
 */
package com.neusoft.education.tp.sso.client;

import com.neusoft.education.tp.sso.client.CheckAliveValidator;
import com.neusoft.education.tp.sso.client.ServiceValidator;
import com.neusoft.education.tp.sso.client.validator.hessian.HessianCheckAliveValidator;
import com.neusoft.education.tp.sso.client.validator.hessian.HessianServiceValidator;
import com.neusoft.education.tp.sso.client.validator.http.AliveChecker;
import com.neusoft.education.tp.sso.client.validator.http.CheckAliveTicketValidator;

public class ValidatorFactory {
    private static ValidatorFactory httpFactory = new ValidatorFactory(false);
    private static ValidatorFactory hessianFactory = new ValidatorFactory(true);
    private boolean hessian;

    private ValidatorFactory(boolean hessian) {
        this.hessian = hessian;
    }

    public static ValidatorFactory factory(boolean hessian) {
        if (hessian) {
            return hessianFactory;
        }
        return httpFactory;
    }

    public ServiceValidator getServiceValidator() {
        if (this.hessian) {
            return new HessianServiceValidator();
        }
        return new CheckAliveTicketValidator();
    }

    public CheckAliveValidator getCheckAliveValidator() {
        if (this.hessian) {
            return new HessianCheckAliveValidator();
        }
        return new AliveChecker();
    }
}

