/*
 * Decompiled with CFR 0.152.
 */
package com.neusoft.education.tp.sso.client.filter;

import com.neusoft.education.tp.sso.client.CASAuthenticationException;
import com.neusoft.education.tp.sso.client.CASReceipt;
import com.neusoft.education.tp.sso.client.ServiceValidator;
import com.neusoft.education.tp.sso.client.Util;
import com.neusoft.education.tp.sso.client.ValidatorFactory;
import com.neusoft.education.tp.sso.client.filter.CASFilter;
import com.neusoft.education.tp.sso.client.filter.CASFilterRequestWrapper;
import com.neusoft.education.tp.sso.client.filter.DefaultCASFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCASFilter
implements CASFilter {
    protected static Log log = LogFactory.getLog(CASFilter.class);
    protected static final String SSO_FILTER_GATEWAYED = "com.neusoft.education.tp.sso.client.filter.didGateway";
    protected String casLogin;
    protected String casValidate;
    private String casServiceUrl;
    protected String casServerName;
    private String casProxyCallbackUrl;
    private boolean casRenew;
    protected boolean wrapRequest;
    private boolean casGateway = false;
    protected boolean checkAlive = false;
    protected String casCheckAliveUrl;
    protected boolean hessian = false;
    protected List<Pattern> notForceAuthUrls = new ArrayList<Pattern>();
    private List<String> authorizedProxies = new ArrayList<String>();

    public void init(FilterConfig config) throws ServletException {
        InputStream ins = DefaultCASFilter.class.getResourceAsStream("/casFilterConfig.xml");
        if (ins != null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser parser = factory.newSAXParser();
                parser.parse(ins, (DefaultHandler)new CasFilterConfigHandler());
            }
            catch (SAXException e) {
                throw new ServletException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new ServletException((Throwable)e);
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws ServletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering doFilter()");
        }
        if (!(req instanceof HttpServletRequest) || !(res instanceof HttpServletResponse)) {
            log.error((Object)"doFilter() called on a request or response that was not an HttpServletRequest or response.");
            throw new ServletException("CASFilter protects only HTTP resources");
        }
        Object request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession();
        if (this.casProxyCallbackUrl != null && this.casProxyCallbackUrl.endsWith(request.getRequestURI()) && request.getParameter("pgtId") != null && request.getParameter("pgtIou") != null) {
            log.trace((Object)"passing through what we hope is CAS's request for proxy ticket receptor.");
            fc.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.wrapRequest) {
            log.trace((Object)"Wrapping request with CASFilterRequestWrapper.");
            request = new CASFilterRequestWrapper((HttpServletRequest)request);
        }
        if (!this.isNeedCASLoginOrValidate((HttpServletRequest)request, response, (CASReceipt)session.getAttribute("com.neusoft.education.tp.sso.client.filter.receipt"))) {
            log.debug((Object)"isNeedCASLoginOrValidate() return false, do not check CAS.");
            fc.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        CASReceipt receipt = (CASReceipt)session.getAttribute("com.neusoft.education.tp.sso.client.filter.receipt");
        String ticket = request.getParameter("ticket");
        if (ticket == null || ticket.equals("")) {
            log.trace((Object)"CAS ticket was not present on request.");
            boolean didGateway = Boolean.valueOf((String)session.getAttribute(SSO_FILTER_GATEWAYED));
            if (this.casLogin == null) {
                log.fatal((Object)"casLogin was not set, so filter cannot redirect request for authentication.");
                throw new ServletException("When CASFilter protects pages that do not receive a 'ticket' parameter, it needs a com.neusoft.education.tp.sso.client.filter.loginUrl filter parameter");
            }
            if (!didGateway) {
                log.trace((Object)"Did not previously gateway.  Setting session attribute to true.");
                session.setAttribute(SSO_FILTER_GATEWAYED, (Object)"true");
                if (!this.isNeedRedirectToCAS((HttpServletRequest)request, response)) {
                    fc.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                this.redirectToCAS((HttpServletRequest)request, response);
                return;
            }
            log.trace((Object)"Previously gatewayed.");
            if (this.casGateway || session.getAttribute("com.neusoft.education.tp.sso.client.filter.user") != null) {
                log.trace((Object)"casGateway was true and SSO_FILTER_USER set: passing request along filter chain.");
                fc.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            session.setAttribute(SSO_FILTER_GATEWAYED, (Object)"true");
            if (!this.isNeedRedirectToCAS((HttpServletRequest)request, response)) {
                fc.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.redirectToCAS((HttpServletRequest)request, response);
            return;
        }
        if (!this.isNeedValidate((HttpServletRequest)request, response)) {
            fc.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            receipt = this.getAuthenticatedUser((HttpServletRequest)request);
        }
        catch (CASAuthenticationException e) {
            log.warn((Object)"getAuthenticatedUser() error");
        }
        if (!this.isReceiptAcceptable(receipt)) {
            throw new ServletException("Authentication was technically successful but rejected as a matter of policy. [" + receipt + "]");
        }
        if (!this.userLoginAndValidated((HttpServletRequest)request, response, receipt)) {
            return;
        }
        fc.doFilter((ServletRequest)request, (ServletResponse)response);
        log.trace((Object)"returning from doFilter()");
    }

    protected boolean isReceiptAcceptable(CASReceipt receipt) {
        if (receipt == null) {
            throw new IllegalArgumentException("Cannot evaluate a null receipt.");
        }
        if (this.casRenew && !receipt.isPrimaryAuthentication()) {
            return false;
        }
        return !receipt.isProxied() || this.authorizedProxies.contains(receipt.getProxyingService());
    }

    private CASReceipt getAuthenticatedUser(HttpServletRequest request) throws ServletException, CASAuthenticationException {
        log.trace((Object)"entering getAuthenticatedUser()");
        ServiceValidator sv = ValidatorFactory.factory(this.hessian).getServiceValidator();
        sv.setCasValidateUrl(this.casValidate);
        sv.setServiceTicket(request.getParameter("ticket"));
        sv.setService(this.getService(request, false));
        if (log.isDebugEnabled()) {
            log.debug((Object)("about to validate CheckAliveTicketValidator: [" + sv + "]"));
        }
        sv.setNeedCheckAlive(this.checkAlive);
        return CASReceipt.getReceipt(sv);
    }

    protected String getService(HttpServletRequest request, boolean encoding) throws ServletException {
        log.trace((Object)"entering getService()");
        String serviceString = null;
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: com.neusoft.education.tp.sso.client.filter.serviceUrl or com.neusoft.education.tp.sso.client.filter.serverName");
        }
        if (this.casServiceUrl != null && encoding) {
            try {
                serviceString = URLEncoder.encode(this.casServiceUrl, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            serviceString = this.casServiceUrl == null ? Util.getService(request, this.casServerName, encoding) : this.casServiceUrl;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from getService() with service [" + serviceString + "]"));
        }
        return serviceString;
    }

    private void redirectToCAS(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering redirectToCAS()");
        }
        String casLoginString = String.valueOf(this.casLogin) + "?service=" + this.getService(request, true) + (this.casRenew ? "&renew=true" : "") + (this.casGateway ? "&gateway=true" : "");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirecting browser to [" + casLoginString + ")"));
        }
        response.sendRedirect(casLoginString);
        if (log.isTraceEnabled()) {
            log.trace((Object)"returning from redirectToCAS()");
        }
    }

    protected boolean isUrlMatch(String url, List<Pattern> patterns) {
        boolean retval = false;
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(url);
            if (!matcher.find()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[CASFilter:");
        sb.append(" casGateway=");
        sb.append(this.casGateway);
        sb.append(" wrapRequest=");
        sb.append(this.wrapRequest);
        sb.append(" casAuthorizedProxies=[");
        sb.append(this.authorizedProxies);
        sb.append("]");
        if (this.casLogin != null) {
            sb.append(" casLogin=[");
            sb.append(this.casLogin);
            sb.append("]");
        } else {
            sb.append(" casLogin=NULL!!!!!");
        }
        if (this.casProxyCallbackUrl != null) {
            sb.append(" casProxyCallbackUrl=[");
            sb.append(this.casProxyCallbackUrl);
            sb.append("]");
        }
        if (this.casRenew) {
            sb.append(" casRenew=true");
        }
        if (this.casServerName != null) {
            sb.append(" casServerName=[");
            sb.append(this.casServerName);
            sb.append("]");
        }
        if (this.casServiceUrl != null) {
            sb.append(" casServiceUrl=[");
            sb.append(this.casServiceUrl);
            sb.append("]");
        }
        if (this.casValidate != null) {
            sb.append(" casValidate=[");
            sb.append(this.casValidate);
            sb.append("]");
        } else {
            sb.append(" casValidate=NULL!!!");
        }
        return sb.toString();
    }

    public void destroy() {
    }

    private class CasFilterConfigHandler
    extends DefaultHandler {
        private boolean notNeedAuth = false;
        private boolean isUrl = false;
        private boolean isLoginServer = false;
        private boolean isValidateServer = false;
        private boolean isThis = false;
        private boolean isWrap = false;
        private boolean isCheckAlive = false;
        private boolean isHessian = false;

        private CasFilterConfigHandler() {
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("notForceAuthUrls".equals(name)) {
                this.notNeedAuth = true;
            } else if ("url-pattern".equals(name)) {
                this.isUrl = true;
            } else if ("loginServer".equals(name)) {
                this.isLoginServer = true;
            } else if ("validateServer".equals(name)) {
                this.isValidateServer = true;
            } else if ("this".equals(name)) {
                this.isThis = true;
            } else if ("wrapRequest".equals(name)) {
                this.isWrap = true;
            } else if ("checkAlive".equals(name)) {
                this.isCheckAlive = true;
            } else if ("hessian".equals(name)) {
                this.isHessian = true;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isWrap) {
                AbstractCASFilter.this.wrapRequest = Boolean.parseBoolean(new String(ch, start, length));
            }
            if (this.isThis) {
                AbstractCASFilter.this.casServerName = new String(ch, start, length);
            }
            if (this.isLoginServer || this.isValidateServer) {
                String server = new String(ch, start, length);
                if (server.trim().length() == 0) {
                    throw new SAXException("cas\u670d\u52a1\u5668\u7684\u5730\u5740\u6ca1\u6709\u6307\u5b9a");
                }
                if (server.endsWith("/")) {
                    server = new String(ch, start, length - 1);
                }
                if (this.isLoginServer) {
                    AbstractCASFilter.this.casLogin = String.valueOf(server) + "/login";
                } else {
                    AbstractCASFilter.this.casValidate = server;
                    AbstractCASFilter.this.casCheckAliveUrl = server;
                }
            }
            if (this.isUrl) {
                String urlPattern = new String(ch, start, length);
                Pattern pattern = Pattern.compile(urlPattern.trim(), 2);
                if (this.notNeedAuth) {
                    AbstractCASFilter.this.notForceAuthUrls.add(pattern);
                }
            }
            if (this.isCheckAlive) {
                AbstractCASFilter.this.checkAlive = Boolean.parseBoolean(new String(ch, start, length));
            }
            if (this.isHessian) {
                AbstractCASFilter.this.hessian = Boolean.parseBoolean(new String(ch, start, length));
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("notForceAuthUrls".equals(name)) {
                this.notNeedAuth = false;
            } else if ("url-pattern".equals(name)) {
                this.isUrl = false;
            } else if ("loginServer".equals(name)) {
                this.isLoginServer = false;
            } else if ("validateServer".equals(name)) {
                this.isValidateServer = false;
            } else if ("this".equals(name)) {
                this.isThis = false;
            } else if ("wrapRequest".equals(name)) {
                this.isWrap = false;
            } else if ("checkAlive".equals(name)) {
                this.isCheckAlive = false;
            } else if ("hessian".equals(name)) {
                this.isHessian = false;
            }
        }
    }
}

