/*
 * Decompiled with CFR 0.152.
 */
package com.neusoft.education.tp.sso.client.validator.http;

import com.neusoft.education.tp.sso.client.ServiceValidator;
import com.neusoft.education.tp.sso.client.validator.http.ProxyTicketValidator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CheckAliveTicketValidator
extends ProxyTicketValidator
implements ServiceValidator {
    protected String caKey;
    protected boolean needCheckAlive;

    public String getCheckAliveKey() {
        return this.caKey;
    }

    public void setNeedCheckAlive(boolean need) {
        this.needCheckAlive = need;
    }

    protected String getRemoteUrl() {
        String superResult = super.getRemoteUrl();
        if (this.needCheckAlive) {
            superResult = String.valueOf(superResult) + "&checkAlive=true";
        }
        return superResult;
    }

    protected DefaultHandler newHandler() {
        return new CheckAliveHandler();
    }

    protected class CheckAliveHandler
    extends ProxyTicketValidator.ProxyHandler {
        protected static final String CHECKALIVE = "sso:checkAliveTicket";
        protected boolean checkAliveFragment;
        protected String caKey;

        protected CheckAliveHandler() {
            super(CheckAliveTicketValidator.this);
            this.checkAliveFragment = false;
        }

        public void startElement(String ns, String ln, String qn, Attributes a) {
            super.startElement(ns, ln, qn, a);
            if (this.authenticationSuccess && qn.equals(CHECKALIVE)) {
                this.checkAliveFragment = true;
            }
        }

        public void endElement(String ns, String ln, String qn) throws SAXException {
            super.endElement(ns, ln, qn);
            if (qn.equals(CHECKALIVE)) {
                this.checkAliveFragment = false;
                this.caKey = this.currentText.toString().trim();
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.authenticationSuccess) {
                CheckAliveTicketValidator.this.caKey = this.caKey;
            }
        }
    }
}

